/* DOX for Enlightenment - by The Rasterman (C) 1998 - GPL License */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/XShm.h>
#include <Imlib.h>
#include <Fnlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* Motif window hints */
#define MWM_HINTS_FUNCTIONS           (1L << 0)
#define MWM_HINTS_DECORATIONS         (1L << 1)

/* bit definitions for MwmHints.functions */
#define MWM_FUNC_ALL            (1L << 0)
#define MWM_FUNC_RESIZE         (1L << 1)
#define MWM_FUNC_MOVE           (1L << 2)
#define MWM_FUNC_MINIMIZE       (1L << 3)
#define MWM_FUNC_MAXIMIZE       (1L << 4)
#define MWM_FUNC_CLOSE          (1L << 5)

/* bit definitions for MwmHints.decorations */
#define MWM_DECOR_ALL                 (1L << 0)
#define MWM_DECOR_BORDER              (1L << 1)
#define MWM_DECOR_RESIZEH             (1L << 2)
#define MWM_DECOR_TITLE               (1L << 3)
#define MWM_DECOR_MENU                (1L << 4)
#define MWM_DECOR_MINIMIZE            (1L << 5)
#define MWM_DECOR_MAXIMIZE            (1L << 6)

#define PROP_MWM_HINTS_ELEMENTS       4

typedef struct _mwmhints
  {
     CARD32              flags;
     CARD32              functions;
     CARD32              decorations;
     INT32               inputMode;
  }
MWMHints;

typedef struct _thing
  {
     char                isimg;
     int                 x, y, w, h;
     FnlibFont          *fn;
     FnlibStyle          fs;
     int                 size;
     unsigned char      *text;
     ImlibImage         *im1, *im2, *im3;
     Window              win;
     int                 page;
  }
Thing;

typedef struct _page
  {
     int                 num;
     Thing              *thing;
  }
Page;

Display            *disp;
ImlibData          *id;
FnlibData          *fd;
Window              win_main, win_title, win_exit, win_next, win_prev, win_text,
                    win_cover;
int                 num_pages;
Page               *page;
int                 w, h, t;
ImlibImage         *im_text;
ImlibImage         *im_title1, *im_title2, *im_title3;
ImlibImage         *im_prev1, *im_prev2, *im_prev3;
ImlibImage         *im_next1, *im_next2, *im_next3;
ImlibImage         *im_exit1, *im_exit2, *im_exit3;
char               *docdir;

Window
CreateWindow(Window parent, int x, int y, int ww, int hh)
{
   Window              win;
   XSetWindowAttributes attr;
   MWMHints            mwm;
   Atom                a;
   XSizeHints          hnt;

   attr.backing_store = NotUseful;
   attr.override_redirect = False;
   attr.colormap = Imlib_get_colormap(id);
   attr.border_pixel = 0;
   attr.background_pixel = 0;
   attr.save_under = False;
   mwm.flags = MWM_HINTS_DECORATIONS;
   mwm.functions = 0;
   mwm.decorations = 0;
   mwm.inputMode = 0;
   a = XInternAtom(disp, "_MOTIF_WM_HINTS", False);
   win = XCreateWindow(disp, parent, x, y, ww, hh, 0, id->x.depth,
		       InputOutput, Imlib_get_visual(id),
		       CWOverrideRedirect | CWSaveUnder | CWBackingStore |
		       CWColormap | CWBackPixel | CWBorderPixel, &attr);
   XSetWindowBackground(disp, win, 0);
   XChangeProperty(disp, win, a, a, 32, PropModeReplace,
		   (unsigned char *)&mwm, sizeof(MWMHints) / 4);
   hnt.flags = USPosition | USSize | PPosition | PSize | PMinSize | PMaxSize;
   hnt.x = x;
   hnt.y = y;
   hnt.width = ww;
   hnt.height = hh;
   hnt.min_width = ww;
   hnt.max_width = ww;
   hnt.min_height = hh;
   hnt.max_height = hh;
   XSetWMNormalHints(disp, win, &hnt);
   return win;
}

int
ReadHeader(FILE * f)
{
   char                s[10240], ss[10240];
   char                s1[10240], s2[10240], s3[10240];
   int                 a1, a2, a3, a4, b1, b2, b3, b4, c1, c2, c3, c4;
   ImlibBorder         bd;

   fgets(s, 10240, f);
   if (strncmp("EDOC", s, 4))
      return 0;
   fgets(s, 10240, f);
   sscanf(s, "%i %i %i", &w, &h, &t);
   fgets(s, 10240, f);
   sscanf(s, "%s %i %i %i %i", s1, &a1, &a2, &a3, &a4);
   sprintf(ss, "%s/%s", docdir, s1);
   im_text = Imlib_load_image(id, ss);
   bd.left = a1;
   bd.right = a2;
   bd.top = a3;
   bd.bottom = a4;
   Imlib_set_image_border(id, im_text, &bd);
   fgets(s, 10240, f);
   sscanf(s, "%s %i %i %i %i %s %i %i %i %i %s %i %i %i %i",
      s1, &a1, &a2, &a3, &a4, s2, &b1, &b2, &b3, &b4, s3, &c1, &c2, &c3, &c4);
   sprintf(ss, "%s/%s", docdir, s1);
   im_title1 = Imlib_load_image(id, ss);
   bd.left = a1;
   bd.right = a2;
   bd.top = a3;
   bd.bottom = a4;
   Imlib_set_image_border(id, im_title1, &bd);
   sprintf(ss, "%s/%s", docdir, s2);
   im_title2 = Imlib_load_image(id, ss);
   bd.left = b1;
   bd.right = b2;
   bd.top = b3;
   bd.bottom = b4;
   Imlib_set_image_border(id, im_title2, &bd);
   sprintf(ss, "%s/%s", docdir, s3);
   im_title3 = Imlib_load_image(id, ss);
   bd.left = c1;
   bd.right = c2;
   bd.top = c3;
   bd.bottom = c4;
   Imlib_set_image_border(id, im_title3, &bd);

   fgets(s, 10240, f);
   sscanf(s, "%s %i %i %i %i %s %i %i %i %i %s %i %i %i %i",
      s1, &a1, &a2, &a3, &a4, s2, &b1, &b2, &b3, &b4, s3, &c1, &c2, &c3, &c4);
   sprintf(ss, "%s/%s", docdir, s1);
   im_prev1 = Imlib_load_image(id, ss);
   bd.left = a1;
   bd.right = a2;
   bd.top = a3;
   bd.bottom = a4;
   Imlib_set_image_border(id, im_prev1, &bd);
   sprintf(ss, "%s/%s", docdir, s2);
   im_prev2 = Imlib_load_image(id, ss);
   bd.left = b1;
   bd.right = b2;
   bd.top = b3;
   bd.bottom = b4;
   Imlib_set_image_border(id, im_prev2, &bd);
   sprintf(ss, "%s/%s", docdir, s3);
   im_prev3 = Imlib_load_image(id, ss);
   bd.left = c1;
   bd.right = c2;
   bd.top = c3;
   bd.bottom = c4;
   Imlib_set_image_border(id, im_prev3, &bd);

   fgets(s, 10240, f);
   sscanf(s, "%s %i %i %i %i %s %i %i %i %i %s %i %i %i %i",
      s1, &a1, &a2, &a3, &a4, s2, &b1, &b2, &b3, &b4, s3, &c1, &c2, &c3, &c4);
   sprintf(ss, "%s/%s", docdir, s1);
   im_next1 = Imlib_load_image(id, ss);
   bd.left = a1;
   bd.right = a2;
   bd.top = a3;
   bd.bottom = a4;
   Imlib_set_image_border(id, im_next1, &bd);
   sprintf(ss, "%s/%s", docdir, s2);
   im_next2 = Imlib_load_image(id, ss);
   bd.left = b1;
   bd.right = b2;
   bd.top = b3;
   bd.bottom = b4;
   Imlib_set_image_border(id, im_next2, &bd);
   sprintf(ss, "%s/%s", docdir, s3);
   im_next3 = Imlib_load_image(id, ss);
   bd.left = c1;
   bd.right = c2;
   bd.top = c3;
   bd.bottom = c4;
   Imlib_set_image_border(id, im_next3, &bd);

   fgets(s, 10240, f);
   sscanf(s, "%s %i %i %i %i %s %i %i %i %i %s %i %i %i %i",
      s1, &a1, &a2, &a3, &a4, s2, &b1, &b2, &b3, &b4, s3, &c1, &c2, &c3, &c4);
   sprintf(ss, "%s/%s", docdir, s1);
   im_exit1 = Imlib_load_image(id, ss);
   bd.left = a1;
   bd.right = a2;
   bd.top = a3;
   bd.bottom = a4;
   Imlib_set_image_border(id, im_exit1, &bd);
   sprintf(ss, "%s/%s", docdir, s2);
   im_exit2 = Imlib_load_image(id, ss);
   bd.left = b1;
   bd.right = b2;
   bd.top = b3;
   bd.bottom = b4;
   Imlib_set_image_border(id, im_exit2, &bd);
   sprintf(ss, "%s/%s", docdir, s3);
   im_exit3 = Imlib_load_image(id, ss);
   bd.left = c1;
   bd.right = c2;
   bd.top = c3;
   bd.bottom = c4;
   Imlib_set_image_border(id, im_exit3, &bd);

   return 1;
}

int
ReadPages(FILE * f)
{
   char                s[10240], ss[10240], s1[10240], s2[10240], s3[10240];
   int                 num, cp, i, ct;
   int                 x1, y1, w1, h1, sz, js, sp, pg;
   Thing              *th;

   th = NULL;
   cp = 0;
   ct = 0;
   page = NULL;
   num = 0;
   num_pages = 0;
   while (fgets(s, 10240, f))
     {
	s[strlen(s) - 1] = 0;
	sscanf(s, "%s", ss);
	if (!strcmp(ss, "page"))
	  {
	     sscanf(s, "%*s %i", &num);
	     if (num >= num_pages)
	       {
		  if (page)
		     page = realloc(page, sizeof(Page) * (num + 1));
		  else
		     page = malloc(sizeof(Page) * (num + 1));
		  for (i = num_pages; i < num + 1; i++)
		    {
		       page[i].num = 0;
		       page[i].thing = NULL;
		    }
		  num_pages = num + 1;
	       }
	     cp = num;
	     ct = 0;
	  }
	else if (!strcmp(ss, "text"))
	  {
	     sscanf(s, "%*s %s %i %i %i %i %i %i %i",
		    s1, &sz, &js, &sp, &x1, &y1, &w1, &h1);
	     page[cp].num++;
	     if (page[cp].thing)
		page[cp].thing = realloc(page[cp].thing, page[cp].num * sizeof(Thing));
	     else
		page[cp].thing = malloc(page[cp].num * sizeof(Thing));
	     th = &(page[cp].thing[page[cp].num - 1]);
	     th->isimg = 0;
	     th->text = NULL;
	     th->fs.orientation = FONT_TO_RIGHT;
	     th->fs.mode = MODE_WRAP_WORD;
	     th->fs.justification = js;
	     th->fs.spacing = sp;
	     th->size = sz;
	     th->x = x1;
	     th->y = y1;
	     th->w = w1;
	     th->h = h1;
	     th->fn = Fnlib_load_font(fd, s1);
	  }
	else if (!strcmp(ss, "."))
	  {
	     th = &(page[cp].thing[page[cp].num - 1]);
	     if (th->text)
	       {
		  th->text = realloc(th->text, strlen((char *)(th->text)) + strlen(&(s[2])) + 2);
		  strcat((char *)(th->text), " ");
	       }
	     else
	       {
		  th->text = malloc(strlen(&(s[2])) + 1);
		  th->text[0] = 0;
	       }
	     strcat((char *)(th->text), &(s[2]));
	  }
	else if (!strcmp(ss, "image"))
	  {
	     sscanf(s, "%*s %i %i %s %s %s %i",
		    &x1, &y1, s1, s2, s3, &pg);
	     page[cp].num++;
	     if (page[cp].thing)
		page[cp].thing = realloc(page[cp].thing, page[cp].num * sizeof(Thing));
	     else
		page[cp].thing = malloc(page[cp].num * sizeof(Thing));
	     th = &(page[cp].thing[page[cp].num - 1]);
	     th->isimg = 1;
	     th->x = x1;
	     th->y = x1;
	     th->page = pg;
	     th->win = 0;
	     sprintf(ss, "%s/%s", docdir, s1);
	     th->im1 = Imlib_load_image(id, ss);
	     sprintf(ss, "%s/%s", docdir, s2);
	     th->im2 = Imlib_load_image(id, ss);
	     sprintf(ss, "%s/%s", docdir, s3);
	     th->im3 = Imlib_load_image(id, ss);
	     if (th->im1)
	       {
		  th->win = CreateWindow(win_text, x1, y1,
				     th->im1->rgb_width, th->im1->rgb_height);
		  XSelectInput(disp, th->win, EnterWindowMask | LeaveWindowMask |
		      ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
		  Imlib_apply_image(id, th->im1, th->win);
	       }
	  }
     }
   fclose(f);
   return 1;
}

int
main(int argc, char **argv)
{
   int                 pagenum;
   int                 x, y;
   int                 wx, wy;
   char                movewin;
   FILE               *f;
   char               *s;
   int                 i;
   Thing              *th;
   int                 expcount;
   Pixmap              bg;
   Pixmap              mk;
   Pixmap              draw;

   movewin = 0;
   x = 0;
   y = 0;
   pagenum = 0;
   num_pages = 0;

   disp = XOpenDisplay(NULL);
   id = Imlib_init(disp);
   fd = Fnlib_init(id);

   if (argc < 2)
     {
	printf("usage:\n%s [-page num] Edoc_dir\n", argv[0]);
	exit(1);
     }
   if (!strcmp(argv[1], "-page"))
     {
	pagenum = atoi(argv[2]);
	docdir = argv[3];
     }
   else
      docdir = argv[1];
   s = malloc(strlen(docdir) + 1 + 5);
   strcpy(s, docdir);
   strcat(s, "/MAIN");
   f = fopen(s, "r");
   if (!f)
     {
	printf("Edoc_dir does not contain a MAIN file\n");
	exit(1);
     }
   w = 512;
   h = 400;
   t = 16;
   if (!ReadHeader(f))
     {
	printf("Bad Edoc header\n");
	exit(0);
     }
   Fnlib_add_dir(fd, docdir);
   wx = (DisplayWidth(disp, DefaultScreen(disp)) - w) / 2;
   wy = (DisplayHeight(disp, DefaultScreen(disp)) - (h + t)) / 2;
   win_main = CreateWindow(id->x.root, wx, wy, w, h + t);
   win_title = CreateWindow(win_main, 0, 0, (w - 64 - 64 - t), t);
   XSelectInput(disp, win_title, EnterWindowMask | LeaveWindowMask |
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
   win_prev = CreateWindow(win_main, (w - 64 - 64 - t), 0, 64, t);
   XSelectInput(disp, win_prev, EnterWindowMask | LeaveWindowMask |
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
   win_next = CreateWindow(win_main, (w - 64 - 64 - t) + 64, 0, 64, t);
   XSelectInput(disp, win_next, EnterWindowMask | LeaveWindowMask |
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
   win_exit = CreateWindow(win_main, (w - 64 - 64 - t) + 64 + 64, 0, t, t);
   XSelectInput(disp, win_exit, EnterWindowMask | LeaveWindowMask |
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
   win_text = CreateWindow(win_main, 0, t, w, h);
   win_cover = CreateWindow(win_main, 0, t, w, h);
   draw = XCreatePixmap(disp, win_text, w, h, id->x.depth);
   XSetWindowBackgroundPixmap(disp, win_text, draw);
   Imlib_render(id, im_text, w, h);
   bg = Imlib_move_image(id, im_text);
   mk = Imlib_move_mask(id, im_text);
   {
      GC                  gc;

      gc = XCreateGC(disp, draw, 0, NULL);
      XCopyArea(disp, bg, draw, gc, 0, 0, w, h, 0, 0);
      XFreeGC(disp, gc);
   }
   XSetWindowBackgroundPixmap(disp, win_cover, draw);
   if (mk)
     {
	XShapeCombineMask(disp, win_text, ShapeBounding, 0, 0, mk, ShapeSet);
	XShapeCombineMask(disp, win_cover, ShapeBounding, 0, 0, mk, ShapeSet);
     }
   Imlib_apply_image(id, im_title1, win_title);
   Imlib_apply_image(id, im_prev1, win_prev);
   Imlib_apply_image(id, im_next1, win_next);
   Imlib_apply_image(id, im_exit1, win_exit);
   ReadPages(f);
   XMapWindow(disp, win_text);
   XMapWindow(disp, win_exit);
   XMapWindow(disp, win_next);
   XMapWindow(disp, win_prev);
   XMapWindow(disp, win_title);
   XMapWindow(disp, win_main);
   XRaiseWindow(disp, win_cover);
   XSync(disp, False);
   expcount = 0;
   if (pagenum > num_pages)
      pagenum = num_pages - 1;
   if (pagenum < 0)
      pagenum = 0;
   for (;;)
     {
	XEvent              ev;
	char                newpage;
	int                 dx, dy;
	int                 ppage;

	newpage = 0;
	if (!expcount)
	  {
	     newpage = 1;
	     expcount++;
	  }
	ppage = -1;
	XNextEvent(disp, &ev);
	switch (ev.type)
	  {
	  case ButtonPress:
	     if (ev.xbutton.window == win_title)
	       {
		  XRaiseWindow(disp, win_main);
		  Imlib_apply_image(id, im_title3, win_title);
		  XGrabPointer(disp, win_title, True,
			       ButtonPressMask | ButtonReleaseMask |
			       ButtonMotionMask | PointerMotionMask,
			       GrabModeAsync, GrabModeAsync, None, None,
			       CurrentTime);
		  x = ev.xbutton.x_root;
		  y = ev.xbutton.y_root;
		  movewin = 1;
	       }
	     else if (ev.xbutton.window == win_prev)
		Imlib_apply_image(id, im_prev3, win_prev);
	     else if (ev.xbutton.window == win_next)
		Imlib_apply_image(id, im_next3, win_next);
	     else if (ev.xbutton.window == win_exit)
		Imlib_apply_image(id, im_exit3, win_exit);
	     else
	       {
		  for (i = 0; i < page[pagenum].num; i++)
		    {
		       th = &(page[pagenum].thing[i]);
		       if (th->isimg)
			 {
			    if (ev.xcrossing.window == th->win)
			       Imlib_apply_image(id, th->im3, th->win);
			 }
		    }
	       }
	     break;
	  case ButtonRelease:
	     if (ev.xbutton.window == win_title)
	       {
		  Imlib_apply_image(id, im_title2, win_title);
		  XUngrabPointer(disp, CurrentTime);
		  movewin = 0;
	       }
	     else if (ev.xbutton.window == win_prev)
	       {
		  Imlib_apply_image(id, im_prev2, win_prev);
		  if (pagenum > 0)
		    {
		       ppage = pagenum;
		       pagenum--;
		       newpage = 1;
		    }
	       }
	     else if (ev.xbutton.window == win_next)
	       {
		  Imlib_apply_image(id, im_next2, win_next);
		  if (pagenum < (num_pages - 1))
		    {
		       ppage = pagenum;
		       pagenum++;
		       newpage = 1;
		    }
	       }
	     else if (ev.xbutton.window == win_exit)
	       {
		  Imlib_apply_image(id, im_exit2, win_exit);
		  exit(0);
	       }
	     else
	       {
		  for (i = 0; i < page[pagenum].num; i++)
		    {
		       th = &(page[pagenum].thing[i]);
		       if (th->isimg)
			 {
			    if (ev.xcrossing.window == th->win)
			      {
				 Imlib_apply_image(id, th->im2, th->win);
				 if ((th->page >= 0) && (th->page < num_pages))
				   {
				      ppage = pagenum;
				      pagenum = th->page;
				      newpage = 1;
				   }
			      }
			 }
		    }
	       }
	     break;
	  case EnterNotify:
	     if (ev.xcrossing.window == win_title)
		Imlib_apply_image(id, im_title2, win_title);
	     else if (ev.xcrossing.window == win_prev)
		Imlib_apply_image(id, im_prev2, win_prev);
	     else if (ev.xcrossing.window == win_next)
		Imlib_apply_image(id, im_next2, win_next);
	     else if (ev.xcrossing.window == win_exit)
		Imlib_apply_image(id, im_exit2, win_exit);
	     else
	       {
		  for (i = 0; i < page[pagenum].num; i++)
		    {
		       th = &(page[pagenum].thing[i]);
		       if (th->isimg)
			 {
			    if (ev.xcrossing.window == th->win)
			       Imlib_apply_image(id, th->im2, th->win);
			 }
		    }
	       }
	     break;
	  case LeaveNotify:
	     if (ev.xcrossing.window == win_title)
		Imlib_apply_image(id, im_title1, win_title);
	     else if (ev.xcrossing.window == win_prev)
		Imlib_apply_image(id, im_prev1, win_prev);
	     else if (ev.xcrossing.window == win_next)
		Imlib_apply_image(id, im_next1, win_next);
	     else if (ev.xcrossing.window == win_exit)
		Imlib_apply_image(id, im_exit1, win_exit);
	     else
	       {
		  for (i = 0; i < page[pagenum].num; i++)
		    {
		       th = &(page[pagenum].thing[i]);
		       if (th->isimg)
			 {
			    if (ev.xcrossing.window == th->win)
			       Imlib_apply_image(id, th->im1, th->win);
			 }
		    }
	       }
	     break;
	  case MotionNotify:
	     while (XCheckTypedEvent(disp, ev.type, &ev));
	     if (movewin)
	       {
		  dx = ev.xbutton.x_root - x;
		  dy = ev.xbutton.y_root - y;
		  wx += dx;
		  wy += dy;
		  XMoveWindow(disp, win_main, wx, wy);
		  x = ev.xbutton.x_root;
		  y = ev.xbutton.y_root;
	       }
	     break;
	  default:
	     break;
	  }
	if (newpage)
	  {
	     Pixmap              tbg;

	     XSync(disp, False);
	     tbg = XCreatePixmap(disp, win_cover, w, h, id->x.depth);
	     XSetWindowBackgroundPixmap(disp, win_cover, tbg);
	     {
		GC                  gc;
		XGCValues           gcv;

		gcv.subwindow_mode = IncludeInferiors;
		gc = XCreateGC(disp, draw, GCSubwindowMode, &gcv);
		XCopyArea(disp, bg, draw, gc, 0, 0, w, h, 0, 0);
		XCopyArea(disp, win_text, tbg, gc, 0, 0, w, h, 0, 0);
		XFreeGC(disp, gc);
	     }
	     XFreePixmap(disp, tbg);
	     XMapWindow(disp, win_cover);
	     if (ppage >= 0)
	       {
		  for (i = 0; i < page[ppage].num; i++)
		    {
		       th = &(page[ppage].thing[i]);
		       if ((th->isimg) && (th->win))
			 {
			    Imlib_apply_image(id, th->im1, th->win);
			    XUnmapWindow(disp, th->win);
			    expcount++;
			 }
		    }
	       }
	     for (i = 0; i < page[pagenum].num; i++)
	       {
		  th = &(page[pagenum].thing[i]);
		  if ((th->isimg) && (th->win))
		     XMapWindow(disp, th->win);
		  else if (!th->isimg)
		    {
		       if ((th->text) && (th->fn))
			  Fnlib_draw(fd, th->fn, draw, 0,
				     th->x, th->y, th->w, th->h, 0, 0,
				     th->size, &(th->fs), th->text);
		    }
	       }
	     XClearWindow(disp, win_text);
	     XUnmapWindow(disp, win_cover);
	     XSync(disp, False);
	  }
     }
}
