#include "E.h"

int
main(int argc, char **argv)
{
   Border             *b;
   ImageClass         *ic;
   ActionClass        *ac;
   Action             *a;

#ifdef DEBUG
   call_level = 0;
   debug_level = 0;
   {
      char               *debug_str;

      debug_str = getenv("EDBUG");
      if (debug_str)
	 debug_level = atoi(debug_str);
   }
#endif
   EDBUG(1, "main");
   srand(time(NULL));
   command = duplicate(argv[0]);
   themepath[0] = 0;
   {
      int                 j = 0;

      for (j = 1; j < argc; j++)
	{
	   if ((!strcmp("-theme", argv[j])) && (argc - j))
	     {
		Esnprintf(themepath, sizeof(themepath), "%s", argv[++j]);
		j++;
	     }
	}
   }
   SetupSignals();
   SetupX();
   SetupDirs();
   SetupEnv();
   InitDesktopBgs();
   GotoDesktop(0);
   CommsSetup();
   CommsFindCommsWindow();
   GrabX();
   MapUnmap(0);

   /*
    * The next section creates simple internal data members to be used in 
    * emergencies - ie when all else fails - ie a button is told to use an
    * imageclass that doesn't exist, or no DEFAULt border is defined... at 
    * least E won't barf on us then.
    */

   /* create a default fallback actionclass for the fallback border */
   ac = CreateAclass("__FALLBACK_ACTION");
   AddItem(ac, ac->name, 0, LIST_TYPE_ACLASS);
   a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 1, 0, NULL);
   AddAction(ac, a);
   AddToAction(a, ACTION_MOVE, NULL);
   a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 2, 0, NULL);
   AddAction(ac, a);
   AddToAction(a, ACTION_KILL, NULL);
   a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 3, 0, NULL);
   AddAction(ac, a);
   AddToAction(a, ACTION_RESIZE, NULL);

   /* create a fallback imageclass incase no imageclass can be found */
   ic = CreateIclass();
   ic->name = duplicate("__FALLBACK_ICLASS");
   ic->norm.normal = CreateImageState();
   ic->norm.normal->hihi.r = 255;
   ic->norm.normal->hihi.g = 255;
   ic->norm.normal->hihi.b = 255;
   ic->norm.normal->hi.r = 255;
   ic->norm.normal->hi.g = 255;
   ic->norm.normal->hi.b = 255;
   ic->norm.normal->bg.r = 160;
   ic->norm.normal->bg.g = 160;
   ic->norm.normal->bg.b = 160;
   ic->norm.normal->lo.r = 0;
   ic->norm.normal->lo.g = 0;
   ic->norm.normal->lo.b = 0;
   ic->norm.normal->lolo.r = 0;
   ic->norm.normal->lolo.g = 0;
   ic->norm.normal->lolo.b = 0;
   ic->norm.normal->bevelstyle = BEVEL_AMIGA;
   ic->norm.hilited = CreateImageState();
   ic->norm.hilited->hihi.r = 255;
   ic->norm.hilited->hihi.g = 255;
   ic->norm.hilited->hihi.b = 255;
   ic->norm.hilited->hi.r = 255;
   ic->norm.hilited->hi.g = 255;
   ic->norm.hilited->hi.b = 255;
   ic->norm.hilited->bg.r = 192;
   ic->norm.hilited->bg.g = 192;
   ic->norm.hilited->bg.b = 192;
   ic->norm.hilited->lo.r = 0;
   ic->norm.hilited->lo.g = 0;
   ic->norm.hilited->lo.b = 0;
   ic->norm.hilited->lolo.r = 0;
   ic->norm.hilited->lolo.g = 0;
   ic->norm.hilited->lolo.b = 0;
   ic->norm.hilited->bevelstyle = BEVEL_AMIGA;
   ic->norm.clicked = CreateImageState();
   ic->norm.clicked->hihi.r = 0;
   ic->norm.clicked->hihi.g = 0;
   ic->norm.clicked->hihi.b = 0;
   ic->norm.clicked->hi.r = 0;
   ic->norm.clicked->hi.g = 0;
   ic->norm.clicked->hi.b = 0;
   ic->norm.clicked->bg.r = 192;
   ic->norm.clicked->bg.g = 192;
   ic->norm.clicked->bg.b = 192;
   ic->norm.clicked->lo.r = 255;
   ic->norm.clicked->lo.g = 255;
   ic->norm.clicked->lo.b = 255;
   ic->norm.clicked->lolo.r = 255;
   ic->norm.clicked->lolo.g = 255;
   ic->norm.clicked->lolo.b = 255;
   ic->norm.clicked->bevelstyle = BEVEL_AMIGA;
   ic->active.normal = CreateImageState();
   ic->active.normal->hihi.r = 255;
   ic->active.normal->hihi.g = 255;
   ic->active.normal->hihi.b = 255;
   ic->active.normal->hi.r = 255;
   ic->active.normal->hi.g = 255;
   ic->active.normal->hi.b = 255;
   ic->active.normal->bg.r = 180;
   ic->active.normal->bg.g = 140;
   ic->active.normal->bg.b = 160;
   ic->active.normal->lo.r = 0;
   ic->active.normal->lo.g = 0;
   ic->active.normal->lo.b = 0;
   ic->active.normal->lolo.r = 0;
   ic->active.normal->lolo.g = 0;
   ic->active.normal->lolo.b = 0;
   ic->active.normal->bevelstyle = BEVEL_AMIGA;
   ic->active.hilited = CreateImageState();
   ic->active.hilited->hihi.r = 255;
   ic->active.hilited->hihi.g = 255;
   ic->active.hilited->hihi.b = 255;
   ic->active.hilited->hi.r = 255;
   ic->active.hilited->hi.g = 255;
   ic->active.hilited->hi.b = 255;
   ic->active.hilited->bg.r = 230;
   ic->active.hilited->bg.g = 190;
   ic->active.hilited->bg.b = 210;
   ic->active.hilited->lo.r = 0;
   ic->active.hilited->lo.g = 0;
   ic->active.hilited->lo.b = 0;
   ic->active.hilited->lolo.r = 0;
   ic->active.hilited->lolo.g = 0;
   ic->active.hilited->lolo.b = 0;
   ic->active.hilited->bevelstyle = BEVEL_AMIGA;
   ic->active.clicked = CreateImageState();
   ic->active.clicked->hihi.r = 0;
   ic->active.clicked->hihi.g = 0;
   ic->active.clicked->hihi.b = 0;
   ic->active.clicked->hi.r = 0;
   ic->active.clicked->hi.g = 0;
   ic->active.clicked->hi.b = 0;
   ic->active.clicked->bg.r = 230;
   ic->active.clicked->bg.g = 190;
   ic->active.clicked->bg.b = 210;
   ic->active.clicked->lo.r = 255;
   ic->active.clicked->lo.g = 255;
   ic->active.clicked->lo.b = 255;
   ic->active.clicked->lolo.r = 255;
   ic->active.clicked->lolo.g = 255;
   ic->active.clicked->lolo.b = 255;
   ic->active.clicked->bevelstyle = BEVEL_AMIGA;
   IclassPopulate(ic);
   AddItem(ic, ic->name, 0, LIST_TYPE_ICLASS);

   /* create a fallback border incase no border is found */
   b = CreateBorder("__FALLBACK_BORDER");
   b->border.left = 8;
   b->border.right = 8;
   b->border.top = 8;
   b->border.bottom = 8;
   AddBorderPart(b, ic, ac, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		 -1, 0, 0, 0, 0,
		 -1, 1024, -1, 0, 7);
   AddBorderPart(b, ic, ac, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		 -1, 0, 0, 1024, -8,
		 -1, 1024, -1, 1024, -1);
   AddBorderPart(b, ic, ac, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		 -1, 0, 0, 0, 8,
		 -1, 0, 7, 1024, -9);
   AddBorderPart(b, ic, ac, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		 -1, 1024, -8, 0, 8,
		 -1, 1024, -1, 1024, -9);
   AddItem(b, b->name, 0, LIST_TYPE_BORDER);

   UngrabX();
   XSync(disp, False);

   LoadEConfig(themepath);

   SoundInit();
   GrabX();

   if (mode.sound)
     {
	ApplySclass(FindItem("SOUND_STARTUP", 0,
			     LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
	DestroySclass(RemoveItem("SOUND_STARTUP", 0,
				 LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
     }

   InitDesktopControls();
   UngrabX();
   {
      Button            **lst;
      int                 i, num;

      lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 0);
      if (lst)
	{
	   for (i = 0; i < num; i++)
	      SimpleShowButton(lst[i]);
	   Efree(lst);
	}
   }
   ShowDesktopControls();
   StackDesktops();
   CheckEvent();
   MapUnmap(1);
   XSync(disp, False);
   for (;;)
     {
	WaitEvent();
     }
   EDBUG_RETURN(0);
}
