
#include "E.h"

TextClass          *
CreateTclass()
{
   TextClass          *t;

   EDBUG(5, "CreateTclass");
   t = Emalloc(sizeof(TextClass));
   if (!t)
      EDBUG_RETURN(NULL);
   t->name = NULL;
   t->norm.normal = t->norm.hilited = t->norm.clicked = t->norm.disabled = NULL;
   t->active.normal = t->active.hilited = t->active.clicked = t->active.disabled = NULL;
   t->sticky.normal = t->sticky.hilited = t->sticky.clicked = t->sticky.disabled = NULL;
   t->sticky_active.normal = t->sticky_active.hilited = t->sticky_active.clicked = t->sticky_active.disabled = NULL;
   EDBUG_RETURN(t);
}

TextState          *
CreateTextState()
{
   TextState          *ts;

   EDBUG(6, "CreateTextState");
   ts = Emalloc(sizeof(TextState));
   if (!ts)
      EDBUG_RETURN(NULL);
   ts->fontname = NULL;
   ts->style.mode = MODE_WRAP_CHAR;
   ts->style.orientation = FONT_TO_RIGHT;
   ts->style.justification = 0;
   ts->style.spacing = 0;
   ts->font = NULL;
   EDBUG_RETURN(ts);
}

void
TclassPopulate(TextClass * tclass)
{
   EDBUG(6, "TclassPopulate");
   if (!tclass)
      EDBUG_RETURN_;

   if (!tclass->norm.normal)
      EDBUG_RETURN_;
   if (!tclass->norm.hilited)
      tclass->norm.hilited = tclass->norm.normal;
   if (!tclass->norm.clicked)
      tclass->norm.clicked = tclass->norm.normal;
   if (!tclass->norm.disabled)
      tclass->norm.disabled = tclass->norm.normal;

   if (!tclass->active.normal)
      tclass->active.normal = tclass->norm.normal;
   if (!tclass->active.hilited)
      tclass->active.hilited = tclass->active.normal;
   if (!tclass->active.clicked)
      tclass->active.clicked = tclass->active.normal;
   if (!tclass->active.disabled)
      tclass->active.disabled = tclass->active.normal;

   if (!tclass->sticky.normal)
      tclass->sticky.normal = tclass->norm.normal;
   if (!tclass->sticky.hilited)
      tclass->sticky.hilited = tclass->sticky.normal;
   if (!tclass->sticky.clicked)
      tclass->sticky.clicked = tclass->sticky.normal;
   if (!tclass->sticky.disabled)
      tclass->sticky.disabled = tclass->sticky.normal;

   if (!tclass->sticky_active.normal)
      tclass->sticky_active.normal = tclass->norm.normal;
   if (!tclass->sticky_active.hilited)
      tclass->sticky_active.hilited = tclass->sticky_active.normal;
   if (!tclass->sticky_active.clicked)
      tclass->sticky_active.clicked = tclass->sticky_active.normal;
   if (!tclass->sticky_active.disabled)
      tclass->sticky_active.disabled = tclass->sticky_active.normal;
   EDBUG_RETURN_;
}

void
TclassApply(ImageClass * iclass, Window win, int w, int h, int active, int state, char expose, TextClass * tclass, char *text)
{
   TextState          *ts;

   EDBUG(4, "TclassApply");
   if ((!iclass) || (!tclass) || (!win) || (w < 1) || (h < 1))
      EDBUG_RETURN_;
   ts = NULL;

   switch (active & (EWIN_ACTIVE | EWIN_STICKY))
     {
     case EWIN_ACTIVE:
	switch (state)
	  {
	  case STATE_NORMAL:
	     ts = tclass->active.normal;
	     break;
	  case STATE_HILITED:
	     ts = tclass->active.hilited;
	     break;
	  case STATE_CLICKED:
	     ts = tclass->active.clicked;
	     break;
	  case STATE_DISABLED:
	     ts = tclass->active.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case EWIN_STICKY:
	switch (state)
	  {
	  case STATE_NORMAL:
	     ts = tclass->sticky.normal;
	     break;
	  case STATE_HILITED:
	     ts = tclass->sticky.hilited;
	     break;
	  case STATE_CLICKED:
	     ts = tclass->sticky.clicked;
	     break;
	  case STATE_DISABLED:
	     ts = tclass->sticky.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case (EWIN_ACTIVE | EWIN_STICKY):
	switch (state)
	  {
	  case STATE_NORMAL:
	     ts = tclass->sticky_active.normal;
	     break;
	  case STATE_HILITED:
	     ts = tclass->sticky_active.hilited;
	     break;
	  case STATE_CLICKED:
	     ts = tclass->sticky_active.clicked;
	     break;
	  case STATE_DISABLED:
	     ts = tclass->sticky_active.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     case 0:
	switch (state)
	  {
	  case STATE_NORMAL:
	     ts = tclass->norm.normal;
	     break;
	  case STATE_HILITED:
	     ts = tclass->norm.hilited;
	     break;
	  case STATE_CLICKED:
	     ts = tclass->norm.clicked;
	     break;
	  case STATE_DISABLED:
	     ts = tclass->norm.disabled;
	     break;
	  default:
	     break;
	  }
	break;
     default:
	break;
     }
   if (!ts)
      EDBUG_RETURN_;
   if (!ts->fontname)
      EDBUG_RETURN_;
   if (!ts->font)
      ts->font = Fnlib_load_font(fd, ts->fontname);
   if (!ts->font)
      EDBUG_RETURN_;
   XClearWindow(disp, win);
   Fnlib_draw(fd, ts->font, win, 0, iclass->padding.left, iclass->padding.top,
	      w - (iclass->padding.left + iclass->padding.right),
	      h - (iclass->padding.top + iclass->padding.bottom),
	      0, 0, h - (iclass->padding.top + iclass->padding.bottom),
	      &ts->style, (unsigned char *)text);
   EDBUG_RETURN_;
}
