.\" t
.\" @(#)FvwmIconMan.1	7/16/97
.de EX          \"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH FvwmIconMan 1.0 "July 16, 1997"
.UC
.SH NAME
FvwmIconMan \- an Fvwm Icon Manager
.SH SYNOPSIS
FvwmIconMan is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
FvwmIconMan is an icon manager modeled after the TWM icon manager.  The user
may have multiple icon managers, each of which armed with a list of window
types which it manages. For example, the user may have one manager which lists
only emacs windows, and another which lists everything else. You may also
specify what resolution each icon manager uses, for example, one icon manager
may manage windows on all desks, and another may manage only those on the
current desk, or page. If you have applied the MiniIcons patch to fvwm2, then
FvwmIconMan can display the miniature icons for its managed windows. The
managers may have a maximum number of columns (and so grows vertically), a
maximum number of rows (and then grows horizontally), or stay at a fixed size, 
and adjust the size of the window buttons to fit (think win95's Taskbar). And
when support is compiled in for the X Shape extension, then the manager windows
may be shaped.

You can specify actions to be run when mouse, or key events are received. For
example, you could bind the first mouse button to iconify the selected window,
and make bindings for the arrow keys to navigate the manager window without
the mouse.

FvwmIconMan can be set to display which window currently has the keyboard
focus, and by binding the select event (see below) to the fvwm Focus function,
you can emulate the TWM icon manager's behavior.

.SH INITIALIZATION
During initialization, FvwmIconMan searches though the fvwm configuration file
for the options which are described below. It is highly recommended that you
make FvwmIconMan be a sticky window. And if you want to make use of the
followfocus option, and/or binding an action to Focus, then you should make
FvwmIconMan clicktofocus. Also, when using the Shape option, it's recommended
that the FvwmIconMan window not be decorated at all by fvwm. 

.SH INVOCATION
FvwmIconMan can be invoked by inserting the line 'Module FvwmIconMan' in the .fvwmrc file. If FvwmIconMan is to be spawned during fvwm's initialization,
then this line should be placed in the InitFunction and ResetFunction
declarations, or it can be bound to a menu, mouse button, or keystroke to
invoke it later. FvwmIconMan should be placed in the ModulePath (defined in
the .fvwmrc file) in order for fvwm to find it.

If you wish to run FvwmIconMan in a transient mode, such as with the built in
window list, then pass Transient as an argument. The invocation "Module
FvwmIconMan Transient" will do nicely. In this mode, FvwmIconMan will pop up
one manager window directly under the cursor. When the mouse button is
released, it will execute the appropriate action, and then exit.  Things are
somewhat complicated by the fact that you can specify that FvwmIconMan create
multiple manager windows, behavior which is unsuitable when running
transiently. So, when running transiently, FvwmIconMan will only create one
manager window. Use the manager id 'transient' to specify options for this
manager window.

.SH CONFIGURATION OPTIONS REFERENCE CHART
FvwmIconMan has acquired quite a few options. I assume others share my dislike
of paging though a long manpage, so here is a terse reference chart describing
the available options. They are described in more detail in the next section.

.ft C                   \" Courier
.nf
Name            Description                Default
.ft P

action          binds command to event     Mouse 0 N sendcommand Iconify
background      default background         gray
buttongeometry  size of button in pixels   100x17
dontshow        list of windows to ignore  
drawicons       use miniicons              false
focusandselectbutton                       flat black white
focusbutton     style for focused buttons  up black white
followfocus     show which win has focus   false
font                                       8x13
foreground      default text color         white
format          describes button label     "%c: %i"
iconname        manger icon name           FvwmIconMan
managergeometry size of manager in buttons 0x1
nummanagers     number of managers         1
plainbutton     style for normal buttons   up white gray
resolution      global, desk, or page      global  
selectbutton    style for selected buttons flat white gray 
shape           use shape extension        false
show            list of windows to show
sort            keep managers sorted       true
title           manager title              FvwmIconMan
titlebutton     style for title button     raisededge white gray
usewinlist      honor WinListSkip?         true

.fi

.SH CONFIGURATION OPTIONS
With the exception of the nummanagers option, all of the options may be
defined on a per-manager basis. So, for example, the user may have his emacs
manager with a red foreground, and his xterm manager with a blue one. A
configuration line may therefore have one of two forms:

.IP "*FvwmIconMan*optionname optionvalue"
To specify that the \fIoptionname\fP takes the value \fIoptionvalue\fP 
for all managers.
.IP "*FvwmIconMan*managerid*optionname optionvalue"
To specify that the option \fIoptionname\fP takes the value \fIoptionvalue\fP
for manager \fImanagerid\fP. \fIMangerid\fP may either be a positive integer,
or the string "transient". An integral id refers to managers which FvwmIconMan
creates when running normally, and an id of "transient" refers to the single
manager which FvwmIconMan creates when running transiently.

.PP
The following options may be specified:

.IP "*FvwmIconMan*nummanagers \fInum\fP"
\fInum\fP is a positive integer specifying the total number of icon managers.
Since FvwmIconMan would like to know how many managers there are before
handling any manager specific options, this should come first. The default
is 1.

.IP "*FvwmIconMan*[id*]action \fItype\fP \fIbinding\fP
Binds an FvwmIconMan command to an event. \fIType\fP may be one of the values:
Key, Mouse, or Select. Actions are described in the following section ACTIONS.

.IP "*FvwmIconMan*[id*]background \fIbackground\fP"
Specifies the default background color.

.IP "*FvwmIconMan*[id*]buttongeometry \fIgeometry\fP"
Specifies the initial geometry of an individual button in pixels. If the
specified height is 0, then the button height is determined from the font
size. X and Y coordinates are ignored.

.IP "*FvwmIconMan*[id*]drawicons \fIboolean\fP"
If your version of fvwm2 is capable of using MiniIcons, then this option
determines if FvwmIconMan displays the MiniIcons. Otherwise, it generates
an error message.

.IP "*FvwmIconMan*[id*]focusbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons whose
windows have the keyboard focus. 

.IP "*FvwmIconMan*[id*]focusandselectbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons which are
both selected, and have the keyboard focus.

.IP "*FvwmIconMan*[id*]font \fIfont\fP"
Specifies the font to be used for labeling the buttons. The default is 8x13.

.IP "*FvwmIconMan*[id*]foreground \fIforeground\fP"
Specifies the default foreground color.

.IP "*FvwmIconMan*[id*]format \fIformatstring\fP"
A printf like format string which describes the string to be printed in the
manager window for each managed window. Possible flags are: %t, %i, %c, and
%r for the window's title, icon, class, or resource name, respectively. 
The default is "%c: %i". \fBWarning\fP: m4 reserves the word \fIformat\fP, 
so if you use m4, take appropriate action.

.IP "*FvwmIconMan*[id*]iconname \fIiconstring\fP"
Specifies the window icon name for that manager window. \fIIconstring\fP
may either be a single word, or a string enclosed in quotes. The default is
"FvwmIconMan".

.IP "*FvwmIconMan*[id*]managergeometry \fIgeometry\fP"
Specifies the initial geometry of the manager, in units of buttons. If
\fIheight\fP is 0, then the manager will use \fIwidth\fP columns, and will
grow vertically once it has more than \fIwidth\fP windows. Likewise, if
\fIwidth\fP is 0, it will use \fIheight\fP rows, and grow horizontally.  If
both are nonzero, then the manager window will be exactly that size, and stay
that way. As columns are created, the buttons will narrow to accommodate.  If
the geometry is specified with a negative y coordinate, then the window
manager will grow upwards. Otherwise, it will grow downwards.

.IP "*FvwmIconMan*[id*]plainbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Specifies how normal buttons look. \fIstyle\fP may be one of \fIflat\fP,
\fIup\fP, \fIdown\fP, \fIraisededge\fP, or \fIsunkedge\fP, and describes how
the button is drawn. The color options are both optional, and if not set, then
the default colors are used. If on a monochrome screen, then the \fIstyle\fP
option is ignored, but must still be set.

.IP "*FvwmIconMan*[id*]resolution \fIresolution\fP"
Specifies when the manager will display an entry for a certain
window. \fIresolution\fP may take one of the following values: global, desk,
or page. If global, then all windows of the appropriate type (see the show and
dontshow options below) will be shown. If desk, then only those windows on the
current desk will be down. And if page, then only those windows on the current
page will be shown. The default is global.

.IP "*FvwmIconMan*[id*]selectbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons when the
mouse is over them.

.IP "*FvwmIconMan*[id*]shape \fIboolean\fP"
If \fITrue\fP, then use make the window shaped. Probably only useful if you
have multiple columns or rows. If FvwmIconMan wasn't compiled to support the
Shape extension, this generates an error message. When using shaped windows,
it's recommended that a fvwm style is made for FvwmIconMan that has no borders.
Otherwise, fvwm will get confused.

.IP "*FvwmIconMan*[id*]title \fItitlestring\fP"
Specifies the window title string for that manager window. \fITitlestring\fP
may either be a single word, or a string enclosed in quotes. The default is
"FvwmIconMan". This will be drawn in the titlebar of the manager window, if 
any, and in the title button, which is the button drawn when the manager is
empty.

.IP "*FvwmIconMan*[id*]titlebutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of the title button
(the button drawn when the manager is empty). The manager's title is drawn
in the title button.

.PP
The two following options control which windows get handled by which
managers. A manager can get two lists, one of windows to show, and one of
windows to ignore. If only the \fIshow\fP list is given, then that manager
will show only the windows in the list. If only the \fIdontshow\fP list is
given, then the manager will show all windows except those in the list. If
both lists are given, then a window will be shown if it is not in the
\fIdontshow\fP list, and in the \fIshow\fP list. And finally, if neither list
is given, then the manager will handle all windows. Each list is made up of
patterns of the form \fItype=pattern\fP, where type is one of \fIclass\fP,
\fIresource\fP, \fItitle\fP, or \fIicon\fP, and pattern is an expression of
the same format used in the fvwm style command (minimalistic shell pattern
matching). Quotes around the pattern will be taken as part of the
expression. If a window could be handled by more than one manager, then the
manager with the lowest id gets it.

.IP "*FvwmIconMan*[id*]show \fIpattern list\fP"
If a window matches one of the patterns in the list, then it may be handled
by this manager.

.IP "*FvwmIconMan*[id*]dontshow \fIpattern list\fP"
If a window matches one of the patterns in the list, then it may not be
handled by this manager.

.IP "*FvwmIconMan*[id*]usewinlist \fIboolean\fP"
If \fItrue\fP, then honor the WinListSkip style flag. Otherwise, all windows
are subject to possible management according to the show and dontshow lists.

.IP "*FvwmIconMan*[id*]followfocus \fIboolean\fP"
If \fItrue\fP, then the button appearance reflects
which window currently has focus.  Default is false.

.IP "*FvwmIconMan*[id*]sort \fIboolean\fP"
If \fItrue\fP, then the icon manager is kept sorted. Default is true.

.SH ACTIONS
Actions are commands which may be bound to an event of the type: a keypress, a
mouse click, or the mouse entering a window manager button - denoted by the
action types \fIKey\fP, \fIMouse\fP, and \fISelect\fP.

Normally, actions bound to a mouse click are executed when the button is
pressed. In transient mode, the action is executed when the button is
released, since it is assumed that FvwmIconMan was bound to some mouse
event. A tip/warning: FvwmIconMan still keeps track of the mouse button and
any modifier keys in this case, so if you bind FvwmIconMan to say,
meta-button3, then it would be wise to ensure that the action you want to
execute will be executed when the meta-button3 event occurs (which would be
the button release, assuming you kept your finger on the meta key).

The syntax for actions are:

.IP "\fBKey actions\fP: Key \fIKeysym\fP \fIModifiers\fP \fIFunctionList\fP"
\fIKeysym\fP and \fIModifiers\fP are exactly the same as for the fvwm \fIKey\fP
command. 

.IP "\fBMouse actions\fP: Mouse \fIButton\fP \fIModifiers\fP \fIFunctionList\fP"
\fIButton\fP and \fIModifiers\fP are exactly the same as for the fvwm 
\fIMouse\fP command.

.IP "\fBSelect actions\fP: Select \fIFunctionList\fP"

.PP
A \fIFunctionList\fP is a sequence of commands separated by commas. They are
executed in left to right order, in one shared context - which currently only
contains a pointer to the "current" button. If a button is selected (typically
by the mouse pointer sitting on it) when the action is executed, then the 
current button is initialized to that button. Otherwise, it points to nothing. 

Most of the available commands then modify this "current" button, either by 
moving it around, making it become the selected button, or sending commands
to fvwm acting on the window represented by that button. Note that while this
current button is initialized to be the selected button, the selected button
does not implicitly follow it around. This way, the user can send commands
to various windows, without changing which button is selected.

Commands take five types of arguments: \fIInteger\fP, \fIManager\fP,
\fIWindow\fP, \fIButton\fP, and \fIString\fP. A \fIString\fP is a string
specified exactly as for fvwm - either in quotes or as a single word not in
quotes. Again, you may bind a sequence of commands to an event, by listing
them separated by commas.

\fIWindow\fP and \fIButton\fP types look exactly the same in the .fvwm2rc
file, but are interpreted as either specifying a managed window, or a
FvwmIconMan button representing a window. They can either be an integer (which
is interpreted module N where N is the number of buttons - so 0 is the first
and -1 is the last), or one of the strings: \fISelect\fP, \fIFocus\fP,
\fIUp\fP, \fIDown\fP, \fIRight\fP, \fILeft\fP, \fINext\fP,
\fIPrev\fP. \fISelect\fP and \fIFocus\fP refer to the currently selected or
focused button or window. \fIUp\fP, \fIDown\fP, \fIRight\fP, and \fILeft\fP
refer to the button or window above, below, to the right of, or to the left of
the current button in the manager window, allowing navigation around the
manager window. \fINext\fP and \fIPrev\fP designates the window, button, or
manager after or before the current button, allowing navigation of the one
dimensional list of windows which is drawn in the manager window. If the
manager is sorted, \fINext\fP and \fIPrev\fP move through the windows in 
alphabetical order.

The \fIManager\fP type can either be an integer, \fINext\fP, or \fIPrev\fP. 
The meaning is analogous to that of the \fIButton\fP type, but in terms of
the integral index of the managers, restricted to managers which are nonempty.

The following functions are currently defined:
.IP "bif \fIButton\fP \fIInteger/String\fP"
A relative branch instruction. If \fIButton\fP is \fISelect\fP or \fIFocus\fP,
then take the branch if there is a selected button or a focused button. If
\fIButton\fP is an integer, then branch if nonzero. If it is one of \fIUp\fP,
\fIDown\fP, \fIRight\fP, \fILeft\fP, \fINext\fP, \fIPrev\fP, then the branch is
taken when the current button can move in that direction. If the branch is
taken, then \fIInteger\fP commands are skipped. No backwards branches are
allowed.

.IP "bifn \fIButton\fP \fIInteger/String\fP"
The complement of bif. The branch is taken if \fIButton\fP evaluates to false,
by the criteria listed for bif.

.IP "gotobutton \fIButton\fP"
Sets current button to \fIButton\fP. If \fIButton\fP is an integer, then 
the current button is set to \fIButton\fP modulo the number of buttons,
in the whichever manager contains the selected button, if any.

.IP "gotomanager \fIManager\fP"
Sets button to button 0 of \fIManager\fP. This will only go to a visible,
nonempty manager. So an integral argument is taken modulo the number of such
managers.

.IP "jmp \fIInteger/String\fP"
Executes a relative jump of \fIInteger\fP instructions. Backwards jumps are
not allowed. The jump is computed relative to the instruction following the
jmp.

.IP "label \fIString\fP"
Provides a label that previous instructions can jump to. It will not be
visible to subsequent jump instructions, and the same label can be used
multiple times in the same instruction list (though it would be perverse
to do so.)

.IP "print \fIString\fP"
Prints \fIString\fP to the console. Useful for debugging actions.

.IP "quit"
Quits FvwmIconMan.

.IP "ret"
Stop executing the entire action.

.IP "select"
Selects the current button, if any. If a select action has been specified, 
it will then be run. Therefore, it is considered unwise to set the select
button in the select action.

.IP "sendcommand \fICommand\fP"
Sends the fvwm command \fICommand\fP to the window represented by the current
button, if any.

.IP "warp"
Warps cursor to current button, if any.

.PP
.B Examples:
.EX
gotobutton select, gotobutton Down, select
.EE
Selects the button below the currently selected button. Since the 
current button is already initialized to the selected button, this may be
shortened to "gotobutton Down , select".

.EX
gotobutton Up, select
.EE
Selects the button above the currently selected button.

.EX
gotobutton 0, select
.EE
Selects the first button of the current manager. If there is no current 
manager, which is the case when no button is selected, then this does nothing.

.EX
gotobutton -1, select
.EE
Selects the last button of the current manager.

.EX
gotobutton focus, select
.EE
Selects the button corresponding to the focused window.

.EX
gotobutton focus, Iconify
.EE
Sends the fvwm command Iconify to the focused window. Note that this
does not change the selected button.

.EX
bif Next 3, gotobutton 0, select, ret, gotobutton Next, select
.EE
If a button is selected, and it's the last button, go to button 0. If it's
not the last button, go to the next button. Otherwise, do nothing. Basically, 
this action cycles through all buttons in the current manager.

.EX
bif select 7, bif focus 3, gotomanager 0, select, ret, gotobutton focus, select, ret, gotobutton down, select
.EE
This is good for sending to FvwmIconMan with a SendToModule command. If there
is a selected button, it moves down. Otherwise, if there is a focused button,
it is selected. Otherwise, button 0 of manager 0 gets selected.

.EX
bif select Select, bif focus Focus, gotomanager 0, select, ret, label Focus, gotobutton focus, select, ret, label Select, gotobutton down, select
.EE
Same as previous, but using the label instruction. 

.PP
In addition to being bound to keys and mice, actions can be sent from fvwm to
FvwmIconMan via the SendToModule command. Don't quote the command when using
SendToModule. Also, due to a bug in the current version of fvwm2, don't quote
FvwmIconMan either. 

.SH SAMPLE CONFIGURATIONS
This first example is of a the simplest invocation of FvwmIconMan, which only
has one manager, and handles all windows:

.nf
.sp
##############################################################
# Load any modules which should be started during 
# fvwm initialization
ModulePath /usr/lib/X11/fvwm:/usr/bin/X11
Module FvwmIconMan

# Make FvwmIconMan title-bar-less, sticky, and give it an icon	
Style "Fvwm*"      Icon toolbox.xpm,NoTitle,NoHandles,Sticky
Style "FvwmIconMan" HandleWidth 5, Handles, BorderWidth 5


##############################################################
##############################################################
#Definitions used by the modules

*FvwmIconMan*nummanagers        1
*FvwmIconMan*resolution         global
*FvwmIconMan*background         slategrey
*FvwmIconMan*foreground         white
*FvwmIconMan*font               7x13
*FvwmIconMan*buttongeometry     100x0
*FvwmIconMan*managergeometry    1x0-0+0
.sp
.fi

This example is the Reader's Digest version of my personal configuration. It
has two managers, one for emacs and one for everything else, minus things with
no icon title. Only windows on the current page are displayed. The use of the
\fIdrawicons\fP and \fIshape\fP options requires that fvwm and FvwmIconMan we
compiled with the correct options. Note how the geometry and show options are
specified per manager, and the others are common to all:

.nf
.sp
Style "FvwmIconMan"  NoTitle, Sticky, WindowListSkip, BorderWidth 0
Style "FvwmIconMan"  HandleWidth 0


Key F8 A N SendToModule FvwmIconMan bif select Select, bif focus Focus, gotomanager 0, select, sendcommand WarpToWindow, ret, label Focus, gotobutton focus, select, sendcommand WarpToWindow, ret, label Select, gotobutton prev, select, sendcommand WarpToWindow
Key F9 A N SendToModule FvwmIconMan bif select Select, bif focus Focus, gotomanager 0, select, sendcommand WarpToWindow, ret, label Focus, gotobutton focus, select, sendcommand WarpToWindow, ret, label Select, gotobutton next, select, sendcommand WarpToWindow

*FvwmIconMan*numManagers 2
*FvwmIconMan*Resolution  page
*FvwmIconMan*background  steelblue
*FvwmIconMan*foreground  white
*FvwmIconMan*font        7x13
*FvwmIconMan*usewinlist  true
*FvwmIconMan*drawicons   true
*FvwmIconMan*shape	 true
*FvwmIconMan*followfocus true
*FvwmIconMan*sort	 true
*FvwmIconMan*plainbutton          up white steelblue
*FvwmIconMan*selectbutton         down white steelblue
*FvwmIconMan*focusbutton          up white brown
*FvwmIconMan*focusandselectButton down white brown
*FvwmIconMan*titleButton          raisededge white steelblue

*FvwmIconMan*1*title           "Emacs windows"
*FvwmIconMan*1*iconname        "FvwmIconMan: Emacs"
*FvwmIconMan*1*format          "%i"
*FvwmIconMan*1*show            resource=emacs resource=gemacs
*FvwmIconMan*1*managergeometry 1x0-400+0
*FvwmIconMan*1*buttongeometry  200x0

*FvwmIconMan*2*title           "All windows"
*FvwmIconMan*2*iconname        "FvwmIconMan: all"
*FvwmIconMan*2*format          "%c: %i"
*FvwmIconMan*2*dontshow        icon=Untitled
*FvwmIconMan*2*managergeometry 2x4-0+0
*FvwmIconMan*2*buttongeometry  200x0

*FvwmIconMan*transient*geometry 194x100
*FvwmIconMan*transient*dontshow icon=Untitled
*FvwmIconMan*transient*action   Mouse 0 A sendcommand select select Iconify

*FvwmIconMan*action	Mouse	1 N sendcommand Iconify
*FvwmIconMan*action	Mouse	2 N sendcommand WarpToWindow
*FvwmIconMan*action	Mouse	3 N sendcommand "Module FvwmIdent FvwmIdent"
*FvwmIconMan*action	Key	Left  N gotobutton Left, select
*FvwmIconMan*action	Key	Right N gotobutton Right, select
*FvwmIconMan*action	Key	Up    N gotobutton Up, select
*FvwmIconMan*action	Key	Down  N gotobutton Down, select
*FvwmIconMan*action	Key	q     N quit
.sp
.fi

.SH UNFINISHED BUSINESS
There is one bug that I know of. A honest to goodness solution to this would
be appreciated. When an icon manager is set to grow upwards or leftwards, on
some machines it may wander occasionally.

It doesn't handle windows without resource names as gracefully as it should.

.SH AUTHOR
Brady Montz (bradym@cs.arizona.edu).

.SH THANKS
.nf
Thanks to: 
	David Berson (berson@cs.pitt.edu), 
	Josh M. Osborne (stripes@va.pubnix.com, 
	Bjorn Victor (victor@delial.docs.uu.se),
	Adam Rice (wysiwyg@glympton.airtime.co.uk).
