package MCanvas;
require Tk;
require Tk::Canvas;
use MLine;
use English;
use Carp;
@ISA = qw(Tk::Canvas);

Construct Tk::Widget 'MCanvas';

sub new {
    my $class = shift;
    my $w = shift;
    my $self = $w->Canvas();
    bless $self,$class;
    $self->init();
    $self->configure(@_);
    $self->move_bind;
    return $self;
}

sub getxy {
    my $c = shift;
    my $e = $c->XEvent;
    return($c->canvasx($e->x),$c->canvasx($e->y));
}

sub make_item {
    my $self = shift;
    my $type = shift;
    my($it,$obj);
    if ($type eq 'line') {
	 $obj = new MLine(@_);
	 $it = $obj->create($self);
#	push @{$self->{Lines}},$obj;
    }
    if (defined $it) {
	$self->{Items}->{$it} = $obj;
	$self->ifmble($it);
	push @{$self->{ItemOrder}},$it; #order of creation.
    }
    return $obj;
}

sub kill_item {
    my $self = shift;
    my $it = shift;
    $self->{Items}->{$it}->destroy;
    delete $self->{Items}->{$it};
    my $i;
    my $ref = $self->{ItemOrder};
#    &main::debug (0,"killing");
    for($i=0;$i<@$ref;$i++) {
	if ($$ref[$i] == $it ) {
	    splice(@$ref,$i,1); #remove it
#	    &main::debug (0,"found $it");
	    return $it;
	}
    }
#    &main::debug (0,"can't kill");
    carp "Can't find item to kill";
}

sub find_item_order {
    my $self = shift;
    my $it = shift;
    my $ref = $self->{ItemOrder};
    my $i;
#    &main::debug (0,"finding");
    for($i=0;$i<@$ref;$i++) {
	if ($$ref[$i] == $it ) {
	    return $i;
	}
    }
#    &main::debug (0,"can't find");
    carp "Couldn't find item in order list";
}

sub replace_item_order {
    my $self = shift;
    my($i,$id) = @_;
    $self->{ItemOrder}->[$i] = $id;
#    &main::debug (0, join ":",@{$self->{ItemOrder}});
}

sub get_items {
    my $self = shift;
    return (%{$self->{Items}});
}

sub get_item_order {
    my $self = shift;
    return (@{$self->{ItemOrder}});
    
}
#sub get_lines {
#    my $self = shift;
#    my @list;
#}



#####################################################
sub new_group {
    my $self = shift;
    ($self->{MaxGroup})++;
    return "g".$self->{MaxGroup};
}

sub add_to_group {
    my $self = shift;
    my $obj = shift;
    my $group = shift;
    $obj->group($group);
=pod
    if (exists $self->{GroupOrder}->{$group}) {
	($self->{GroupSize}->{$group}) ++ ;
	$self->{GroupOrder}->{$group}->{$obj} = $self->{GroupSize}->{$group};
    }
    else {
	$self->{GroupSize}->{$group} = 1;
	$self->{GroupOrder}->{$group}->{$obj} = 1;
    }
=cut
}

sub destroy_group {
    my $self = shift;
    
}

sub ungroup_selected {
    my $self = shift;
    my @items = $self->items_with('sel');
    foreach (@items) {
	$_->ungroup;
    }
}

sub group_selected {
    my $self = shift;
    my @items = $self->items_with('sel');
    my $group = $self->new_group;
    foreach (@items) {
	$_->group($group);
    }

}

sub init {
    my $c = shift;
    $c->{Lines} = [];
    $c->{TempLine} = '';
    $self->{Items} = {};
    $self->{MaxGroup} = 0;
    $self->{ItemOrder} = [];
#    $self->{GroupOrder} = {};
#    $self->{GroupSize} = {};
}


##
sub current_item {
    my $self = shift;
    my $it = $self->find('withtag','current');
    return $self->{Items}->{$it} if exists $self->{Items}->{$it};
    return undef;
}

sub current_item_id {
    my $self = shift;
    my $it = $self->find('withtag','current');
    return $it if defined $it;
    return undef;
}

sub items_with {
    my $self = shift;
    my $tag = shift;
    my @list = $self->find('withtag',$tag);
    my @out;
    foreach (@list) {
	push @out,$self->{Items}->{$_} if exists $self->{Items}->{$_};
    }
    return @out;
}

sub select_bind {
    my $self = shift;
    $self->clear_bind;
    $self->bind('all', '<1>' => sub {
	$self->select_current;
    });
    $self->bind('all', '<2>' => sub {
	$self->deselect_current;
    });
    $self->Tk::bind('<3>' => sub {
	$self->deselect_all;
    });
}

sub group_select_bind {
    my $self = shift;
    $self->clear_bind;
    $self->bind('all', '<1>' => sub {
	$self->select_group;
    });
    $self->bind('all', '<2>' => sub {
	$self->deselect_group;
    });
    $self->Tk::bind('<3>' => sub {
	$self->deselect_all;
    });
}


sub select_current {
    my $self = shift;
    $self->current_item()->select;

}

sub get_current_group {
    my $self = shift;
    my @items = $self->items_with($self->current_item()->get_group());
    return @items;
}

sub select_group {
    my $self = shift;
    my @items = $self->items_with($self->current_item()->get_group());

    if (@items == 0 ) {
	$self->current_item()->select();
	return;
    }
    foreach (@items) {
	$_->select();
    }
}

sub deselect_group {
    my $self = shift;
    my @items = $self->items_with($self->current_item()->get_group());
    foreach (@items) {
	$_->deselect();
    }
}


sub deselect_current {
    my $self = shift;
    $self->current_item()->deselect;

}


sub select_all {
    my $self = shift;
    my @items = $self->items_with('all') ;
    foreach (@items) {
	$_->select;
    }
}

sub deselect_all {
    my $self = shift;
    my @items = $self->items_with('sel') ;
    foreach (@items) {
	$_->deselect;
    }
}

sub mble {
    my $self = shift;
    my $id = shift;
    $self->addtag('mble', "withtag" , $id);
}

sub delete_group_bind {
    my $self = shift;
    $self->clear_bind;
    $self->bind('all', '<1>' => sub {
	my @items  = $self->find('withtag',$self->current_item()->get_group());
	my ($it);
	foreach $it (@items) {
	    $self->kill_item($it);
#	    $self->{Items}->{$it}->destroy;
#	    delete $self->{Items}->{$it};
	}
#	$self->delete('current');
    }
  );


}

sub delete_bind {
    my $self = shift;
    $self->clear_bind;
    $self->bind('all', '<1>' => sub {
#	print $self->find('withtag','current'),"\n";
	my $it = $self->find('withtag','current');
	$self->kill_item($it);
#	$self->{Items}->{$it}->destroy;
#	delete $self->{Items}->{$it};
	$self->delete('current');
    }
  );
}

sub delete_selected {
    my $self = shift;
    my @list = $self->find('withtag','sel');
#    main::debug 0, join ";",@list;
    foreach(@list) {
	if (exists $self->{Items}->{$_} ) {
	    $self->kill_item($_);
#	    $self->{Items}->{$_}->destroy;
#	    delete $self->{Items}->{$_};   
	    $self->delete($_);
	}
    }
}

sub clear_bind {
    my $self = shift;
    foreach ('mble','all') {
	$self->bind($_, '<1>' => '');
	$self->bind($_, '<2>' => '');
	$self->bind($_, '<3>' => '');
	$self->bind($_, '<B1-Motion>' => '');
    }
    $self->Tk::bind('<1>' => '');
    $self->Tk::bind('<2>' => '');
    $self->Tk::bind('<3>' => '');
    $self->Tk::bind('<Motion>' => '');
    $self->Tk::bind('<B1-Motion>' =>'');
}


sub set_line_conf {
    my $self = shift;
    $self->{LineConf} = [@_];
}

# single lines, not one
# but grouped together
sub sline_bind {
    my $self = shift;
    $self->clear_bind;
    $self->{LineConf} = [@_] if @_;
    $self->{LineConf} = [] unless defined $self->{LineConf};
    $self->{LineCoords} = [] ;
# start a set
    $self->Tk::bind('<1>' => sub {
	my $r = $self->{LineCoords};
	push @$r,$self->getxy;
	if( @$r > 2 ) {
	    $self->{TempLine}->destroy;
	    $self->{TempLine}='';
	    my $s = @$r-1;
	    my $l =$self->make_item('line',[@$r[$s-3..$s]],$self->{LineConf});

	    $self->add_to_group($l,$self->{NewLineGroup});
	}
	else {
	    $self->{NewLineGroup} = $self->new_group;
	}
    });
# finish
    $self->Tk::bind('<2>' => sub {
	my $r = $self->{LineCoords};
	push @$r,$self->getxy;
	if( @$r > 2 ) {
	    my $s = @$r-1;
	    $self->{TempLine}->destroy;
	    $self->{TempLine}='';
	    my $l = $self->make_item('line',[@$r[$s-3..$s]],$self->{LineConf});
	    $self->add_to_group($l,$self->{NewLineGroup});
	}
	$self->{LineCoords} = [] ;
    }); 
# abort
    $self->Tk::bind('<3>' => sub {
	my $r = $self->{LineCoords};
	my ($i,$l);
	my @items = $self->find('withtag',$self->{NewLineGroup});
	foreach(@items) {
	    $self->kill_item($_);
#	    $self->{Items}->{$_}->destroy;
#	    delete $self->{Items}->{$_};
	}
	$self->{LineCoords} = [] ;
	$self->{TempLine}->destroy;
	$self->{TempLine}='';
    });
    $self->line_motion_bind();
} #end sline_bind 

sub line_bind {
    my $self = shift;
    $self->clear_bind;
    $self->{LineConf} = [@_] if @_;
    $self->{LineConf} = [] unless defined $self->{LineConf};
    $self->{LineCoords} = [] ;

    $self->Tk::bind('<1>' => sub {
	my $r = $self->{LineCoords};
	push @$r,$self->getxy;
	if( @$r > 2 ) {
	    $self->{TempLine}->destroy;
	    $self->{TempLine}='';
	    $self->{TempLine2}->destroy if exists $self->{TempLine2};
	    $self->{TempLine2} = new MLine([@$r],$self->{LineConf});
	    $self->{TempLine2}->create($self);
	}
    });
    $self->Tk::bind('<2>' => sub {
	$self->{TempLine}->destroy;
	$self->{TempLine}='';
	my $r = $self->{LineCoords};
	push @$r,$self->getxy;
	$self->{TempLine2}->destroy if exists $self->{TempLine2};
	delete $self->{TempLine2};
	my $l = $self->make_item('line',[@$r],$self->{LineConf});
	$self->{LineCoords} = [] ;
    }); 
    $self->line_motion_bind();     
}  # end line_bind


sub line_motion_bind {
    my $self = shift;
    $self->Tk::bind('<Motion>' => sub {
	my $r = $self->{LineCoords};
	return unless @$r >= 2;
	my $last = @$r;
	my($x,$y) = ($$r[$last-2],$$r[$last-1]);
	if($self->{TempLine}) {
	    $self->{TempLine}->destroy;
	}
	my ($xc,$yc) = $self->getxy;
#	print "$x,$y,$xc,$yc,@{$self->{LineConf}}\n";
	$self->{TempLine} = new MLine([$x,$y,$xc,$yc],$self->{LineConf});
	$self->{TempLine}->create($self);
    });
    
}
# begin move a vertex of joined lines.
sub vert_move_bind {
    my $self = shift;
    $self->clear_bind;
    $self->bind('all','<1>' => sub {
	my ($x,$y) = $self->getxy();
	my $item = $self->current_item();
	my @group = $self->get_current_group();
	my @coords = $item->get_coords();
	my ($i,$ind,$max,$d);
	$max=9999999;
	for ($i=0;$i<@coords-1;$i+=2) {
	    $d = ($coords[$i]-$x)*($coords[$i]-$x)+
		($coords[$i+1]-$y)*($coords[$i+1]-$y);
	    if($d<$max) {$max=$d;$ind=$i}
	}
	# store information on each vertex.
	$self->{VertMove}=[$item,$ind,[@coords]];
	$self->{VertOrder} = [$self->find_item_order($item->get_id)]; # so lines stay in order.
	my (@coords2,$ind2);
#	Now look for line segment with same endpoint as current item.
#       This will be second line of vertex
	foreach (@group) {
	   next if $item eq $_;
	   @coords2 = $_->get_coords(); 
	   for ($i=0;$i<@coords2-1;$i+=2) {
	       if($coords2[$i]==$coords[$ind] and
		  $coords2[$i+1]==$coords[$ind+1]) {
		   push @{$self->{VertMove}},$_,$i,[@coords2];
		   push @{$self->{VertOrder}},$self->find_item_order($_->get_id);
	       }
	   }
	}
    });
#=pod
    $self->Tk::bind('<B1-Motion>' => sub {
	my $verts = $self->{VertMove};
#	&main::debug( 0,join " ; ", @$verts);
	my ($i,$id);
	my ($x,$y) = $self->getxy();
	for ($i=0;$i<@$verts-2;$i+=3) {
	    $verts->[$i+2]->[$$verts[$i+1]]=$x;
	    $verts->[$i+2]->[$$verts[$i+1]+1]=$y;
	    delete $self->{Items}->{$$verts[$i]->get_id};
	    $id=$$verts[$i]->change_coords(@{$verts->[$i+2]});
	    $self->{Items}->{$id}=$$verts[$i];
	    # place new item in order list.
	    $self->replace_item_order($self->{VertOrder}->[$i/3],$id);
	    $self->ifmble($id);
	}
    });
#=cut
}# end vert_move_bind

sub mble_on {
    my $self = shift;
    $self->{AllMble} = 'Y';
}

sub mble_off {
    my $self = shift;
    $self->{AllMble} = 'N';
}

sub is_mble_on {
    my $self = shift;
    return 1 if $self->{AllMble} eq 'Y';
    return undef;
}

sub ifmble {
    my $self = shift;
    my $id = shift;
#    print "'$id', and '",
    $self->mble($id) if $self->is_mble_on;
}

sub move_bind {
    my $self = shift;
    $self->clear_bind;

    $self->bind('mble','<1>' => sub {
	my($c) = @ARG;
        my $e = $c->XEvent;
	$self->{thisX} = $e->x;
	$self->{thisY} = $e->y;
	$self->items_start_drag;
    });
    $self->bind('mble','<B1-Motion>' => sub {
	my($c) = @ARG;
        my $e = $c->XEvent;
	$self->{thisX} = $e->x;
	$self->{thisY} = $e->y;
	$self->items_drag;
    });
}

sub items_start_drag {

    my $self = shift;

    $self->{lastX} = $self->canvasx($self->{thisX});
    $self->{lastY} = $self->canvasy($self->{thisY});
    my @tags = $self->gettags('current');
    return unless @tags;
    my $group = '';
    foreach (@tags) {
	next unless /^g\d+/;
	$group = $_;
    }
    if (not $group) {
	$self->{MoveItems} = '';
	return;
    }
    $self->{MoveItems} = [$self->find('withtag',$group)];

} # end items_start_drag

sub items_drag {

    my($self, $item) = @ARG;

    my $x = $self->canvasx($self->{thisX});
    my $y = $self->canvasy($self->{thisY});
    if($self->{MoveItems}) {
	my $dx = $x-$self->{lastX};
	my $dy = $y-$self->{lastY};
	foreach (@{$self->{MoveItems}}) {
	    $self->move($_, $dx,$dy);
	}
    }
    else {
	$self->move('current', $x-$self->{lastX}, $y-$self->{lastY});
    }
    $self->{lastX} = $x;
    $self->{lastY} = $y;

} # end items_drag


1;








