%{
/*
 * Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: grammar.y,v 1.20 1998/09/04 15:06:56 onoe Exp $
 */
/*
 * partly derived from lbl libpcap source code, which has the following
 * copyright notice:
 */
/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "mgp.h"
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#if 0
#define QSET(q, p, d, a) (q).proto = (p),\
			 (q).dir = (d),\
			 (q).addr = (a)

static struct qual qerr = { Q_UNDEF, Q_UNDEF, Q_UNDEF, Q_UNDEF };
#endif

int n_errors = 0;
struct ctrl *root;
char *yyfilename;
int yylineno;

#ifdef HAVE_STDARG_H
/* GCC complains if we declare this function in traditional style */
static void
yyerror(char *msg, ...)
#else
static void
yyerror(msg)
	char *msg;
#endif
{
	va_list ap;
#ifdef HAVE_STDARG_H
	va_start(ap, msg);
#else
	va_start(ap);
#endif
	++n_errors;
	fprintf(stderr, "%s:%d: error: ", yyfilename, yylineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

#ifdef HAVE_STDARG_H
/* GCC complains if we declare this function in traditional style */
static void
yywarn(char *msg, ...)
#else
static void
yywarn(msg)
	char *msg;
#endif
{
	va_list ap;
#ifdef HAVE_STDARG_H
	va_start(ap, msg);
#else
	va_start(ap);
#endif
	fprintf(stderr, "%s:%d: warning: ", yyfilename, yylineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

static struct ctrl *
gen_void(op)
	int op;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate void node");
		return ct;
	}
	return ct;
}

static struct ctrl *
gen_double(op, v)
	int op;
	double v;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate integer node");
		return ct;
	}
	ct->ctf_value = v;
	return ct;
}

static struct ctrl *
gen_int(op, v)
	int op;
	int v;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate integer node");
		return ct;
	}
	ct->cti_value = v;
	return ct;
}

static struct ctrl *
gen_str(op, str)
	int op;
	char *str;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate color node");
		return ct;
	}
	ct->ctc_value = str;
	return ct;
}

static struct ctrl *
gen_color(op, color)
	int op;
	char *color;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate color node");
		return ct;
	}
	if (get_color(color, &ct->ctl_value) < 0)
		yyerror("cannot allocate color \"%s\"", color);
	return ct;
}

static struct ctrl *
gen_bgrad(w, h, colors, dir, zoomflg, extra)
	int w;
	int h;
	int colors;
	int dir;
	int zoomflg;
	struct ctrl *extra;
{
	struct ctrl *ct;
	struct ctrl *p;
	int siz;

	if (!(ct = ctlalloc1(CTL_BGRAD))) {
		yyerror("cannot allocate node (op=BGRAD)");
		return ct;
	}
	ct->ctd_width = w;
	ct->ctd_height = h;
	ct->ctd_numcolor = colors;
	ct->ctd_dir = dir;
	ct->ctd_zoomflag = zoomflg;

	/* process color list. */
	siz = ct->ctd_g_colors = 0;
	for (p = extra; p; p = p->ct_next)
		siz++;
	if (siz <= 2) {
		ct->ct_val.ctrl_grad.colors =
			malloc(3 * sizeof(struct gcolor *));
	} else {
		ct->ct_val.ctrl_grad.colors =
			malloc((siz + 1) * sizeof(struct gcolor *));
	}
	if (!ct->ct_val.ctrl_grad.colors) {
		yyerror("cannot allocate color table\n");
		return ct;
	}

	ct->ctd_g_colors = 2;
	ct->ct_val.ctrl_grad.colors[0] = name2gcolor(DEFAULT_GRADSTART);
	ct->ct_val.ctrl_grad.colors[1] = name2gcolor(DEFAULT_GRADEND);
	switch (siz) {
	case 0:
		break;
	case 1:
		ct->ct_val.ctrl_grad.colors[0] = name2gcolor(extra->ctc_value);
		break;
	default:
		ct->ctd_g_colors = siz;
		siz = 0;
		for (p = extra; p; p = p->ct_next) {
			ct->ct_val.ctrl_grad.colors[siz] =
				name2gcolor(p->ctc_value);
			siz++;
		}
	}

	/* normalize */
	if (ct->ctd_dir < 0) {	/*circle*/
		ct->ctd_mode = 1;
		ct->ctd_dir = abs(ct->ctd_dir);
	} else			/*linear*/
		ct->ctd_mode = 0;
	while (ct->ctd_dir < 0)
		ct->ctd_dir += 360;
	ct->ctd_dir %= 360;
	if (ct->ctd_width <= 0)
		ct->ctd_width = 100;
	if (ct->ctd_height <= 0)
		ct->ctd_height = 100;

	if (extra)
		ctlfree(extra);

	return ct;
}

static struct ctrl *
gen_image(fname, colors, xsiz, ysiz, zoomflg)
	char *fname;
	int colors;
	int xsiz;
	int ysiz;
	int zoomflg;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(CTL_IMAGE))) {
		yyerror("cannot allocate node (op=IMAGE)");
		return ct;
	}
	ct->ctm_fname = embed_fname(fname);
	ct->ctm_numcolor = colors;
	ct->ctm_ximagesize = xsiz;
	ct->ctm_yimagesize = ysiz;
	ct->ctm_zoomflag = zoomflg;
	if (mgpwdirname[0] != '\0' &&
	    strncmp(mgpwdirname, ct->ctm_fname, strlen(mgpwdirname)) == 0)
		;	/* do not chkfile() */
	else
		chkfile(ct->ctm_fname);
	return ct;
}

static struct ctrl *
gen_bar(color, thick, start, len)
	char *color;
	int thick;
	int start;
	int len;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(CTL_BAR))) {
		yyerror("cannot allocate node (op=BAR)");
		return ct;
	}
	if (get_color(color, &ct->ctb_color) < 0)
		yyerror("cannot allocate color %s", color);
	ct->ctb_width = thick;
	ct->ctb_start = start;
	ct->ctb_length = len;

	/* normalize */
	if (ct->ctb_width < 0)
		ct->ctb_width = 0;
	else if (1000 < ct->ctb_width)
		ct->ctb_width = 1000;
	if (ct->ctb_start < 0)
		ct->ctb_start = 0;
	else if (100 < ct->ctb_start)
		ct->ctb_start = 100;
	if (100 < ct->ctb_start + ct->ctb_length)
		ct->ctb_length = 100 - ct->ctb_start;

	return ct;
}

static struct ctrl *
gen_icon(n, color, siz)
	char *n;
	char *color;
	int siz;
{
	struct ctrl *ct;

	if (!(ct = ctlalloc1(CTL_ICON))) {
		yyerror("cannot allocate node (op=ICON)");
		return ct;
	}
	ct->ctic_value = n;
	if (get_color(color, &ct->ctic_color) < 0)
		yyerror("cannot allocate color %s", color);
	ct->ctic_size = siz;
	return ct;
}

static struct ctrl *
gen_argsfromnid(op, nid)
	int op;
	struct ctrl *nid;
{
	struct ctrl *ct;
	struct ctrl *p;
	int siz;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate args node");
		return ct;
	}

	siz = 0;
	for (p = nid; p; p = p->ct_next)
		siz++;
	ct->cta_argc = siz;
	ct->cta_argv = malloc((siz + 1) * sizeof(char *));
	if (!ct->cta_argv) {
		yyerror("cannot allocate args table");
		return ct;
	}
	siz = 0;
	for (p = nid; p; p = p->ct_next) {
		ct->cta_argv[siz] = strdup(p->ctc_value);
		siz++;
	}
	ct->cta_argv[siz] = NULL;

	if (nid)
		ctlfree(nid);

	return ct;
}

static struct ctrl *
gen_argsfromstr(op, str, flag)
	int op;
	char *str;
	int flag;
{
	struct ctrl *ct;
	int siz;
	char **h;

	if (!(ct = ctlalloc1(op))) {
		yyerror("cannot allocate args node");
		return ct;
	}

	ct->cta_argc = 0;
	ct->cta_argv = malloc((siz = 16) * sizeof(char *));	/*initial siz*/
	ct->cta_flag = flag;
	if (!ct->cta_argv) {
		yyerror("cannot allocate args table");
		return ct;
	}
	for (h = (char **)ct->cta_argv;
	     *h = strsep((char **)&str, " ");
	     /*none*/) {
		if (**h != '\0') {
			h++;
			ct->cta_argc++;
			if (siz < ct->cta_argc + 2) {
				siz *= 2;
				ct->cta_argv = realloc(ct->cta_argv,
					siz * sizeof(char *));
				if (!ct->cta_argv) {
					yyerror("cannot allocate args table");
					return ct;
				}
			}
		}
	}
	ct->cta_argv[ct->cta_argc] = NULL;

	return ct;
}

#if 0	/*YYBISON*/
int yyparse __P((void));

int
pcap_parse()
{
	return (yyparse());
}
#endif

%}

%union {
	int i;
	double d;
	char *s;
	struct ctrl *ct;
}

%token COMMA NUM DOUBLE ID STR WINSIZ
%token KW_NOOP KW_DEFAULT KW_TAB KW_SIZE KW_FORE KW_BACK KW_LEFT KW_CENTER
%token KW_RIGHT KW_SHRINK KW_LCUTIN KW_RCUTIN KW_CONT KW_NODEF KW_XFONT
%token KW_VFONT KW_IMAGE KW_BIMAGE KW_PAGE KW_HGAP KW_VGAP KW_GAP KW_PAUSE
%token KW_PREFIX KW_AGAIN KW_CCOLOR KW_BAR KW_INCLUDE KW_BGRAD KW_TEXT
%token KW_LINESTART KW_LINEEND KW_MARK KW_SYSTEM KW_FILTER KW_ENDFILTER
%token KW_QUALITY KW_ICON KW_LEFTFILL KW_XSYSTEM KW_VFCAP KW_TFONT KW_TFDIR
%token KW_DEFFONT KW_FONT KW_TFONT0 KW_EMBED KW_ENDEMBED

%type <ct> toplevel
%type <ct> line defaultline tabline shellline deffontline
%type <ct> cmd defaultcmd tabcmd  deffontcmd
%type <ct> nid
%type <i> NUM
%type <d> DOUBLE
%type <s> ID STR WINSIZ STRorID

%%
toplevel: line			{ root = $$; }
	| defaultline		{ root = $$; }
	| tabline		{ root = $$; }
	| shellline		{ root = $$; }
	| deffontline		{ root = $$; }
	;
line:	  cmd			{ $$ = $1; }
	| cmd COMMA line	{ $$ = $1; $$->ct_next = $3; }
	;
defaultline: defaultcmd line	{ $$ = $1; $$->ct_next = $2; }
	;
tabline: tabcmd line		{ $$ = $1; $$->ct_next = $2; }
	;
deffontline: deffontcmd line	{ $$ = $1; $$->ct_next = $2; }
	;
STRorID:  STR
	| ID			{ yywarn("\"%s\" should be quoted", $1); }
	;
shellline:
	  KW_SYSTEM STR	NUM	{ $$ = gen_argsfromstr(CTL_SYSTEM, $2, $3); }
	| KW_SYSTEM STR		{ $$ = gen_argsfromstr(CTL_SYSTEM, $2, 0); }
	| KW_XSYSTEM STR NUM	{ $$ = gen_argsfromstr(CTL_XSYSTEM, $2, $3); }
	| KW_XSYSTEM STR	{ $$ = gen_argsfromstr(CTL_XSYSTEM, $2, 0); }
	| KW_FILTER STR		{ $$ = gen_argsfromstr(CTL_FILTER, $2, 0); }
	| KW_ENDFILTER		{ $$ = gen_void(CTL_ENDFILTER); }
	| KW_EMBED STR		{ $$ = gen_str(CTL_EMBED, $2); }
	| KW_ENDEMBED STR	{ $$ = gen_void(CTL_ENDEMBED); }
	;
nid:	  STRorID	{ $$ = gen_str(CTL_NOOP, $1); }
	| STRorID nid	{ $$ = gen_str(CTL_NOOP, $1); $$->ct_next = $2; }
	;
cmd:	  KW_NOOP	{ $$ = gen_void(CTL_NOOP); }
	| KW_LEFT	{ $$ = gen_void(CTL_LEFT); }
	| KW_LEFTFILL	{ $$ = gen_void(CTL_LEFTFILL); }
	| KW_RIGHT	{ $$ = gen_void(CTL_RIGHT); }
	| KW_CENTER	{ $$ = gen_void(CTL_CENTER); }
	| KW_SHRINK	{ $$ = gen_void(CTL_SHRINK); }
	| KW_LCUTIN	{ $$ = gen_void(CTL_LCUTIN); }
	| KW_RCUTIN	{ $$ = gen_void(CTL_RCUTIN); }
	| KW_CONT	{ $$ = gen_void(CTL_CONT); }
	| KW_NODEF	{ $$ = gen_void(CTL_NODEF); }
	| KW_PAUSE	{ $$ = gen_int(CTL_PAUSE, 0); }
	| KW_AGAIN	{ $$ = gen_void(CTL_AGAIN); }
	| KW_MARK	{ $$ = gen_void(CTL_MARK); }
	| KW_PAGE	{ $$ = gen_void(CTL_PAGE); }
	| KW_SIZE NUM	{ $$ = gen_int(CTL_SIZE, $2); }
	| KW_HGAP NUM	{ $$ = gen_int(CTL_HGAP, $2); }
	| KW_VGAP NUM	{ $$ = gen_int(CTL_VGAP, $2); }
	| KW_GAP NUM	{ $$ = gen_int(CTL_GAP, $2); }
	| KW_QUALITY NUM
			{ if (!quality_flag)
				$$ = gen_int(CTL_QUALITY, $2);
			  else
				$$ = ctlalloc1(CTL_NOOP);
			}
	| KW_FORE STRorID	{ $$ = gen_color(CTL_FORE, $2); }
	| KW_BACK STRorID	{ $$ = gen_color(CTL_BACK, $2); }
	| KW_CCOLOR STRorID	{ $$ = gen_color(CTL_CCOLOR, $2); }
	| KW_BGRAD NUM NUM NUM NUM NUM nid
			{ $$ = gen_bgrad($2, $3, $4, $5, $6, $7); }
	| KW_BGRAD NUM NUM NUM NUM NUM
			{ $$ = gen_bgrad($2, $3, $4, $5, $6,
				(struct ctrl *)NULL);
			}
	| KW_BGRAD NUM NUM NUM NUM
			{ $$ = gen_bgrad($2, $3, $4, $5, 1,
				(struct ctrl *)NULL);
			}
	| KW_BGRAD NUM NUM NUM
			{ $$ = gen_bgrad($2, $3, $4, 0, 1,
				(struct ctrl *)NULL);
			}
	| KW_BGRAD NUM NUM
			{ $$ = gen_bgrad($2, $3, DEFAULT_GRADCOLORS, 0, 1,
					(struct ctrl *)NULL);
			}
	| KW_BGRAD NUM	{ $$ = gen_bgrad($2, 100, DEFAULT_GRADCOLORS, 0, 1,
					(struct ctrl *)NULL);
			}
	| KW_BGRAD	{ $$ = gen_bgrad(100, 100, DEFAULT_GRADCOLORS, 0, 1,
					(struct ctrl *)NULL);
			}
	| KW_XFONT STRorID
			{ char *p;
			  if (strncmp($2, "medium", 6) == 0
			   || strncmp($2, "bold", 4) == 0) {
				/* for backward compatibility */
				p = malloc(strlen($2) + 1 + 6);
				sprintf(p, "times-%s", $2);
			  } else
				p = $2;
			  $$ = gen_str(CTL_XFONT, p);
			}
	| KW_BIMAGE STRorID	{ $$ = gen_str(CTL_BIMAGE, $2); }
	| KW_VFONT STRorID	{
#ifdef VFLIB
				  $$ = gen_str(CTL_VFONT, $2);
#else
				  $$ = gen_str(CTL_NOOP, $2);
				  yywarn("directive \"vfont\" not supported "
					"in this configuration");
#endif
				}
	| KW_TFONT STRorID	{
#ifdef FREETYPE
				  $$ = gen_str(CTL_TFONT, $2);
#else
				  $$ = gen_str(CTL_NOOP, $2);
				  yywarn("directive \"tfont\" not supported "
					"in this configuration");
#endif
				}
	| KW_TFONT0 STRorID	{
#ifdef FREETYPE
				  $$ = gen_str(CTL_TFONT0, $2);
#else
				  $$ = gen_str(CTL_NOOP, $2);
				  yywarn("directive \"tfont0\" not supported "
					"in this configuration");
#endif
				}
	| KW_INCLUDE STRorID	{ $$ = gen_str(CTL_INCLUDE, $2); }
	| KW_PREFIX ID	{ char *p;
			  $$ = gen_str(CTL_PREFIX, $2);
			  for (p = $$->ctc_value; *p; p++) {
				if (*p == '_') *p = ' ';
			  }
			}
	| KW_PREFIX STR	{ $$ = gen_str(CTL_PREFIX, $2); }
	| KW_IMAGE STRorID WINSIZ
			{ int x, y;
			  x = atoi($3); y = atoi(strchr($3, 'x') + 1);
			  $$ = gen_image($2, 0, x, y, 2);
			}
	| KW_IMAGE STRorID NUM WINSIZ
			{ int x, y;
			  x = atoi($4); y = atoi(strchr($4, 'x') + 1);
			  $$ = gen_image($2, $3, x, y, 2);
			}
	| KW_IMAGE STRorID NUM NUM NUM NUM
			{ $$ = gen_image($2, $3, $4, $5, $6 ? 1 : 0); }
	| KW_IMAGE STRorID NUM NUM NUM
			{ $$ = gen_image($2, $3, $4, $5, 0); }
	| KW_IMAGE STRorID NUM NUM
			{ $$ = gen_image($2, $3, $4, 0, 0); }
	| KW_IMAGE STRorID NUM
			{ $$ = gen_image($2, $3, 0, 0, 0); }
	| KW_IMAGE STRorID 	{ $$ = gen_image($2, 0, 0, 0, 0); }
	| KW_BAR STRorID NUM NUM NUM
			{ $$ = gen_bar($2, $3, $4, $5); }
	| KW_BAR STRorID NUM NUM
			{ $$ = gen_bar($2, $3, $4, 100); }
	| KW_BAR STRorID NUM	{ $$ = gen_bar($2, $3, 0, 100); }
	| KW_BAR STRorID	{ $$ = gen_bar($2, 10, 0, 100); }
	| KW_BAR	{ $$ = gen_bar("black", 10, 0, 100); }
	| KW_ICON STR STRorID NUM
			{ $$ = gen_icon($2, $3, $4); }
	| KW_ICON ID STRorID NUM
			{ $$ = gen_icon($2, $3, $4); }
	| KW_VFCAP STR	{
#ifdef VFLIB
			  $$ = gen_str(CTL_VFCAP, $2);
#else
			  $$ = gen_str(CTL_NOOP, $2);
			  yywarn("directive \"vfcap\" not supported "
				"in this configuration");
#endif
			}
	| KW_TFDIR STR	{
#ifdef FREETYPE
			  $$ = gen_str(CTL_TFDIR, $2);
#else
			  $$ = gen_str(CTL_NOOP, $2);
			  yywarn("directive \"tfdir\" not supported "
				"in this configuration");
#endif
			}
	| KW_FONT STR	{ $$ = gen_str(CTL_FONT, $2); }
	| KW_TEXT STR	{ $$ = gen_str(CTL_TEXT, $2); }	/*easter egg*/
	;
tabcmd:	  KW_TAB NUM	{ $$ = gen_int(CTL_TAB, $2); }
	| KW_TAB ID	{ $$ = gen_str(CTL_TAB, $2); }
	;
defaultcmd: KW_DEFAULT NUM
			{ $$ = gen_int(CTL_DEFAULT, $2); }
	;
deffontcmd: KW_DEFFONT STR
			{ $$ = gen_str(CTL_DEFFONT, $2); }
	;

enbedded_file: 
	|
	;
%%
