/* $Id: shutdown.c,v 1.26 1998/08/02 23:43:22 gjb Exp $ 
 * (C) 1998 Maciej Stachowiak and Greg J. Badros
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <signal.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <guile/gh.h>
#include "scwm.h"
#include "screen.h"
#include "virtual.h"
#include "callbacks.h"
#include "shutdown.h"
#include "syscompat.h"
#ifdef USE_DMALLOC
#include "dmalloc.h"
#endif


SCM shutdown_hook;
SCM startup_hook;

static inline void
run_restart_command(char *command) {
  if (STREQ(command,"scwm")) {
      char *my_argv[20];
      int i, done, j;

      i = 0;
      j = 0;
      done = 0;
      while ((g_argv[j] != NULL) && (i < 18)) {
	if (!STREQ(g_argv[j], "-s")) {
	  my_argv[i] = g_argv[j];
	  i++;
	  j++;
	} else
	  j++;
      }
      my_argv[i++] = "-s";
      
      while (i < 20)
	my_argv[i++] = NULL;
      execvp(command, my_argv);
  } else {
    execl("/bin/sh", "/bin/sh", "-c", command, NULL);
  }
  scwm_msg(ERR, "Done", "Call of '%s' failed!!!!", command);
  execvp(g_argv[0], g_argv);	/* that _should_ work */
  scwm_msg(ERR, "Done", "Call of '%s' failed!!!!", g_argv[0]);
}


/* restart_or_dump == 0 to just close
   > 0 for restart
   < 0 for dump core */
void 
Done(int restart_or_dump, char *command)
{
  /* need to be sure we've opened the display -- could
     seg fault during startup */
  if (dpy) {
    call0_hooks(shutdown_hook);

    MoveViewport(0, 0, False);

    Reborder();

    XDeleteProperty(dpy, Scr.Root, XA_SCWMEXEC_LISTENER);

    /* Pretty sure this should be done... */
    XDeleteProperty(dpy, Scr.Root, XA_MOTIF_WM);

    /* FIXGJB: this used to be done only on restart -- why? --07/31/98 gjb */
    SaveDesktopState();

    /* Really make sure that the connection is closed and cleared! */
    XSelectInput(dpy, Scr.Root, 0);
    XSync(dpy, 0);
    XCloseDisplay(dpy);

  }
  /* FIXGJB: Should restore cursor to original cursor before scwm started */

  if (restart_or_dump < 0) {
    /* force seg fault -- need to use as an argument to a function
       to be sure it doesn't get optimized away, so invoke a function
       we're sure exists -- this same function! --07/23/98 gjb */
    Done(*((int *)0),NULL); /* Force seg fault */
    return; /* Never executed */
  } else if (restart_or_dump > 0) {
    sleep(1);
    ReapChildren();
    run_restart_command(command);
  } else {
    exit(0);
  }
}


/****************************************************************************
 *
 * Save Desktop State
 *
 ****************************************************************************/
void 
SaveDesktopState()
{
  ScwmWindow *t;
  unsigned long data[1];

  for (t = Scr.ScwmRoot.next; t != NULL; t = t->next) {
    data[0] = (unsigned long) t->Desk;
    XChangeProperty(dpy, t->w, XA_WM_DESKTOP, XA_WM_DESKTOP, 32,
		    PropModeReplace, (unsigned char *) data, 1);
  }

  data[0] = (unsigned long) Scr.CurrentDesk;
  XChangeProperty(dpy, Scr.Root, XA_WM_DESKTOP, XA_WM_DESKTOP, 32,
		  PropModeReplace, (unsigned char *) data, 1);

  XSync(dpy, 0);
}

SCWM_PROC(restart, "restart", 0, 1, 0,
          (SCM command))
     /** Restart the window manager. If COMMAND is specified, use
that, as the new window manager to run. If COMMAND is not specified or
is exactly equal to "scwm", restart scwm with the same command-line
arguments as given previously. */
#define FUNC_NAME s_restart
{
  int dummy;
  char *sz;

  if (gh_string_p(command)) {
    sz = gh_scm2newstr(command, &dummy);
  } else if (command == SCM_UNDEFINED) {
    sz = "scwm";
  } else {
    scm_wrong_type_arg(FUNC_NAME, 1, command);
  }

  Done(1, sz);  /* 1 == restart */
  FREE(sz); /* Done shouldn't return, but you never know... */
  return SCM_UNSPECIFIED;	
}
#undef FUNC_NAME

/* FIXGJB: what is args for, and why does this have it */
SCWM_PROC(scwm_quit, "scwm-quit", 0, 0, 1,
          (SCM args))
     /** Exit scwm cleanly. `quit' is redefined as this within
scwm. ARGS is ignored.*/
#define FUNC_NAME s_scwm_quit
{
  if (master_pid != getpid())
    kill(master_pid, SIGTERM);
  Done(0, NULL); /* Done shouldn't return, but you
		    never know... */
  return SCM_UNSPECIFIED;
}
#undef FUNC_NAME

void run_startup_hook()
{
  call0_hooks(startup_hook);
}

void init_shutdown()
{
  /**HOOK: shutdown-hook
The procedures in shutdown-hook are called with no arguments right
before scwm quits or restarts.  
  */
  SCWM_DEFINE_HOOK(shutdown_hook, "shutdown-hook");

  /**HOOK: startup-hook 
The procedures in startup-hook are called with no arguments after scwm
has processed the scwmrc and captured all application windows, and
right before it enters the main event loop.  Note that during
processing of the .scwmrc startup file, windows have not already been
captured, so the window-list (as reported by `list-all-windows') is
empty.  To provide behviour conditioned on a property of an existing
window, this hook should be used instead.
 */

  SCWM_DEFINE_HOOK(startup_hook, "startup-hook");

#ifndef SCM_MAGIC_SNARFER
#include "shutdown.x"
#endif
}
