/*
 *  texture.h
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@informatik.uni-wuerzburg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1998/10/06 21:32:21 $
 *  $Author: hafner $
 *  $Revision: 1.5 $
 *  $State: Exp $
 */

#ifndef _TEXTURE_H
#define _TEXTURE_H

#include <gtk/gtk.h>
#include <proplist.h>

enum pixmap_e {PIXMAP_NAME, PIXMAP_PIXMAP, PIXMAP_BROWSE, PIXMAP_PREVIEWS,
	       PIXMAP_TILES, PIXMAP_FRAME, PIXMAP_LAST};
enum gradient_e {GRADIENT_LIST, GRADIENT_REMOVE, GRADIENT_INSERT, GRADIENT_APPEND,
		 GRADIENT_CHANGE, GRADIENT_FRAME, GRADIENT_LAST};

void
texture_dialog (GtkWidget *box, proplist_t *key, bool_t preview_browser);
void
fill_preview (GtkPreview *preview, const char *col_spec);
void
color_selection_dialog (GtkWidget *widget, proplist_t *key);

#endif /* not _TEXTURE_H */

