
#include <config.h>
#include <stdlib.h>
#include <stdio.h>

/*Xlib*/
#include <X11/Xlib.h>

/*Xt*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/*Xmu*/
#include <X11/Xmu/Error.h>

/*Xaw*/
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>

/*my jazz*/
#include "xwin.h"
#include "main.h"
#include "who.h"

/*bitmaps*/
#include "up.h"
#include "down.h"

/* catch X close events */
XtActionsRec xfontsel_actions_2[] =
    {
        {"Close", CloseAction },
        {"CallCallback", ActionToCallback }
    };

char **determined_tty_list=0;
int determined_length=0;
int determined_current = 0;
char **determined_mesg_list;

char **determined_who_list = 0;
int determined_who_length = 0;
int determined_who_current = 0;

extern int det_patterns_num;
extern int configs_num;
extern int autorunflag;
extern char *tty;

extern Display *temp_d;

extern Atom wm_delete_window;

/* top level windows */
extern Widget MainCommand, ShellFrame, TtyList, WhoList, EditResponse,Ack;
Widget *CommandMenuOptions, *ConfigMenuOptions;
Widget CommandMenu,ConfigMenu,CommandMenuButton,ConfigMenuButton;

Widget create_popup (Widget toplevel, XtAppContext * app, int fd, Widget MainCommand, node * patterns, det_node * det_patterns, config_node * configs, init_info *init,mail_node *mail,fd_and_widgets *F_W)
    {
    int n, i;
    Arg args[12];
    static app_wid_pid info;
    static Widget MainFrame, LogLabel, LogWindow, Respond,  Quit, 
      PopDown2, ResponseControl, NextButton, LastButton, ButtonFrame, OutWardFrame,
      WhoPort, TtyPort,
      AutoAnswer, AutoRun, AutoRefresh, Refresh;
    static widget_pair pair;
    static Pixmap up_bitmap, down_bitmap;
	char name[18+MAX_PTY_NAME_LENGTH];

    info.toplevel = toplevel;
    info.app = *app;

    info.head = patterns;
    info.mail= mail;
    info.det_head = det_patterns;
    info.config_head = configs;
    info.init = init;

	sprintf(name,"Xitalk Control on %s",tty);
    ShellFrame = XtCreatePopupShell (name, applicationShellWidgetClass, toplevel, NULL, 0);

    XtAppAddActions (*app, xfontsel_actions_2, XtNumber (xfontsel_actions_2));
    XtOverrideTranslations (ShellFrame, XtParseTranslationTable ("<Message>WM_PROTOCOLS: Close()"));

    MainFrame = XtCreateManagedWidget ("MainFrame", panedWidgetClass, ShellFrame, NULL, 0);

    n = 0;
    XtSetArg (args[n], XtNwidth, 600); n++;
    XtSetArg (args[n], XtNheight, 200); n++;
    XtSetArg (args[n], XtNeditType, XawtextAppend); n++;
    XtSetArg (args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg (args[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
    XtSetArg (args[n], XtNdisplayNonprinting, FALSE); n++;
    XtSetArg (args[n], XtNskipAdjust, (XtArgVal) True); n++;
    LogWindow = XtCreateManagedWidget ("log_window", asciiTextWidgetClass, MainFrame, args, n);

	n =0;
    XtSetArg (args[n], XtNskipAdjust, (XtArgVal) True); n++;
    ResponseControl = XtCreateManagedWidget ("ResponseControl", formWidgetClass, MainFrame, args, n);

    n = 0;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    XtSetArg (args[n], XtNborderWidth, 0); n++;
    XtSetArg (args[n], XtNvertDistance, 8); n++;
    LogLabel = XtCreateManagedWidget ("Command", labelWidgetClass, ResponseControl, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, LogLabel); n++;
    XtSetArg (args[n], XtNwidth, 400); n++;
    XtSetArg (args[n], XtNeditType, XawtextEdit); n++;
    /* Typical with the Athena Widgets, the scroll bar thing is a bit
     * useless, when you type beyond the end of the widget the scroll bar
     * functions, but the widget doesnt scroll automaticall yto leave the
     * cursor in the viewport, sigh in off to do all this in Qt or Java while
     * im at it, i have never seen a useful layout widget, the best is that
     * layout thing with the TeX syntax, and thats still a pig. */
    XtSetArg (args[n], XtNscrollHorizontal, XawtextScrollAlways); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    XtSetArg (args[n], XtNvertDistance, 8); n++;
    EditResponse = XtCreateManagedWidget ("editresponse", asciiTextWidgetClass, ResponseControl, args, n);

    down_bitmap = XCreateBitmapFromData (XtDisplay (ShellFrame), RootWindowOfScreen (XtScreen (ShellFrame)), down_bits, down_width, down_height);
    up_bitmap = XCreateBitmapFromData (XtDisplay (ShellFrame), RootWindowOfScreen (XtScreen (ShellFrame)), up_bits, up_width, up_height);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, EditResponse); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    XtSetArg (args[n], XtNbitmap, up_bitmap); n++;
    LastButton = XtCreateManagedWidget ("LastButton", commandWidgetClass, ResponseControl, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, LastButton); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    XtSetArg (args[n], XtNvertDistance, 8); n++;
if (init->autoanswer)
    {
    XtSetArg (args[n], XtNstate, True); n++;
    }
#if ( USE_ROUNDED_BUTTONS == 1 )
    XtSetArg (args[n], XtNshapeStyle, XmuShapeRoundedRectangle); n++;
    XtSetArg (args[n], XtNcornerRoundPercent, 30); n++;
    XtSetArg (args[n], XtNhighlightThickness, 2); n++;
#endif
    AutoAnswer = XtCreateManagedWidget ("AutoAnswer", toggleWidgetClass, ResponseControl, args, n);
	info.autoanswer = AutoAnswer;

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, EditResponse); n++;
    XtSetArg (args[n], XtNfromVert, LastButton); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    XtSetArg (args[n], XtNbitmap, down_bitmap); n++;
    NextButton = XtCreateManagedWidget ("NextButton", commandWidgetClass, ResponseControl, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromVert, NextButton); n++;
    XtSetArg (args[n], XtNtop, XtChainBottom); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    Respond = XtCreateManagedWidget ("Execute", commandWidgetClass, ResponseControl, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromVert, NextButton); n++;
    XtSetArg (args[n], XtNfromHoriz, EditResponse); n++;
    XtSetArg (args[n], XtNtop, XtChainBottom); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
    Ack = XtCreateManagedWidget ("Ignore", commandWidgetClass, ResponseControl, args, n);

    OutWardFrame = XtCreateManagedWidget ("OutWardFrame", formWidgetClass, MainFrame, NULL, 0);

    /* insert my viewport fix here */
    n = 0;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNallowHoriz, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNallowVert, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNforceBars, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNheight, (XtArgVal) 250); n++;
    WhoPort = XtCreateManagedWidget ("WhoPort", viewportWidgetClass, OutWardFrame, args, n);

    n = 0;
    XtSetArg (args[n], XtNlist, determined_who_list); n++;
    XtSetArg (args[n], XtNnumberStrings, 0); n++;
    XtSetArg (args[n], XtNdefaultColumns, 1); n++;
    XtSetArg (args[n], XtNforceColumns, TRUE); n++;
    WhoList = XtCreateManagedWidget ("WhoList", listWidgetClass, WhoPort, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, WhoPort); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNallowHoriz, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNallowVert, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNforceBars, (XtArgVal) TRUE); n++;
    XtSetArg (args[n], XtNheight, (XtArgVal) 250); n++;
    TtyPort = XtCreateManagedWidget ("TtyPort", viewportWidgetClass, OutWardFrame, args, n);

    determined_tty_list = (char **) malloc (WHO_LIST_INC * sizeof (char *));
    if (determined_tty_list == NULL)
        {
        fprintf (stderr, "xitalk: Memory Allocation Failed\n");
        exit (-1);
        }
    determined_length = WHO_LIST_INC;

    for (i = 0; i < WHO_LIST_INC; i++)
        determined_tty_list[i] = (char *) malloc ((USRNAMLEN + 3) * sizeof (char));

    strcpy (determined_tty_list[0], "-     -");

    n = 0;
    XtSetArg (args[n], XtNlist, determined_tty_list); n++;
    XtSetArg (args[n], XtNnumberStrings, 1); n++;
    XtSetArg (args[n], XtNdefaultColumns, 1); n++;
    XtSetArg (args[n], XtNforceColumns, TRUE); n++;
    TtyList = XtCreateManagedWidget ("TtyList", listWidgetClass, TtyPort, args, n);
    XtSetSensitive (TtyList, FALSE);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, TtyPort); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNmenuName, "CommandMenu"); n++;
    CommandMenuButton = XtCreateManagedWidget ("Command Menu", menuButtonWidgetClass, OutWardFrame, args, n);

    CommandMenu = XtCreatePopupShell ("CommandMenu", simpleMenuWidgetClass, CommandMenuButton, NULL, 0);

    CreateCommand(&info);

    n = 0;
    XtSetArg (args[n], XtNfromVert, CommandMenuButton); n++;
    XtSetArg (args[n], XtNfromHoriz, TtyPort); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    XtSetArg (args[n], XtNmenuName, "ConfigMenu"); n++;
    ConfigMenuButton = XtCreateManagedWidget ("Config Menu", menuButtonWidgetClass, OutWardFrame, args, n);

    ConfigMenu = XtCreatePopupShell ("ConfigMenu", simpleMenuWidgetClass, ConfigMenuButton, NULL, 0);

    CreateConfigs(&info,F_W);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, TtyPort); n++;
    XtSetArg (args[n], XtNfromVert, ConfigMenuButton); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
if (init->autorun)
    {
    XtSetArg (args[n], XtNstate, True); n++;
    }
#if ( USE_ROUNDED_BUTTONS == 1 )
    XtSetArg (args[n], XtNshapeStyle, XmuShapeRoundedRectangle); n++;
    XtSetArg (args[n], XtNcornerRoundPercent, 30); n++;
    XtSetArg (args[n], XtNhighlightThickness, 2); n++;
#endif
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    AutoRun = XtCreateManagedWidget ("AutoRun", toggleWidgetClass, OutWardFrame, args, n);
	info.autorun = AutoRun;


    n = 0;
    XtSetArg (args[n], XtNfromVert, AutoRun); n++;
    XtSetArg (args[n], XtNfromHoriz, TtyPort); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
if (init->autorefresh)
    {
    XtSetArg (args[n], XtNstate, True); n++;
    }
#if ( USE_ROUNDED_BUTTONS == 1 )
    XtSetArg (args[n], XtNshapeStyle, XmuShapeRoundedRectangle); n++;
    XtSetArg (args[n], XtNcornerRoundPercent, 30); n++;
    XtSetArg (args[n], XtNhighlightThickness, 2); n++;
#endif
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    AutoRefresh = XtCreateManagedWidget ("AutoRefresh", toggleWidgetClass, OutWardFrame, args, n);
	info.autorefresh= AutoRefresh;


    n = 0;
    XtSetArg (args[n], XtNfromVert, AutoRefresh); n++;
    XtSetArg (args[n], XtNfromHoriz, TtyPort); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
    XtSetArg (args[n], XtNtop, XtChainTop); n++;
    XtSetArg (args[n], XtNbottom, XtChainTop); n++;
    Refresh = XtCreateManagedWidget ("Refresh", commandWidgetClass, OutWardFrame, args, n);

	n =0;
    XtSetArg (args[n], XtNskipAdjust, (XtArgVal) True); n++;
    ButtonFrame = XtCreateManagedWidget ("ButtonFrame", formWidgetClass, MainFrame, args, n);

    n = 0;
    XtSetArg (args[n], XtNtop, XtChainBottom); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNleft, XtChainLeft); n++;
    XtSetArg (args[n], XtNright, XtChainLeft); n++;
    PopDown2 = XtCreateManagedWidget ("PopDown", commandWidgetClass, ButtonFrame, args, n);

    n = 0;
    XtSetArg (args[n], XtNfromHoriz, PopDown2); n++;
    XtSetArg (args[n], XtNtop, XtChainBottom); n++;
    XtSetArg (args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg (args[n], XtNleft, XtChainRight); n++;
    XtSetArg (args[n], XtNright, XtChainRight); n++;
    Quit = XtCreateManagedWidget ("Quit", commandWidgetClass, ButtonFrame, args, n);


    F_W->fd = fd;
    F_W->log_widget = LogWindow;
    F_W->EditResponse = EditResponse;
    F_W->ack = Ack;
    F_W->respond = Respond;
    F_W->command = MainCommand;
    F_W->head = patterns;
    F_W->det_head = det_patterns;
	F_W->mail = mail;
    /* user definable eventually */
    F_W->autoanswer = &(init->autoanswer);
    F_W->autorun = &autorunflag;                     /* tum te tum */
	F_W->init = init;
    autorunflag = init->autorun;
    if (init->autorefresh)
        autorefresh (NULL, NULL, NULL);

    XtAddCallback (Respond, XtNcallback, (XtCallbackProc) respond, F_W);

    XtAddCallback (Ack, XtNcallback, (XtCallbackProc) clear_activity, init);
    XtSetSensitive (Ack, FALSE);

    XtAddCallback (LastButton, XtNcallback, (XtCallbackProc) up_arrow, F_W);
    XtAddCallback (NextButton, XtNcallback, (XtCallbackProc) down_arrow, F_W);
    XtAddCallback (Refresh, XtNcallback, (XtCallbackProc) refresh, NULL);
    XtAddCallback (WhoList, XtNcallback, (XtCallbackProc) determine_tty, NULL);

    XtAddCallback (AutoRun, XtNcallback, (XtCallbackProc) autorun, F_W);
    XtAddCallback (AutoAnswer, XtNcallback, (XtCallbackProc) autoanswer, F_W);
    XtAddCallback (AutoRefresh, XtNcallback, (XtCallbackProc) autorefresh, NULL);

/*make right click on pic spawn default action*/
    XtOverrideTranslations (MainCommand, XtParseTranslationTable ("<Btn3Down>,<Btn3Up>: CallCallback(MainFrame.ResponseControl.Execute)"));

    XtOverrideTranslations (EditResponse, XtParseTranslationTable (":<Key>Return: CallCallback(MainFrame.ResponseControl.Execute)"));
    XtOverrideTranslations (EditResponse, XtParseTranslationTable (":<Key>Up: CallCallback(MainFrame.ResponseControl.LastButton)"));
    XtOverrideTranslations (EditResponse, XtParseTranslationTable (":<Key>Down: CallCallback(MainFrame.ResponseControl.NextButton)"));


    pair.one = ShellFrame;
    pair.two = MainCommand;
    XtAddCallback (PopDown2, XtNcallback, (XtCallbackProc) popdown, &pair);

    XtAddCallback (Quit, XtNcallback, (XtCallbackProc) quit, &info);
    XtAppAddInput (*app, fd, (XtPointer) XtInputReadMask, (XtInputCallbackProc) read_pty_input, (XtPointer) F_W);
    return (ShellFrame);
    }


void CreateCommand(app_wid_pid *info)
    {
    int i,dummy=0;
    det_node *temp;
	
	if (det_patterns_num == 0)
		{
		det_patterns_num  =1;	
		dummy = 1;
		}

    CommandMenuOptions = (Widget *) malloc (det_patterns_num * sizeof (Widget));
    if (CommandMenuOptions == NULL)
        {
        fprintf (stderr, "xitalk: Memory Allocation Failed\n");
        exit (-1);
        }

	if (dummy)
		strcpy(info->det_head->title,"dummy entry");

    temp = info->det_head;
    for (i = 0; i < det_patterns_num; i++)
        {
        if (temp == NULL)
            {
            fprintf (stderr, "wrong number of patterns!\n");
            break;
            }
        CommandMenuOptions[i] = XtCreateManagedWidget (temp->title, smeBSBObjectClass, CommandMenu, NULL, 0);
		if (!dummy)
			{
        	XtAddCallback (CommandMenuOptions[i], XtNcallback, (XtCallbackProc) begin_comm, temp->determined_command);
        	temp = temp->next;
    		}
    	}
    }

void PurgeCommands(app_wid_pid *info)
    {
    /*the pattterns must be changed coming into this*/
    free(CommandMenuOptions);
    XtDestroyWidget(CommandMenu);
    CommandMenu = XtCreatePopupShell ("CommandMenu", simpleMenuWidgetClass, CommandMenuButton, NULL, 0);
    CreateCommand(info);
    }


void CreateConfigs(app_wid_pid *info,fd_and_widgets *F_W)
    {
    silly_c *c;
    int i,dummy=0;
    config_node *temp_con;
	
	if (configs_num == 0)
		{
		configs_num =1;	
		dummy = 1;
		}

    ConfigMenuOptions = (Widget *) malloc (configs_num * sizeof (Widget));
    if (ConfigMenuOptions == NULL)
        {
        fprintf (stderr, "xitalk: Memory Allocation Failed\n");
        exit (-1);
        }

	if (dummy)
		strcpy(info->config_head->title,"dummy entry");
    temp_con = info->config_head;
    for (i = 0; i < configs_num; i++)
        {
        if (temp_con == NULL)
            {
            fprintf (stderr, "wrong number of configs\n");
            break;
            }
        ConfigMenuOptions[i] = XtCreateManagedWidget (temp_con->title, smeBSBObjectClass, ConfigMenu, NULL, 0);
		if (!dummy)
			{
	        c = (silly_c *) malloc(sizeof(silly_c));
	        c->info = info;
			c->F_W = F_W;
	        c->filename = temp_con->filename;
        	XtAddCallback(ConfigMenuOptions[i],XtNcallback,(XtCallbackProc)re_init,c); 
        	temp_con = temp_con->next;
			}
        }
    }

void PurgeConfigs(app_wid_pid *info,fd_and_widgets *F_W)
    {
    /*the pattterns must be changed coming into this*/
    free(ConfigMenuOptions);
    XtDestroyWidget(ConfigMenu);
    ConfigMenu = XtCreatePopupShell ("ConfigMenu", simpleMenuWidgetClass, ConfigMenuButton, NULL, 0);
    CreateConfigs(info,F_W);
    }
