// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: fileutl.h,v 1.4 1998/05/01 03:58:40 jgg Exp $
/* ######################################################################
   
   File Utilities
   
   CopyFile - Buffered copy of a single file
   GetLock - dpkg compatible lock file manipulation (fcntl)
   FileExists - Returns true if the file exists
   
   This source is placed in the Public Domain, do with it what you will
   It was originally written by Jason Gunthorpe.
   
   ##################################################################### */
									/*}}}*/
// This is a private header
// Header section: /
#ifndef PKGLIB_FILEUTL_H
#define PKGLIB_FILEUTL_H

#include <string>

bool CopyFile(string From,string To);
int GetLock(string File,bool Errors = true);
bool FileExists(string File);
string SafeGetCWD();

#endif
