static char print_c_rcsid[]="print.c,v 1.1.1.1 1994/06/18 19:43:27 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * print.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:27  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/At/Plotter.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#include <X11/At/BarPlot.h>
#include "h.h"
#include "def.h"
#include "struct.h"
#include "dqs.h"
#include "globals.h"
#include "stdstuff.h"
#include "error.h"
#include "help.h"
#include "cpuusage.h"
#include "print.h"

#define DEFAULTPLOTFILENAME "qusage.ps"

static void *CPUUsagePlotW;
static BOOLEAN PlotLandscape;
static Widget DQSUsagePrintPlotFileNameTextW;

static void
DQSUsagePrintAccept (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  Arg args[1];
  String Str;
  static char PlotFileName[MAX_STRING_SIZE];
  int scanfResult;

  DENTER ((DQS_EVENT, "DQSUsagePrintAccept"));

  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsagePrintPlotFileNameTextW, args, ONE);
  strncpy (PlotFileName, Str, MAX_STRING_SIZE);

  if (strlen (Str) == 0)
    strncpy (PlotFileName, DEFAULTPLOTFILENAME, MAX_STRING_SIZE);
      
  {
    FILE *fopenResult;
    char ErrMsg[MAX_STRING_SIZE];
    
    fopenResult = fopen (PlotFileName, "w+");
    if (fopenResult == NULL)
      {
	sprintf (ErrMsg,
		 "Cannot write plot file named:\n%s\nPossible reason:\n%s",
		 PlotFileName, ErrorMessage (errno));
	ErrorPopup (W, ErrMsg);
	DEXIT;
	return;
      }
    else
      fclose (fopenResult);
  }
  
  XtPopdown (ParentW);

  CPUUsagePrint (CPUUsagePlotW, PlotFileName, PlotLandscape);

  DEXIT;
}

static void
DQSUsagePrintHelp (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsagePrintHelp"));

  Help ("Usage Print");

  DEXIT;
}

static void
DQSUsagePrintCancel (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsagePrintCancel"));

  XtPopdown (ParentW);

  DEXIT;
}

static void
DQSUsagePrintOrientation (W)
     Widget W;
{
  Arg args[2];

  DENTER ((DQS_EVENT, "DQSUsagePrintOrientation"));
  
  PlotLandscape = (PlotLandscape == TRUE) ? FALSE : TRUE;
  
  if (PlotLandscape == TRUE)
    XtSetArg (args[0], XtNlabel, "Landscape");
  else
    XtSetArg (args[0], XtNlabel, "Portrait");

  XtSetValues (W, args, 1);

  DEXIT;
}

void
DQSUsagePrint (W, ClientData, CallData)
     Widget W;
     caddr_t ClientData;
     caddr_t CallData;
{
  static Widget DQSUsagePrintParentW;
  static Widget DQSUsagePrintFormW;
  static Widget DQSUsagePrintOptFormW;
  static Widget DQSUsagePrintTitleLabelW;
  static Widget DQSUsagePrintPlotFileNameLabelW;
  static Widget DQSUsagePrintOrientationLabelW;
  static Widget DQSUsagePrintOrientationButtonW;
  static Widget DQSUsagePrintAcceptButtonW;
  static Widget DQSUsagePrintHelpButtonW;
  static Widget DQSUsagePrintCancelButtonW;
  static int DejaVu = 0;
  Arg wargs[10];
  unsigned int n;

  DENTER ((DQS_EVENT, "DQSUsagePrint"));

  CPUUsagePlotW = (void *) ClientData;

  if (DejaVu == 0)
    {
      DQSUsagePrintParentW =
	XtCreatePopupShell ("DQSUsagePrintParent", transientShellWidgetClass,
			    W, NULL, ZERO);
      
      DQSUsagePrintFormW =
	XtCreateManagedWidget ("DQSUsagePrintForm", formWidgetClass,
			       DQSUsagePrintParentW, NULL, ZERO);
      
      DQSUsagePrintTitleLabelW =
	XtCreateManagedWidget ("DQSUsagePrintTitle", labelWidgetClass,
			       DQSUsagePrintFormW, NULL, ZERO);
      
      DQSUsagePrintOptFormW =
	XtCreateManagedWidget ("DQSUsagePrintOptForm", formWidgetClass,
			       DQSUsagePrintFormW, NULL, ZERO);
      
      /* PlotFileName */
      DQSUsagePrintPlotFileNameLabelW =
	XtCreateManagedWidget ("DQSUsagePrintPlotFileNameL", labelWidgetClass,
			       DQSUsagePrintOptFormW, NULL, ZERO);
      
      DQSUsagePrintPlotFileNameTextW =
	XtCreateManagedWidget ("DQSUsagePrintPlotFileNameT",
			      asciiTextWidgetClass, DQSUsagePrintOptFormW,
			      NULL, ZERO);

      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsagePrintPlotFileNameTextW, wargs, n);

      DQSUsagePrintOrientationLabelW =
	XtCreateManagedWidget ("DQSUsagePrintOrientationL", labelWidgetClass,
			       DQSUsagePrintOptFormW, NULL, ZERO);
      
      DQSUsagePrintOrientationButtonW =
	XtCreateManagedWidget ("DQSUsagePrintOrientation", commandWidgetClass,
			       DQSUsagePrintOptFormW, NULL, ZERO);
      XtAddCallback (DQSUsagePrintOrientationButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsagePrintOrientation,
		     DQSUsagePrintParentW);

      DQSUsagePrintAcceptButtonW =
	XtCreateManagedWidget ("DQSUsagePrintAccept", commandWidgetClass,
			       DQSUsagePrintFormW, NULL, ZERO);
      XtAddCallback (DQSUsagePrintAcceptButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsagePrintAccept,
		     DQSUsagePrintParentW);

      DQSUsagePrintHelpButtonW =
	XtCreateManagedWidget ("DQSUsagePrintHelp", commandWidgetClass,
			       DQSUsagePrintFormW, NULL, ZERO);
      XtAddCallback (DQSUsagePrintHelpButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsagePrintHelp, DQSUsagePrintParentW);

      DQSUsagePrintCancelButtonW =
	XtCreateManagedWidget ("DQSUsagePrintCancel", commandWidgetClass,
			       DQSUsagePrintFormW, NULL, ZERO);
      XtAddCallback (DQSUsagePrintCancelButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsagePrintCancel,
		     DQSUsagePrintParentW);

      DejaVu = 1;
    }

  XtPopup (DQSUsagePrintParentW, XtGrabNonexclusive);

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
