#include "ckcsym.h"
char *userv = "User Interface 6.1.196, 1 February 1998";

/*  C K U U S R --  "User Interface" for C-Kermit (Part 1)  */

/*
  Author: Frank da Cruz <fdc@columbia.edu>
  Columbia University Academic Information Systems, New York City.

  Copyright (C) 1985, 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.
*/

/*
  NOTE: Because of the massive additions in functionality, and therefore
  the increase in the number of commands, much code was moved from here to
  the two new modules, ckuus4.c and ckuus5.c.  This module now contains only
  the top-level command keyword table, the SET command keyword table, and
  the top-level interactive command parser/dispatcher.  ckuus3.c contains the
  rest of the SET and REMOTE command parsers; ckuus2.c contains the help
  command parser and help text strings, and ckuus4.c and ckuus5.c contain
  miscellaneous pieces that logically belong in the ckuusr.c file but had to
  be moved because of size problems with some C compilers / linkers.
  Later...  as the other modules became too large, a ckuus6.c was created.
  Still later...  ckuus7.c.
  Also: ckuusy.c contains the UNIX-style command-line interface;
  ckuusx.c contains routines needed by both the command-line interface and
  the interactive command parser.
*/

/*
 The ckuus*.c modules depend on the existence of C library features like fopen,
 fgets, feof, (f)printf, argv/argc, etc.  Other functions that are likely to
 vary among different platforms -- like setting terminal modes or interrupts
 -- are invoked via calls to functions that are defined in the system-
 dependent modules, ck?[ft]io.c.  The command line parser processes any
 arguments found on the command line, as passed to main() via argv/argc.  The
 interactive parser uses the facilities of the cmd package (developed for this
 program, but usable by any program).  Any command parser may be substituted
 for this one.  The only requirements for the Kermit command parser are these:

1. Set parameters via global variables like duplex, speed, ttname, etc.  See
   ckmain.c for the declarations and descriptions of these variables.

2. If a command can be executed without the use of Kermit protocol, then
   execute the command directly and set the variable sstate to 0. Examples
   include 'set' commands, local directory listings, the 'connect' command.

3. If a command requires the Kermit protocol, set the following variables:

    sstate                             string data
      'x' (enter server mode)            (none)
      'r' (send a 'get' command)         cmarg, cmarg2
      'v' (enter receive mode)           cmarg2
      'g' (send a generic command)       cmarg
      's' (send files)                   nfils, cmarg & cmarg2 OR cmlist
      'c' (send a remote host command)   cmarg

    cmlist is an array of pointers to strings.
    cmarg, cmarg2 are pointers to strings.
    nfils is an integer.

    cmarg can be a filename string (possibly wild), or
       a pointer to a prefabricated generic command string, or
       a pointer to a host command string.
    cmarg2 is an "as-name" - the name to send file(s) under, or
       the name under which to store incoming file(s); must not be wild.
       A null or empty value means to use the file's own name.
    cmlist is a list of filenames, such as passed via argv.
    nfils is an integer, interpreted as follows:
      -1: filespec (possibly wild) in cmarg, must be expanded internally.
       0: send from stdin (standard input).
      >0: number of files to send, from cmlist.

 The screen() function is used to update the screen during file transfer.
 The tlog() function writes to a transaction log.
 The debug() function writes to a debugging log.
 The intmsg() and chkint() functions provide the user i/o for interrupting
   file transfers.
*/

#ifndef NOICP
/* Includes */

#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckuusr.h"
#include "ckcxla.h"
#include "ckcnet.h"			/* Network symbols */

#ifdef OS2
#ifndef NT
#define INCL_NOPM
#define INCL_VIO			/* Needed for ckocon.h */
#include <os2.h> 
#undef COMMENT
#else 
#define APIRET ULONG
#include <windows.h>
#include <tapi.h>
#include "cknwin.h"
#include "ckntap.h"			/* CK_TAPI definition */
#endif /* NT */
#include "ckowin.h"
#include "ckocon.h"
extern int tcp_avail;
extern bool viewonly;
extern tt_status;
int display_demo = 1;
#endif /* OS2 */

#ifdef VMS
extern int batch;
#endif /* VMS */

#ifdef datageneral
#include <packets:common.h>
#define fgets(stringbuf,max,fd) dg_fgets(stringbuf,max,fd)
#endif /* datageneral */

/* External Kermit Variables, see ckmain.c for description. */

extern xx_strp xxstring;
extern long xvernum;

extern int size, local, sndsrc, xitsta, server, displa, binary, msgflg,
  escape, duplex, nfils, quiet, tlevel, pflag, zincnt, atcapr, atdiso,
  ckxech, carrier, deblog, sendmode, epktflg, what, moving, protocol, nopush;
extern int haveline;
extern int bye_active;
extern long sendstart;
extern int fncnv, fnspath, fnrpath, xfermode;
extern struct keytab fntab[]; extern int nfntab;
extern int urpsiz, spsizf, spsiz, spsizr, spmax, wslotr, prefixing, fncact;
extern struct ck_p ptab[NPROTOS];

int sleepcan = 1;

int g_binary = -1;
int g_proto  = -1;
int g_urpsiz = -1;
int g_spsizf = -1;
int g_spsiz  = -1;
int g_spsizr = -1;
int g_spmax  = -1;
int g_wslotr = -1;
int g_prefixing = -1;
int g_fnact  = -1;
int g_fncnv  = -1;
int g_fnspath = -1;
int g_fnrpath = -1;
int g_recursive = -1;
int g_displa = -1;
int g_spath  = -1;
int g_rpath  = -1;
int g_fncact = -1;
int g_xfermode = -1;
char * g_sfilter = NULL;
char * g_rfilter = NULL;
char * g_pswd = NULL;
int g_pflg = -1;
#ifdef PATTERNS
extern int patterns;
int g_patterns = -1;
#endif /* PATTERNS */

#ifdef PIPESEND
extern int usepipes, pipesend;
extern char * sndfilter, * rcvfilter;
#endif /* PIPESEND */

extern long vernum;
extern char *versio, *copyright[];
extern char *ckxsys, *cmarg, *cmarg2, **cmlist;
#ifndef NOHELP
extern char *introtxt[];
extern char *newstxt[];
#endif /* NOHELP */
extern char *PWDCMD, *WHOCMD, *TYPCMD;
extern char ttname[];
#ifndef NOFRILLS
extern int rmailf;			/* MAIL command items */
extern char optbuf[];
#endif /* NOFRILLS */
extern CHAR sstate;

#ifdef NETCONN
extern int network,			/* Have active network connection */
  nettype,  				/* Type of network */
  ttnproto;				/* Network Protocol */
#endif /* NETCONN */

#ifndef NODIAL
extern int dialsta, dialatmo, dialcon, dialcq; /* DIAL status, etc. */
#endif /* NODIAL */

#ifdef CK_APC
extern int apcactive, apcstatus;
#endif /* CK_APC */

#ifndef NOPUSH
#ifndef NOFRILLS
extern char editor[];
extern char editopts[];
extern char editfile[];
#endif /* NOFRILLS */
#endif /* NOPUSH */

#ifdef BROWSER
extern char browser[];			/* Web browser application */
extern char browsopts[];		/* Web browser options */
extern char browsurl[];			/* Most recent URL */
char ftpapp[CKMAXPATH+1] = { NUL, NUL }; /* ftp executable */
char ftpopts[128] = { NUL, NUL };	/* ftp command-line options */
#endif /* BROWSER */

#ifndef NOMSEND				/* Multiple SEND */
extern char *msfiles[];
int filesinlist = 0;			/* And ADD ... */
extern struct filelist * filehead;
extern struct filelist * filetail;
extern struct filelist * filenext;
extern int addlist;
#endif /* NOMSEND */

static struct keytab addtab[] = {
#ifdef PATTERNS
    "binary-patterns", ADD_BIN, 0,
#endif /* PATTERNS */
#ifndef NOMSEND
    "send-list", ADD_SND, 0,
#endif /* NOMSEND */
#ifdef PATTERNS
    "text-patterns", ADD_TXT, 0,
#endif /* PATTERNS */
    "", 0, 0
};
static int naddtab = sizeof(addtab)/sizeof(struct keytab) - 1;

extern char fspec[];			/* Most recent filespec */

extern struct keytab onoff[];		/* On/Off keyword table */

#ifndef NOCSETS
extern int nfilc;
extern struct keytab fcstab[];
#endif /* NOCSETS */

#ifdef CK_TMPDIR
int f_tmpdir = 0;			/* Directory changed temporarily */
char savdir[TMPDIRLEN];			/* For saving current directory */
extern char * dldir;
#endif /* CK_TMPDIR */

int activecmd = -1;			/* Keyword index of active command */
int doconx = -1;			/* CONNECT-class command active */
int ooflag = 0;				/* User-settable on/off flag */

#ifdef COMMENT
#ifdef pdp11
/* Normally this is defined in ckcfns.c */
#define ENCBUFL 200
CHAR encbuf[ENCBUFL];
#endif /* pdp11 */
#endif /* COMMENT */

int rcflag = 0;				/* Pointer to home directory string */
int repars,				/* Reparse needed */
    techo = 0;				/* Take echo */
#ifndef NOSCRIPT
int secho = 1;
#endif /* NOSCRIPT */

int xitwarn =			/* Warn about open connection on exit */
#ifdef NOWARN
0
#else
1
#endif /* NOWARN */
;

#ifndef NOXMIT
/* Variables for TRANSMIT command */

int xmitx = 1;			/* Whether to echo during TRANSMIT */
int xmitf = 0;			/* Character to fill empty lines */
int xmitl = 0;			/* 0 = Don't send linefeed too */
int xmitp = LF;			/* Host line prompt */
int xmits = 0;			/* Use shift-in/shift-out, 0 = no */
int xmitw = 0;			/* Milliseconds to pause during TRANSMIT */
int xmitt = 1;			/* Seconds to wait for each char to echo */
int xmita = 1;			/* Action upon timeout */
#endif /* NOXMIT */

/* Declarations from ck?fio.c module */

extern char *SPACMD, *SPACM2;		/* SPACE commands */

/* Command-oriented items */

#ifdef DCMDBUF
extern char *cmdbuf;			/* Command buffers */
extern char *atmbuf;
extern char *line;			/* Character buffer for anything */
extern char *tmpbuf;			/* Short temporary string buffer */
extern int *ifcmd;
extern int *intime;
#else
extern char cmdbuf[];			/* Command buffers */
extern char atmbuf[];
extern char line[];			/* Character buffer for anything */
extern char tmpbuf[];			/* Temporary buffer */
extern int ifcmd[];
extern int intime[];
#endif /* DCMDBUF */

char *lp;				/* Pointer to line buffer */

#ifndef NOSPL
char evalbuf[33];			/* EVALUATE result */
extern char * inpbuf;			/* Buffer for INPUT and REINPUT */
char *inpbp;				/* And pointer to same */
extern char lblbuf[];			/* Buffer for labels */
int m_found;				/* MINPUT result */
int i_active = 0;			/* INPUT command is active */
char *ms[MINPMAX];			/* Pointers to MINPUT strings */
extern int fndiags, fnerror, fnsuccess;	/* Function diagnostics */
#endif /* NOSPL */

char psave[PROMPTL] = { NUL };		/* For saving & restoring prompt */

extern int success;			/* Command success/failure flag */

#ifndef NOSPL
int					/* SET INPUT parameters. */
/* Note, INPUT TIMEOUT, intime[], is on the command-level stack. */
  inbufsize = 0,			/* INPUT buffer size */
  indef = 1,				/* default timeout, seconds */
  inecho = 1,				/* 1 = echo on */
  inautodl = 0,				/* INPUT autodownload */
  inintr = 1,				/* INPUT interrupion allowed */
  insilence = 0;			/* 0 = no silence constraint */
#ifdef OS2
int interm = 1;				/* Terminal emulator displays input */
#endif /* OS2 */
int maclvl = -1;			/* Macro nesting level */
int mecho = 0;				/* Macro echo, 0 = don't */
char varnam[6];				/* For variable names */
extern int macargc[];			/* ARGC from macro invocation */

extern char *m_arg[MACLEVEL][NARGS];	/* Stack of macro arguments */

extern char **a_ptr[];			/* Array pointers */
extern int a_dim[];			/* Array dimensions */

#ifdef DCMDBUF
extern struct cmdptr *cmdstk;		/* The command stack itself */
#else
extern struct cmdptr cmdstk[];		/* The command stack itself */
#endif /* DCMDBUF */
extern int cmdlvl;			/* Current position in command stack */

long ck_alarm = 0;			/* SET ALARM value */
char alrm_date[10] = { ' ',' ',' ',' ',' ',' ',' ',' ',' ' };
char alrm_time[ 8] = { ' ',' ',' ',' ',' ',' ',' ' };

#endif /* NOSPL */

static int x, y, z = 0;			/* Local workers */
static char *s;

#define xsystem(s) zsyscmd(s)

/* Top-Level Interactive Command Keyword Table */
/* Keywords must be in lowercase and in alphabetical order. */

#ifndef ADDCMD
#ifndef NOMSEND
#define ADDCMD
#endif /* NOMSEND */
#ifndef ADDCMD
#ifdef PATTERNS
#define ADDCMD
#endif /* PATTERNS */
#endif /* ADDCMD */
#endif /* ADDCMD */

struct keytab cmdtab[] = {
#ifndef NOPUSH
    "!",	   XXSHE, CM_INV,	/* Shell escape */
#endif /* NOPUSH */
    "#",    	   XXCOM, CM_INV,	/* Comment */
#ifndef NOSPL
    ".",           XXDEF, CM_INV,	/* Assignment */
    ":",           XXLBL, CM_INV,	/* Label */
#endif /* NOSPL */
#ifndef NOPUSH
#ifdef CK_REDIR
    "<",           XXFUN, CM_INV,	/* REDIRECT */
#endif /* CK_REDIR */
    "@",           XXSHE, CM_INV,	/* DCL escape */
#endif /* NOPUSH */
    "about",       XXVER, CM_INV,	/* Synonym for VERSION */
#ifndef NOSPL
#ifdef ADDCMD
    "add",         XXADD, 0,		/* ADD */
#endif /* ADDCMD */
#ifndef NODIAL
    "answer",      XXANSW, 0,		/* ANSWER the phone */
#endif /* NODIAL */
    "apc",         XXAPC, 0,		/* Application Program Command */
    "ascii",       XXASC, CM_INV,
    "asg",         XXASS, CM_INV,       /* Invisible synonym for ASSIGN */
    "ask",         XXASK, 0,		/* ASK for text, assign to variable */
    "askq",        XXASKQ,0,            /* ASK quietly (no echo) */
    "assign",      XXASS, 0,            /* ASSIGN value to variable or macro */
#ifdef CK_KERBEROS
    "authenticate",XXAUTH,		/* Authentication */
#ifdef CK_AUTHENTICATION    
                          0,
#else
                          CM_INV,
#endif /* CK_AUTHENTICATION */
#endif /* CK_KERBEROS */
#endif /* NOSPL */
#ifndef NOFRILLS
    "back",        XXBACK,0,		/* BACK to previous directory */
#endif /* NOFRILLS */
#ifndef NOSPL
    "beep",        XXBEEP,CM_INV,	/* BEEP */
#endif /* NOSPL */
    "binary",      XXBIN, CM_INV,
#ifndef NOFRILLS
    "bug",         XXBUG, 0,		/* BUG report instructions */
#endif /* NOFRILLS */
#ifdef BROWSER
    "browse",      XXBROWS, 0,		/* BROWSE (start browser) */
#endif /* BROWSER */
    "bye",         XXBYE, 0,		/* BYE to remote server */
#ifndef NOLOCAL
    "c",           XXCON, CM_INV|CM_ABR, /* invisible synonym for CONNECT */
#endif /* NOLOCAL */
#ifndef NOFRILLS
    "cat",         XXTYP, CM_INV,	/* Invisible synonym for TYPE */
#endif /* NOFRILLS */
    "cd",          XXCWD, 0,		/* Change Directory */
#ifdef PIPESEND
    "cget",        XXCGET, CM_INV,	/* CGET */
#endif /* PIPESEND */
    "check",       XXCHK, 0,		/* CHECK for a feature */
#ifdef COMMENT
    "chroot",      XXCHRT,CM_INV,	/* CHROOT */
#endif /* COMMENT */
#ifndef NOFRILLS
    "clear",       XXCLE, 0,		/* CLEAR input and/or device buffer */
#endif /* NOFRILLS */
    "close",	   XXCLO, 0,		/* CLOSE a log or other file */
#ifdef OS2
    "cls",         XXCLS, CM_INV,	/* Clear Screen (CLS) */
#endif /* OS2 */
    "comment",     XXCOM, 0,		/* Introduce a comment */
#ifndef NOLOCAL
    "connect",     XXCON, 0,		/* Begin terminal connection */
#endif /* NOLOCAL */
#ifndef NOFRILLS
#ifdef ZCOPY
    "co",          XXCPY, CM_INV|CM_ABR,
    "copy",        XXCPY, 0,		/* COPY a file */
    "copyright",   XXCPR, 0,		/* COPYRIGHT */
    "cp",          XXCPY, CM_INV,	/* COPY a file */
#endif /* ZCOPY */
#ifndef NOLOCAL
#ifndef OS2
    "cq",          XXCQ, CM_INV,	/* CQ (connect quietly) */
#endif /* OS2 */
#endif /* NOLOCAL */
#ifdef PIPESEND
    "creceive",    XXCREC,CM_INV,	/* CRECEIVE (receive to command) */
    "csend",       XXCSEN,CM_INV,	/* CSEND (send from command) */
#endif /* PIPESEND */
#endif /* NOFRILLS */
    "cwd",	   XXCWD, CM_INV,	/* Invisible synonym for cd */
#ifndef NOSPL
    "date",        XXDATE,0,		/* DATE */
    "dcl",         XXDCL, CM_INV,	/* DECLARE an array */
    "declare",     XXDCL, 0,		/* DECLARE an array */
    "decrement",   XXDEC, 0,		/* DECREMENT a numeric variable */
    "define",      XXDEF, 0,		/* DEFINE a macro or variable */
#endif /* NOSPL */
#ifndef NOFRILLS
    "delete",      XXDEL, 0,		/* DELETE a file */
#endif /* NOFRILLS */
#ifndef NODIAL
    "dial",	   XXDIAL,0,		/* DIAL a phone number */
#endif /* NODIAL */
    "directory",   XXDIR, 0,		/* DIRECTORY of files */
#ifndef NOFRILLS
#ifndef NOSERVER
    "disable",     XXDIS, 0,		/* DISABLE a server function */
#endif /* NOSERVER */
#endif /* NOFRILLS */
#ifndef NOSPL
    "do",          XXDO,  0,		/* DO (execute) a macro */
#endif /* NOSPL */
    "e",           XXEXI, CM_INV|CM_ABR,
#ifndef NOFRILLS
    "e-packet",    XXERR, CM_INV,	/* Send an Error-Packet */
#endif /* NOFRILLS */
    "echo",        XXECH, 0,		/* ECHO text */
#ifndef NOPUSH
#ifndef NOFRILLS
    "edit",        XXEDIT, 0,		/* EDIT */
#endif /* NOFRILLS */
#endif /* NOPUSH */
    "eightbit",    XXEIGHT, 0,		/* EIGHTBIT */
#ifndef NOSPL
    "else",        XXELS, CM_INV,	/* ELSE part of IF statement */
#endif /* NOSPL */
#ifndef NOSERVER
#ifndef NOFRILLS
    "enable",      XXENA, 0,		/* ENABLE a server function */
#endif /* NOFRILLS */
#endif /* NOSERVER */
#ifndef NOSPL
    "end",         XXEND, 0,		/* END command file or macro */
    "evaluate",    XXEVAL, 0,		/* EVALUATE */
#ifdef COMMENT
    "exchange",    XXEXCH, 0,		/* EXCHANGE */
#endif /* COMMENT */
#endif /* NOSPL */
    "ex",          XXEXI, CM_INV|CM_ABR, /* Let "ex" still be EXIT */
    "exit",	   XXEXI, 0,		 /* EXIT from C-Kermit */
#ifdef OS2
    "extproc",     XXCOM, CM_INV,        /* Dummy command for OS/2 */
#endif /* OS2 */
    "f",           XXFIN, CM_INV|CM_ABR, /* Invisible abbreviation for... */
    "finish",      XXFIN, 0,		 /* FINISH */
#ifndef NOSPL
    "fo",          XXFOR, CM_INV|CM_ABR, /* Invisible abbreviation for... */
    "for",         XXFOR, 0,		/* FOR loop */
    "forward",     XXFWD, CM_INV,	/* FORWARD (ugh) */
#endif /* NOSPL */
#ifndef NOFRILLS
    "fot",	   XXDIR, CM_INV,	/* "fot" = "dir" (for Chris) */
#endif /* NOFRILLS */
#ifndef NOPUSH
#ifdef TCPSOCKET
    "ftp",	   XXFTP, 0,		/* FTP (for TCP/IP) */
#endif /* TCPSOCKET */
#endif /* NOPUSH */
#ifndef NOSPL
    "function",    XXFUNC, CM_INV|CM_HLP, /* Function */
#endif /* NOSPL */
    "g",           XXGET, CM_INV|CM_ABR, /* Invisible abbreviation for GET */
#ifndef NOSPL
    "ge",          XXGET, CM_INV|CM_ABR, /* Ditto */
#endif /* NOSPL */
    "get",         XXGET, 0,		/* GET */
#ifndef NOSPL
    "getc",        XXGETC, 0,		/* GETC */
#ifndef NOFRILLS
    "getok",       XXGOK, 0,		/* GETOK (ask for Yes/No) */
#endif /* NOFRILLS */
#endif /* NOSPL */
#ifndef NOSPL
    "goto",        XXGOTO,0,		/* GOTO label in take file or macro */
#endif /* NOSPL */
    "h",           XXHLP, CM_INV|CM_ABR, /* Invisible synonym for HELP */
#ifndef NOLOCAL
    "hangup",      XXHAN, 0,		 /* HANGUP the connection */
#endif /* NOLOCAL */
    "help",	   XXHLP, 0,		 /* Display HELP text */
#ifndef NOSPL
    "i",           XXINP, CM_INV|CM_ABR, /* Invisible synonym for INPUT */
    "if",          XXIF,  0,		 /* IF (condition) command */
    "in",          XXINP, CM_INV|CM_ABR, /* Invisible synonym for INPUT */
    "increment",   XXINC, 0,		 /* Increment a numeric variable */
    "input",       XXINP, 0,		 /* INPUT text from comm device */
#endif /* NOSPL */
#ifndef NOHELP
    "int",         XXINT, CM_INV|CM_ABR,
    "intr",        XXINT, CM_INV|CM_ABR,
    "intro",       XXINT, 0,
    "introduction",XXINT, CM_INV,	/* Print introductory text */
#endif /* NOHELP */
#ifdef OS2
    "k95",         XXKERMI, 0,		/* Hmmm what's this... */
    "kermit",      XXKERMI, CM_INV,
#else
    "kermit",      XXKERMI, 0,
#endif /* OS2 */
#ifdef OS2
#ifndef NOKVERBS
    "kverb",       XXKVRB, CM_INV|CM_HLP, /* Keyboard verb */
#endif /* NOKVERBS */
#endif /* OS2 */
#ifndef NOFRILLS
    "l",           XXLOG, CM_INV|CM_ABR, /* Invisible synonym for log */
#endif /* NOFRILLS */
#ifndef NOSPL
    "local",       XXLOCAL, 0,		/* LOCAL variable declaration */
#endif /* NOSPL */
    "log",  	   XXLOG, 0,		/* Open a log file */
#ifndef NOFRILLS
#ifndef NODIAL
    "lookup",      XXLOOK,0,		/* LOOKUP */
#endif /* NODIAL */
    "ls",          XXDIR, CM_INV,	/* Invisible synonym for DIRECTORY */
    "mail",        XXMAI, 0,		/* Send a file as e-mail */
    "man",         XXHLP, CM_INV,       /* Synonym for HELP */
#endif /* NOFRILLS */
#ifdef CK_MKDIR
    "md",          XXMKDIR, CM_INV,	/* Synonym for MKDIR */
#endif /* CK_MKDIR */
#ifdef CK_MINPUT
    "minput",      XXMINP, 0,		/* MINPUT */
#endif /* CK_MINPUT */
#ifndef NOMSEND
    "mget",        XXMGET, 0,		/* MGET */
#endif /* NOMSEND */
#ifdef CK_MKDIR
    "mkdir",       XXMKDIR, 0,		/* MKDIR */
#endif /* CK_MKDIR */
#ifndef NOMSEND
    "mmove",       XXMMOVE, 0,		/* MMOVE */
#endif /* NOMSEND */
    "move",        XXMOVE, 0,		/* MOVE  */
#ifndef NOSPL
    "mpause",      XXMSL, CM_INV,	/* Millisecond sleep */
#endif /* NOSPL */
#ifndef NOMSEND
    "mput",        XXMSE, CM_INV,	/* MPUT = MSEND */
#endif /* NOMSEND */
#ifndef NOMSEND
    "ms",          XXMSE, CM_INV|CM_ABR,
    "msend",       XXMSE, 0,		/* Multiple SEND */
#endif /* NOMSEND */
#ifndef NOSPL
    "msleep",      XXMSL, 0,		/* Millisecond sleep */
#endif /* NOSPL */
#ifndef NOFRILLS
    "mv",          XXREN, CM_INV,	/* Synonym for rename */
#endif /* NOFRILLS */
#ifndef NOHELP
    "news",        XXNEW, 0,		/* Display NEWS of new features */
#endif /* NOHELP */
    "nopush",      XXNPSH, CM_INV,	/* Disable PUSH command/features */
#ifndef NOSPL
    "o",           XXOUT, CM_INV|CM_ABR, /* Invisible synonym for OUTPUT */
    "open",        XXOPE, 0,		/* OPEN file for reading or writing */
    "options",     XXOPTS,CM_INV|CM_HLP, /* Options */
    "output",      XXOUT, 0,		/* OUTPUT text to comm device */
#endif /* NOSPL */
#ifdef ANYX25
#ifndef IBMX25
    "pad",         XXPAD, 0,            /* X.3 PAD commands */
#endif /* IBMX25 */
#endif /* ANYX25 */
#ifndef NOSPL
    "pause",       XXPAU, 0,		/* Sleep for specified interval */
#endif /* NOSPL */
#ifndef NODIAL
    "pdial",       XXPDIA,0,		/* PDIAL (partial dial) */
#endif /* NODIAL */
#ifndef NOPUSH
#ifdef TCPSOCKET
    "ping",        XXPNG, 0,		/* PING (for TCP/IP) */
#ifdef NETCMD
#endif /* NOPUSH */
    "pipe",        XXPIPE, 0,		/* PIPE */
#endif /* NETCMD */
#endif /* TCPSOCKET */
#ifndef NOSPL
    "pop",         XXEND, CM_INV,	/* Invisible synonym for END */
#endif /* NOSPL */
#ifndef NOFRILLS
    "print",       XXPRI, 0,		/* PRINT a file locally */
#endif /* NOFRILLS */
#ifdef CK_RESEND
    "psend",       XXPSEN, CM_INV,	/* PSEND */
#endif /* CK_RESEND */
#ifndef NOPUSH
    "pu",          XXSHE, CM_INV,	/* PU = PUSH */
    "push",        XXSHE, 0,		/* PUSH command (like RUN, !) */
#endif /* NOPUSH */
    "put",	   XXSEN, CM_INV,	/* PUT = SEND */
    "pwd",         XXPWD, 0,            /* Print Working Directory */
    "quit",	   XXQUI, 0,		/* QUIT from program = EXIT */
    "r",           XXREC, CM_INV|CM_ABR, /* Invisible synonym for RECEIVE */
#ifdef CK_MKDIR
    "rd",          XXRMDIR, CM_INV,     /* RMDIR */
#endif /* CK_MKDIR */
#ifndef NOSPL
    "read",        XXREA, 0,            /* READ a line from a file */
#ifdef BINREAD
    "readblock",   XXRDBL, 0,		/* READ a block */
#endif /* BINREAD */
#endif /* NOSPL */
    "receive",	   XXREC, 0,		/* RECEIVE files */
#ifndef NODIAL
#ifdef CK_REDIR
    "red",         XXRED, CM_INV|CM_ABR, /* Invisible synonym for REDIAL */
    "redi",        XXRED, CM_INV|CM_ABR, /* Invisible synonym for REDIAL */
#endif /* CK_REDIR */
    "redial",      XXRED, 0,		/* REDIAL last DIAL number */
#endif /* NODIAL */
#ifndef NOPUSH
#ifdef CK_REDIR
#ifdef OS2
    "redirect",    XXFUN, CM_INV,	/* REDIRECT local command to ttyfd */
#else /* OS2 */
    "redirect",    XXFUN, 0,		/* REDIRECT local command to ttyfd */
#endif /* OS2 */
#endif /* CK_REDIR */
#endif /* NOPUSH */
#ifdef CK_RECALL
    "redo",        XXREDO,  CM_NOR,	/* REDO */
#endif /* CK_RECALL */
#ifdef CK_RESEND
    "reget",       XXREGET, 0,		/* REGET */
#endif /* CK_RESEND */
#ifndef NOSPL
    "reinput",     XXREI, 0,            /* REINPUT (from INPUT buffer) */
#endif /* NOSPL */
#ifdef ADDCMD    
    "rem",         XXREM, CM_INV|CM_ABR,
    "remo",        XXREM, CM_INV|CM_ABR,
#endif /* ADDCMD */
    "remote",	   XXREM, 0,		/* Send REMOTE command to server */
#ifdef ADDCMD    
    "remove",      XXREMV,0,		/* REMOVE (something from a list) */
#endif /* ADDCMD */
#ifndef NOFRILLS
#ifndef NORENAME
    "rename",      XXREN, 0,		/* RENAME a local file */
#endif /* NORENAME */
    "replay",      XXTYP, CM_INV,	/* REPLAY (for now, just type) */
#endif /* NOFRILLS */
#ifdef CK_RESEND
    "resend",      XXRSEN, 0,		/* RESEND */
#ifndef NOSPL
    "ret",         XXRET, CM_INV|CM_ABR,
#endif /* NOSPL */
#endif /* CK_RESEND */
    "retrieve",    XXRETR, CM_INV,	/* RETRIEVE */
#ifndef NOSPL
    "return",      XXRET, 0,		/* RETURN from a function */
#endif /* NOSPL */
#ifndef NOPUSH
#ifdef CK_REXX
    "rexx",       XXREXX, 0,		/* Execute a Rexx command */
#endif /* CK_REXX */
#endif /* NOPUSH */
#ifdef TCPSOCKET
    "rlogin",    XXRLOG, 0,		/* Rlogin to host */
#endif /* TCPSOCKET */
#ifndef NOFRILLS
    "rm",          XXDEL, CM_INV,	/* Invisible synonym for delete */
#endif /* NOFRILLS */
#ifdef CK_MKDIR
    "rmdir",       XXRMDIR, 0,          /* RMDIR */
#endif /* CK_MKDIR */
#ifdef CK_RECALL
    "rr",          XXREDO, CM_INV|CM_NOR,
#endif /* CK_RECALL */
#ifndef NOPUSH
    "run",         XXSHE, 0,		/* RUN a program or command */
#endif /* NOPUSH */
    "s",           XXSEN, CM_INV|CM_ABR, /* Invisible synonym for send */
#ifndef NOSETKEY
    "save",	   XXSAVE, 0,		/* SAVE parameters */
#endif /* NOSETKEY */
#ifndef NOSCRIPT
    "script",	   XXLOGI,0,		/* Execute a UUCP-style script */
#endif /* NOSCRIPT */
    "send",	   XXSEN, 0,		/* Send (a) file(s) */
#ifndef NOSERVER
    "server",	   XXSER, 0,		/* Be a SERVER */
#endif /* NOSERVER */
    "set",	   XXSET, 0,		/* SET parameters */
#ifndef NOSHOW
    "show", 	   XXSHO, 0,		/* SHOW parameters */
#endif /* NOSHOW */
#ifndef NOSPL
#ifndef NOFRILLS
    "sleep",       XXPAU, CM_INV,	/* SLEEP for specified interval */
#endif /* NOFRILLS */
#endif /* NOSPL */
#ifndef MAC
#ifndef NOFRILLS
    "sp",          XXSPA, CM_INV|CM_ABR,
    "spa",         XXSPA, CM_INV|CM_ABR,
#endif /* NOFRILLS */
    "space",       XXSPA, 0,		/* Show available disk SPACE */
#endif /* MAC */
#ifndef NOFRILLS
#ifndef NOPUSH
    "spawn",       XXSHE, CM_INV,	/* Synonym for PUSH, RUN */
#endif /* NOPUSH */
#endif /* NOFRILLS */
    "sta",         XXSTA, CM_INV|CM_ABR,
    "stat",        XXSTA, CM_INV|CM_ABR,
    "statistics",  XXSTA, 0,		/* Display file transfer stats */
    "status",      XXSTATUS, 0,		/* Show status of previous command */
#ifndef NOSPL
    "stop",        XXSTO, 0,		/* STOP all take files and macros */
#endif /* NOSPL */
#ifndef NOJC
    "suspend",     XXSUS, 0,		/* SUSPEND C-Kermit (UNIX only) */
#endif /* NOJC */
#ifndef NOSPL
    "switch",      XXSWIT, 0,		/* SWITCH */
#endif /* NOSPL */
#ifdef CK_TAPI
    "ta",	   XXTAK, CM_INV|CM_ABR, /* (because of TAPI) */
#endif /* CK_TAPI */
    "take",	   XXTAK, 0,		/* TAKE commands from a file */
#ifdef CK_TAPI
    "tapi",	   XXTAPI, 0,		/* Microsoft TAPI commands */
#endif /* CK_TAPI */
#ifndef NOFRILLS
#ifdef TCPSOCKET
    "te",          XXTEL, CM_INV|CM_ABR,
    "tel",         XXTEL, CM_INV|CM_ABR,
    "telnet",      XXTEL, 0,		/* TELNET (TCP/IP only) */
    "telopt",      XXTELOP, CM_INV,     /* TELOPT (ditto) */
#endif /* TCPSOCKET */
#ifdef OS2
    "terminal",    XXTERM, 0,		/* == SET TERMINAL TYPE */
#else
    "terminal",    XXTERM, CM_INV,
#endif /* OS2 */
#endif /* NOFRILLS */
    "text",        XXASC, CM_INV,
#ifndef NOCSETS
    "translate",   XXXLA, 0,		/* TRANSLATE local file char sets */
#endif
#ifndef NOXMIT
    "transmit",    XXTRA, 0,		/* Send (upload) a file, no protocol */
#endif /* NOXMIT */
#ifndef NOFRILLS
    "type",        XXTYP, 0,		/* Display a local file */
#endif /* NOFRILLS */
#ifndef NOSPL
    "undefine",    XXUNDEF, 0,		/* UNDEFINE a variable or macro */
#endif /* NOSPL */
#ifdef COMMENT
    "updates",     XXUPD, 0,		/* View UPDATES file */
#endif /* COMMENT */
    "version",     XXVER, 0,		/* VERSION-number display */
#ifdef OS2
    "viewonly",    XXVIEW, 0,		/* VIEWONLY Terminal Mode */
#endif /* OS2 */
#ifndef NOSPL
    "wait",        XXWAI, 0,		/* WAIT (like pause) */
#endif /* NOSPL */
    "where",       XXWHERE, 0,		/* WHERE (did my file go?) */
#ifndef NOSPL
    "while",       XXWHI, 0,		/* WHILE loop */
#endif /* NOSPL */
#ifndef OS2
#ifndef MAC
#ifndef NOFRILLS
    "who",         XXWHO, 0,		/* WHO's logged in? */
#endif /* NOFRILLS */
#endif /* MAC */
#endif /* OS2 */
#ifndef NOSPL
    "wr",          XXWRI, CM_INV|CM_ABR,
    "wri",         XXWRI, CM_INV|CM_ABR,
    "writ",        XXWRI, CM_INV|CM_ABR,
    "write",       XXWRI, 0,		/* WRITE characters to a file */
    "write-line",  XXWRL, 0,		/* WRITE a line to a file */
#ifdef BINREAD
    "writeblock",  XXWRBL, 0,		/* WRITE a block */
#endif /* BINREAD */
    "writeln",     XXWRL, CM_INV,	/* Pascalisch synonym for write-line */
#endif /* NOSPL */
#ifndef NOFRILLS
    "xecho",       XXXECH,0,		/* XECHO */
#endif /* NOFRILLS */
#ifndef NOSPL
    "xif",         XXIFX, 0,		/* Extended IF command */
#endif /* NOSPL */
#ifndef NOCSETS
    "xlate",       XXXLA, CM_INV,	/* Synonym for TRANSLATE */
#endif /* NOCSETS */
#ifndef NOXMIT
    "xmit",        XXTRA, CM_INV,	/* Synonym for TRANSMIT */
#endif /* NOXMIT */
#ifndef OS2
    "z",           XXSUS, CM_INV,	/* Synonym for SUSPEND */
#endif /* OS2 */
#ifdef CK_RECALL
    "^",           XXREDO,CM_INV|CM_NOR, /* Synonym for REDO */
#endif /* CK_RECALL */
#ifndef NOSPL
    "_asg",        XXASX, CM_INV,	/* Used internally by FOR, etc */
    "_assign",     XXASX, CM_INV,	/* Used internally by FOR, etc */
    "_define",     XXDFX, CM_INV,	/* Used internally by FOR, etc */
    "_forward",    XXXFWD,CM_INV,	/* Used internally by SWITCH   */
    "_getargs",    XXGTA, CM_INV,       /* Used internally by FOR, etc */
    "_putargs",    XXPTA, CM_INV,       /* Used internally by FOR, etc */
#endif /* NOSPL */
"", 0, 0
};
int ncmd = (sizeof(cmdtab) / sizeof(struct keytab)) - 1;

char toktab[] = {
#ifndef NOPUSH
    '!',				/* Shell escape */
#endif /* NOPUSH */
    '#',				/* Comment */
#ifndef NOSPL
    '.',				/* Assignment */
#endif /* NOSPL */
    ';',				/* Comment */
#ifndef NOSPL
    ':',				/* Label */
#endif /* NOSPL */
#ifndef NOPUSH
#ifdef CK_REDIR
    '<',				/* REDIRECT */
#endif /* CK_REDIR */
    '@',				/* DCL escape */
#endif /* NOPUSH */
#ifdef CK_RECALL
    '^',
#endif /* CK_RECALL */
    '\0'				/* End of this string */
};
int xxdot = 0;				/* Used with "." token */

struct keytab yesno[] = {		/* Yes/No keyword table */
    "no",    0, 0,
    "ok",    1, 0,
    "yes",   1, 0
};
int nyesno = (sizeof(yesno) / sizeof(struct keytab));

/* Save keyword table */

struct keytab savtab[] = {
#ifndef NOSETKEY
    "keymap", XSKEY, 0
#else
	"", 	0, 	0
#endif	/* NOSETKEY */
};
int nsav = (sizeof(savtab) / sizeof(struct keytab));

/* Parameter keyword table */

struct keytab prmtab[] = {
    "alarm",            XYALRM,  0,
    "attributes",       XYATTR,  0,
#ifdef CK_KERBEROS
    "authentication",   XYAUTH,  0,
#endif /* CK_KERBEROS */
    "b",		XYBACK,  CM_INV|CM_ABR,
    "ba",		XYBACK,  CM_INV|CM_ABR,
#ifdef VMS
    "background",       XYBACK,  CM_INV,
    "batch",            XYBACK,  0,
#else
    "background",       XYBACK,  0,
    "batch",            XYBACK,  CM_INV,
#endif /* VMS */
#ifndef NOLOCAL
    "baud",	        XYSPEE,  CM_INV,
#endif /* NOLOCAL */
#ifdef OS2
    "bell",             XYBELL,  0,
#endif /* OS2 */
    "block-check",  	XYCHKT,  0,
#ifdef OS2
#ifdef BPRINT
    "bprinter",         XYBDCP,  CM_INV,
#endif /* BPRINT */
#endif /*  OS2 */
#ifdef BROWSER
    "browser",          XYBROWSE,0,
#endif /* BROWSER */
#ifdef DYNAMIC
    "buffers",          XYBUF,   0,
#endif /* DYNAMIC */
#ifndef NOLOCAL
#ifndef MAC
    "carrier-watch",    XYCARR,  0,
#endif /* MAC */
#endif /* NOLOCAL */
#ifndef NOSPL
    "case",             XYCASE,  0,
#endif /* NOSPL */
    "clearchannel",     XYCLEAR, 0,
    "cmd",              XYCMD,   CM_INV,
    "command",          XYCMD,   0,
#ifdef CK_SPEED
    "con",              XYQCTL,  CM_INV|CM_ABR,
#endif /* CK_SPEED */
    "console",          XYCMD,   CM_INV,
#ifdef CK_SPEED
    "control-character",XYQCTL,  0,
#endif /* CK_SPEED */
#ifndef NOSPL
    "count",            XYCOUN,  0,
#endif /* NOSPL */
    "d",		XYDELA,  CM_INV|CM_ABR,
    "de",		XYDELA,  CM_INV|CM_ABR,
    "debug",            XYDEBU,  CM_INV,
#ifdef VMS
    "default",          XYDFLT,  0,
#else
#ifndef MAC
    "default",          XYDFLT,  CM_INV,
#endif /* MAC */
#endif /* VMS */
    "delay",	    	XYDELA,  0,
    "destination",	XYDEST,  0,
#ifndef NODIAL
    "di",		XYDIAL,  CM_INV|CM_ABR,
    "dia",		XYDIAL,  CM_INV|CM_ABR,
    "dial",             XYDIAL,  0,
#endif /* NODIAL */
#ifdef OS2
    "dialer",		XYDLR,   CM_INV,
#endif /* OS2 */
#ifndef NOLOCAL
    "duplex",	    	XYDUPL,  0,
#endif /* NOLOCAL */
#ifndef NOPUSH
#ifndef NOFRILLS
    "editor",           XYEDIT,  0,
#endif /*  NOFRILLS */
#endif /* NOPUSH */
#ifdef CK_CTRLZ
    "eof",              XYEOF, CM_INV,
#endif /* CK_CTRLZ */
#ifndef NOLOCAL
    "escape-character", XYESC,   0,
#endif /* NOLOCAL */
    "exit",		XYEXIT,  0,
    "file", 	  	XYFILE,  0,
    "fl",           	XYFLOW,  CM_INV|CM_ABR,
#ifndef NOSPL
    "flag",             XYFLAG,  0,
#endif /* NOSPL */
#ifdef BROWSER
    "ftp-client",       XYFTP,   0,
#endif /* BROWSER */
    "flow-control", 	XYFLOW,  0,
#ifndef NOSPL
    "function",         XYFUNC,  0,
#endif /* NOSPL */
    "handshake",    	XYHAND,  0,
#ifdef NETCONN
    "host",             XYHOST,  0,
#endif /* NETCONN */
#ifndef NOSPL
    "i",		XYINPU,  CM_INV|CM_ABR,
    "in",		XYINPU,  CM_INV|CM_ABR,
#endif /* NOSPL */
    "incomplete",   	XYIFD,   CM_INV,
#ifndef NOSPL
    "input",            XYINPU,  0,
#endif /* NOSPL */
#ifndef NOSETKEY
    "key",		XYKEY,   0,
#endif /* NOSETKEY */
    "l",                XYLINE,  CM_INV|CM_ABR,
#ifndef NOCSETS
    "language",         XYLANG,  0,
#endif /* NOCSETS */
#ifndef NOLOCAL
    "line",             XYLINE,  0,
    "local-echo",	XYLCLE,  CM_INV,
#endif /* NOLOCAL */
#ifndef NOSPL
    "login",		XYLOGIN, 0,
#endif /* NOSPL */
#ifndef NOSPL
    "macro",            XYMACR,  0,
#endif /* NOSPL */
#ifdef COMMENT
#ifdef VMS
    "messages",         XYMSGS,  0,
#endif /* VMS */
#endif /* COMMENT */
#ifndef NODIAL
    "modem",		XYMODM,	 0,
#endif /* NODIAL */
#ifndef NOLOCAL
#ifdef OS2MOUSE
    "mouse",		XYMOUSE, 0,
#endif /* OS2MOUSE */
#endif /* NOLOCAL */
#ifdef OS2
    "mskermit",         XYMSK,   0,
#endif /* OS2 */
#ifdef NETCONN
    "network",          XYNET,   0,
#endif /* NETCONN */
#ifndef NOSPL
    "output",           XYOUTP,  0,
#endif /* NOSPL */
    "pause",            XYSLEEP, CM_INV,
#ifdef ANYX25
#ifndef IBMX25
    "pad",              XYPAD,   0,
#endif /* IBMX25 */
#endif /* ANYX25 */
    "parity",	    	XYPARI,   0,
#ifndef NOLOCAL
#ifdef OS2
    "port",             XYLINE,   0,
#else
    "port",             XYLINE,   CM_INV,
#endif /* OS2 */
#endif /* NOLOCAL */
#ifndef NOFRILLS
    "pr",   	    	XYPROM,  CM_INV|CM_ABR,
    "printer",          XYPRTR,  0,
#endif /* NOFRILLS */
#ifdef OS2
    "priority",         XYPRTY,  0,
#endif /* OS2 */
#ifdef CK_SPEED
    "prefixing",        XYPREFIX, 0,
#endif /* CK_SPEED */
#ifndef NOFRILLS
    "prompt",	    	XYPROM,  0,
#endif /* NOFRILLS */
#ifdef CK_XYZ
    "protocol",		XYPROTO, 0,
#else
    "protocol",		XYPROTO, CM_INV,
#endif /* CK_XYZ */
    "quiet",		XYQUIE,  0,
    "receive",          XYRECV,  0,
    "reliable",         XYRELY,  0,
    "repeat",           XYREPT,  0,
    "retry-limit",      XYRETR,  0,
#ifndef NOSCRIPT
    "script",		XYSCRI,  0,
#endif /* NOSCRIPT */
    "send",             XYSEND,  0,
#ifndef NOSERVER
    "server",           XYSERV,  0,
#endif /* NOSERVER */
#ifdef SESLIMIT
    "session-limit",    XYLIMIT, CM_INV,        /* Session Limit */
#endif /* SESLIMIT */

#ifndef NOLOCAL
#ifdef UNIX
    "session-log",      XYSESS,  0,
#else
#ifdef OSK
    "session-log",      XYSESS,  0,
#endif /* OSK */
#endif /* UNIX */
#endif /* NOLOCAL */

    "sleep",            XYSLEEP, 0,

#ifndef NOLOCAL
    "speed",	        XYSPEE,  0,
#endif /* NOLOCAL */

#ifndef NOSPL
    "startup-file",     XYSTARTUP, CM_INV,
#endif /* NOSPL */

#ifdef STREAMING
    "streaming",        XYSTREAM, 0,
#endif /* STREAMING */

#ifndef NOJC
    "suspend",          XYSUSP,  0,
#endif /* NOJC */
    "take",             XYTAKE,  0,
#ifdef CK_TAPI
    "tapi",             XYTAPI,  0,
#endif /* CK_TAPI */
#ifndef NOTCPOPTS
#ifdef TCPSOCKET
    "tcp",              XYTCP, 0,
#endif /* TCPSOCKET */
#endif /* NOTCPOPTS */
#ifdef TNCODE
    "telnet",           XYTEL,   0,
#endif /* TNCODE */
#ifndef NOSPL
    "temp-directory",   XYTMPDIR,0,
#endif /* NOSPL */
#ifndef NOLOCAL
    "terminal",         XYTERM,  0,
#endif /* NOLOCAL */
#ifdef OS2
    "title",		XYTITLE, 0,
#endif /* OS2 */
#ifdef TLOG
    "transaction-log",  XYTLOG,  0,
#endif /* TLOG */
    "transfer",         XYXFER,  0,
#ifndef NOXMIT
    "transmit",         XYXMIT,  0,
#endif /* NOXMIT */
#ifndef NOCSETS
    "unknown-char-set", XYUNCS,  0,
#endif /* NOCSETS */
    "wait",             XYSLEEP, CM_INV,
#ifndef NOPUSH
#ifdef UNIX
    "wildcard-expansion", XYWILD, 0,
#endif /* UNIX */
#endif /* NOPUSH */
#ifdef NT
    "w",                XYWIND,  CM_INV|CM_ABR,
    "wi",               XYWIND,  CM_INV|CM_ABR,
    "win",              XYWIND,  CM_INV|CM_ABR,
#endif /* NT */
    "window-size",      XYWIND,  0,
#ifdef NT
    "win95",            XYWIN95, 0,
#endif /* NT */
#ifdef ANYX25
    "x.25",             XYX25,   0,
    "x25",              XYX25,   CM_INV,
#endif /* ANYX25 */
    "xfer",             XYXFER,  CM_INV,
#ifndef NOXMIT
    "xmit",             XYXMIT,  CM_INV,
#endif /* NOXMIT */
    "", 0, 0
};
int nprm = (sizeof(prmtab) / sizeof(struct keytab)) - 1; /* How many */

/* Table of networks */
#ifdef NETCONN
struct keytab netkey[] = {
    "directory",     XYNET_D,  0,
    "type",          XYNET_T,  0
};
int nnetkey = (sizeof(netkey) / sizeof(struct keytab));

struct keytab netcmd[] = {
/*
  These are the network types.
*/
#ifdef NETCMD
    "command",       NET_CMD,  0,	/* Command */
#endif /* NETCMD */

#ifdef DECNET				/* DECnet / PATHWORKS */
    "decnet",        NET_DEC,  0,
#endif /* DECNET */

#ifdef NETDLL
    "dll",           NET_DLL,  CM_INV,  /* DLL to be loaded */
#endif /* NETDLL */

#ifdef NETFILE
    "file",           NET_FILE, CM_INV,  /* FILE (real crude) */
#endif /* NETFILE */

#ifdef NPIPE				/* Named Pipes */
    "named-pipe",     NET_PIPE,  0,
#endif /* NPIPE */

#ifdef CK_NETBIOS
    "netbios",        NET_BIOS,  0,	/* NETBIOS */
#endif /* CK_NETBIOS */

#ifdef DECNET				/* DECnet / PATHWORKS (alias) */
    "pathworks",     NET_DEC,  CM_INV,  
#endif /* DECNET */

#ifdef SSH              
    "ssh",           NET_SSH,  CM_INV,  /* SSH */
#endif /* SSH */
#ifdef SUPERLAT
   "superlat",        NET_SLAT,  0,	/* Meridian Technologies' SuperLAT */
#endif /* SUPERLAT */

#ifdef TCPSOCKET			/* TCP/IP sockets library */
    "tcp/ip",       NET_TCPB,    0,
#endif /* TCPSOCKET */
#ifdef SUPERLAT
    "tes32",        NET_SLAT,   0,	/* Emulux TES32 */
#endif /* SUPERLAT */
#ifdef ANYX25				/* X.25 */
#ifdef SUNX25
    "x",            NET_SX25, CM_INV|CM_ABR,
    "x.25",         NET_SX25, 0,
    "x25",          NET_SX25, CM_INV,
#else
#ifdef STRATUSX25
    "x",            NET_VX25, CM_INV|CM_ABR,
    "x.25",         NET_VX25, 0,
    "x25",          NET_VX25, CM_INV,
#endif /* STRATUSX25 */
#endif /* SUNX25 */
#ifdef IBMX25
    "x",            NET_IX25, CM_INV|CM_ABR,
    "x.25",         NET_IX25, CM_INV,
    "x25",          NET_IX25, CM_INV,
#endif /* IBMX25 */
#ifdef HPX25
    "x",            NET_IX25, CM_INV|CM_ABR,
    "x.25",         NET_IX25, 0,
    "x25",          NET_IX25, CM_INV,
#endif /* HPX25 */
#endif /* ANYX25 */
    "", 0, 0
};
int nnets = (sizeof(netcmd) / sizeof(struct keytab));

#ifndef NOTCPOPTS
#ifdef TCPSOCKET

/* TCP options */

struct keytab tcpopt[] = {
   "address",   XYTCP_ADDRESS, 0,
#ifdef SO_KEEPALIVE
   "keepalive", XYTCP_KEEPALIVE, 0,
#endif /* SO_KEEPALIVE */
#ifdef SO_LINGER
   "linger", XYTCP_LINGER, 0,
#endif  /* SO_LINGER */
#ifdef TCP_NODELAY
   "nagle",  XYTCP_NAGLE,    CM_INV,
   "nodelay", XYTCP_NODELAY, 0,
#endif /* TCP_NODELAY */
   "reverse-dns-lookup", XYTCP_RDNS, 0,
#ifdef SO_RCVBUF
   "recvbuf", XYTCP_RECVBUF, 0,
#endif /* SO_RCVBUF */
#ifdef SO_SNDBUF
   "sendbuf", XYTCP_SENDBUF, 0,
#endif /* SO_SNDBUF */
#ifdef VMS
#ifdef DEC_TCPIP
   "ucx-port-bug", XYTCP_UCX, 0,
#endif /* DEC_TCPIP */
#endif /* VMS */
   "",0,0
};
int ntcpopt = (sizeof(tcpopt) / sizeof(struct keytab));

#endif /* TCPSOCKET */
#endif /* NOTCPOPTS */

#endif /* NETCONN */

/* Remote Command Table */

struct keytab remcmd[] = {
#ifndef NOSPL
    "as",	 XZASG, CM_INV|CM_ABR,
    "asg",	 XZASG, CM_INV,
    "assign",	 XZASG, 0,
#endif /* NOSPL */
    "cd",        XZCWD, 0,
    "copy",      XZCPY, 0,
    "cwd",       XZCWD, CM_INV,
    "delete",    XZDEL, 0,
    "directory", XZDIR, 0,
    "help",      XZHLP, 0,
#ifndef NOPUSH
    "host",      XZHOS, 0,
#endif /* NOPUSH */
#ifndef NOFRILLS
    "kermit",    XZKER, 0,
    "login",     XZLGI, 0,
    "logout",    XZLGO, 0,
    "mkdir",     XZMKD, 0,
    "print",     XZPRI, 0,
#endif /* NOFRILLS */
    "pwd",       XZPWD, 0,
#ifndef NOSPL
    "query",	 XZQUE, 0,
#endif /* NOSPL */
    "rename",    XZREN, 0,
    "rmdir",     XZRMD, 0,
    "set",       XZSET, 0,
    "space",	 XZSPA, 0
#ifndef NOFRILLS
,   "type", 	 XZTYP, 0,
    "who",  	 XZWHO, 0
#endif /* NOFRILLS */
};
int nrmt = (sizeof(remcmd) / sizeof(struct keytab));

struct keytab logtab[] = {
#ifdef DEBUG
    "debugging",    LOGD, 0,
#endif /* DEBUG */
    "packets",	    LOGP, 0
#ifndef NOLOCAL
,   "session",      LOGS, 0
#endif /* NOLOCAL */
#ifdef TLOG
,   "transactions", LOGT, 0
#endif /* TLOG */
};
int nlog = (sizeof(logtab) / sizeof(struct keytab));

struct keytab writab[] = {
#ifndef NOSPL
    "append-file",     LOGW, CM_INV,
#endif /* NOSPL */
    "debug-log",       LOGD, 0,
    "error",           LOGE, 0,
#ifndef NOSPL
    "file",            LOGW, 0,
#endif /* NOSPL */
    "packet-log",      LOGP, 0,
    "screen",          LOGX, 0,
#ifndef NOLOCAL
    "session-log",     LOGS, 0,
#endif /* NOLOCAL */
    "sys$output",      LOGX, CM_INV,
    "t",               LOGT, CM_ABR|CM_INV, /* Because of a typo in */
    "tr",              LOGT, CM_ABR|CM_INV, /* the book... */
    "tra",             LOGT, CM_ABR|CM_INV,
    "tran",            LOGT, CM_ABR|CM_INV,
    "trans",           LOGT, CM_ABR|CM_INV,
    "transa",          LOGT, CM_ABR|CM_INV,
    "transac",         LOGT, CM_ABR|CM_INV,
    "transact",        LOGT, CM_ABR|CM_INV,
    "transacti",       LOGT, CM_ABR|CM_INV,
    "transactio",      LOGT, CM_ABR|CM_INV,
    "transaction",     LOGT, CM_ABR|CM_INV,
    "transaction-log", LOGT, 0,
    "transactions",    LOGT, CM_INV
};
int nwri = (sizeof(writab) / sizeof(struct keytab));

#ifdef COMMENT				/* INPUT switches not used yet... */
static struct keytab inswtab[] = {
#ifdef COMMENT
    "/assign",       IN_ASG, CM_ARG,
#endif /* COMMENT */
    "/autodownload", IN_ADL, CM_ARG,
    "/case",         IN_CAS, CM_ARG,
    "/echo",         IN_ECH, CM_ARG,
    "/interrupts",   IN_NOI, CM_ARG,
    "/silence",      IN_SIL, CM_ARG,
#ifdef COMMENT
    "/pattern",      IN_PAT, CM_ARG,
#endif /* COMMENT */
    "", 0, 0
};
static int ninswtab = (sizeof(inswtab) / sizeof(struct keytab)) - 1;
#endif /* COMMENT */

static struct keytab clrtab[] = {	/* Keywords for CLEAR command */
#ifndef NOSPL
#ifdef CK_APC
    "apc",              CLR_APC,         0,
#endif /* CK_APC */
    "both",             CLR_DEV|CLR_INP, CM_INV,
#endif /* NOSPL */
#ifdef OS2
    "command-screen",   CLR_CMD,         0,
#endif /* OS2 */
#ifndef NOSPL
    "device",           CLR_DEV,         CM_INV|CM_ABR,
    "device-and-input", CLR_DEV|CLR_INP, 0,
#endif /* NOSPL */
    "device-buffer",    CLR_DEV,         0,
#ifndef NODIAL
    "dial-status",      CLR_DIA,	 0,
#endif /* NODIAL */
#ifndef NOSPL
    "input-buffer",     CLR_INP,         0,
#endif /* NOSPL */
    "send-list",        CLR_SFL,         0,
#ifdef OS2
    "scrollback",       CLR_SCL,         CM_INV,
    "terminal-screen",  CLR_TRM,         0,
#endif /* OS2 */
    "", 0, 0
};
int nclear = (sizeof(clrtab) / sizeof(struct keytab)) - 1;

struct keytab clstab[] = {		/* Keywords for CLOSE command */
#ifndef NOSPL
    "append-file",     LOGW, CM_INV,
#endif /* NOSPL */
#ifndef NOLOCAL
    "connection",      9999, 0,
#endif /* NOLOCAL */
#ifdef DEBUG
    "debug-log",       LOGD, 0,
#endif /* DEBUG */
    "packet-log",      LOGP, 0
#ifndef NOSPL
,   "read-file",       LOGR, 0
#endif /* NOSPL */
#ifndef NOLOCAL
,   "session-log",     LOGS, 0
#endif /* NOLOCAL */
#ifdef TLOG
,   "t",               LOGT, CM_ABR|CM_INV, /* Because of a typo in */
    "tr",              LOGT, CM_ABR|CM_INV, /* the book... */
    "tra",             LOGT, CM_ABR|CM_INV,
    "tran",            LOGT, CM_ABR|CM_INV,
    "trans",           LOGT, CM_ABR|CM_INV,
    "transa",          LOGT, CM_ABR|CM_INV,
    "transac",         LOGT, CM_ABR|CM_INV,
    "transact",        LOGT, CM_ABR|CM_INV,
    "transacti",       LOGT, CM_ABR|CM_INV,
    "transactio",      LOGT, CM_ABR|CM_INV,
    "transaction",     LOGT, CM_ABR|CM_INV,
    "transaction-log", LOGT, 0,
    "transactions",    LOGT, CM_INV
#endif /* TLOG */
#ifndef NOSPL
,   "write-file",      LOGW, 0
#endif /* NOSPL */
};
int ncls = (sizeof(clstab) / sizeof(struct keytab));

/* SHOW command arguments */

struct keytab shotab[] = {
#ifndef NOSPL
    "alarm", SHALRM, 0,
    "arg",  SHARG, CM_INV|CM_ABR,
    "arguments", SHARG, 0,
    "args", SHARG, CM_INV,
    "arrays", SHARR, 0,
#endif /* NOSPL */
    "attributes", SHATT, 0,
#ifdef CK_KERBEROS
    "authentication", SHOAUTH, CM_INV,
#endif /* CK_KERBEROS */
#ifndef NOPUSH
#ifdef BROWSER
    "browser", SHBROWSE, 0,
#endif /*  BROWSER */
#endif /* NOPUSH */
    "character-sets", SHCSE, 0,
    "cmd",  SHCMD, CM_INV,
#ifndef NOLOCAL
    "com",  SHCOM, CM_INV|CM_ABR,
    "comm", SHCOM, CM_INV|CM_ABR,
    "communications", SHCOM, 0,
#endif /* NOLOCAL */
    "command", SHCMD, 0,
#ifdef CK_SPEED
    "control-prefixing", SHCTL, 0,
#endif /* CK_SPEED */
#ifndef NOSPL
    "count", SHCOU, 0,
#endif /* NOSPL */
    "d",       SHDIA, CM_INV|CM_ABR,
#ifdef VMS
    "default", SHDFLT, 0,
#else
    "default", SHDFLT, CM_INV,
#endif /* VMS */
#ifndef NODIAL
    "dial", SHDIA, 0,
#endif /* NODIAL */
    "double/ignore", SHDBL, 0,
#ifndef NOPUSH
#ifndef NOFRILLS
    "editor",        SHEDIT, 0,
#endif /*  NOFRILLS */
#endif /* NOPUSH */
#ifndef NOLOCAL
    "escape", SHESC, 0,
#endif /* NOLOCAL */
    "exit", SHEXI, 0,
    "features", SHFEA, 0,
    "file", SHFIL, 0,
#ifdef BROWSER
    "ftp", SHOFTP, 0,
#endif /* BROWSER */
#ifndef NOSPL
    "functions", SHFUN, 0,
    "globals", SHVAR, 0,
#endif /* NOSPL */
    "ignore/double", SHDBL, CM_INV,
#ifndef NOSPL
    "input", SHINP, 0,
#endif /* NOSPL */
#ifndef NOSETKEY
    "k",   SHKEY, CM_INV|CM_ABR,
    "key", SHKEY, 0,
#ifndef NOKVERBS
    "kverbs", SHKVB, 0,
#endif /* NOKVERBS */
#endif /* NOSETKEY */
#ifdef CK_LABELED
    "labeled-file-info", SHLBL, 0,
#endif /* CK_LABELED */
#ifndef NOCSETS
    "languages", SHLNG, 0,
#endif /* NOCSETS */
    "logs", SHLOG, 0,
#ifndef NOSPL
    "macros", SHMAC, 0,
#endif /* NOSPL */
#ifndef NODIAL
    "modem", SHMOD, 0,
#else
    "modem-signals", SHCOM, CM_INV,
#endif /* NODIAL */
#ifndef NOLOCAL
#ifdef OS2MOUSE
    "mouse", SHMOU, 0,
#endif /* OS2MOUSE */
#endif /* NOLOCAL */
#ifdef NETCONN
    "network", SHNET, 0,
#else
    "network", SHNET, CM_INV,
#endif /* NETCONN */
#ifndef NOSPL
    "output", SHOUTP, CM_INV,
#endif /* NOSPL */
#ifdef ANYX25
#ifndef IBMX25
    "pad", SHPAD, 0,
#endif /* IBMX25 */
#endif /* ANYX25 */
    "parameters", SHPAR, CM_INV,
    "patterns", SHOPAT, 0,
    "printer",  SHPRT, 0,
#ifdef CK_SPEED
    "prefixing", SHCTL, CM_INV,
#endif /* CK_SPEED */
    "protocol", SHPRO, 0,
#ifndef NOSPL
    "scripts", SHSCR, 0,
#endif /* NOSPL */
    "send-list", SHSFL, 0,
#ifndef NOSERVER
    "server", SHSER, 0,
#endif /* NOSERVER */
    "status", SHSTA, 0,
#ifdef MAC
    "stack", SHSTK, 0,			/* debugging */
#endif /* MAC */
#ifdef STREAMING
    "streaming", SHOSTR, 0,
#endif /* STREAMING */
#ifndef NOLOCAL
#ifdef OS2
    "tabs",SHTAB, CM_INV,
#endif /* OS2 */
#ifdef CK_TAPI
    "tapi",          SHTAPI, 0,
    "tapi-comm",     SHTAPI_C, CM_INV,
    "tapi-location", SHTAPI_L, CM_INV,
    "tapi-modem",    SHTAPI_M, CM_INV,
#endif /* CK_TAPI */
#ifdef TNCODE
    "telnet",   SHTEL, 0,
#endif /* TNCODE */
    "terminal", SHTER, 0,
#endif /* NOLOCAL */
#ifndef NOXMIT
    "transmit", SHXMI, 0,
#endif /* NOXMIT */
#ifdef CK_TRIGGER
    "trigger", SHTRIG, 0,
#endif /* CK_TRIGGER */
#ifndef NOSETKEY
#ifndef NOKVERBS
#ifdef OS2
     "udk", SHUDK, 0,
#endif /* OS2 */
#endif /* NOKVERBS */
#endif /* NOSETKEY */
#ifndef NOSPL
    "variables", SHBUI, 0,
#endif /* NOSPL */
#ifndef NOFRILLS
    "versions", SHVER, 0,
#endif /* NOFRILLS */
#ifdef OS2
    "vscrn",    SHVSCRN, CM_INV,
#endif /* OS2 */
#ifndef NOXMIT
    "xmit", SHXMI, CM_INV,
#endif /* NOXMIT */
    "", 0, 0
};
int nsho = (sizeof(shotab) / sizeof(struct keytab)) - 1;

#ifdef ANYX25
#ifndef IBMX25
struct keytab padtab[] = {              /* PAD commands */
    "clear",      XYPADL, 0,
    "interrupt",  XYPADI, 0,
    "reset",      XYPADR, 0,
    "status",     XYPADS, 0
};
int npadc = (sizeof(padtab) / sizeof(struct keytab));
#endif /* IBMX25 */
#endif /* ANYX25 */

#ifndef NOSERVER
static struct keytab kmstab[] = {
    "both",    3, 0,
    "remote",  2, 0,
    "local",   1, 0
};

static struct keytab enatab[] = {	/* ENABLE commands */
    "all",        EN_ALL,  0,
#ifndef NOSPL
    "as",         EN_ASG,  CM_INV|CM_ABR,
    "asg",        EN_ASG,  CM_INV,
    "assign",     EN_ASG,  0,
#endif /* NOSPL */
#ifndef datageneral
    "bye",        EN_BYE,  0,
#endif /* datageneral */
    "cd",         EN_CWD,  0,
#ifdef ZCOPY
    "copy",       EN_CPY,  0,
#endif /* ZCOPY */
    "cwd",        EN_CWD,  CM_INV,
    "delete",     EN_DEL,  0,
    "directory",  EN_DIR,  0,
    "finish",     EN_FIN,  0,
    "get",        EN_GET,  0,
    "host",       EN_HOS,  0,
    "mail",       EN_MAI,  0,
    "mkdir",      EN_MKD,  0,
#ifndef NOSPL
    "query",      EN_QUE,  0,
#endif /* NOSPL */
    "print",      EN_PRI,  0,
    "rename",     EN_REN,  0,
    "retrieve",   EN_RET,  CM_INV,
    "rmdir",      EN_RMD,  0,
    "send",       EN_SEN,  0,
    "set",        EN_SET,  0,
    "space",      EN_SPA,  0,
    "type",       EN_TYP,  0,
    "who",        EN_WHO,  0
};
static int nena = (sizeof(enatab) / sizeof(struct keytab));
#endif /* NOSERVER */

static struct keytab sndtab[] = {	/* SEND command options */
    "/as-name",         SND_ASN, CM_ARG,
    "/after",           SND_AFT, CM_ARG,
    "/b",               SND_BIN, CM_INV|CM_ABR,
    "/before",          SND_BEF, CM_ARG,
    "/binary",          SND_BIN, 0,
#ifdef CALIBRATE
    "/c",               SND_CMD, CM_INV|CM_ABR,
    "/calibrate",       SND_CAL, CM_INV|CM_ARG,
#endif /* CALIBRATE */
    "/command",         SND_CMD, 0,
    "/delete",          SND_DEL, 0,
    "/except",          SND_EXC, CM_ARG,
#ifdef PIPESEND
    "/filter",          SND_FLT, CM_ARG,
#endif /* PIPESEND */
    "/filenames",       SND_NAM, CM_ARG,
#ifdef VMS    
    "/image",           SND_IMG, 0,
#else
    "/image",           SND_BIN, CM_INV,
#endif /* VMS */
#ifdef CK_LABELED
    "/labeled",         SND_LBL, 0,
#endif /* CK_LABELED */
    "/larger-than",     SND_LAR, CM_ARG,
    "/list",            SND_FIL, CM_ARG,
#ifndef NOFRILLS
    "/mail",            SND_MAI, CM_ARG,
#endif /* NOFRILLS */
#ifdef CK_TMPDIR
    "/move-to",         SND_MOV, CM_ARG,
#endif /* CK_TMPDIR */
    "/not-after",       SND_NAF, CM_ARG,
    "/not-before",      SND_NBE, CM_ARG,
    "/pathnames",       SND_PTH, CM_ARG,
    "/print",           SND_PRI, CM_ARG,
#ifdef CK_XYZ
    "/protocol",        SND_PRO, CM_ARG,
#else
    "/protocol",        SND_PRO, CM_ARG|CM_INV,
#endif /* CK_XYZ */
    "/quiet",           SND_SHH, 0,
    "/recover",         SND_RES, 0,
#ifdef RECURSIVE
/* Systems where we do recursion */
    "/recursive",       SND_REC, 0,
#else
#ifdef VMS
/* Systems that do recursion themselves without our assistance */
/* if we give them the right kind of wildcard */
    "/recursive",       SND_REC, 0,
#else
#ifdef datageneral
    "/recursive",       SND_REC, 0,
#else
    "/recursive",       SND_REC, CM_INV,
#endif /* datageneral */
#endif /* VMS */
#endif /* RECURSIVE */
    "/rename-to",       SND_REN, CM_ARG,
    "/since",           SND_AFT, CM_INV|CM_ARG,
    "/smaller-than",    SND_SMA, CM_ARG,
    "/starting-at",     SND_STA, CM_ARG,
#ifndef NOFRILLS
    "/su",              SND_ASN, CM_ARG|CM_INV|CM_ABR,
    "/sub",             SND_ASN, CM_ARG|CM_INV|CM_ABR,
    "/subject",         SND_ASN, CM_ARG,
#endif /* NOFRILLS */
#ifdef RECURSIVE
    "/subdirectories",  SND_REC, CM_INV,
#endif /* RECURSIVE */
    "/text",            SND_TXT, 0
};
#define NSNDTAB sizeof(sndtab)/sizeof(struct keytab)
static int nsndtab = NSNDTAB;

static struct keytab msndtab[] = {	/* MSEND options */
    "/after",           SND_AFT, CM_ARG,
    "/before",          SND_BEF, CM_ARG,
    "/binary",          SND_BIN, 0,
    "/delete",          SND_DEL, 0,
    "/except",          SND_EXC, CM_ARG,
    "/filenames",       SND_NAM, CM_ARG,
#ifdef VMS    
    "/image",           SND_IMG, 0,
#else
    "/image",           SND_BIN, CM_INV,
#endif /* VMS */
#ifdef CK_LABELED
    "/labeled",         SND_LBL, 0,
#endif /* CK_LABELED */
    "/larger-than",     SND_LAR, CM_ARG,
    "/list",            SND_FIL, CM_ARG,
#ifndef NOFRILLS
    "/mail",            SND_MAI, CM_ARG,
#endif /* NOFRILLS */
#ifdef CK_TMPDIR
    "/move-to",         SND_MOV, CM_ARG,
#endif /* CK_TMPDIR */
    "/not-after",       SND_NAF, CM_ARG,
    "/not-before",      SND_NBE, CM_ARG,
    "/pathnames",       SND_PTH, CM_ARG,
    "/print",           SND_PRI, CM_ARG,
#ifdef CK_XYZ
    "/protocol",        SND_PRO, CM_ARG,
#endif /* CK_XYZ */
    "/quiet",           SND_SHH, 0,
    "/recover",         SND_RES, 0,
    "/rename-to",       SND_REN, CM_ARG,
    "/since",           SND_AFT, CM_INV|CM_ARG,
    "/smaller-than",    SND_SMA, CM_ARG,
    "/starting-at",     SND_STA, CM_ARG,
#ifndef NOFRILLS
    "/subject",         SND_ASN, CM_ARG,
#endif /* NOFRILLS */
    "/text",            SND_TXT, 0
};
#define NMSNDTAB sizeof(msndtab)/sizeof(struct keytab)
static int nmsndtab = NMSNDTAB;

/* CONNECT command switches */

#ifndef NOLOCAL
static struct keytab conntab[] = {
#ifdef XLIMITS
    "/idle-interval",   CONN_II, CM_ARG,
    "/idle-limit",      CONN_IL, CM_ARG,
    "/idle-string",     CONN_IS, CM_ARG,
    "/quietly",         CONN_NV, CM_INV
#else
    "/quietly",         CONN_NV, 0
#endif /* XLIMITS */
#ifdef XLIMITS
,   "/time-limit",      CONN_TL, CM_ARG
#endif /* XLIMITS */
#ifdef CK_TRIGGER
,   "/trigger",         CONN_TS, CM_ARG
#endif /* CK_TRIGGER */
};
#define NCONNTAB sizeof(conntab)/sizeof(struct keytab)
static int nconntab = NCONNTAB;
#endif /* NOLOCAL */

static struct keytab stattab[] = {	/* STATISTICS command switches */
    "/brief", 1, 0,
    "/verbose", 0, 0
};

#ifndef NOSPL
#ifdef COMMENT
struct mtab mactab[MAC_MAX] = {		/* Preinitialized macro table */
    NULL, NULL, 0
};
#else
struct mtab *mactab;			/* Dynamically allocated macro table */
#endif /* COMMENT */
int nmac = 0;

struct keytab mackey[MAC_MAX];		/* Macro names as command keywords */
#endif /* NOSPL */

#ifndef NOSPL
#ifdef  OS2
struct keytab beeptab[] = {      /* Beep options */
    "error", BP_FAIL, 0,
    "information", BP_NOTE, 0,
    "warning", BP_WARN, 0
};
int nbeeptab = sizeof(beeptab)/sizeof(struct keytab);

/* CLEAR COMMMAND-SCREEN options */

#define CLR_C_ALL 0
#define CLR_C_BOL 1
#define CLR_C_BOS 2
#define CLR_C_EOL 3
#define CLR_C_EOS 4
#define CLR_C_LIN 5
#define CLR_C_SCR 6

struct keytab clrcmdtab[] = {
    "all",     CLR_C_ALL, 0,
    "bol",     CLR_C_BOL, 0,
    "bos",     CLR_C_BOS, 0,
    "eol",     CLR_C_EOL, 0,
    "eos",     CLR_C_EOS, 0,
    "line",    CLR_C_LIN, 0,
    "scrollback", CLR_C_SCR, 0
};
int nclrcmd = sizeof(clrcmdtab)/sizeof(struct keytab);
#endif /* OS2 */
#endif /* NOSPL */

#ifndef NODIAL
static struct keytab looktab[] = {
    "dial", 0, 0
};
#endif /* NODIAL */

/* Forward declarations of functions local to this module */

_PROTOTYP (int doask,   ( int  ) );
_PROTOTYP (int dodef,   ( int  ) );
_PROTOTYP (int dodel,   ( void ) );
_PROTOTYP (int dodial,  ( int  ) );
_PROTOTYP (int dodir,   ( void ) );
_PROTOTYP (int doelse,  ( void ) );
_PROTOTYP (int dofor,   ( void ) );
_PROTOTYP (int dogta,   ( int  ) );
_PROTOTYP (int doincr,  ( int  ) );
_PROTOTYP (int dopaus,  ( int  ) );
#ifndef NOPUSH
_PROTOTYP (int doping,  ( void ) );
_PROTOTYP (int doftp,   ( void ) );
#endif /* NOPUSH */
#ifndef NORENAME
#ifndef NOFRILLS
_PROTOTYP (int dorenam, ( void ) );
#endif /* NOFRILLS */
#endif /* NORENAME */
#ifdef ZCOPY
_PROTOTYP (int docopy, ( void ) );
#endif /* ZCOPY */
#ifdef CK_REXX
_PROTOTYP (int dorexx,  ( void ) );
#endif /* CK_REXX */
#ifdef CK_REDIR
_PROTOTYP (int ttruncmd, ( char * ) );
#endif /* CK_REDIR */
_PROTOTYP (int dotype,   ( char * ) );

#ifdef TCPSOCKET
static struct keytab telcmd[] = {
   "do",   DO,   0,
   "dont", DONT, 0,
   "will", WILL, 0,
   "wont", WONT, 0
};

static struct keytab tnopts[] = {
    "binary", TELOPT_BINARY, 0,
    "echo", TELOPT_ECHO, 0,
#ifdef IKS_OPTION
    "naks", TELOPT_IKS, 0,
#endif /* IKS_OPTION */
#ifdef CK_NAWS
    "naws", TELOPT_NAWS, 0,
#endif /* CK_NAWS */
    "sga", TELOPT_SGA, 0,
    "ttype", TELOPT_TTYPE, 0,
    "", 0, 0
};
static int ntnopts = (sizeof(tnopts) / sizeof(struct keytab)) - 1;

#ifndef NOPUSH
int 
doftp() {				/* FTP command */
    char *p;				/* for now just runs the ftp program */
    int x;

    if (network)			/* If we have a current connection */
      strcpy(line,ttname);		/* get the host name */
    else *line = '\0';			/* as default host */
    for (p = line; *p; p++)		/* Remove ":service" from end. */
      if (*p == ':') { *p = '\0'; break; }
    if ((x = cmtxt("IP host name or number", line, &s, xxstring)) < 0)
      return(x);
/* Construct FTP command */
#ifdef VMS
#ifdef MULTINET				/* TGV MultiNet */
    sprintf(line,"multinet ftp %s",s);
#else
    sprintf(line,"ftp %s",s);		/* Other VMS TCP/IP's */
#endif /* MULTINET */
#else					/* Not VMS */
#ifdef OS2ORUNIX
    sprintf(line,"%s %s",ftpapp,s);
#ifdef OS2
    p = line + strlen(ftpapp);
    while (p != line) {
        if (*p == '/') *p = '\\';
        p--;
    }
#endif /* OS2 */
#else /* OS2ORUNIX */
    sprintf(line,"ftp %s",s);
#endif /* OS2ORUNIX */
#endif /* VMS */
    conres();				/* Make console normal  */
#ifdef DEC_TCPIP
    printf("\n");			/* Prevent prompt-stomping */
#endif /* DEC_TCPIP */
    x = zshcmd(line);
    concb((char)escape);
    return(success = x);
}
   
int
doping() {				/* PING command */
    char *p;				/* just runs ping program */
    int x;

    if (network)			/* If we have a current connection */
      strcpy(line,ttname);		/* get the host name */
    else *line = '\0';			/* as default host to be pinged. */
    for (p = line; *p; p++)		/* Remove ":service" from end. */
      if (*p == ':') { *p = '\0'; break; }
    if ((x = cmtxt("IP host name or number", line, &s, xxstring)) < 0)
      return(x);
/* Construct PING command */
#ifdef VMS
#ifdef MULTINET				/* TGV MultiNet */
    sprintf(line,"multinet ping %s /num=1",s);
#else
    sprintf(line,"ping %s 56 1",s);	/* Other VMS TCP/IP's */
#endif /* MULTINET */
#else					/* Not VMS */
    sprintf(line,"ping %s",s);
#endif /* VMS */
    conres();				/* Make console normal  */
#ifdef DEC_TCPIP
    printf("\n");			/* Prevent prompt-stomping */
#endif /* DEC_TCPIP */
    x = zshcmd(line);
    concb((char)escape);
    return(success = x);
}
#endif /* NOPUSH */
#endif /* TCPSOCKET */

/*  M A K E L I S T  ---  Breaks {{s1}{s2}..{sn}} into an array of strings */

VOID
makelist(s,list,len) char * s; char *list[]; int len; {
    int i, n, q, bc = 0;
    char *p = NULL, *s2 = NULL;
    debug(F110,"makelist s",s,0);
    if (!s) {				/* Check for null or empty string */
	list[0] = NULL;
	return;
    }
    n = strlen(s);
    if (n == 0) {
	list[0] = NULL;
	return;
    }
    if (s2 = (char *)malloc(n+1)) {	/* Safe copy for poking */
	strcpy(s2,s);
	s = s2;
    }
    s = brstrip(s);			/* Strip braces */
    n = strlen(s);			/* Get length */
    if (*s != '{') {			/* Outer braces only */
	if (p = (char *)malloc(n+1)) {	/* So just one pattern */
	    strcpy(p,s);
	    list[0] = p;
	}
	if (s2) free(s2);
	return;
    }
    q = 0;				/* Inner ones too */
    i = 0;				/* so a list of patterns. */
    n = 0;
    while (*s && i < len) {
	if (*s == CMDQ) {		/* Quote... */
	    q = 1;
	    s++;
	    n++;
	    continue;
	}
	if (*s == '{' && !q) {		/* Opening brace */
	    if (bc++ == 0) {
		p = ++s;
		n = 0;
		continue;
	    }
	} else if (*s == '}' && !q) {	/* Closing brace */
	    if (--bc == 0) {
		*s++ = NUL;
		debug(F111,"makelist element",p,i);
		if (list[i] = (char *)malloc(n+1)) {
		    strcpy(list[i],p);
		    i++;
		}
		while (*s == SP) s++;
		p = s;
		n = 0;
		continue;
	    }
	} else {			/* Regular character */
	    q = 0;
	    s++;
	    n++;
	}
    }
    if (*p && i < len) {		/* Last one */
	if (list[i] = (char *)malloc(n+1)) {
	    strcpy(list[i],p);
	    debug(F111,"makelist last element",p,i);
	}
    }
    if (s2) free(s2);
}

static char * asnbuf = NULL;		/* As-name buffer pointer */
/*
  The new SEND command, replacing BSEND, CSEND, PSEND, etc etc.
  Call with cx = top-level keyword value.  Returns:
    < 0  On parse error.
    0    On other type of failure (e.g. requested operation not allowed).
    1    On success with sstate set to 's' so protocol will begin.
*/

/*  D O X S E N D  --  Parse SEND and related commands with switches  */

int
doxsend(cx) int cx; {
    int c, i, n, wild, confirmed = 0;	/* Workers */
    int x, y;				/* of the world... */
    int getval = 0;			/* Whether to get switch value */
    extern char * snd_move;		/* Directory to move sent files to */
    extern char * snd_rename;		/* What to rename sent files to */
    extern char * filefile;		/* File containing filenames to send */
    extern struct keytab pathtab[];	/* PATHNAMES option keywords */
    extern int npathtab;		/* How many of them */
    extern int recursive;		/* Recursive directory traversal */
    extern int rprintf;			/* REMOTE PRINT flag */
    extern int fdispla;			/* TRANSFER DISPLAY setting */
    struct stringint {			/* Temporary array for switch values */
	char * sval;
	int ival;
    } pv[SND_MAX+1];
    struct FDB sf, sw, fl, cm;		/* FDBs for each parse function */
    int mlist = 0;			/* Flag for MSEND or MMOVE */
    char * m;				/* For making help messages */
    extern struct keytab protos[];	/* File transfer protocols */
    extern int nprotos;
    extern char sndbefore[], sndafter[], *sndexcept[]; /* Selection criteria */
    extern char sndnbefore[], sndnafter[];
    extern long sndsmaller, sndlarger, calibrate;

    for (i = 0; i <= SND_MAX; i++) {	/* Initialize switch values */
	pv[i].sval = NULL;		/* to null pointers */
	pv[i].ival = -1;		/* and -1 int values */
    }
    g_recursive = recursive;		/* Recursive sending */
    recursive = 0;			/* Save global value, set local */
    debug(F101,"xsend entry fncnv","",fncnv);

    /* Preset switch values based on top-level command that called us */
    
    switch (cx) {
      case XXMSE:			/* MSEND */
	mlist = 1; break;
      case XXCSEN:			/* CSEND */
	pv[SND_CMD].ival = 1; break;
      case XXMMOVE:			/* MMOVE */
	mlist = 1;
      case XXMOVE:			/* MOVE */
	pv[SND_DEL].ival = 1; break;
      case XXRSEN:			/* RESEND */
	pv[SND_RES].ival = 1; break;
      case XXMAI:			/* MAIL */
	pv[SND_MAI].ival = 1; break;
    }

    /* Set up chained parse functions... */

    cmfdbi(&sw,				/* First FDB - command switches */
	   _CMKEY,			/* fcode */
	   "Filename, or switch",	/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   mlist ? nmsndtab : nsndtab,	/* addtl numeric data 1: tbl size */
	   4,				/* addtl numeric data 2: 4 = cmswi */
	   xxstring,			/* Processing function */
	   mlist ? msndtab : sndtab,	/* Keyword table */
	   &sf				/* Pointer to next FDB */
	   );
    cmfdbi(&sf,				/* 2nd FDB - file to send */
	   _CMIFI,			/* fcode */
	   "File(s) to send",		/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   0,				/* addtl numeric data 1 */
	   0,				/* addtl numeric data 2 */
	   xxstring,
	   NULL,
	   mlist ? &cm : &fl
	   );
    cmfdbi(&fl,				/* 3rd FDB - command to send from */
	   _CMFLD,			/* fcode */
	   "Command",			/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   0,				/* addtl numeric data 1 */
	   0,				/* addtl numeric data 2 */
	   xxstring,
	   NULL,
	   &cm
	   );
    cmfdbi(&cm,				/* 4th FDB - Confirmation */
	   _CMCFM,			/* fcode */
	   "",				/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   0,				/* addtl numeric data 1 */
	   0,				/* addtl numeric data 2 */
	   NULL,
	   NULL,
	   NULL
	   );

    while (1) {				/* Parse 0 or more switches */
	x = cmfdb(&sw);			/* Parse something */
	debug(F101,"xsend cmfdb","",x);
	if (x < 0)			/* Error */
	  goto xsendx;			/* or reparse needed */
	if (cmresult.fcode != _CMKEY)	/* Break out if not a switch */
	  break;
/*
  They gave a switch, but let's see how they terminated it.
  If they ended it with : or =, then we must parse a value.
  If they ended it with anything else, then we must NOT parse a value.
*/
	c = cmgbrk();			/* Get break character */
	getval = (c == ':' || c == '='); /* to see how they ended the switch */
	if (getval && !(cmresult.kflags & CM_ARG)) {
	    printf("?This switch does not take arguments\n");
	    x = -9;
	    goto xsendx;
	}
	n = cmresult.nresult;		/* Numeric result = switch value */
	debug(F101,"xsend switch","",n);

	switch (n) {			/* Process the switch */
	  case SND_CMD:			/* These take no args */
	    if (nopush) {
		printf("?Sorry, system command access is disabled\n");
		x = -9;
		goto xsendx;
	    }
#ifdef PIPESEND
	    else if (sndfilter) {
		printf(
"?Sorry, no SEND /COMMAND or CSEND when SEND FILTER selected\n");
		x = -9;
		goto xsendx;
	    }
#endif /* PIPESEND */
	    sw.hlpmsg = "Command, or switch"; /* Change help message */
	    /* Fall thru... */

	  case SND_REC:			/* /RECURSIVE */
	    recursive = 2;		/* Set the real variable */
	    pv[SND_PTH].ival = PATH_REL; /* Give them relative pathnames */
	    /* and fall thru... */

	  case SND_DEL:			/* /DELETE */
	  case SND_SHH:			/* /QUIET */
	  case SND_RES:			/* /RECOVER */
	    pv[n].ival = 1;		/* Just set the flag */
	    break;

	  /* File transfer modes - each undoes the others */

	  case SND_BIN:			/* Binary */
	  case SND_TXT:			/* Text */
	  case SND_IMG:			/* Image */
	  case SND_LBL:			/* Labeled */
	    pv[SND_BIN].ival = 0;
	    pv[SND_TXT].ival = 0;
	    pv[SND_IMG].ival = 0;
	    pv[SND_LBL].ival = 0;
	    pv[n].ival = 1;
	    break;

	  case SND_EXC:			/* Excludes */
	    if (!getval) break;
	    if ((x = cmfld("Pattern","",&s,xxstring)) < 0) {
		if (x == -3) {
		    printf("?Pattern required\n");
		    x = -9;
		}
		goto xsendx;
	    }
	    if (pv[n].sval) free(pv[n].sval);
	    y = strlen(s);
	    if (y > 256) {
		printf("?Pattern too long - 256 max\n");
		x = -9;
		goto xsendx;
	    }
	    pv[n].sval = malloc(y+1);
	    if (pv[n].sval) {
		strcpy(pv[n].sval,s);
		pv[n].ival = 1;
	    }
	    break;

	  case SND_MOV:			/* MOVE after */
	  case SND_REN:			/* RENAME after */
	    if (!getval) break;
	    if ((x = cmfld(n == SND_MOV ?
	   "device and/or directory for source file after sending" :
	   "new name for source file after sending",
			   "",
			   &s,
			   n == SND_MOV ? xxstring : NULL
			   )) < 0) {
		if (x == -3) {
		    printf("%s\n", n == SND_MOV ?
			   "?Destination required" :
			   "?New name required"
			   );
		    x = -9;
		}
		goto xsendx;
	    }
	    if (pv[n].sval) free(pv[n].sval);
	    s = brstrip(s);
	    y = strlen(s);
	    if (y > 0) {
		pv[n].sval = malloc(y+1);
		if (pv[n].sval) {
		    strcpy(pv[n].sval,s);
		    pv[n].ival = 1;
		}
	    }
	    break;

	  case SND_SMA:			/* Smaller / larger than */
	  case SND_LAR:
	    if (!getval) break;
	    if ((x = cmnum("Size in bytes","0",10,&y,xxstring)) < 0)
	      goto xsendx;
	    pv[n].ival = y;
	    break;

	  case SND_AFT:			/* Send /AFTER:date-time */
	  case SND_BEF:			/* Send /BEFORE:date-time */
	  case SND_NAF:			/* Send /NOT-AFTER:date-time */
	  case SND_NBE:			/* Send /NOT-BEFORE:date-time */
	    if (!getval) break;
	    if ((x = cmdate("Modification date-time","",&s,0,xxstring)) < 0) {
		if (x == -3) {
		    printf("?Date-time required\n");
		    x = -9;
		}
		goto xsendx;
	    }
	    if (pv[n].sval) free(pv[n].sval);
	    pv[n].sval = malloc((int)strlen(s)+1);
	    if (pv[n].sval) {
		strcpy(pv[n].sval,s);
		pv[n].ival = 1;
	    }
	    break;

	  case SND_MAI:			/* Send as mail (= MAIL) */
	    pv[n].ival = 1;
	    if (!getval) break;
	    if ((x = cmfld("e-mail address","",&s,xxstring)) < 0) {
		if (x == -3) {
		    printf("?address required\n");
		    x = -9;
		}
		goto xsendx;
	    }
	    s = brstrip(s);
	    if (pv[n].sval) free(pv[n].sval);
	    pv[n].sval = malloc((int)strlen(s)+1);
	    if (pv[n].sval)
	      strcpy(pv[n].sval,s);
	    break;

	  case SND_PRI:			/* Send to be printed (REMOTE PRINT) */
	    pv[n].ival = 1;
	    if (!getval) break;
	    if ((x = cmfld("Print options","",&s,xxstring)) < 0)
	      if (x != -3) goto xsendx;
	    s = brstrip(s);
	    if (pv[n].sval) free(pv[n].sval);
	    pv[n].sval = malloc((int)strlen(s)+1);
	    if (pv[n].sval)
	      strcpy(pv[n].sval,s);
	    break;

	  case SND_ASN:			/* As-name */
	    debug(F101,"xsend /as-name getval","",getval);
	    if (!getval) break;
	    if ((x = cmfld("Name to send under","",&s,NULL)) < 0) {
		if (x == -3) {
		    printf("?name required\n");
		    x = -9;
		}
		goto xsendx;
	    }
	    s = brstrip(s);
	    if ((y = strlen(s)) > 0) {
		if (pv[n].sval) free(pv[n].sval);
		pv[n].sval = malloc(y+1);
		if (pv[n].sval) {
		    strcpy(pv[n].sval,s);
		    pv[n].ival = 1;
		}		
	    }
	    break;

	  case SND_STA:			/* Starting position (= PSEND) */
	    if (!getval) break;
	    if ((x = cmnum("0-based position","0",10,&y,xxstring)) < 0)
	      goto xsendx;
	    pv[n].ival = y;
	    break;

	  case SND_PRO:			/* Protocol to use */
	    if (!getval) break;
	    if ((x = cmkey(protos,nprotos,"File-transfer protocol","",
			   xxstring)) < 0) {
		if (x == -3) {
		    printf("?name of protocol required\n");
		    x = -9;
		}
		goto xsendx;
	    }
	    pv[n].ival = x;
	    break;

#ifdef PIPESEND
	  case SND_FLT:			/* Filter */
	    debug(F101,"xsend /filter getval","",getval);
	    if (!getval) break;
	    if ((x = cmfld("Filter program to send through","",&s,NULL)) < 0) {
		if (x == -3)
		  s = "";
		else
		  goto xsendx;
	    }
	    s = brstrip(s);
	    y = strlen(s);
	    for (x = 0; x < y; x++) {	/* Make sure they included "\v(...)" */
		if (s[x] != '\\') continue;
		if (s[x+1] == 'v') break;
	    }
	    if (x == y) {
		printf(
		"?Filter must contain a replacement variable for filename.\n"
		       );
		x = -9;
		goto xsendx;
	    }
	    pv[n].ival = 1;
	    if (pv[n].sval) {
		free(pv[n].sval);
		pv[n].sval = NULL;
	    }
	    if ((y = strlen(s)) > 0) {
		if (pv[n].sval = malloc(y+1))
		  strcpy(pv[n].sval,s);
	    }
	    break;
#endif /* PIPESEND */

	  case SND_PTH:			/* Pathnames */
	    if (!getval) {
		pv[n].ival = PATH_REL;
		break;
	    }
	    if ((x = cmkey(pathtab,npathtab,"","absolute",xxstring)) < 0)
	      goto xsendx;
	    pv[n].ival = x;
	    break;

	  case SND_NAM:			/* Filenames */
	    if (!getval) break;
	    if ((x = cmkey(fntab,nfntab,"","converted",xxstring)) < 0)
	      goto xsendx;
	    debug(F101,"xsend /filenames","",x);
	    pv[n].ival = x;
	    break;

#ifdef CALIBRATE
          case SND_CAL:			/* /CALIBRATE */
	    if (getval) {
		if ((x = cmnum("number of Kbytes to send",
			   "1024",10,&y,xxstring)) < 0)
		  goto xsendx;
	    } else
	      y = 1024;
	    pv[n].ival = y;
	    break;
#endif /* CALIBRATE */

	  case SND_FIL:			/* Name of file containing filnames */
	    if (!getval) break;
	    if ((x = cmifi("Name of file containing list of filenames",
			       "",&s,&y,xxstring)) < 0) {
		if (x == -3) {
		    printf("?Filename required\n");
		    x = -9;
		}
		goto xsendx;
	    } else if (y) {
		printf("?Wildcards not allowed\n");
		x = -9;
		goto xsendx;
	    }
	    if (pv[n].sval)
	      free(pv[n].sval);
	    if (s) if (*s) {
		if (pv[n].sval = malloc((int)strlen(s)+1)) {
		    strcpy(pv[n].sval,s);
		    pv[n].ival = 1;
		}
	    }
	    break;

	  default:
	    printf("?Unexpected switch value - %d\n",cmresult.nresult);
	    x = -9;
	    goto xsendx;
	}
    }
    debug(F101,"xsend cmresult fcode","",cmresult.fcode);

#ifdef COMMENT
    /* List switch parsing results in debug log */
    for (i = 0; i <= SND_MAX; i++) {
	sprintf(line,"xsend switch %02d",i);
	debug(F111,line, pv[i].sval, pv[i].ival);
    }
#endif /* COMMENT */

/* Now we have all switches, plus maybe a filename or command, or nothing */

#ifdef PIPESEND
    if (protocol != PROTO_K && pv[SND_CMD].ival > 0) {
	printf("?Sorry, %s works only with Kermit protocol\n",
	       (cx == XXCSEN) ? "CSEND" : "SEND /COMMAND");
	x = -9;
	goto xsendx;
    }
    if (pv[SND_RES].ival > 0 ||	/* /RECOVER */
	pv[SND_STA].ival > 0) {	/* or /STARTING */
	if (sndfilter || pv[SND_FLT].ival > 0) {
	    printf("?Sorry, no /RECOVER or /START if SEND FILTER selected\n");
	    x = -9;
	    goto xsendx;
	}
    }
#endif /* PIPESEND */

    cmarg = "";
    cmarg2 = "";
    line[0] = NUL;
    s = line;
    wild = 0;

    switch (cmresult.fcode) {		/* How did we get out of switch loop */
      case _CMIFI:			/* Input filename */
	strcpy(line,cmresult.sresult);	/* Name */
	wild = cmresult.nresult;	/* Wild flag */
	break;
      case _CMFLD:			/* Field */
	if (pv[SND_CMD].ival < 1) {	/* Only allowed with /COMMAND */
	    printf("?%s - \"%s\"\n",
		   iswild(cmresult.sresult) ?
		   "No files match" : "File not found",
		   cmresult.sresult
		   );
	    x = -9;
	    goto xsendx;
	}
	strcpy(line,cmresult.sresult);
	break;
      case _CMCFM:			/* Confirmation */
	s = "";
	confirmed = 1;
	break;
      default:
	printf("?Unexpected function code: %d\n",cmresult.fcode);
	x = -9;
	goto xsendx;
    }
    debug(F110,"xsend string",s,0);
    debug(F101,"xsend confirmed","",confirmed);

    /* Save and change protocol and transfer mode */
    /* Global values are restored in main parse loop */

    g_proto = protocol;			/* Save current global protocol */
    g_urpsiz = urpsiz;
    g_spsizf = spsizf;
    g_spsiz = spsiz;
    g_spsizr = spsizr;
    g_spmax = spmax;
    g_wslotr = wslotr;
    g_prefixing = prefixing;
    g_fncact = fncact;
    g_fncnv = fncnv;
    g_fnspath = fnspath;
    g_fnrpath = fnrpath;
    if (pv[SND_PRO].ival > -1) {	/* Change according to switch */
	protocol = pv[SND_PRO].ival;
        if (ptab[protocol].rpktlen > -1) /* copied from initproto() */
            urpsiz = ptab[protocol].rpktlen;
        if (ptab[protocol].spktflg > -1) 
            spsizf = ptab[protocol].spktflg;
        if (ptab[protocol].spktlen > -1) {
            spsiz = ptab[protocol].spktlen;
            if (spsizf) 
	      spsizr = spmax = spsiz;
        }
        if (ptab[protocol].winsize > -1) 
            wslotr = ptab[protocol].winsize;
        if (ptab[protocol].prefix > -1) 
            prefixing = ptab[protocol].prefix;
        if (ptab[protocol].fnca > -1) 
            fncact  = ptab[protocol].fnca;
        if (ptab[protocol].fncn > -1) 
            fncnv   = ptab[protocol].fncn;
        if (ptab[protocol].fnsp > -1) 
            fnspath = ptab[protocol].fnsp;
        if (ptab[protocol].fnrp > -1) 
            fnrpath = ptab[protocol].fnrp;
    }
    debug(F101,"xsend protocol","",protocol);

    if (pv[SND_REC].ival > 0)		/* Recursive */
      recursive = 2;

    g_binary = binary;			/* Save global transfer mode */
    if (pv[SND_BIN].ival > 0) {		/* Change according to switch */
	/* If they said /BINARY they mean /BINARY */
#ifdef PATTERNS
	g_patterns = patterns;		/* So no pattern-based switching */
	patterns = 0;
#endif /* PATTERNS */
	g_xfermode = xfermode;		/* or automatic transfer mode */
	xfermode = XMODE_M;
	binary = XYFT_B;
    } else if (pv[SND_TXT].ival > 0) {	/* Ditto for /TEXT */
#ifdef PATTERNS
	g_patterns = patterns;
	patterns = 0;
#endif /* PATTERNS */
	g_xfermode = xfermode;
	xfermode = XMODE_M;
	binary = XYFT_T;
    } else if (pv[SND_IMG].ival > 0)
#ifdef VMS
      binary = XYFT_I;
#else
      binary = XYFT_B;
#endif /* VMS */
#ifdef CK_LABELED
    else if (pv[SND_LBL].ival > 0)
      binary = XYFT_L;    
#endif /* CK_LABELED */
    debug(F101,"xsend binary","",binary);

    /* Check for legal combinations of switches, filenames, etc */

#ifdef PIPESEND
    if (pv[SND_CMD].ival > 0) {	/* COMMAND - strip any braces */
	debug(F110,"SEND /COMMAND before stripping",s,0);
	s = brstrip(s);
	debug(F110,"SEND /COMMAND after stripping",s,0);
	if (!*s) {
	    printf("?Sorry, a command to send from is required\n");
	    x = -9;
	    goto xsendx;
	}
    }
#endif /* PIPESEND */

/* Set up /MOVE and /RENAME */

    if (pv[SND_DEL].ival > 0 &&
	(pv[SND_MOV].ival > 0 || pv[SND_REN].ival > 0)) {
	printf("?Sorry, /DELETE conflicts with /MOVE or /RENAME\n");
	x = -9;
	goto xsendx;
    }
#ifdef CK_TMPDIR
    if (pv[SND_MOV].ival > 0) {
	int len;
	char * p = pv[SND_MOV].sval;
	len = strlen(p);
	if (!isdir(p)) {		/* Check directory */
#ifdef CK_MKDIR
	    char * s = NULL;
	    s = (char *)malloc(len + 4);
	    if (s) {
		strcpy(s,p);
#ifdef datageneral
		if (s[len-1] != ':') { s[len++] = ':'; s[len] = NUL; }
#else
		if (s[len-1] != '/') { s[len++] = '/'; s[len] = NUL; }
#endif /* datageneral */
		s[len++] = 'X';
		s[len] = NUL;
		x = zmkdir(s);
		free(s);
		if (x < 0) {
		    printf("?Can't create \"%s\"\n",p);
		    x = -9;
		    goto xsendx;
		}
	    }
#else
	    printf("?Directory \"%s\" not found\n",p);
	    x = -9;
	    goto xsendx;
#endif /* CK_MKDIR */
	}
	makestr(&snd_move,p);
    } else {
	makestr(&snd_move,NULL);      
    }
#endif /* CK_TMPDIR */

    if (pv[SND_REN].ival > 0) {		/* /RENAME */
	int len;
	char * p = pv[SND_REN].sval;
	if (!p) p = "";
	if (!*p) {
	    printf("?New name required for /RENAME\n");
	    x = -9;
	    goto xsendx;
	}
	p = brstrip(p);
	len = strlen(p);
	makestr(&snd_rename,NULL);
#ifndef NOSPL
    /* If name given is wild, rename string must contain variables */
	if (wild) {
	    char * s = tmpbuf;
	    x = TMPBUFSIZ;
	    zzstring(p,&s,&x);
	    if (!strcmp(tmpbuf,p)) {
		printf(
    "?/RENAME for file group must contain variables such as \\v(filename)\n"
		       );
		x = -9;
		goto xsendx;
	    }
	}
#endif /* NOSPL */
	makestr(&snd_rename,p);
    }

/* Handle /RECOVER and /START */

#ifdef CK_RESEND
    if (pv[SND_RES].ival > 0 && binary != XYFT_B
#ifdef VMS
	&& binary != XYFT_I
#endif /* VMS */
	) {
	printf(
#ifdef VMS
	       "?Sorry, /BINARY required\n"
#else
	       "?Sorry, /BINARY or /IMAGE required\n"
#endif /* VMS */
	       );
	x = -9;
	goto xsendx;
    }
    if (pv[SND_STA].ival > 0) {		/* /START */
	if (wild) {
	    printf("?Sorry, wildcards not permitted with /START\n");
	    x = -9;
	    goto xsendx;
	}
	if (sizeof(int) < 4) {
	    printf("?Sorry, this command needs 32-bit integers\n");
	    x = -9;
	    goto xsendx;
	}
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("?Sorry, SEND /START works only with Kermit protocol\n");
	    x = -9;
	    goto xsendx;
	}
#endif /* CK_XYZ */
    }
#ifdef CK_XYZ
    if (pv[SND_RES].ival > 0) {
	if (protocol != PROTO_K && protocol != PROTO_Z) {
	    printf(
    "Sorry, /RECOVER is possible only with Kermit or ZMODEM protocol\n"
		   );
	    x = -9;
	    goto xsendx;
	}
    }
#endif /* CK_XYZ */
#endif /* CK_RESEND */

    if ((pv[SND_MAI].ival > 0 ||	/* MAIL */
	 pv[SND_PRI].ival > 0 ||	/* PRINT */
	 pv[SND_RES].ival > 0		/* RESEND */
	 ) &&
	(!atdiso || !atcapr)) {		/* Disposition attribute off? */
	printf("?Sorry, ATTRIBUTE DISPOSITION must be ON\n");
	x = -9;
	goto xsendx;
    }

#ifdef CK_XYZ
    if (wild && (protocol == PROTO_X || protocol == PROTO_XC)) {
	printf(
"Sorry, you can only send one file at a time with XMODEM protocol\n"
	       );
	x = -9;
	goto xsendx;
    }
#endif /* CK_XYZ */

    if (!confirmed) {			/* CR not typed yet, get more fields */
	char *m;
	if (mlist) {			/* MSEND or MMOVE */
	    nfils = 0;			/* We already have the first one */
#ifndef NOMSEND
	    msfiles[nfils++] = line;	/* Store pointer */
	    lp = line + (int)strlen(line) + 1; /* Point past it */
	    debug(F111,"xsend msend",msfiles[nfils-1],nfils-1);
	    while (1) {			/* Get more filenames */
		char *p;
		if ((x = cmifi("Names of files to send, separated by spaces",
			       "", &s,&y,xxstring)) < 0) {
		    if (x != -3)
		      goto xsendx;
		    if ((x = cmcfm()) < 0)
		      goto xsendx;
		    break;
		}
		msfiles[nfils++] = lp;	/* Got one, count it, point to it, */
		p = lp;			/* remember pointer, */
		while (*lp++ = *s++)	/* and copy it into buffer */
		  if (lp > (line + LINBUFSIZ)) { /* Avoid memory leak */
		      printf("?MSEND list too long\n");
		      line[0] = NUL;
		      x = -9;
		      goto xsendx;
		  }
		debug(F111,"xsend msend",msfiles[nfils-1],nfils-1);
		if (nfils == 1) *fspec = NUL; /* Take care of \v(filespec) */
#ifdef ZFNQFP
		zfnqfp(p,TMPBUFSIZ,tmpbuf);
		p = tmpbuf;
#endif /* ZFNQFP */
		if (((int)strlen(fspec) + (int)strlen(p) + 1) < CKMAXPATH) {
		    strcat(fspec,p);
		    strcat(fspec," ");
		} else printf("WARNING - \\v(filespec) buffer overflow\n");
	    }
#endif /* NOMSEND */
	} else {			/* Regular SEND */
	    nfils = -1;
	    if (pv[SND_MAI].ival > 0)
	      m = (pv[SND_MAI].sval) ?
		"e-mail address (optional)" :
		  "e-mail address (required)";
	    else if (pv[SND_PRI].ival > 0)
	      m = "printer options (optional)";
	    else if (wild)
	      m =
"\nOptional as-name template containing replacement variables \
like \\v(filename)";
	    else
	      m = "Optional name to send it with";
	    if ((x = cmtxt(m,"",&cmarg2,NULL)) < 0)
	      goto xsendx;
	}
    }

#ifndef NOFRILLS
    if ((pv[SND_MAI].ival > 0) && (pv[SND_PRI].ival > 0)) {
	printf("Sorry, /MAIL and /PRINT are conflicting options\n");
	x = -9;
	goto xsendx;
    }
    n = 0;				/* /MAIL or /PRINT? */
    if (pv[SND_MAI].ival > 0)
      n = SND_MAI;
    else if (pv[SND_PRI].ival > 0)
      n = SND_PRI;
    if (n) {				/* Yes... */
	debug(F111,"xsend",(n == SND_MAI) ? "/MAIL" : "/PRINT", n);
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, %s available only with Kermit protocol\n",
		   (n == SND_MAI) ? "/MAIL" : "/PRINT"
		   );
	    x = -9;
	    goto xsendx;
	}
#endif /* CK_XYZ */
	debug(F101,"xsend print/mail wild","",wild);
	*optbuf = NUL;			/* Wipe out any old options */
	s = "";
	if (!mlist)			/* If not MSEND/MMOVE */
	  s = cmarg2;			/* then use field after filespec */
	cmarg2 = "";
	if (!s) s = "";
	if (!*s)			/* If nothing so far, then use given */
	  s = pv[n].sval;		/* mail address or print switch val */
	if (!s) s = "";
	if (n == SND_MAI && !*s) {
	    printf("?E-mail address required\n");
	    x = -9;
	    goto xsendx;
	} else if ((int)strlen(s) > 94) { /* Ensure legal size */
	    printf("?%s too long\n",
		   (n == SND_MAI) ?
		   "E-mail address" :
		   "Print option string" 
		   );
	    x = -9;
	    goto xsendx;
	}
	strcpy(optbuf,s);		/* OK, copy to option buffer */
	cmarg = line;			/* File to send */
	if (n == SND_MAI) {
	    debug(F110,"xsend mailing",cmarg,0);
	    debug(F110,"xsend address:",optbuf,0);
	    rmailf = 1;
	} else {
	    debug(F110,"xsend printing",cmarg,0);
	    debug(F110,"xsend options",optbuf,0);
	    rprintf = 1;
	}
    }
#endif /* NOFRILLS */

#ifdef CALIBRATE
    if (pv[SND_CAL].ival > 0) {		/* Handle /CALIBRATE */
	if (confirmed) {
	    calibrate = pv[SND_CAL].ival * 1024L;
	    sndsrc = -9;
	    nfils = 1;
	    wild = 0;
#ifndef NOMSEND
	    addlist = 0;
#endif /* NOMSEND */
	    strcpy(line,"CALIBRATION");
	    s = cmarg = line;
	    if (!cmarg2) cmarg2 = "";
	} else if (line[0]) {
	    calibrate = 0L;
	    pv[SND_CAL].ival = 0L;
	}
    }
#endif /* CALIBRATE */

    if (pv[SND_FIL].ival > 0) {
	if (confirmed && !calibrate) {
	    if (zopeni(ZMFILE,pv[SND_FIL].sval) < 1) {
		debug(F110,"xsend can't open",pv[SND_FIL].sval,0);
		printf("?Failure to open %s\n",filefile);
		x = -9;
		goto xsendx;
	    }
	    makestr(&filefile,pv[SND_FIL].sval); /* Open, remember name */
	    debug(F110,"xsend opened",filefile,0);
	    wild = 1;
	}
    }
    if (confirmed && !line[0] && !filefile && !calibrate) { /* SEND alone */
#ifndef NOMSEND
	if (filehead) {			/* OK if we have a SEND-LIST */
	    nfils = filesinlist;
	    sndsrc = nfils;		/* Like MSEND */
	    addlist = 1;		/* But using a different list... */
	    filenext = filehead;
	    if (pv[SND_DEL].ival > 0)	/* /DELETE given? */
	      moving = 1;
	    goto sendend;
	}
#endif /* NOMSEND */
	printf("?Filename required but not given\n");
	x = -9;
	goto xsendx;
    } 

    /* Not send-list */

#ifndef NOMSEND
    addlist = 0;			/* Don't use SEND-LIST. */
    filenext = NULL;
#endif /* NOMSEND */

    if (mlist) {			/* MSEND or MMOVE */
#ifndef NOMSEND
	cmlist = msfiles;		/* List of files to send */
	sndsrc = nfils;
	cmarg2 = "";
	sendstart = 0L;
#endif /* NOMSEND */
#ifdef PIPESEND
	pipesend = 0;
#endif /* PIPESEND */
    } else if (filefile) {		/* File contains list of filenames */
	s = "";
	cmarg = "";
	cmarg2 = "";
	line[0] = NUL;
	nfils = 1;
	sndsrc = 1;
    } else if (!calibrate) {		/* Not MSEND, MMOVE, or /LIST */
	nfils = sndsrc = -1;
	if (
#ifndef NOFRILLS
	    !rmailf && !rprintf		/* Not MAIL or PRINT */
#else
	    1
#endif /* NOFRILLS */
	    ) {
	    strcpy(line,s);		/* Save copy of string just parsed. */
	    cmarg = line;		/* File to send */
	    debug(F110,"send line",line,0);
	}
#ifdef ZFNQFP
	zfnqfp(cmarg,CKMAXPATH,fspec);
#else
	strncpy(fspec,cmarg,CKMAXPATH);
#endif /* ZFNQFP */
    }
    if (!mlist) {			/* For all but MSEND... */
	/* filename2 takes precedence */
	/* Use /AS-NAME if no filename2 */
	if (!cmarg2) cmarg2 = "";
	if (!*cmarg2 && pv[SND_ASN].ival > 0 && pv[SND_ASN].sval) {
	    int x;
	    x = strlen(line);
	    strncpy(line+x+2,pv[SND_ASN].sval,LINBUFSIZ-x-1);
	    cmarg2 = line+x+2;
	}
#ifdef PIPESEND
	if (pv[SND_CMD].ival > 0)	/* /COMMAND sets pipesend flag */
	  pipesend = 1;
	debug(F101,"xsend /COMMAND pipesend","",pipesend);
	if (pipesend && filefile) {
	    printf("?Invalid switch combination\n");
	    x = -9;
	    goto xsendx;
	}
#endif /* PIPESEND */

#ifndef NOSPL
    /* If as-name given and filespec is wild, as-name must contain variables */
	if (wild && *cmarg2) {
	    char * s = tmpbuf;
	    x = TMPBUFSIZ;
	    zzstring(cmarg2,&s,&x);
	    if (!strcmp(tmpbuf,cmarg2)) {
		printf(
    "?As-name for file group must contain variables such as \\v(filename)\n"
		       );
		x = -9;
		goto xsendx;
	    }
	}
#endif /* NOSPL */

    /* Strip braces from as-name */
	debug(F110,"xsend cmarg2 before stripping",cmarg2,0);
	cmarg2 = brstrip(cmarg2);
	debug(F110,"xsend filename",cmarg,0);
	debug(F110,"xsend as-name",cmarg2,0);

    /* Copy as-name to a safe place */

	if (asnbuf) {
	    free(asnbuf);
	    asnbuf = NULL;
	}
	if ((y = strlen(cmarg2)) > 0) {
	    asnbuf = (char *) malloc(y + 1);
	    if (asnbuf) {
		strcpy(asnbuf,cmarg2);
		cmarg2 = asnbuf;
	    } else cmarg2 = "";
	}

#ifdef CK_RESEND
	debug(F111,"xsend pv[SND_STA].ival","",pv[SND_STA].ival);
	if (pv[SND_STA].ival > -1) {	/* /START position */
	    if (wild) {
		printf("?/STARTING-AT may not be used with multiple files.\n");
		x = -9;
		goto xsendx;
	    } else
	      sendstart = pv[SND_STA].ival;
	} else
	  sendstart = 0L;
	debug(F110,"xsend /STARTING","",sendstart);
#endif /* CK_RESEND */
    }

sendend:				/* Common successful exit */
    moving = 0;
    if (pv[SND_DEL].ival > 0)		/* /DELETE was specified */
      moving = 1;
    debug(F110,"xsend /DELETE","",moving);
    if (pv[SND_AFT].ival > 0)		/* Copy SEND criteria */
      strncpy(sndafter,pv[SND_AFT].sval,18);
    if (pv[SND_BEF].ival > 0)
      strncpy(sndbefore,pv[SND_BEF].sval,18);
    if (pv[SND_NAF].ival > 0)
      strncpy(sndnafter,pv[SND_NAF].sval,18);
    if (pv[SND_NBE].ival > 0)
      strncpy(sndnbefore,pv[SND_NBE].sval,18);
    if (pv[SND_EXC].ival > 0)
      makelist(pv[SND_EXC].sval,sndexcept,8);
    if (pv[SND_SMA].ival > -1)
      sndsmaller = pv[SND_SMA].ival;
    if (pv[SND_LAR].ival > -1)
      sndlarger = pv[SND_LAR].ival;
    if (pv[SND_NAM].ival > -1) {
	g_fncnv = fncnv;		/* Save global value */
	fncnv = pv[SND_NAM].ival;
	debug(F101,"xsend fncnv","",fncnv);
    }
    if (pv[SND_PTH].ival > -1) {
	g_spath = fnspath;		/* Save global values */
	fnspath = pv[SND_PTH].ival;
#ifndef NZLTOR
	if (fnspath != PATH_OFF) {
	    g_fncnv = fncnv;		/* Bad bad... */
	    fncnv = XYFN_C;
	}
#endif /* NZLTOR */
	debug(F101,"xsend fnspath","",fnspath);
	debug(F101,"xsend fncnv","",fncnv);
    }
    if (pv[SND_SHH].ival > 0) {
	g_displa = fdispla;
	fdispla = 0;
	debug(F101,"xsend display","",fdispla);
    }

#ifdef PIPESEND
    if (pv[SND_FLT].ival > 0) {
	g_sfilter = sndfilter;
	if (!pv[SND_FLT].sval) {
	    sndfilter = NULL;
	} else {
	    sndfilter = (char *) malloc((int) strlen(pv[SND_FLT].sval) + 1);
	    if (sndfilter) strcpy(sndfilter,pv[SND_FLT].sval);
	}
    }
#endif /* PIPESEND */

#ifdef CK_APC
/* MOVE not allowed in APCs */
    if (moving &&
	(apcactive == APC_LOCAL || apcactive == APC_REMOTE)
	&& apcstatus != APC_UNCH)
      return(success = 0);
#endif /* CK_APC */

    sstate = 's';			/* Set start state to SEND */
#ifdef CK_RESEND
    if (pv[SND_RES].ival > 0)		/* Send sendmode appropriately */
      sendmode = SM_RESEND;
    else if (pv[SND_STA].ival > 0)
      sendmode = SM_PSEND;
    else 
#endif /* CK_RESEND */
    if (mlist)
      sendmode = SM_MSEND;
    else
      sendmode = SM_SEND;
#ifdef MAC
    what = W_SEND;
    scrcreate();
#endif /* MAC */
    if (local && pv[SND_SHH].ival != 0) { /* If in local mode, */
	displa = 1;			/* turn on file transfer display */
    }
    x = 0;

  xsendx:				/* Common exit, including failure */
    debug(F101,"doxsend sndsrc","",sndsrc);
    for (i = 0; i <= SND_MAX; i++) {	/* Free malloc'd memory */
	if (pv[i].sval)
	  free(pv[i].sval);
    }
    return(x);
}

#ifndef NOLOCAL
/*  D O X C O N N  --  CONNECT command parsing with switches */

#ifdef XLIMITS
#define XLIMORTRIGGER
#else
#ifdef CK_TRIGGER
#define XLIMORTRIGGER
#endif /* CK_TRIGGER */
#endif /*  XLIMITS */

#ifdef OS2				/* K95 only: */
extern int
  tt_idlesnd_tmo;			/*   Idle interval */
int tt_idlelimit = 0;			/*   Idle limit */
int tt_timelimit = 0;			/*   Time limit, 0 = none */
extern char *				/* Parse results - strings: */
  tt_idlesnd_str;			/*   Idle string */
#endif /* OS2 */

#ifdef CK_TRIGGER
extern char *tt_trigger[];
extern CHAR *tt_trmatch[];
extern char *triggerval;
#endif /* CK_TRIGGER */

int
doxconn(cx) int cx; {
    int c, i, n;			/* Workers */
    int x, y;
    int getval = 0;			/* Whether to get switch value */
    struct stringint {			/* Temporary array for switch values */
	char * sval;
	int ival;
    } pv[CONN_MAX+1];
    struct FDB sw, cm;			/* FDBs for each parse function */

#ifdef CK_TRIGGER
    char *g_tt_trigger[TRIGGERS];
#endif /* CK_TRIGGER */

#ifdef OS2
    int g_tt_idlesnd_tmo, g_tt_timelimit; /* For saving and restoring */
    int g_tt_idlelimit;
    char * g_tt_idlesnd_str;		/* global settings */

    g_tt_idlesnd_tmo = tt_idlesnd_tmo;	/* Save global settings */
    g_tt_timelimit   = tt_timelimit;
    g_tt_idlelimit   = tt_idlelimit;
    g_tt_idlesnd_str = tt_idlesnd_str;
#endif /* OS2 */

#ifdef CK_TRIGGER
    if (!tt_trigger[0]) {		/* First initialization */
	for (i = 1; i < TRIGGERS; i++)
	  tt_trigger[i] = NULL;
    }
    for (i = 0; i < TRIGGERS; i++)
      g_tt_trigger[i] = tt_trigger[i];
    if (triggerval)
      free(triggerval);
#endif /* CK_TRIGGER */

    for (i = 0; i <= CONN_MAX; i++) {	/* Initialize switch values */
	pv[i].sval = NULL;		/* to null pointers */
	pv[i].ival = -1;		/* and -1 int values */
    }
    if (cx == XXCQ)			/* CQ == CONNECT /QUIETLY */
      pv[CONN_NV].ival = 1;

    /* Set up chained parse functions... */

    cmfdbi(&sw,				/* First FDB - command switches */
	   _CMKEY,			/* fcode */
	   "Switch",			/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   nconntab,			/* addtl numeric data 1: tbl size */
	   4,				/* addtl numeric data 2: 4 = cmswi */
	   xxstring,			/* Processing function */
	   conntab,			/* Keyword table */
	   &cm				/* Pointer to next FDB */
	   );
    cmfdbi(&cm,				/* 2nd FDB - Confirmation */
	   _CMCFM,			/* fcode */
	   "",				/* hlpmsg */
	   "",				/* default */
	   "",				/* addtl string data */
	   0,				/* addtl numeric data 1 */
	   0,				/* addtl numeric data 2 */
	   NULL,
	   NULL,
	   NULL
	   );

    while (1) {				/* Parse 0 or more switches */
	x = cmfdb(&sw);			/* Parse switch or confirmation */
	debug(F101,"xconn cmfdb","",x);
	if (x < 0) {			/* Error */
	    if (x == -9 || x == -2)
	      printf("?No switches match - \"%s\"\n",atmbuf);
	    goto xconnx;		/* or reparse needed */
	}
	if (cmresult.fcode != _CMKEY)	/* Break out if not a switch */
	  break;
	c = cmgbrk();			/* Get break character */
	getval = (c == ':' || c == '='); /* to see how they ended the switch */
	if (getval && !(cmresult.kflags & CM_ARG)) {
	    printf("?This switch does not take arguments\n");
	    x = -9;
	    goto xconnx;
	}
	n = cmresult.nresult;		/* Numeric result = switch value */
	debug(F101,"xconn switch","",n);

	switch (n) {			/* Process the switch */
	  case CONN_NV:			/* Non-verbal */
	    pv[n].ival = 1;
	    break;
#ifdef XLIMITS
	  case CONN_II:			/* Idle-interval */
	  case CONN_IL:			/* Idle-limit */
	  case CONN_TL:			/* Time-limit */
	    if (!getval) break;
	    if ((x = cmnum("Seconds","0",10,&y,xxstring)) < 0)
	      goto xconnx;
	    pv[n].ival = y;
	    break;
	  case CONN_IS:			/* Idle-string */
#endif /* XLIMITS */
#ifdef CK_TRIGGER
	  case CONN_TS:			/* Trigger-string */
#endif /* CK_TRIGGER */
#ifdef XLIMORTRIGGER
	    if (!getval) break;
	    if ((x = cmfld("String (enclose in braces if it contains spaces)",
			   "",&s,xxstring)) < 0) {
		if (x == -3) {
		    printf("?String required\n");
		    x = -9;
		}
		goto xconnx;
	    }
	    if (n != CONN_TS)
	      s = brstrip(s);
	    if ((y = strlen(s)) > 0) {
		if (pv[n].sval) free(pv[n].sval);
		pv[n].sval = malloc(y+1);
		if (pv[n].sval) {
		    strcpy(pv[n].sval,s);
		    pv[n].ival = 1;
		}		
	    }
	    break;
#endif /* XLIMORTRIGGER */
	  default:
	    printf("?Unexpected switch value - %d\n",cmresult.nresult);
	    x = -9;
	    goto xconnx;
	}
    }
    debug(F101,"doxconn cmresult.fcode","",cmresult.fcode);
    if (cmresult.fcode != _CMCFM) {
	printf("?Unexpected function code: %d\n",cmresult.fcode);
	x = -9;
	goto xconnx;
    }

#ifdef OS2				/* Make results available globally */
    if (pv[CONN_IL].ival > -1)		/* Idle limit */
      tt_idlelimit = pv[CONN_IL].ival;
    if (pv[CONN_II].ival > -1)		/* Idle limit */
      tt_idlesnd_tmo = pv[CONN_II].ival;
    if (pv[CONN_IS].sval)		/* Idle string */
      if (tt_idlesnd_str = (char *)malloc((int)strlen(pv[CONN_IS].sval)+1))
	strcpy(tt_idlesnd_str,pv[CONN_IS].sval);
    if (pv[CONN_TL].ival > -1)		/* Session limit */
      tt_timelimit = pv[CONN_TL].ival;
#endif /* OS2 */

#ifdef CK_TRIGGER
    if (pv[CONN_TS].sval)		/* Trigger strings */
      makelist(pv[CONN_TS].sval,tt_trigger,TRIGGERS);
    for (i = 0; i < TRIGGERS; i++)	/* Trigger match pointers */
      tt_trmatch[i] = NULL;
    if (triggerval) {			/* Reset trigger value */
	free(triggerval);
	triggerval = NULL;
    }
#endif /* CK_TRIGGER */

    x = doconect((pv[CONN_NV].ival > 0) ? 1 : 0);

#ifdef CK_TRIGGER
    debug(F111,"doxconn doconect triggerval",triggerval,x);
#endif /* CK_TRIGGER */

    /* Back from CONNECT -- Restore global settings */

#ifdef OS2
    tt_idlelimit   = g_tt_idlelimit;
    tt_idlesnd_tmo = g_tt_idlesnd_tmo;
    tt_timelimit   = g_tt_timelimit;
    tt_idlesnd_str = g_tt_idlesnd_str;
#endif /* OS2 */

#ifdef CK_TRIGGER
    for (i = 0; i < TRIGGERS; i++)
      tt_trigger[i] = g_tt_trigger[i];
#endif /* CK_TRIGGER */

  xconnx:
    for (i = 0; i <= CONN_MAX; i++) {	/* Free malloc'd memory */
	if (pv[i].sval)
	  free(pv[i].sval);
    }
    success = (x > 0) ? 1 : 0;
    return(x);
}
#endif /* NOLOCAL */

#ifdef ADDCMD
/* cx == XXADD or XXREMV */
/* fc == ADD_blah */
static int
doadd(cx,fc) int cx, fc; {
#ifdef PATTERNS
    extern char *txtpatterns[], *binpatterns[], alphacase;
    char * tmp[FTPATTERNS];
    char **p = NULL;
    int i, n = 0, x = 0, last;
#endif /* PATTERNS */
    if (cx != XXADD && cx != XXREMV) {
	printf("?Unexpected function code: %d\n",cx);
	return(-9);
    }
#ifdef PATTERNS
    while (n < FTPATTERNS) {		/* Collect new patterns */
	tmp[n] = NULL;
	if ((x = cmfld("Pattern","",&s,xxstring)) < 0)
	  break;
	strcpy(line,s);
	s = brstrip(line);
	makestr(&(tmp[n++]),s);
    }
    if (x == -3)
      x = cmcfm();
    if (x < 0)
      goto xdoadd;
    p = (fc == ADD_BIN) ? binpatterns : txtpatterns; /* Which list */
    last = 0;
    for (i = 0; i < FTPATTERNS; i++) { /* Find last one in list */
	if (!p[i]) {
	    last = i;
	    break;
	}
    }
    if (cx == XXADD) {			/* Adding */
	if (last + n > FTPATTERNS) {	/* Check if too many */
	    printf("?Too many patterns - %d is the maximum\n", FTPATTERNS);
	    goto xdoadd;
	}
	for (i = 0; i < n; i++)		/* Copy in the new ones. */
	  makestr(&(p[i+last]),tmp[i]);
	makestr(&(p[i+last]),NULL);	/* Null-terminate the list */
	goto xdoadd;			/* Done */
    } else if (cx == XXREMV) {		/* Remove something(s) */
	int j, k;
	if (last == 0)			        /* List is empty */
	  goto xdoadd;			        /* Nothing to remove */
	for (i = 0; i < n; i++) {	        /* i = Patterns they typed */
	    for (j = 0; j < last; j++) {        /* j = Patterns in list */
		if (alphacase)
		  x = !strcmp(tmp[i],p[j]);     /* Case-sensitive match */
		else
		  x = xxstrcmp(tmp[i],p[j],-1);	/* Case-independent match */
		if (x) {	    	        /* This one matches */
		    makestr(&(p[j]),NULL);      /* Free it */
		    for (k = j; k < last; k++)  /* Move the rest up */
		      p[k] = p[k+1];
		    p[k] = NULL;	        /* Erase last one */
		    if (!p[k])
		      break;
		}
	    }
	}
    }
  xdoadd:				/* Common exit */
    for (i = 0; i < n; i++)
      if (tmp[i])
	free(tmp[i]);
    return(x);
#endif /* PATTERNS */
}
#endif /* ADDCMD */

/*  D O C M D  --  Do a command  */

/*
 Returns:
   -2: user typed an illegal command
   -1: reparse needed
    0: parse was successful (even tho command may have failed).
*/
int
docmd(cx) int cx; {

    debug(F101,"docmd entry, cx","",cx);
    activecmd = cx;
    doconx = ((activecmd == XXCON)  || (activecmd == XXTEL) ||
	      (activecmd == XXRLOG) || (activecmd == XXPIPE));
/*
  Massive switch() broken up into many smaller ones, for the benefit of
  compilers that run out of space when trying to handle large switch
  statements.
*/
    switch (cx) {
      case -4:			/* EOF */
#ifdef OSK
	if (msgflg)  printf("\n");
#else
	if (msgflg)  printf("\r\n");
#endif /* OSK */
	  doexit(GOOD_EXIT,xitsta);
      case -3:				/* Null command */
	return(0);
      case -9:				/* Like -2, but errmsg already done */
      case -1:				/* Reparse needed */
	return(cx);
      case -6:				/* Special */
      case -2:				/* Error, maybe */
#ifndef NOSPL
/*
  Maybe they typed a macro name.  Let's look it up and see.
*/
	if (cx == -6)			/* If they typed CR */
	  strcat(cmdbuf,"\015");	/*  add it back to command buffer. */
	if (ifcmd[cmdlvl] == 2)		/* Watch out for IF commands. */
	  ifcmd[cmdlvl]--;
	repars = 1;			/* Force reparse */
	cmres();
	cx = XXDO;			/* Try DO command */
#else
	return(cx);
#endif /* NOSPL */
      default:
	break;
    }

#ifndef NOSPL
/* Copy macro args from/to two levels up, used internally by _floop et al. */
    if (cx == XXGTA || cx == XXPTA) {	/* _GETARGS, _PUTARGS */
	int x;
	debug(F101,"docmd XXGTA","",XXGTA);
	debug(F101,"docmd cx","",cx);
	debug(F101,"docmd XXGTA maclvl","",maclvl);
	x = dogta(cx);
	debug(F101,"docmd dogta returns","",x);
	debug(F101,"docmd dogta maclvl","",maclvl);
	return(x);
    }
#endif /* NOSPL */

#ifndef NOSPL
/* ASK, ASKQ, READ */
    if (cx == XXASK || cx == XXASKQ || cx == XXREA ||
	cx == XXRDBL || cx == XXGETC) {
	return(doask(cx));
    }
#endif /* NOSPL */

#ifndef NOFRILLS
    if (cx == XXBUG) {			/* BUG */
	if ((x = cmcfm()) < 0) return(x);
	return(dobug());
    }
#endif /* NOFRILLS */

    if (cx == XXBYE) {			/* BYE */
	bye_active = 1;
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, BYE only works with Kermit protocol\n");
	    return(-9);
	}
#endif /* CK_XYZ */
	if ((x = cmcfm()) < 0) return(x);
	sstate = setgen('L',"","","");
	if (local) ttflui();		/* If local, flush tty input buffer */
	return(0);
    }

#ifndef NOSPL
    if ( cx == XXBEEP ) {        /* BEEP */
        int x;
#ifdef OS2
	int y;
        if ((y = cmkey( beeptab, nbeeptab, "which kind of beep", "information",
		       xxstring)) < 0 )
	  return (y);
    	if ((x = cmcfm()) < 0) return(x);
        bleep((short)y);		/* y is one of the BP_ values */
#else  /* OS2 */
    	if ((x = cmcfm()) < 0) return(x);
        bleep(BP_NOTE);
#endif /* OS2 */
        return(0);
    }
#endif /* NOSPL */

#ifndef NOFRILLS
    if (cx == XXCLE) {			/* CLEAR */
	if ((x = cmkey(clrtab,nclear,"item to clear",
#ifdef NOSPL
		  "device-buffer"
#else
		  "device-and-input"
#endif /* NOSPL */
		  ,xxstring)) < 0) return(x);
#ifndef NOSPL
#ifdef OS2
        if ( x == CLR_CMD || x == CLR_TRM ) {
            if ((z = cmkey(clrcmdtab,nclrcmd,"how much screen to clear\n",
			   "all",xxstring)) < 0)
	      return(z);
        }
#endif /* OS2 */
#endif /* NOSPL */
	if ((y = cmcfm()) < 0) return(y);

	/* Clear device input buffer if requested */
	y = (x & CLR_DEV) ? ttflui() : 0;
#ifndef NOSPL
	/* Clear INPUT command buffer if requested */
	if (x & CLR_INP) {
	    for (x = 0; x < inbufsize; x++)
	      inpbuf[x] = NUL;
	    inpbp = inpbuf;
	    y = 0;
	}
#ifdef CK_APC
	if (x & CLR_APC) {
	    apcactive = 0;
	    y = 0;
	}
#endif /* CK_APC */
#endif /* NOSPL */

#ifndef NODIAL
	if (x & CLR_DIA) {
	    dialsta = DIA_UNK;
	    y = 0;
	}
#endif /* NODIAL */

#ifndef NOMSEND
	if (x & CLR_SFL) {		/* CLEAR SEND-LIST */
	    if (filehead) {
		struct filelist * flp, * next;
		flp = filehead;
		while (flp) {
		    if (flp->fl_name)
		      free(flp->fl_name);
		    if (flp->fl_alias)
		      free(flp->fl_alias);
		    next = flp->fl_next;
		    free(flp);
		    flp = next;
		}
	    }
	    filesinlist = 0;
	    filehead = NULL;
	    filetail = NULL;
	    y = 0;
	}
#endif /* NOMSEND */

#ifdef OS2
	switch (x) {
	  case CLR_SCL:
	    clearscrollback(VTERM);
	    break;
	  case CLR_CMD:
	    switch ( z ) {
	      case CLR_C_ALL:
		clear();
		break;
	      case CLR_C_BOS:
		clrboscr_escape(VCMD,SP);
		break;
	      case CLR_C_BOL:
		clrbol_escape(VCMD,SP);
		break;
	      case CLR_C_EOL:
		clrtoeoln(VCMD,SP);
		break;
	      case CLR_C_EOS:
		clreoscr_escape(VCMD,SP);
		break;
	      case CLR_C_LIN:
		clrline_escape(VCMD,SP);
		break;
	      case CLR_C_SCR:
		clearscrollback(VCMD);
		break;
            default:
		printf("Not implemented yet, sorry.\n");
		break;
	    }
	    break;

	  case CLR_TRM:
             switch ( z ) {
	      case CLR_C_ALL:
                 if (VscrnGetBufferSize(VTERM) > 0 ) {
                     VscrnScroll(VTERM, UPWARD, 0, 
				 VscrnGetHeight(VTERM)-(tt_status?2:1),
				 VscrnGetHeight(VTERM) -
				 (tt_status?1:0), TRUE, SP
				 );
                     cleartermscreen(VTERM);
                 }
                 break;
	      case CLR_C_BOS:
		clrboscr_escape(VTERM,SP);
		break;
	      case CLR_C_BOL:
		clrbol_escape(VTERM,SP);
		break;
	      case CLR_C_EOL:
		clrtoeoln(VTERM,SP);
		break;
	      case CLR_C_EOS:
		clreoscr_escape(VTERM,SP);
		break;
	      case CLR_C_LIN:
		clrline_escape(VTERM,SP);
		break;
             case CLR_C_SCR:
                 clearscrollback(VTERM);
                 break;
             default:
                 printf("Not implemented yet, sorry.\n");
                 break;
	    }
	    break;
	}
	y = 0;	
#endif /* OS2 */    
	return(success = (y == 0));
    }
#endif /* NOFRILLS */

    if (cx == XXCOM) {			/* COMMENT */
	if ((x = cmtxt("Text of comment line","",&s,NULL)) < 0)
	  return(x);
	/* Don't change SUCCESS flag for this one */
	return(0);
    }

#ifndef NOLOCAL
    if (cx == XXCON || cx == XXCQ)	/* CONNECT or CONNECT /QUIETLY */
      return(doxconn(cx));
#endif /* NOLOCAL */

#ifndef NOFRILLS
#ifdef ZCOPY
    if (cx == XXCPY) {			/* COPY a file */
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH) return(success = 0);
#endif /* CK_APC */
	return(docopy());
    }
#endif /* ZCOPY */
#endif /* NOFRILLS */

    if (cx == XXCWD || cx == XXBACK)	/* CD or BACK */
      return(success = docd(cx));

    if (cx == XXCHK)			/* CHECK */
      return(success = dochk());

    if (cx == XXCLO) {			/* CLOSE */
	x = cmkey(clstab,ncls,"\"CONNECTION\", or log or file to close",
		  "connection",xxstring);
	if (x == -3) {
	    printf("?You must say which file or log\n");
	    return(-9);
	}
	if (x < 0) return(x);
	if ((y = cmcfm()) < 0) return(y);
#ifndef NOLOCAL
	if (x == 9999) {		/* CLOSE CONNECTION */
	    x = clsconnx();
	    if (msgflg) {
		switch (x) {
		  case 0:
		    if (msgflg) printf("?Connection was not open\n"); 
		  case -1:
		    return(0);
		  case 1:
		    return(1);
		}
	    }
	} 
#endif /* NOLOCAL */
	y = doclslog(x);
	success = (y == 1);
	return(success);
    }

#ifndef NOSPL
    if (cx == XXDEC || cx == XXINC)	/* DECREMENT, INCREMENT */
      return(doincr(cx));

    if (cx == XXEVAL) {
	char *p;
	if ((x = cmtxt("Integer arithmetic expression","",&s,xxstring)) < 0)
	  return(x);
	p = evala(s);
	if (!p) p = "";
	if (*p)
	  printf("%s\n", p);
	strncpy(evalbuf,p,32);
	return(success = *p ? 1 : 0);
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXDEF || cx == XXASS ||
	cx == XXDFX || cx == XXASX || cx == XXUNDEF) {
	if (atmbuf[0] == '.' && !atmbuf[1]) /* "." entered as keyword */
	  xxdot = 1;			/* i.e. with space after it... */
	return(dodef(cx));		/* DEFINE, ASSIGN, etc... */
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXDCL) {			/* DECLARE an array */
	int i, n, v, rc = 0;
#ifdef BIGBUFOK
#define MAXAINITS 1024			/* Max number of initializers */
#else
#define MAXAINITS 64
#endif /* BIGBUFOK */
	char * p[MAXAINITS+1];		/* Pointers to initializers */
	char tmp[32];			/* For initializer help message */
	for (i = 0; i <= MAXAINITS; i++)
	  p[i] = NULL;
	if ((y = cmfld("Array name","",&s,NULL)) < 0) {	/* Parse array name */
	    if (y == -3) {
		printf("?Array name required\n");
		return(-9);
	    } else return(y);
	}
	if ((y = arraynam(s,&x,&n)) < 0) /* Check it */
	  return(y);
	if (n > MAXAINITS)		/* Max number of initializers */
	  n = MAXAINITS;
	v = 0;				/* Highest initialized member */
	while (n > 0 && v < n) {	/* Parse initializers */
	    sprintf(tmp,"Initial value for \\&%c[%d]",x,v+1); /* Help string */
	    if ((rc = cmfld((char *)tmp,"",&s,NULL)) < 0) { /* Get a field */
		if (rc == -3)		/* If answer is empty, we're done */
		  break;
		else			/* Parse error, free temp pointers */
		  goto dclx;
	    }
	    s = brstrip(s);		/* Strip any braces */
	    if (v == 0 && !strcmp(s,"=")) /* Skip the = sign. */
	      continue;
	    makestr(&(p[++v]),s);
	}
	if ((y = cmtxt("Carriage return to confirm","",&s,NULL)) < 0)
	  return(y);
	if (dclarray((char)x,n) < 0) {	/* Declare the array */
	    printf("?Declare failed\n");
	    goto dclx;
	}
	for (i = 1; i <= v; i++) {	/* Add any initial values */

	    sprintf(tmp,"&%c[%d]",(char)x,i);
	    if (addmac(tmp,p[i]) < 0) {
		printf("Array initialization error: %s %s\n",tmp,p[i]);
		rc = -9;
		goto dclx;
	    }
	}
      dclx:
	for (i = 1; i <= v; i++)
	  if (p[i]) free(p[i]);
	return(success = rc);
    }
#endif /* NOSPL */

#ifndef NODIAL
    if (cx == XXRED  || cx == XXDIAL || cx == XXPDIA ||
	cx == XXANSW || cx == XXLOOK) { /* DIAL, REDIAL etc */
#ifdef VMS
	extern int batch;
#else
#ifdef UNIXOROSK
	extern int backgrd;
#endif /* UNIXOROSK */
#endif /* VMS */
	x = dodial(cx);
	debug(F101,"dodial returns","",x);
	if ((cx == XXDIAL || cx == XXRED || cx == XXANSW) &&
	    (x > 0) &&			/* If DIAL or REDIAL succeeded */
	    (dialcon > 0)) {
	    if ((dialcon == 1 ||	/* And DIAL CONNECT is ON, */
		(dialcon == 2) &&	/* or DIAL CONNECT is AUTO */
		 !cmdsrc()		/* and we're at top level... */
#ifdef VMS		 
		 && !batch		/* Not if running from batch */
#else
#ifdef UNIXOROSK
		 && !backgrd		/* Not if running in background */
#endif /* UNIXOROSK */
#endif /* VMS */
		 )) /* Or AUTO */
	      x = doconect(dialcq);	/* Then also CONNECT */
	}
	return(success = x);
    }
#endif /* NODIAL */

#ifndef NOPUSH
#ifdef CK_REXX
    if (cx == XXREXX) {			/* REXX */
        extern int nopush;
        if ( nopush )
          return(success=0);
        return(dorexx());
    }
#endif /* CK_REXX */
#endif /* NOPUSH */

#ifndef NOFRILLS
    if (cx == XXDEL) {			/* DELETE */
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH) return(success = 0);
#endif /* CK_APC */
	return(dodel());
    }
#endif /* NOFRILLS */

    if (cx == XXDIR)			/* DIRECTORY */
      return(dodir());

#ifndef NOSPL
    if (cx == XXELS)			/* ELSE */
      return(doelse());
#endif /* NOSPL */

#ifndef NOSERVER
#ifndef NOFRILLS
    if (cx == XXENA || cx == XXDIS) {	/* ENABLE, DISABLE */
	s = (cx == XXENA) ?
	  "Server function to enable" :
	    "Server function to disable";

	if ((x = cmkey(enatab,nena,s,"",xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of server function required\n");
		return(-9);
	    } else return(x);
	}
	if ((y = cmkey(kmstab,3,"mode","both",xxstring)) < 0) {
	    if (y == -3) {
		printf("?Please specify remote, local, or both\n");
		return(-9);
	    } else return(y);
	}
	if (cx == XXDIS)		/* Disabling, not enabling */
	  y = 3 - y; 
	if ((z = cmcfm()) < 0) return(z);
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH)
	  return(success = 0);
#endif /* CK_APC */
	return(doenable(y,x));
    }
#endif /* NOFRILLS */
#endif /* NOSERVER */

#ifndef NOSPL
    if (cx == XXRET) {			/* RETURN */
	if ((x = cmtxt("optional return value","",&s,NULL)) < 0)
	  return(x);
	s = brstrip(s);			/* Strip braces */
	if (cmdlvl == 0) {		/* At top level, nothing happens... */
	    return(success = 1);
	} else if (cmdstk[cmdlvl].src == CMD_TF) { /* In TAKE file, like POP */
	    popclvl();			/* pop command level */
	    return(success = 1);	/* always succeeds */
	} else if (cmdstk[cmdlvl].src == CMD_MD) { /* Within macro */
	    return(doreturn(s));	/* Trailing text is return value. */
	} else return(-2);
    }
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXDO) {			/* DO (a macro) */
	if (nmac == 0) {
	    printf("\n?No macros defined\n");
	    return(-9);
	}
	for (y = 0; y < nmac; y++) {	/* copy the macro table */
	    mackey[y].kwd = mactab[y].kwd; /* into a regular keyword table */
	    mackey[y].kwval = y;	/* with value = pointer to macro tbl */
	    mackey[y].flgs = mactab[y].flgs;
	}
	/* parse name as keyword */
	if ((x = cmkey(mackey,nmac,"macro","",xxstring)) < 0) {
	    if (x == -3) {
		printf("?Macro name required\n");
		return(-9);
	    } else return(x);
	}
	if ((y = cmtxt("optional arguments","",&s,xxstring)) < 0)
	  return(y);			/* get args */
	return(dodo(x,s,cmdstk[cmdlvl].ccflgs) < 1 ? (success = 0) : 1);
    }
#endif /* NOSPL */

    if (cx == XXECH || cx == XXXECH
#ifndef NOSPL
	|| cx == XXAPC
#endif /* NOSPL */
	) {				/* ECHO or APC */
	if ((x = cmtxt((cx == XXECH || cx == XXXECH) ?
		       "Text to be echoed" :
		       "Application Program Command text",
		       "",&s,xxstring)) < 0)
	  return(x);
	s = brstrip(s);			/* Strip braces */
	if (cx == XXECH) {		/* ECHO */
#ifndef NOSPL
	    if (fndiags && fnerror && !fnsuccess)
	      printf("%s",s);
	    else
#endif /* NOSPL */
	      printf("%s\n",s);
	} else if (cx == XXXECH) {	/* XECHO */
	    printf("%s",s);
#ifdef UNIX
	    fflush(stdout);
#endif /* UNIX */
	} else {			/* APC */
#ifdef CK_APC
	    if (apcactive == APC_LOCAL || 
            apcactive == APC_REMOTE && apcstatus != APC_UNCH)
	      return(success = 0);
#endif /* CK_APC */
	    if (!local) {
		printf("%c_%s%c\\",ESC,s,ESC);
#ifdef UNIX
		fflush(stdout);
#endif /* UNIX */

	    } else {
#ifndef NOSPL
		sprintf(tmpbuf,"%c_%s%c\\",ESC,s,ESC);
		return(success = dooutput(tmpbuf));
#else
		printf("%c_%s%c\\",ESC,s,ESC);
#endif /* NOSPL */
	    }
	}
	return(success = 1);		/* Always succeeds */
    }

#ifndef NOSPL
    if (cx == XXOPE)			/* OPEN */
      return(doopen());
#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXOUT) {			/* OUTPUT */
	if ((x = cmtxt("Text to be output","",&s,NULL)) < 0)
	  return(x);
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH)
	  return(success = 0);
#endif /* CK_APC */
	debug(F110,"OUTPUT 1",s,0);
	s = brstrip(s);			/* Strip enclosing braces, */
	debug(F110,"OUTPUT 2",s,0);
/*
  I don't think I could ever fully explain this in a million years...
  We have read the user's string without calling the variable-expander
  function.  Now, before we call it, we have to double backslashes that
  appear before \N, \B, \L, and \ itself, so the expander function will
  reduce them back to single backslashes, so when we call dooutput()...
  But it's more complicated than that.
*/
	if (cmdgquo()) {		/* Only if COMMAND QUOTING ON ... */
	    for (x = 0, y = 0; s[x]; x++, y++) {
		if (s[x] == CMDQ) {
		    char c = s[x+1];
		    if (c == 'n' || c == 'N' ||
			c == 'b' || c == 'B' ||
			c == 'l' || c == 'L' ||
			c == CMDQ)
		      line[y++] = CMDQ;
		}
		line[y] = s[x];
	    }
	    line[y++] = '\0';		/* Now expand variables, etc. */
	    debug(F110,"OUTPUT 3",line,0);
	    s = line+y+1;
	    x = LINBUFSIZ - (int) strlen(line) - 1;
	    debug(F101,"OUTPUT size","",x);
	    if (zzstring(line,&s,&x) < 0)
	      return(success = 0);
	    s = line+y+1;
	    debug(F110,"OUTPUT 4",s,0);
	}
	success = dooutput(s);
	return(success);
    }
#endif /* NOSPL */

#ifdef ANYX25
#ifndef IBMX25
    if (cx == XXPAD) {			/* PAD commands */
	x = cmkey(padtab,npadc,"PAD command","",xxstring);
	if (x == -3) {
	    printf("?You must specify a PAD command to execute\n");
	    return(-9);
	}
	if (x < 0) return(x);

	switch (x) {
	  case XYPADL:
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else {
		x25clear();
		initpad();
	    }
	    break;
	  case XYPADS:
	    if (x25stat() < 0)
	      printf("Not connected\r\n");
	    else {
		extern int linkid, lcn;
		conol("Connected thru ");
		conol(ttname);
		printf(", Link id %d, Logical channel number %d\r\n",
		       linkid,lcn);
	    }
	    break;
	  case XYPADR:
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else
	      x25reset(0,0);
	    break;
	  case XYPADI:
	    if (x25stat() < 0)
	      printf("Sorry, you must 'set network' & 'set host' first\r\n");
	    else
	      x25intr(0);
	}
	return(0);
}
#endif /* IBMX25 */
#endif /* ANYX25 */

#ifndef NOSPL
    if (cx == XXPAU || cx == XXWAI || cx == XXMSL) /* PAUSE, WAIT, etc */
      return(dopaus(cx));
#endif /* NOSPL */

#ifndef NOFRILLS
    if (cx == XXPRI) {
	if ((x = cmifi("File to print","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?A file specification is required\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?Wildcards not allowed\n");
	    return(-9);
	}
	strcpy(line,s);
	s = "";
#ifndef NT
	if ((x = cmtxt("Local print command options, or carriage return","",&s,
		       xxstring)) < 0)
	  return(x);
#endif /* NT */
	if ((x = cmcfm()) < 0)
	  return(x);
	return(success = (zprint(s,line) == 0) ? 1 : 0);
    }
#endif /* NOFRILLS */

#ifndef NOPUSH
#ifdef TCPSOCKET
    if (cx == XXPNG) 			/* PING an IP host */
      return(doping());

    if (cx == XXFTP)			/* FTP an IP host */
      return(doftp());
#endif /* TCPSOCKET */
#endif /* NOPUSH */

    if (cx == XXPWD) {			/* PWD */
#ifdef MAC
	char *pwp;
#else
#ifdef OS2
	char *pwp;
#endif /* OS2 */
#endif /* MAC */
	if ((x = cmcfm()) < 0)
	  return(x);
#ifndef MAC
#ifndef OS2
	xsystem(PWDCMD);
	return(success = 1);		/* blind faith */
#else
	if (pwp = zgtdir()) {
	    printf("%s\n",pwp);
	    return(success = ((int)strlen(pwp) > 0));
	} else return(success = 0);
#endif
#else
	if (pwp = zgtdir()) {
	    printf("%s\n",pwp);
	    return(success = ((int)strlen(pwp) > 0));
	} else return(success = 0);
#endif /* MAC */
    }
    if (cx == XXQUI || cx == XXEXI) {	/* EXIT, QUIT */
	if ((y = cmnum("exit status code","",10,&x,xxstring)) < 0) {
	    if (y == -3)
	      x = xitsta;
	    else return(y);
	}
	if ((y = cmtxt("Optional EXIT message","",&s,xxstring)) < 0)
	  return(y);
	strcpy(line,s);
	if ((y = cmcfm()) < 0) return(y);

	if (!hupok(0))			/* Check if connection still open */
	  return(success = 0);
#ifdef COMMENT
#ifndef NODIAL
	mdmhup();
#endif /* NODIAL */
#endif /* COMMENT */

	if (line[0])			/* Print EXIT message if given */
	  printf("%s\n",(char *)line);

#ifdef VMS
	doexit(GOOD_EXIT,x);
#else
#ifdef OSK
/* Returning any codes here makes the OS-9 shell print an error message. */
	doexit(GOOD_EXIT,-1);
#else
#ifdef datageneral
        doexit(GOOD_EXIT,x);
#else
	doexit(x,-1);
#endif /* datageneral */
#endif /* OSK */
#endif /* VMS */
    }

#ifndef NOFRILLS
    if (cx == XXERR) {			/* ERROR */
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, E-PACKET only works with Kermit protocol\n");
	    return(-9);
	}
#endif /* CK_XYZ */
	if ((x = cmcfm()) < 0) return(x);
	ttflui();
	epktflg = 1;
	sstate = 'a';
	return(0);
    }
#endif /* NOFRILLS */

    if (cx == XXFIN) {			/* FINISH */
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, FINISH only works with Kermit protocol\n");
	    return(-9);
	}
#endif /* CK_XYZ */
	if ((x = cmcfm()) < 0) return(x);
	sstate = setgen('F',"","","");
	if (local) ttflui();		/* If local, flush tty input buffer */
	return(0);
    }

#ifndef NOSPL
    if (cx == XXFOR)			/* FOR loop */
      return(dofor());
#endif /* NOSPL */

    /* GET MGET REGET RETRIEVE etc */
    if (cx == XXGET || cx == XXMGET || cx == XXREGET || cx == XXRETR) {
	return(doxget(cx));
#ifdef COMMENT
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, \"%s\" only works with Kermit protocol\n", atmbuf);
	    return(-9);
	}
#endif /* CK_XYZ */
	x = cmtxt("Name of remote file(s), or carriage return","",&cmarg,
		  xxstring);
#ifndef NOFRILLS
	if ((x == -2) || (x == -1)) return(x);
#else
	if (x < 0) return(x);
#endif /* NOFRILLS */
	cmarg = brstrip(cmarg);		/* Strip braces */
	x = doget(cx);
#ifdef MAC
	what = W_RECV;
	if (sstate == 'r')
	    scrcreate();
#endif /* MAC */
	return(x);
#endif /* COMMENT */
    }

#ifndef NOSPL
#ifndef NOFRILLS
    if (cx == XXGOK) {			/* GETOK */
	return(success = doask(cx));
    }
#endif /* NOFRILLS */
#endif /* NOSPL */

    if (cx == XXHLP) {			/* HELP */
#ifdef NOHELP
	return(dohlp(XXHLP));
#else
	x = cmkey2(cmdtab,ncmd,"C-Kermit command","help",toktab,xxstring,3);
	debug(F101,"HELP command x","",x);
	if (x == -5) {
	    y = chktok(toktab);
	    debug(F101,"top-level cmkey token","",y);
	    ungword();
	    switch (y) {
#ifndef NOPUSH
	      case '!': x = XXSHE; break;
#endif /* NOPUSH */
	      case '#': x = XXCOM; break;
	      case ';': x = XXCOM; break;
#ifndef NOSPL
              case '.': x = XXDEF; break;
	      case ':': x = XXLBL; break;
#endif /* NOSPL */
	      case '&': x = XXECH; break;
	      default:
		printf("\n?Invalid - %s\n",cmdbuf);
		x = -2;
	    }
	}
	return(dohlp(x));
#endif /* NOHELP */
    }

#ifndef NOHELP
    if (cx == XXINT)			/* INTRO */
      return(hmsga(introtxt));
    if (cx == XXNEW)			/* NEWS */
      return(hmsga(newstxt));
#ifdef OS2ONLY
    if (cx == XXUPD) {			/* View UPDATE file */
        extern char exedir[];
        char * pTopic;
        char updstr[2048];
        if ((x = cmtxt("topic name","",&pTopic,xxstring)) < 0)
            return x;
	sprintf(updstr,
		"start view %s\\docs\\k2.inf+%s\\docs\\using_ck.inf+\
%s\\docs\\dialing.inf+%s\\docs\\modems.inf %s",
		exedir,exedir,exedir,exedir,pTopic
		);
        system(updstr);
        return(success = 1);
    }
#endif /* OS2ONLY */
#endif /* NOHELP */

#ifndef NOLOCAL
    if (cx == XXHAN) {			/* HANGUP */
	if ((x = cmcfm()) < 0) return(x);
#ifndef NODIAL
	if ((x = mdmhup()) < 1)
#endif /* NODIAL */
	  x = (tthang() > -1);
#ifdef OS2
	if (x)
	  DialerSend(OPT_KERMIT_HANGUP, 0);
#endif /* OS2 */
	if (x) haveline = 0;
	return(success = x);
    }
#endif /* NOLOCAL */

#ifndef NOSPL
    if (cx == XXGOTO || cx == XXFWD || cx == XXXFWD) { /* GOTO or FORWARD */
/* Note, here we don't set SUCCESS/FAILURE flag */
	if ((y = cmfld("label","",&s,xxstring)) < 0) {
	    if (y == -3) {
		printf("?Label name required\n");
		return(-9);
	    } else return(y);
	}
	strncpy(lblbuf,s,LBLSIZ);
	if ((x = cmcfm()) < 0) return(x);
	s = lblbuf;
	return(dogoto(s,cx));
    }
#endif /* NOSPL */

#ifndef NOSPL
/* IF, Extended IF, WHILE */
    if (cx == XXIF || cx == XXIFX || cx == XXWHI) {
	return(doif(cx));
    }
    if (cx == XXSWIT) {
	return(doswitch());
    }
#endif /* NOSPL */

#ifndef NOSPL
    /* INPUT, REINPUT, and MINPUT */

    if (cx == XXINP || cx == XXREI
#ifdef CK_MINPUT
	|| cx == XXMINP
#endif /* CK_MINPUT */
	) {
	long zz;
	extern int x_ifnum;

	sprintf(tmpbuf,"%d",indef);
	zz = -1L;
	x_ifnum = 1;			/* Turn off internal complaints */
	y = cmnum("seconds to wait for input, or time of day hh:mm:ss",
		  (char *)tmpbuf, 10, &x, xxstring
		  );
	x_ifnum = 0;
	if (y < 0) {
	    if (y == -2) {		/* Invalid number or expression */
		zz = tod2sec(atmbuf);	/* Convert to secs since midnight */
		if (zz < 0L) {
		    printf("?Number, expression, or time of day required\n");
		    return(-9);
		} else {
		    char now[32];	/* Current time */
		    char *p;
		    long tnow;
		    p = now;
		    ztime(&p);
		    tnow = atol(p+11) * 3600L + atol(p+14) * 60L + atol(p+17);
		    if (zz < tnow)	/* User's time before now */
		      zz += 86400L;	/* So make it tomorrow */
		    zz -= tnow;		/* Seconds from now. */
		}
	    } else
	      return(y);
	}
	if (zz > -1L) {
	    x = zz;
	    if (zz != (long) x) {
		printf(
"Sorry, arithmetic overflow - hh:mm:ss not usable on this platform.\n"
		       );
		return(-9);
	    }
	}
	for (y = 0; y < MINPMAX; y++) {	/* Initialize strings */
	    if (ms[y]) {
		free(ms[y]);		/* Free old strings, if any */
		ms[y] = NULL;
	    }
	}
#ifdef CK_MINPUT
	if (cx == XXMINP) {		/* MINPUT */
	    int res = 0;
	    for (y = 0; y < MINPMAX; y++) { /* Parse up to MINPMAX strings */
                res = cmfld("List of input strings","",&s,xxstring);
                if (res < 0) return(res);
		debug(F110,"MINPUT cmfld returns",s,0);
                if (*s == '{') {
		    char *ss;
		    int n;
		    ss = s; n = 0;
		    while (*ss) {*ss = *(ss+1); ss++; n++; }
		    while (--n > 0) if (s[n] == '}') break;
		    if (n > 0) {
			ss = s + n;
			while (*ss) {*ss = *(ss+1); ss++; n++; }
		    }
                }
		if (!(ms[y] = malloc((int)strlen(s) + 1))) { /* Get memory */
		    printf("?Memory allocation failure\n");
		    return(-9);
		}
		strcpy(ms[y],s);	/* Got memory, copy. */
                if (res == 1) break;
            }
	    for (y++; y < MINPMAX; y++) { /* Clean up old strings */
		if (ms[y]) {
		    free(ms[y]);	/* Free old strings, if any */
		    ms[y] = NULL;
		}
            }
#ifdef DEBUG
	    if (deblog) {		/* Check the parsing */
		for (y = 0; y < MINPMAX; y++)
		  if (ms[y]) debug(F111,"MINPUT",ms[y],y);
	    }
#endif /* DEBUG */
	
	} else
#endif /* CK_MINPUT */
	{
	    if ((y = cmtxt("Material to be input","",&s,xxstring)) < 0)
	      return(y);

	    s = brstrip(s);
	    if (!(ms[0] = malloc((int)strlen(s) + 1))) { /* Get memory */
		printf("?Memory allocation failure\n");
		return(-9);
	    }
	    strcpy(ms[0],s);		/* Got memory, copy. */
	    ms[1] = NULL;
	}
	if (cx == XXINP			/* INPUT */
#ifdef CK_MINPUT
	    || cx == XXMINP		/* or MINPUT */
#endif /* CK_MINPUT */
	    ) {
	    i_active = 1;
	    success = doinput(x,ms);	/* Go try to input the search string */
	    i_active = 0;
	} else {			/* REINPUT */
	    debug(F110,"xxrei line",s,0);
	    success = doreinp(x,s);
	}
	if (intime[cmdlvl] && !success) { /* TIMEOUT-ACTION = QUIT? */
	    popclvl();			/* If so, pop command level. */
	    if (pflag && cmdlvl == 0) {
		if (cx == XXINP)  printf("?INPUT timed out\n");
		if (cx == XXMINP) printf("?MINPUT timed out\n");
		if (cx == XXREI)  printf("?REINPUT failed\n");
	    }
	}
	return(success);		/* Return do(re)input's return code */
    }

#endif /* NOSPL */

#ifndef NOSPL
    if (cx == XXLBL) {			/* LABEL */
	if ((x = cmfld("label","",&s,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Label name required\n");
		return(-9);
	    } else return(x);
	}
	if ((x = cmcfm()) < 0) return(x);
	return(0);
    }
#endif /* NOSPL */

    if (cx == XXLOG) {			/* LOG */
	x = cmkey(logtab,nlog,"What to log","",xxstring);
	if (x == -3) {
	    printf("?Type of log required\n");
	    return(-9);
	}
	if (x < 0) return(x);
	x = dolog(x);
	if (x < 0)
	  return(x);
	else
	  return(success = x);
    }

#ifndef NOSCRIPT
    if (cx == XXLOGI) {			/* UUCP-style script */
	if ((x = cmtxt("expect-send expect-send ...","",&s,xxstring)) < 0)
	  return(x);
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH) return(success = 0);
#endif /* CK_APC */
#ifdef VMS
	conres();			/* For Ctrl-C to work... */
#endif /* VMS */
	return(success = dologin(s));	/* Return 1=completed, 0=failed */
    }
#endif /* NOSCRIPT */

#ifdef PIPESEND
    if (cx == XXCREC) {			/* CRECEIVE */
	if (protocol != PROTO_K) {
	    printf("?Sorry, CRECEIVE works only with Kermit protocol\n");
	    return(-9);
	}
#ifdef COMMENT
	cmarg2 = "";
	if ((x = cmtxt("Command","",&cmarg2,NULL)) < 0)
	  return(x);
	if (nopush) {
	    printf("?Sorry, system command access is disabled\n");
	    return(-9);
	} else if (rcvfilter) {
	    printf("?Sorry, can't CRECEIVE while RECEIVE FILTER selected\n");
	    return(-9);
	}
	cmarg2 = brstrip(cmarg2);
	if (!*cmarg2) {
	    printf("?You must supply the name of a command to receive to\n");
	    return(-9);
	}
	pipesend = 1;
	debug(F111,"CRECEIVE cmarg2",cmarg2,pipesend);
	sstate = 'v';
#ifdef MAC
	what = W_RECV;
	scrcreate();
#endif /* MAC */
	if (local) displa = 1;
	return(0);
#else
	return(doxget(cx));
#endif /* COMMENT */
    }

    if (cx == XXCGET) {			/* CGET */
#ifdef COMMENT
	char * s, * s2;
	if (protocol != PROTO_K) {
	    printf("?Sorry, CGET works only with Kermit protocol\n");
	    return(-9);
	}
	cmarg2 = "";
	if ((x = cmfld(
	    "Remote file or command - enclose in braces if it contains spaces",
		       "",&s,xxstring)) < 0)
	  return(x);
	if (nopush) {
	    printf("?Sorry, system command access is disabled\n");
	    return(-9);
	} else if (rcvfilter) {
	    printf("?Sorry, can't CGET while RECEIVE FILTER selected\n");
	    return(-9);
	}
	s = brstrip(s);
	if (!*s) {
	    printf("?You must supply the name of a remote file or command\n");
	    return(-9);
	}
	strcpy(line,s);
	s = line;
	if ((x = cmtxt("Local command","",&s2,NULL)) < 0)
	  return(x);
	s2 = brstrip(s2);
	if (!*s2) {
	    printf("?You must supply the name of a command to receive to\n");
	    return(-9);
	}
	cmarg = s;
	cmarg2 = s2;
	pipesend = 1;
	debug(F111,"CGET cmarg2",cmarg2,pipesend);
	sstate = 'r';
#ifdef MAC
	what = W_RECV;
	scrcreate();
#endif /* MAC */
	if (local) displa = 1;
	return(0);
#else
	return(doxget(cx));
#endif /* COMMENT */
    }

#endif /* PIPESEND */

    if (cx == XXREC)
      return(doxget(cx));

#ifdef COMMENT
    if (cx == XXREC) {			/* RECEIVE */
	cmarg2 = "";

#ifdef COMMENT /* wrong place for this -- see protocol module */
#ifdef CK_TMPDIR
	if (dldir && !f_tmpdir) {	/* If they have a download directory */
	    if (s = zgtdir()) {		/* Get current directory */
		if (zchdir(dldir)) {	/* Change to download directory */
		    strncpy(savdir,s,TMPDIRLEN);
		    f_tmpdir = 1;	/* Remember that we did this */
		}
	    }
	}
#endif /* CK_TMPDIR */
#endif /* COMMENT */

#ifdef CK_XYZ
	if (protocol == PROTO_X || protocol == PROTO_XC) {
	    x = cmofi("Name for incoming file", "", &s, xxstring);
	} else {
#endif /* CK_XYZ */
	    x = cmofi(
#ifdef CK_TMPDIR
"\nName under which to store incoming file, or:\n\
 name of directory in which to store all the file(s), or:\n\
 confirm the command now to store the files in the current\n\
 directory under their own names.",
#else
"Name under which to store the file, or confirm to accept\n\
 the file with its own name.",
#endif /* CK_TMPDIR */
		      "", &s, xxstring
		      );
#ifdef CK_XYZ
	}
#endif /* CK_XYZ */
	if ((x == -1) || (x == -2) || (x == -9)) {
#ifdef CK_TMPDIR
	    if (f_tmpdir) {
		zchdir(savdir);
		f_tmpdir = 0;
	    }
#endif /* CK_TMPDIR */
	    return(x);
	}
#ifdef CK_XYZ
	if ((protocol == PROTO_X || protocol == PROTO_XC) && x == -3) {
	    printf(
"Sorry, you must specify a name when receiving a file with XMODEM protocol\n");
#ifdef CK_TMPDIR
	    if (f_tmpdir) {
		zchdir(savdir);
		f_tmpdir = 0;
	    }
#endif /* CK_TMPDIR */
	    return(-9);
	}
#endif /* CK_XYZ */
	strcpy(line,s);
	if ((x = cmcfm()) < 0) {
#ifdef CK_TMPDIR
	    if (f_tmpdir) {
		zchdir(savdir);
		f_tmpdir = 0;
	    }
#endif /* CK_TMPDIR */
	    return(x);
	}
#ifdef CK_TMPDIR
/*
   User can give a device &/or directory specification here,
   rather than an alternative filename.
*/
	x = strlen(line);
	if (
#ifdef OS2
	    (isalpha(line[0]) &&
	     line[1] == ':' &&
	     line[2] == '\0') ||
	    isdir(line)
#else
#ifdef UNIX
	    (x > 0 && line[x-1] == '/') || isdir(line)
#else
#ifdef VMS
	    (x > 0) && isdir(line)
#else
/*
  Others -- Maybe this will work; if not, add another #ifdef..#endif.
  CK_TMPDIR should not be defined without an isdir() function.
*/
	    (x > 0) && isdir(line)
#endif /* VMS */
#endif /* UNIX */
#endif /* OS2 */
	    ) {
	    debug(F110,"DOWNLOAD arg disk or dir",line,0);
	    if (!f_tmpdir) {	/* If not already cd'd to download directory */
		s = zgtdir();		/* Get current directory */
		if (s) {		/* Save it */
		    strncpy(savdir,s,TMPDIRLEN);
		    f_tmpdir = 1;	/* Remember that we did this */
		    cmarg2 = "";	/* and we don't have an as-name. */
		} else {
		    printf("?Can't get current directory\n");
		    return(-9);
		}
	    }
	    if (!zchdir(line)) {	/* Change to given disk/directory, */
		printf("?Can't access %s\n",line);
		return(-9);
	    }
	} else				/* It's an alternative filename */
#endif /* CK_TMPDIR */
/*
  This used to be simply "cmarg2 = line;".  But now that we allow as-name
  templates we have to undo the evaluation that was done by cmofi().  amtbuf[]
  contains the evaluated string.  The only place to find the original string
  is in the command buffer.  But it has the whole command in it.  So we have
  to get the as-name out of it.  We know it begins with "receive" or some
  abbreviation, and then some whitespace, followed by the as-name.  This is
  because we now evaluate the as-name dynamically during file transfer, once
  for each file, rather than just once at parse time.
*/
	  {
	      s = cmdbuf + 1;
	      while (*s) {
		  if (*s > SP && *(s-1) <= SP)
		    break;
		  s++;
	      }
	      cmarg2 = s;
	  }
	if (!*cmarg2)
	  cmarg2 = line;
	debug(F111,"cmofi cmarg2",cmarg2,x);
	sstate = 'v';
#ifdef MAC
	what = W_RECV;
	scrcreate();
#endif /* MAC */
	if (local) displa = 1;
	return(0);
    }
#endif /* COMMENT */

    if (cx == XXREM) {			/* REMOTE */
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, REMOTE commands only work with Kermit protocol\n");
	    return(-9);
	}
#endif /* CK_XYZ */
	x = cmkey(remcmd,nrmt,"Remote Kermit server command","",xxstring);
	if (x == -3) {
	    printf("?You must specify a command for the remote server\n");
	    return(-9);
	}
	return(dormt(x));
    }

#ifndef NORENAME
#ifndef NOFRILLS
    if (cx == XXREN) {			/* RENAME */
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
	    apcactive == APC_REMOTE && apcstatus != APC_UNCH)
	  return(success = 0);
#endif /* CK_APC */
	return(dorenam());
    }
#endif /* NOFRILLS */
#endif /* NORENAME */

    if (cx == XXEIGHT) {		/* EIGHTBIT */
	extern int parity, cmask, cmdmsk;
	if ((x = cmcfm()) < 0)
	  return(x);
	parity = 0;
	cmask = 0xff;
	cmdmsk = 0xff;
	return(success = 1);
    }

/* SEND, CSEND, MOVE, MAIL, and RESEND use the new code */

    if (cx == XXSEN			/* SEND */
#ifdef PIPESEND
	|| cx == XXCSEN			/* CSEND */
#endif /* PIPESEND */
	|| cx == XXMOVE			/* MOVE */	
	|| cx == XXMAI			/* MAIL */
#ifdef CK_RESEND
	|| cx == XXRSEN			/* RESEND */
#endif /* CK_RESEND */
	)
      return(doxsend(cx));

/* ADD, PSEND, and REMOVE use special parsing */

    if (cx == XXADD || cx == XXREMV	/* ADD or REMOVE */
#ifdef CK_RESEND
	|| cx == XXPSEN			/* PSEND */
#endif /* CK_RESEND */
	) {
#ifdef CK_RESEND
	int seekto = 0;
	/* int filemode = XYFT_B; (not used) */
#endif /* CK_RESEND */

#ifdef ADDCMD
#ifndef NOMSEND
	char * fmode = "";
	int xmode = 0;
#endif /* NOMSEND */
	if (cx == XXADD || cx == XXREMV) {
	    if ((x = cmkey(addtab,
			   naddtab,"Name of list","send-list",xxstring)) < 0)
	      return(x);
	    if (x != ADD_SND)
	      return(doadd(cx,x));
	    if (cx == XXREMV) {
		printf("?Sorry, not implemented yet.\n");
		return(-9);
	    }
#ifndef NOMSEND
#ifndef XYZ_INTERNAL
	    if (protocol != PROTO_K) {
		printf(
		"?Sorry, ADD SEND-LIST does not work with external protocols\n"
		       );
		return(-9);
	    }
#endif /* XYZ_INTERNAL */
#endif /* NOMSEND */
	}
#endif /* ADDCMD */

#ifdef PIPESEND
	if (protocol != PROTO_K && cx == XXCSEN) {
	    printf("?Sorry, CSEND works only with Kermit protocol\n");
	    return(-9);
	}
#endif /* PIPESEND */

#ifdef CK_RESEND
	if (cx == XXRSEN && binary != XYFT_B
#ifdef VMS
	    && binary != XYFT_I
#endif /* VMS */
	    ) {
	    printf(
#ifdef VMS
		   "?Sorry, FILE TYPE must be BINARY\n"
#else
		   "?Sorry, FILE TYPE must be BINARY or IMAGE\n"
#endif /* VMS */
		   );
	    return(-9);
	}
#ifdef PIPESEND
	if (cx == XXRSEN || cx == XXPSEN) {
	    if (sndfilter) {
		printf(
"?Sorry, no RESEND or PSEND while SEND FILTER selected\n"
		       );
		return(-9);
	    }
	}
#endif /* PIPESEND */

#ifdef CK_XYZ
	if (cx == XXRSEN) {
	    if (protocol != PROTO_K && protocol != PROTO_Z) {
		printf(
"Sorry, RESEND is possible only with Kermit or ZMODEM protocol\n"
		       );
		return(-9);
		
	    }
	}
#endif /* CK_XYZ */
#endif /* CK_RESEND */
	if ((cx == XXMAI		/* MAIL */
#ifdef CK_RESEND
	     || cx == XXRSEN		/* RESEND */
#endif /* CK_RESEND */
	     ) &&
	    (!atdiso || !atcapr)) {	/* Disposition attribute off? */
	    printf("?Sorry, ATTRIBUTE DISPOSITION must be ON\n");
	    return(-9);
	}
	cmarg = cmarg2 = "";
	y = 0;
	x =
#ifdef PIPESEND
	  (cx == XXCSEN) ?
	    cmfld("Command","",&s,xxstring) :
#endif /* PIPESEND */
	      cmifi(
#ifdef CK_XYZ
		    (protocol == PROTO_X || protocol == PROTO_XC)
#else
		    1
#endif /* CK_XYZ */
		    ?
		    "File to send" :
		    "File(s) to send",
                    "",
		    &s,
		    &y,
		    xxstring
		    );
	if (x < 0) {
	    if (x == -3) {
#ifndef NOMSEND
		if (filehead) {	/* SEND by itself with ADD list? */
		    nfils = filesinlist;
		    sndsrc = nfils;	/* Like MSEND */
		    addlist = 1;	/* But using a different list... */
		    filenext = filehead;
		    if (cx == XXMOVE)
		      moving = 1;
		    sstate = 's';
		    goto sendend;
		} else {		/* Oops, no list. */
		    printf("?No send list - use ADD to make one.\n");
		    return(-9);
		}
#else
		printf("?A file specification is required\n");
		return(-9);
#endif /* NOMSEND */
	    } else return(x);
	}
#ifdef PIPESEND
	if (cx == XXCSEN) {		/* CSEND - strip any braces */
	    debug(F110,"CSEND before stripping",s,0);
	    if (*s == '{') {		/* from around the command */
		int n;
		if ((n = strlen(s)) > 0) {
		    if (s[n-1] == '}') {
			s[n-1] = NUL;
			s++;
		    }
		}
	    }
	    debug(F110,"CSEND after stripping",s,0);
	    if (!*s) {
		printf("?Sorry, a command to send from is required\n");
		return(-9);
	    }
	}
#endif /* PIPESEND */

#ifdef CK_XYZ
	if (y != 0 && (protocol == PROTO_X || protocol == PROTO_XC)) {
	    printf(
"Sorry, you can only send one file at a time with XMODEM protocol\n"
		   );
	    return(-9);
	}
#endif /* CK_XYZ */

	nfils = -1;			/* Files come from internal list. */
#ifndef NOMSEND
        addlist = 0;			/* Don't use SEND-LIST. */
        filenext = NULL;
#endif /* NOMSEND */
	strcpy(line,s);			/* Save copy of string just parsed. */
	debug(F110,"send line",line,0);
#ifndef NOMSEND
	if (cx == XXADD) {
	    if (filesinlist == 0)	/* Take care of \v(filespec) */
	      fspec[0] = NUL;
#ifdef ZFNQFP
	    zfnqfp(s,TMPBUFSIZ,tmpbuf);
	    s = tmpbuf;
#endif /* ZFNQFP */
	    if (((int)strlen(fspec) + (int)strlen(s) + 1) < CKMAXPATH) {
		strcat(fspec,s);
		strcat(fspec," ");
	    } else printf("WARNING - \\v(filespec) buffer overflow\n");
	} else
#endif /* NOMSEND */
#ifdef ZFNQFP
	  zfnqfp(s,CKMAXPATH,fspec);
#else
	  strncpy(fspec,s,CKMAXPATH);
#endif /* ZFNQFP */

#ifdef CK_RESEND
	if (cx == XXPSEN) {		/* PSEND */
	    if (y != 0) {
		printf("?Sorry, wildcards not permitted in this command\n");
		return(-9);
	    }
	    if (sizeof(int) < 4) {
		printf("?Sorry, this command needs 32-bit integers\n");
		return(-9);
	    }
#ifdef CK_XYZ
	    if (protocol != PROTO_K) {
		printf("?Sorry, PSEND works only with Kermit protocol\n");
		return(-9);
	    }
#endif /* CK_XYZ */
	    x = cmnum("starting position (byte number)",
		      "",10,&seekto,xxstring);
	    if (x < 0)
	      return(x);
	}
#endif /* CK_RESEND */
#ifndef NOMSEND
	if (cx == XXADD) {
	    extern struct keytab fttab[];
	    extern int nfttyp;

	    fmode = gfmode(binary,0);
	    if ((x = cmkey(fttab,nfttyp,
		       "type of file transfer", fmode, xxstring)) < 0)
	      return(x);
	    xmode = x;
	}
#endif /* NOMSEND */
	if (cx == XXSEN			/* SEND command */
	    || cx == XXMOVE		/* MOVE command */
	    || cx == XXADD		/* ADD command */
#ifdef PIPESEND
	    || cx == XXCSEN		/* CSEND */
#endif /* PIPESEND */
#ifdef CK_RESEND
	    || cx == XXRSEN || cx == XXPSEN /* RESEND or PSEND command */
#endif /* CK_RESEND */
	    ) {
	    debug(F101,"Send: wild","",y);
#ifdef NOSPL
/*
  This is the original code from Day One in which an as-name was not
  allowed if the filespec was wild.  This code is still used in NOSPL builds.
*/
	    if (y == 0) {
		if ((x = cmtxt("Name to send it with","",&cmarg2,NULL)) < 0)
		  return(x);
	    } else {
		if ((x = cmcfm()) < 0) return(x);
	    }
#else
/*
  Now (6.1.193) as-names are allowed even with file groups,
  but only if they contain replacement variables like \v(filename).
*/
	    if ((x = cmtxt(y ?
  "\nAs-name template containing replacement variables such as \\v(filename)" :
  "Name to send it with", "",&cmarg2,NULL)) < 0)
	      return(x);
	    if (y && *cmarg2) {
		char * s = tmpbuf;
		x = TMPBUFSIZ;
		zzstring(cmarg2,&s,&x);
		if (!strcmp(tmpbuf,cmarg2)) {
		    printf(
  "?As-name for file group must contain variables such as \\v(filename)\n"
			   );
		    return(-9);
		}
	    }
#endif /* NOSPL */
	    debug(F110,"cmarg2 before stripping",cmarg2,0);
#ifdef PIPESEND
	    if (cx == XXCSEN) {
		if (nopush) {
		    printf("?Sorry, system command access is disabled\n");
		    return(-9);
		} else if (sndfilter) {
		    printf("?Sorry, can't CSEND while SEND FILTER selected\n");
		    return(-9);
		}
		pipesend = 1;
		debug(F101,"CSEND pipesend","",pipesend);
	    }
/* NOTE: The following was added not only for CSEND but also for SEND... */
#endif /* PIPESEND */
	    cmarg2 = brstrip(cmarg2);	/* Strip braces */
	    cmarg = line;		/* File to send */
	    debug(F110,"SEND filename",cmarg,0);
	    debug(F110,"SEND as-name",cmarg2,0);
	} else {			/* MAIL */
#ifndef NOFRILLS
#ifdef CK_XYZ
	    if (protocol != PROTO_K) {
		printf("Sorry, MAIL can be sent using only Kermit protocol\n");
		return(-9);
	    }
#endif /* CK_XYZ */
	    if (!atdiso || !atcapr) {	/* Disposition attribute off? */
		printf("?Disposition Attribute is Off\n");
		return(-9);
	    }
	    debug(F101,"Mail: wild","",y);
	    *optbuf = NUL;		/* Wipe out any old options */
	    if ((x = cmtxt("Address to mail to","",&s,xxstring)) < 0)
	      return(x);
	    if ((int)strlen(s) == 0) {
		printf("?Address required\n");
		return(-9);
	    }
	    strcpy(optbuf,s);
	    if ((int)strlen(optbuf) > 94) { /* Ensure legal size */
		printf("?Option string too long\n");
		return(-9);
	    }
	    cmarg = line;		/* File to send */
	    debug(F110,"Mailing:",cmarg,0);
	    debug(F110,"To:",optbuf,0);
	    rmailf = 1;			/* MAIL modifier flag for SEND */
#else
	    printf("?Sorry, MAIL feature not configured.\n");
	    return(-9);
#endif /* NOFRILLS */
	}
#ifdef CK_RESEND
	if (cx == XXPSEN)		/* Partial-send starting position */
	  sendstart = seekto;
	else
	  sendstart = 0L;
#endif /* CK_RESEND */
	if (cx == XXMOVE)
	  moving = 1;
#ifndef NOMSEND
	if (cx != XXADD) {		/* Not ADD, really sending... */
#endif /* NOMSEND */
	    sstate = 's';		/* Set start state to SEND */
#ifndef NOMSEND
	    addlist = 0;
	    filenext = NULL;
	} else {			/* Just ADDing... */
	    struct filelist * flp;
	    flp = (struct filelist *) malloc(sizeof(struct filelist));
	    if (flp) {
		if (filetail)
		  filetail->fl_next = flp;
		filetail = flp;
		if (!filehead)
		  filehead = flp;
		x = (int) strlen(line);	/* Length of filename */
		s = (char *) malloc(x + 1);
		if (s) {
		    strcpy(s,line);
		    flp->fl_name = s;
		    flp->fl_mode = xmode;
		    x = (int) strlen(cmarg2); /* Length of as-name */
		    if (x < 1) {
			flp->fl_alias = NULL;
		    } else {
			s = (char *) malloc(x + 1);
			if (s) {
			    strcpy(s,cmarg2);
			    flp->fl_alias = s;
			} else {
			    printf("Sorry, can't allocate space for as-name");
			    return(-9);
			}
		    }
		    flp->fl_next = NULL;
		    filesinlist++;	/* Count this node */
		    return(0);		/* Finished adding this node */
		} else {
		    printf("Sorry, can't allocate space for name");
		    return(-9);
		}
	    } else {
		printf("Sorry, can't allocate file list node");
		return(-9);
	    }
	}
#endif /* NOMSEND */
sendend:

#ifdef CK_RESEND
	switch (cx) {
	  case XXRSEN: sendmode = SM_RESEND; break;
	  case XXPSEN: sendmode = SM_PSEND;  break;
	  case XXSEN:
	  default:     sendmode = SM_SEND;   break;
	}
#else
	sendmode = SM_SEND;
#endif /* CK_RESEND */
#ifdef MAC
	what = W_SEND;
	scrcreate();
#endif /* MAC */
	if (local) {			/* If in local mode, */
	    displa = 1;			/* turn on file transfer display */
	}
	return(0);
    }

#ifndef NOMSEND
    if (cx == XXMSE || cx == XXMMOVE) {
#ifdef CK_XYZ
	if (protocol == PROTO_X || protocol == PROTO_XC) {
	    printf(
"Sorry, you can only send one file at a time with XMODEM protocol\n"
		   );
	    return(-9);
	}
#endif /* CK_XYZ */
        return(doxsend(cx));
    }

#ifdef COMMENT				/* (moved to doxsend) */
    if (cx == XXMSE || cx == XXMMOVE) {	/* MSEND and MMOVE commands */
	nfils = 0;			/* Like getting a list of */
	lp = line;			/* files on the command line */
	addlist = 0;			/* Do not use SEND-LIST */
	filenext = NULL;		/* Ditto ! */

	while (1) {
	    char *p;
	    if ((x = cmifi("Names of files to send, separated by spaces","",
			   &s,&y,xxstring)) < 0) {
		if (x == -3) {
		    if (nfils <= 0) {
			printf("?A file specification is required\n");
			return(-9);
		    } else break;
		}
		return(x);
	    }
	    msfiles[nfils++] = lp;	/* Got one, count it, point to it, */
	    p = lp;			/* remember pointer, */
	    while (*lp++ = *s++)	/* and copy it into buffer */
	      if (lp > (line + LINBUFSIZ)) { /* Avoid memory leak */
		  printf("?MSEND list too long\n");
		  line[0] = NUL;
		  return(-9);
	      }
	    debug(F111,"msfiles",msfiles[nfils-1],nfils-1);
	    if (nfils == 1) *fspec = NUL; /* Take care of \v(filespec) */
#ifdef ZFNQFP
	    zfnqfp(p,TMPBUFSIZ,tmpbuf);
	    p = tmpbuf;
#endif /* ZFNQFP */
	    if (((int)strlen(fspec) + (int)strlen(p) + 1) < CKMAXPATH) {
		strcat(fspec,p);
		strcat(fspec," ");
	    } else printf("WARNING - \\v(filespec) buffer overflow\n");
	}
	cmlist = msfiles;		/* Point cmlist to pointer array */
	cmarg2 = "";			/* No internal expansion list (yet) */
	sndsrc = nfils;			/* Filenames come from cmlist */
	sendmode = SM_MSEND;		/* Remember this kind of SENDing */
	sstate = 's';			/* Set start state for SEND */
	if (cx == XXMMOVE)		/* If MMOVE'ing, */
	  moving = 1;			/*  set this flag. */
#ifdef MAC
	what = W_SEND;
	scrcreate();
#endif /* MAC */
	if (local) {			/* If in local mode, */
	    displa = 1;			/* turn on file transfer display */
	    ttflui();			/* and flush tty input buffer. */
	}
	return(0);
    }
#endif /* COMMENT */
#endif /* NOMSEND */

#ifndef NOSERVER
    if (cx == XXSER) {			/* SERVER */
#ifdef CK_XYZ
	if (protocol != PROTO_K) {
	    printf("Sorry, SERVER only works with Kermit protocol\n");
	    return(-9);
	}
#endif /* CK_XYZ */
#ifdef COMMENT
/*
  Parse for time limit, but since we don't use it yet,
  the parsing is commented out.
*/
	x_ifnum = 1;			/* Turn off internal complaints */
	y = cmnum("optional time limit, seconds, or time of day as hh:mm:ss",
		  "0", 10, &x, xxstring
		  );
	x_ifnum = 0;
	if (y < 0) {
	    if (y == -2) {		/* Invalid number or expression */
		zz = tod2sec(atmbuf);	/* Convert to secs since midnight */
		if (zz < 0L) {
		    printf("?Number, expression, or time of day required\n");
		    return(-9);
		} else {
		    char now[32];	/* Current time */
		    char *p;
		    long tnow;
		    p = now;
		    ztime(&p);
		    tnow = atol(p+11) * 3600L + atol(p+14) * 60L + atol(p+17);
		    if (zz < tnow)	/* User's time before now */
		      zz += 86400L;	/* So make it tomorrow */
		    zz -= tnow;		/* Seconds from now. */
		}
	    } else
	      return(y);
	}
	if (zz > -1L) {
	    x = zz;
	    if (zz != (long) x) {
		printf(
"Sorry, arithmetic overflow - hh:mm:ss not usable on this platform.\n"
		       );
		return(-9);
	    }
	}
	if (x < 0)
	  x = 0;
#endif /* COMMENT */

	if ((x = cmcfm()) < 0) return(x);
	sstate = 'x';
#ifdef MAC
	what = W_RECV;
	scrcreate();
#endif /* MAC */
	if (local) displa = 1;
#ifdef AMIGA
	reqoff();			/* No DOS requestors while server */
#endif /* AMIGA */
    return(0);
    }
#endif /* NOSERVER */

    if (cx == XXSAVE) {			/* SAVE command */
	x = cmkey(savtab,nsav,"option","keymap",xxstring);
	if (x == -3) {
	    printf("?You must specify an option to save\n");
	    return(-9);
	}
	if (x < 0) return(x);
	/* have to set success separately for each item in doprm()... */
	/* actually not really, could have just had doprm return 0 or 1 */
	/* and set success here... */
	y = dosave(x);
	if (y == -3) {
	    printf("?More fields required\n");
	    return(-9);
	} else return(y);
    }

    if (cx == XXSET) {			/* SET command */
	x = cmkey(prmtab,nprm,"Parameter","",xxstring);
	if (x == -3) {
	    printf("?You must specify a parameter to set\n");
	    return(-9);
	}
	if (x < 0) return(x);
	/* have to set success separately for each item in doprm()... */
	/* actually not really, could have just had doprm return 0 or 1 */
	/* and set success here... */
	y = doprm(x,0);
	if (y == -3) {
	    printf("?More fields required\n");
	    return(-9);
	} else return(y);
    }

#ifndef NOPUSH
    if (cx == XXSHE) {			/* SHELL (system) command */
        extern int nopush;
#ifndef COMMENT
	int i,n;
/*
  The old way was simple -- just parse a text string.  But in Windows this
  requires users to type double backslashes in pathnames.  We're keeping the
  old way because there is no way to do this right for every conceivable
  command (and filenames as operands!) on every platform, etc.
*/
	if (cmtxt("System command to execute","",&s,xxstring) < 0)
	  return(-1);
#else
/*
  EXPERIMENTAL CODE, NOT USED:
  Try to parse a filename in the PATH, using a special call to cmifi2() that
  does not result in error messages if there is no match.  But if a regular
  DOS-format filespec is given for an existing program or batch file
  (i.e. using single backslash as the directory separator), it should be
  accepted.
*/
	n = strlen(cmdbuf);
	debug(F111,"RUN cmdbuf",cmdbuf,n);
	i = 0;
	while (cmdbuf[i] == SP) i++;
	if (cmdbuf[i] == '!' || cmdbuf[i] == '@') {
	    i++;
	    while (cmdbuf[i] == SP) i++;
	    n = i;
	}
	y = cmifi2(
		   "Program or command to execute", /* Help */
		   "",			/* Default */
		   &s,			/* Pointer to result */
		   &x,			/* Wild flag */
		   1,			/* Suppress error messages */
		   getenv("PATH"),	/* Look in PATH */
		   xxstring,		/* Do processing */
		   0			/* Parse filenames not directories */
		   );
	debug(F101,"RUN cmifi2","",y);
	if (y < 0 && y != -2)		/* If no files match, stay here. */
	  return(y);
	i = n;
	while (cmdbuf[i] == SP) i++;	/* Strip leading spaces again */
	strcpy(tmpbuf,(char *)(cmdbuf+i)); /* Copy command name */
	if (cmtxt("Operands for the command","",&s,xxstring) < 0)
	  return(-1);
	sprintf(line,"%s %s",tmpbuf,s);	/* Build full command. */
	s = line;
	debug(F110,"RUN command",s,0);
/*
  Conceivably, we could continue the process for every "word" in the RUN
  command...
*/
#endif /* COMMENT */
       
        if (nopush)
          return(success = 0);
#ifdef CK_APC
	if (apcactive == APC_REMOTE && apcstatus != APC_UNCH)
	  return(success = 0);
#endif /* CK_APC */
	conres();			/* Make console normal  */
#ifdef OS2
	if (!(s && *s)) {
	    os2push();
	    x = 1;
	} else 
#endif /* OS2 */
	x = zshcmd(s);
	debug(F101,"RUN zshcmd code","",x);
	concb((char)escape);
	return(success = x);
    }
#ifdef CK_REDIR
    if (cx == XXFUN) {			/* REDIRECT */
        extern int nopush;

        if (nopush) {
            printf("?REDIRECT disabled\n");
            return(success=0);
        }
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH) return(success = 0);
#endif /* CK_APC */
	if (!local) {
	    printf("?SET LINE or SET HOST required first\n");
	    return(-9);
	}
	sprintf(tmpbuf,
		"Local command to run,\n\
with its standard input/output redirected to %s\n",
		ttname);
	if ((x = cmtxt(tmpbuf,"",&s,xxstring)) < 0)
	  return(x);
	return(success = ttruncmd(s));
    }
#endif /* CK_REDIR */
#endif /* NOPUSH */

#ifndef NOSHOW
    if (cx == XXSHO) {			/* SHOW */
	x = cmkey(shotab,nsho,"","parameters",xxstring);
	if (x < 0) return(x);
	return(doshow(x));
    }
#endif /* NOSHOW */

#ifndef MAC
    if (cx == XXSPA) {			/* SPACE */
#ifdef datageneral
	/* AOS/VS can take an argument after its "space" command. */
	if ((x = cmtxt("Confirm, or local directory name","",&s,xxstring)) < 0)
	  return(x);
	if (*s == NUL) {
	    xsystem(SPACMD);
	} else {
	    sprintf(line,"space %s",s);
	    xsystem(line);
	}
#else
#ifdef OS2
	if ((x = cmtxt("Press Enter for current disk,\n\
 or specify a disk letter like A:","",&s,xxstring)) < 0)
	  return(x);
	if (*s == NUL) {		/* Current disk */
	    printf(" Free space: %ldK\n", zdskspace(0)/1024L);
	} else {
	    int drive = toupper(*s);
	    printf(" Drive %c: %ldK free\n", drive,
		   zdskspace(drive - 'A' + 1) / 1024L);
	}
#else
#ifdef OSK
#define UNIX
#endif /* OSK */
#ifdef UNIX
#ifdef COMMENT
	if ((x = cmtxt("Confirm for current disk,\n\
 or specify a disk device or directory","",&s,xxstring)) < 0)
	  return(x);
#else
	x = cmdir("Confirm for current disk,\n\
 or specify a disk device or directory","",&s,xxstring);
	if (x == -3)
	  s = "";
	else if (x < 0)
	  return(x);
	if ((x = cmcfm()) < 0) return(x);
#endif /* COMMENT */
	if (*s == NUL) {		/* Current disk */
	    xsystem(SPACMD);
	} else {			/* Specified disk */
	    sprintf(line,"%s %s",SPACM2,s);
	    xsystem(line);
	}
#ifdef OSK
#undef UNIX
#endif /* OSK */
#else
	if ((x = cmcfm()) < 0) return(x);
	xsystem(SPACMD);
#endif /* UNIX */
#endif /* OS2 */
#endif /* datageneral */
	return(success = 1);		/* Pretend it worked */
    }
#endif /* MAC */

    if (cx == XXSTA) {			/* STATISTICS */
	if ((x = cmkey(stattab,2,"Carriage return, or option",
		       "/brief",xxstring)) < 0)
	  return(x);
	if ((y = cmcfm()) < 0) return(y);
	return(success = dostat(x));
    }

    if (cx == XXSTO || cx == XXEND) {	/* STOP, END, or POP */
	if ((y = cmnum("exit status code","0",10,&x,xxstring)) < 0)
	  return(y);
	if ((y = cmtxt("Message to print","",&s,xxstring)) < 0)
	  return(y);
	s = brstrip(s);
	if (*s) printf("%s\n",s);
	if (cx == XXSTO) {
	    dostop();
	} else {
#ifndef NOSPL
	    /* Pop from all FOR/WHILE/XIF/SWITCH's */
	    debug(F101,"END maclvl 1","",maclvl);
	    while ((maclvl > 0) &&
		   (m_arg[maclvl-1][0]) &&
		   (cmdstk[cmdlvl].src == CMD_MD) &&
		     (!strncmp(m_arg[maclvl-1][0],"_xif",4) ||
		      !strncmp(m_arg[maclvl-1][0],"_for",4) ||
		      !strncmp(m_arg[maclvl-1][0],"_whi",4) ||
		      !strncmp(m_arg[maclvl-1][0],"_swi",4))) {
		debug(F110,"END popping",m_arg[maclvl-1][0],0);
		dogta(XXPTA);		/* Put args back */
		popclvl();		/* Pop up two levels */
		popclvl();
		debug(F101,"END maclvl 2","",maclvl);
	    }
#endif /* NOSPL */
	    popclvl();			/* Now pop out of macro or TAKE file */
#ifndef NOSPL
	    debug(F101,"END maclvl 3","",maclvl);
#endif /* NOSPL */
	}
	return(success = (x == 0));
    }

    if (cx == XXSUS) {			/* SUSPEND */
	if ((y = cmcfm()) < 0) return(y);
#ifdef NOJC
	printf("Sorry, this version of Kermit cannot be suspended\n");
#else
	stptrap(0);
#endif /* NOJC */
	return(0);
    }

    if (cx == XXTAK) {			/* TAKE */
#ifdef OS2
	extern char startupdir[],exedir[],inidir[];
	char * scriptenv, * keymapenv;
#endif /* OS2 */
	char takepath[1024];

	if (tlevel >= MAXTAKE-1) {
	    printf("?Take files nested too deeply\n");
	    return(-9);
	}
#ifdef OS2    
#ifdef NT
	scriptenv = getenv("K95SCRIPTS");
	keymapenv = getenv("K95KEYMAPS");
#else /* NT */
	scriptenv = getenv("K2SCRIPTS");
	keymapenv = getenv("K2KEYMAPS");
#endif /* NT */
	if (!scriptenv)
	  scriptenv = getenv("CK_SCRIPTS");
	if (!keymapenv)
	  keymapenv = getenv("CK_KEYMAPS");

	sprintf(takepath,
                /* semicolon-separated path list */
                "%s%s%s%s%s;%s%s;%s%s;%s;%s%s;%s%s;%s;%s%s;%s%s", 
                scriptenv?scriptenv:"",
                (scriptenv && scriptenv[strlen(scriptenv)-1]==';')?"":";",
                keymapenv?keymapenv:"",
                (keymapenv && keymapenv[strlen(keymapenv)-1]==';')?"":";",
                startupdir,
                startupdir, "SCRIPTS/",    
                startupdir, "KEYMAPS/",
                inidir,
                inidir, "SCRIPTS/",
                inidir, "KEYMAPS/",
                zhome(),
                zhome(), "SCRIPTS/",
                zhome(), "KEYMAPS/",
                exedir,
                exedir, "SCRIPTS/",
                exedir, "KEYMAPS/"
                );
#else /* not OS2 */
	y = 1024;
	s = takepath;
	zzstring("\\v(home)",&s,&y);
#endif /* OS2 */

	if ((y = cmifip("C-Kermit command file",
			"",&s,&x,0,takepath,xxstring)) < 0) {
	    if (y == -3) {
		printf("?A file name is required\n");
		return(-9);
	    } else
	      return(y);
	}
	if (x != 0) {
	    printf("?Wildcards not allowed in command file name\n");
	    return(-9);
	}
	strcpy(line,s);
	if ((y = cmcfm()) < 0) return(y);
	return(success = dotake(line));
    }

#ifdef OS2
    if (cx == XXVIEW) {			/* VIEW Only Terminal mode */
	viewonly = TRUE;
	success = doconect(0);
	viewonly = FALSE;
	return success;
    }
#endif /* OS2 */

#ifdef NETCONN
    if (cx == XXTEL) {			/* TELNET */
	int x,z;
#ifdef OS2
    if (!tcp_avail) {
        printf("?Sorry, either TCP/IP is not available on this system or\n\
necessary DLLs did not load.  Use SHOW NETWORK to check network status.\n");
        success = 0;
        return(-9);
    } else
#endif /* OS2 */
      {
	  x = nettype;			/* Save net type in case of failure */
	  z = ttnproto;			/* Save protocol in case of failure */
	  nettype = NET_TCPB;
	  ttnproto = NP_TELNET;
	  if ((y = setlin(XYHOST,0,1)) < 0) {
              nettype = x;		/* Failed, restore net type. */
              ttnproto = z;		/* and protocol */
              success = 0;
           }
        }
	return(y);
    }

#ifdef NETCMD
    if (cx == XXPIPE) {			/* PIPE */
	int x;
	extern int netsave;
	x = nettype;			/* Save net type in case of failure */
	nettype = NET_CMD;
	if ((y = setlin(XYHOST,0,1)) < 0) {
	    nettype = x;		/* Failed, restore net type. */
	    ttnproto = z;		/* and protocol */
	    success = 0;
	}
	netsave = x;
	return(y);
    }
#endif /* NETCMD */

    if (cx == XXRLOG) {			/* RLOGIN */
#ifdef RLOGCODE
	int x,z;
#ifdef OS2
	if ( !tcp_avail ) {
	    printf("?Sorry, either TCP/IP is not available on this system or\n\
necessary DLLs did not load.  Use SHOW NETWORK to check network status.\n"
		   );
	    success = 0;
	    return(-9);
	} else {
#endif /* OS2 */
	    x = nettype;		/* Save net type in case of failure */
	    z = ttnproto;		/* Save protocol in case of failure */
	    nettype = NET_TCPB;
	    ttnproto = NP_RLOGIN;
	    if ((y = setlin(XYHOST,0,1)) < 0) {
		nettype = x;		/* Failed, restore net type. */
		ttnproto = z;		/* and protocol */
		success = 0;
#ifdef COMMENT
#ifdef UNIX
		printf("Hint: The RLOGIN port is privileged in UNIX.\n");
#else
#ifdef VMS
		printf("Hint: The RLOGIN port is privileged in VMS.\n");
#endif /* VMS */
#endif /* UNIX */
#endif /* COMMENT */
	    }
#ifdef OS2	    
	}
#endif /* OS2 */
	return(y);
#else
	printf("?Sorry, RLOGIN is not configured in this copy of C-Kermit.\n");
	return(-9);
#endif /* RLOGCODE */
    }
#endif /* NETCONN */

#ifndef NOXMIT
    if (cx == XXTRA) {			/* TRANSMIT */
	if ((x = cmifi("File to transmit","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?Only a single file may be transmitted\n");
	    return(-9);
	}
	strcpy(line,s);			/* Save copy of string just parsed. */
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */
#ifdef CK_APC
	if (apcactive == APC_LOCAL || 
        apcactive == APC_REMOTE && apcstatus != APC_UNCH) return(success = 0);
#endif /* CK_APC */
	debug(F111,"calling transmit",line,xmitp);
	return(success = transmit(line,(char)xmitp)); /* Do the command */
    }
#endif /* NOXMIT */

#ifndef NOFRILLS
    if (cx == XXTYP) {			/* TYPE */
	if ((x = cmifi("File to type","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?A single file please\n");
	    return(-9);
	}
	strcpy(line,s);
	if ((y = cmcfm()) < 0)		/* Confirm the command */
	  return(y);

	debug(F110,"TYPE",line,0);
	return(success = dotype(line));
    }
#endif /* NOFRILLS */

#ifndef NOCSETS
    if (cx == XXXLA)  {	   /* TRANSLATE <ifn> from-cs to-cs <ofn> */
	int incs, outcs;
	if ((x = cmifi("File to translate","",&s,&y,xxstring)) < 0) {
	    if (x == -3) {
		printf("?Name of an existing file\n");
		return(-9);
	    } else return(x);
	}
	if (y != 0) {
	    printf("?A single file please\n");
	    return(-9);
	}
	strcpy(line,s);			/* Save copy of string just parsed. */

	if ((incs = cmkey(fcstab,nfilc,"from character-set","",xxstring)) < 0)
	  return(incs);
	if ((outcs = cmkey(fcstab,nfilc,"to character-set","",xxstring)) < 0)
	  return(outcs);
	if ((x = cmofi("output file",CTTNAM,&s,xxstring)) < 0) return(x);
	if (x > 1) {
	    printf("?Directory name not allowed\n");
	    return(-9);
	}
	strncpy(tmpbuf,s,TMPBUFSIZ);
	if ((y = cmcfm()) < 0) return(y); /* Confirm the command */
	return(success = xlate(line,tmpbuf,incs,outcs)); /* Execute it */
    }
#endif /* NOCSETS */

    if (cx == XXVER) {			/* VERSION */
	extern char * ck_patch, * ck_s_test;
	if ((y = cmcfm()) < 0) 
          return(y);

	printf("\n%s, for%s\n Numeric: %ld",versio,ckxsys,vernum);
	printf("\n");
	if (*ck_s_test)
	  printf("\n THIS IS A TEST VERSION, NOT FOR PRODUCTION USE.\n\n");
	if (*ck_patch)
	  printf(" Patches: %s\n", ck_patch);
	printf(" Type COPYRIGHT for copyright information.\n\n");

#ifdef OS2
	shoreg();
#endif /* OS2 */

	return(success = 1);
    }

    if (cx == XXCPR) {			/* COPYRIGHT */
	if ((y = cmcfm()) < 0) 
          return(y);
	hmsga(copyright);
	return(success = 1);
    }

#ifndef MAC				/* Only for multiuser systems */
#ifndef NOFRILLS
    if (cx == XXWHO) {			/* WHO */
	char *wc;
#ifdef datageneral
        xsystem(WHOCMD);
#else
	if ((y = cmtxt("user name","",&s,xxstring)) < 0) return(y);
	if (!(wc = getenv("CK_WHO"))) wc = WHOCMD;
	if (wc)
	  if ((int) strlen(wc) > 0) {
	      sprintf(line,"%s %s",wc,s);
	      xsystem(line);
	  }
#endif /* datageneral */
	return(success = 1);
    }
#endif /* NOFRILLS */
#endif /* MAC */

#ifndef NOFRILLS
    if (cx == XXWRI || cx == XXWRL || cx == XXWRBL) { /* WRITE */
#ifdef BINREAD
	if (cx == XXWRBL) {
	    extern CHAR * readbuf;
	    extern int readsize;
	    if ((y = cmcfm()) < 0) return(y);
	    y = zsoutx(ZWFILE, readbuf, readsize);
	    printf("WRITEBLOCK = %d\n",y);
	    return(y);
	}	    
#endif /* BINREAD */
	if ((x = cmkey(writab,nwri,"to file or log","",xxstring)) < 0) {
	    if (x == -3) printf("?Write to what?\n");
	    return(x);
	}
	if ((y = cmtxt("text","",&s,xxstring)) < 0) return(y);
	s = brstrip(s);
	switch (x) {
	  case LOGD: y = ZDFILE; break;
	  case LOGP: y = ZPFILE; break;
#ifndef NOLOCAL
	  case LOGS: y = ZSFILE; break;
#endif /* NOLOCAL */
	  case LOGT: y = ZTFILE; break;
#ifndef NOSPL
	  case LOGW: y = ZWFILE; break;
#endif /* NOSPL */
	  case LOGX:
	  case LOGE:

#ifndef MAC
	    if (x == LOGE) fprintf(stderr,"%s",s);
	    else
#endif /* MAC */
	      printf("%s",s);
	    if (!cmdsrc())
#ifndef MAC
	      if (x == LOGE) fprintf(stderr,"\n");
	      else
#endif /* MAC */
		printf("\n");
	    return(success = 1);
	  default: return(-2);
	}
	if (chkfn(y) > 0) {
	    x = (cx == XXWRI) ? zsout(y,s) : zsoutl(y,s);
	    if (x < 0) printf("?Write error\n");
	} else {
	    x = -1;
	    printf("?File or log not open\n");
	}
	return(success = (x == 0) ? 1 : 0);
    }
#endif /* NOFRILLS */

    if (cx == XXASC || cx == XXBIN) {
	if ((x = cmcfm()) < 0) return(x);
	binary = (cx == XXASC) ? XYFT_T : XYFT_B;
	return(success = 1);
    }
#ifdef OS2
    if (cx == XXCLS) {
	if ((x = cmcfm()) < 0) return(x);	
	clear();
	return(success = 1);
    }
#endif /* OS2 */

#ifdef CK_MKDIR
    if (cx == XXMKDIR) {
	char *p;
	if ((x = cmfld("Name for new directory","",&s,xxstring)) < 0) {
	    if (x != -3) {
		return(x);
	    } else {
		printf("?Directory name required\n");
		return(-9);
	    }
	}
	strcpy(line,s);
	s = line;
	if ((x = cmcfm()) < 0) return(x);
	s = brstrip(s);
	x = ckmkdir(0,s,&p,msgflg,0);
	if (msgflg && x == 0)
	  printf("?Directory already exists\n");
	return(success = (x < 0) ? 0 : 1);
    }
    if (cx == XXRMDIR) {		/* RMDIR */
	char *p;
	if ((x = cmdir("Name of directory to be removed","",&s,xxstring)) < 0)
	  return(x);
	strcpy(line,s);
	s = line;
	if ((x = cmcfm()) < 0) return(x);
	s = brstrip(s);
	x = ckmkdir(1,s,&p,msgflg,0);
	return(success = (x < 0) ? 0 : 1);
    }
#endif /* CK_MKDIR */
                                            
#ifdef TCPSOCKET
    if (cx == XXTELOP) {
        if ((x = cmkey( telcmd, 4, "TELNET command", "", xxstring)) < 0 )
	  return(x);
        if ((y = cmkey( tnopts, ntnopts, "TELNET option", "", xxstring)) < 0 )
	  return(y);	
	if ((z = cmcfm()) < 0) return(z);
	if (local) {
	    return((tn_sopt(x,y) > -1) ? 1 : 0);
	} else {
	    printf("ff%02x%02x\n",x,y);
	    return(0);
	}
    }
#endif /* TCPSOCKET */

#ifndef NOPUSH
    if (cx == XXNPSH) {
        extern int nopush;
#ifndef NOSERVER
	extern int en_hos;
#endif /* NOSERVER */
	if ((z = cmcfm()) < 0) return(z);
        nopush = 1;
#ifndef NOSERVER
        en_hos = 0;
#endif /* NOSERVER */
#ifdef PIPESEND
	usepipes = 0;
#endif /* PIPESEND */
        return(success = 1);
    }
#endif /* NOPUSH */

#ifndef NOSPL
    if (cx == XXLOCAL)			/* LOCAL variable declarations */
      return(success = dolocal());
#endif /* NOSPL */

    if (cx == XXKERMI) {
	char * list[64];
	extern char **xargv;
	extern int xargc;
	int i;
	if ((y = cmtxt("kermit command-line arguments, -h for help",
		       "",&s,xxstring)) < 0)
	  return(y);
	strcpy(line,"kermit ");
	strcat(line,s);
	xwords(line,64,list,0);
	for (i = 1; i < 64; i++) {
	    if (!list[i])
	      break;
	}
	i--;
	xargc = i;
	xargv = list;
	xargv++;
	if (sstate = cmdlin()) {
	    extern int justone;
	    justone = 1;		/* Force return to command mode */
	    proto();			/* after protocol */
	    return(success);
	} else return(success = 1);	/* Not exactly right, but... */
    }
    if (cx == XXDATE) {
	if ((z = cmcfm()) < 0) return(z);
	ztime(&s);
	printf("%s\n",s);
	return(success = 1);
    }
#ifndef NOPUSH
#ifndef NOFRILLS
    if (cx == XXEDIT) {
	char * p = NULL;
	if (!editor[0]) {
	    s = getenv("EDITOR");
	    if (s) strncpy(editor,s,CKMAXPATH);
	    editor[CKMAXPATH] = NUL;
	    if (!editor[0]) {
		printf("?Editor not defined - use SET EDITOR to define\n");
		return(-9);
	    }
	}
	strncpy(tmpbuf,editfile,TMPBUFSIZ);
	tmpbuf[TMPBUFSIZ] = NUL;
/*
   cmiofi() lets us parse the name of an existing file, or the name of
   a nonexistent file to be created.
*/
	x = cmiofi("File to edit", (char *)tmpbuf, &s, &y, xxstring);
	if (x < 0) {
	    if (x == -9) {
		if (zchko(s) < 0) {
		    printf("Can't create \"%s\"\n",s);
		    return(x);
		}
	    } else if (x != -3)
	      return(x);
	}
	if (x == -3)
	  tmpbuf[0] = NUL;
	else {
	    strncpy(tmpbuf,s,TMPBUFSIZ);
	    tmpbuf[TMPBUFSIZ] = NUL;
	    if (iswild((char *)tmpbuf)) {
		printf("?A single file please\n");
		return(-9);
	    }
	}
	if ((z = cmcfm()) < 0) return(z);
	if (nopush) {
	    printf("?Sorry, editing not allowed\n");
	    return(success = 0);
	}
	if (tmpbuf[0]) {
#ifdef ZFNQFP
	/* Get full path in case we change directories between EDIT commands */
	    zfnqfp(tmpbuf, CKMAXPATH, editfile);	
#else
	    strncpy(editfile,tmpbuf,CKMAXPATH);
#endif /* ZFNQFP */
	    editfile[CKMAXPATH] = NUL;
#ifdef OS2
            p = editfile;		/* Flip the stupid slashes */
            while (*p) {
                if (*p == '/') *p = '\\';
                p++;
            }   
#endif /* OS2 */
	} else
	  editfile[0] = NUL;
	s = line;
	x = 0;
	if (editopts[0]) {
#ifdef OS2
	    x = ckindex("%1",(char *)editopts,0,0,1);
	    if (x > 0)
	      editopts[x] = 's';
	    else
#endif /* OS2 */
	      x = ckindex("%s",(char *)editopts,0,0,1);	
	}
	if (x)
	  sprintf(tmpbuf,editopts,editfile);
	else
	  sprintf(tmpbuf,"%s %s",editopts,editfile);
	sprintf(s,"%s %s",editor,tmpbuf);
#ifdef OS2
        p = s + strlen(editor);		/* And again with the slashes */
        while (p != s) {
            if (*p == '/') *p = '\\';
            p--;
        }
#endif /* OS2 */
	conres();
	x = zshcmd(s);
	concb((char)escape);
	return(x);
    }
#endif /* NOFRILLS */
#endif /* NOPUSH */

#ifdef BROWSER				/* Defined only ifndef NOPUSH */
    if (cx == XXBROWS) {
        char * p = NULL;
	if (nopush) {
	    printf("?Sorry, browsing not allowed\n");
	    return(success = 0);
	}
#ifndef NT
        /* Windows lets the Shell Execute the URL if no Browser is defined */
	if (!browser[0]) {
	    s = getenv("BROWSER");
	    if (s) strncpy(browser,s,CKMAXPATH);
	    browser[CKMAXPATH] = NUL;
	    if (!browser[0]) {
		printf("?Browser not defined - use SET BROWSER to define\n");
		return(-9);
	    }
	}
#endif /* NT */
	strncpy(tmpbuf,browsurl,TMPBUFSIZ);
	tmpbuf[TMPBUFSIZ] = NUL;
	if ((x = cmtxt("URL",(char *)browsurl,&s,xxstring)) < 0)
	  return(x);
	strncpy(browsurl,s,4095);
	browsurl[4095] = NUL;
	s = line;

	x = 0;
	if (browsopts[0]) {
#ifdef OS2
	    x = ckindex("%1",(char *)browsopts,0,0,1);
	    if (x > 0)
	      browsopts[x] = 's';
	    else
#endif /* OS2 */
	      x = ckindex("%s",(char *)browsopts,0,0,1);	
	}
	if (x)
	  sprintf(tmpbuf,browsopts,browsurl);
	else
	  sprintf(tmpbuf,"%s %s",browsopts,browsurl);
#ifdef NT
        if ( !browser[0] ) {
            return(success = Win32ShellExecute( browsurl ));
        }
#endif /* NT */
	sprintf(s,"%s %s",browser,tmpbuf);
#ifdef OS2
        p = line + strlen(browser);	/* Flip slashes */
        while (p != line) {
            if (*p == '/') *p = '\\';
            p--;
        }
#endif /* OS2 */
	conres();
	x = zshcmd(s);
	concb((char)escape);
	return(x);
    }
#endif /* BROWSER */

#ifdef CK_TAPI
    if (cx == XXTAPI) {			/* Microsoft TAPI */
	return (success = dotapi());
    }
#endif /* CK_TAPI */

    if (cx == XXWHERE) {
	extern char * rfspec, * sfspec, * srfspec, * rrfspec;
	if ((x = cmcfm()) < 0) return(x);
	printf("\nFile most recently...\n\n");
	printf("  Sent:       %s\n",   sfspec ? sfspec : "(none)");
	if (sfspec && srfspec) {
	    printf("  Stored as:  %s\n",   srfspec);
	    printf("\n");
	}
	printf("  Received:   %s\n",   rrfspec ? rrfspec : "(none)");
	if (rfspec && rrfspec)
	printf("  Stored as:  %s\n",   rfspec);
	printf(
"\nIf the full path is not shown, then the file is probably in your current\n"
	       );
	printf(
"directory or your download directory (if any - SHOW FILE to find out).\n\n"
	       );
	return(success = 1);
    }

#ifdef CK_RECALL
    if (cx == XXREDO) {			/* Find a previous cmd and redo it */
	extern int on_recall, in_recall, cmflgs;
	int i, x;
	char * p;

	if ((x = cmtxt(
"pattern, or first few characters of a previous command",
		       "*",&s,xxstring)) < 0)
	  return(x);
	strcpy(line,s);
	x = strlen(s);
	s = line;
	if (*s == '{') {		/* Braces disable adding * to end */
	    if (s[x-1] == '}') {
		s[x-1] = NUL;
		s++;
		x--;
	    }
	} else {			/* No braces, add * to end. */
	    s[x] = '*';
	    s[x+1] = NUL;
	}

	while (x > 0 && s[x] == '*' && s[x-1] == '*') s[x--] = NUL;

	if (!on_recall || !in_recall) {
	    printf("?Sorry, command recall can't be used now.\n");
	    return(-9);
	}
	if (p = cmgetcmd(s)) {		/* Look for it history buffer */
	    sprintf(cmdbuf,"%s%c",p,'\r'); /* Found - copy to command buffer */
	    cmaddnext();		/* Force re-add to history buffer */
	    return(cmflgs = -1);	/* Force reparse */
	} else {
	    printf("?Sorry - \"%s\" not found\n", s);
	    return(-9);
	}
    }
#endif /* CK_RECALL */

/* This is useless unless user is root.  Too bad, it's just what we need. */

#ifdef COMMENT
    if (cx == XXCHRT) {			/* Change root directory */
#ifdef UNIX
	if ((x = cmdir("Name of new root directory","",&s,xxstring)) < 0)
	  return(x);
	strcpy(line,s);
	s = line;
	if ((x = cmcfm()) < 0) return(x);
	s = brstrip(s);
	priv_on();			/* This doesn't work if setuid root */
	x = chroot(s);			/* See priv_ini() in ckutio.c. */
	priv_off();
	if (x) {
	    printf("Error %d\n",errno);	/* 1 = EPERM (i.e. "not root") */
	    perror("chroot");
	    return(success = 0);
	}
	return(success = zchdir(s));
#else
	printf("?Sorry, not implemented\n");
	return(-9);
#endif /* UNIX */
    }
#endif /* COMMENT */

#ifdef CK_KERBEROS
    if (cx == XXAUTH) {			/* KERBEROS */
	x = cp_auth();			/* Parse it */
	if (x < 0)			/* Pass parse errors back */
	  return(x);
	else				/* Parsed OK, do it. */
	  return(success = doauth(cx));
    }
#endif /* CK_KERBEROS */

#ifndef NOLOCAL
    if (cx == XXTERM) {
	return(settrmtyp());
    }
#endif /* NOLOCAL */

    if (cx == XXSTATUS) {
	if ((x = cmcfm()) < 0) return(x);
	printf( " %s\n", success ? "SUCCESS" : "FAILURE" );
	return(0);			/* Don't change it */
    }

    debug(F101,"docmd unk arg","",cx);	/* None of the above. */
    return(-2);

} /* end of docmnd() */

#endif /* NOICP */
