;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Args/args.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 12 11:04:06 1996                          */
;*    Last change :  Wed Jan 14 15:09:58 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    An example of args.sch usage                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module args
   (include "args.sch")
   (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (parse-args (cdr argv))
   (print "Parsing finished"))

;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: foo [options]")
   (parse-args 'usage))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args argv)
   (let ((unmatched? #f))
      (args-parse argv
	 (("-o" ?name (synopsis "The name of the src file"))
	  (print "The source file is " name))
	 (("-o?name" (synopsis "An alternate way of providing src file"))
	  (print "The source file is again " name))
	 (("-dummy" (synopsis "-dummy" "A dummy option"))
	  (print "One dummy option"))
	 (("-dummy2" ?dummy1 ?dummy2 (synopsis "-dummy2 <arg1> <arg2>"
					       "A dummy option with 2 args"))
	  (print "One dummy option with 2 args"))
	 (("-help")
	  (args-parse-usage))
	 (else
	  (if unmatched?
	      (args-parse-error else)
	      (begin
		 (set! unmatched? #t)
		 (print "An unmatched argument: " else)))))))

 
