;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/R5rs/expand5.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Willian Clinger                                   */
;*    Creation    :  Sat Mar 21 17:18:51 1998                          */
;*    Last change :  Sat Mar 21 18:18:13 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*  Copyright 1992 William Clinger                                     */
;*                                                                     */
;*  Permission to copy this software, in whole or in part, to use this */
;*  software for any lawful purpose, and to redistribute this software */
;*  is granted subject to the restriction that all copies made of this */
;*  software must include this copyright notice in full.               */
;*                                                                     */
;*  I also request that you send me a copy of any improvements that you*/
;*  make to this software so that they may be incorporated within it to*/
;*  the benefit of the Scheme community.                               */
;*                                                                     */
;*  The external entry points and kernel of the macro expander.        */
;*                                                                     */
;*  Part of this code is snarfed from the Twobit macro expander.       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_syntax_expand
   
   (export (internal-expand-syntax ::obj)
	   (desugar-definitions ::obj ::obj)
	   define-syntax-scope
	   m-quit)

   (use    (__type                       "Llib/type.scm")
           (__error                      "Llib/error.scm")
           (__bigloo                     "Llib/bigloo.scm")
           (__tvector                    "Llib/tvector.scm")
           (__structure                  "Llib/struct.scm")
           (__tvector                    "Llib/tvector.scm")
           (__bexit                      "Llib/bexit.scm")
            
           (__reader                     "Read/reader.scm")

           (__rgc                        "Rgc/runtime.scm")
            
           (__r4_numbers_6_5             "Ieee/number.scm")
           (__r4_numbers_6_5_fixnum      "Ieee/fixnum.scm")
           (__r4_numbers_6_5_flonum      "Ieee/flonum.scm")
           (__r4_characters_6_6          "Ieee/char.scm")
           (__r4_equivalence_6_2         "Ieee/equiv.scm")
           (__r4_booleans_6_1            "Ieee/boolean.scm")
           (__r4_symbols_6_4             "Ieee/symbol.scm")
           (__r4_strings_6_7             "Ieee/string.scm")
           (__r4_pairs_and_lists_6_3     "Ieee/pair-list.scm")
           (__r4_input_6_10_2            "Ieee/input.scm")
           (__r4_control_features_6_9    "Ieee/control.scm")
           (__r4_vectors_6_8             "Ieee/vector.scm")
           (__r4_ports_6_10_1            "Ieee/port.scm")
           (__r4_output_6_10_3           "Ieee/output.scm")
   
	   (__r5_syntax_misc             "R5rs/misc5.scm")
	   (__r5_syntax_syntaxenv        "R5rs/syntaxenv5.scm")
	   (__r5_syntax_syntaxrules      "R5rs/syntaxrules5.scm")
	   (__r5_syntax_prefs            "R5rs/prefs5.scm")))

(define define-syntax-scope
  (let ((flag 'letrec))
    (lambda args
      (cond ((null? args) flag)
            ((not (null? (cdr args)))
             (apply m-warn
                    "Too many arguments passed to define-syntax-scope"
                    args))
            ((memq (car args) '(letrec letrec* let*))
             (set! flag (car args)))
            (else (m-warn "Unrecognized argument to define-syntax-scope"
                          (car args)))))))

(define m-quit             ; assigned by expand-syntax
  (lambda (v) v))

(define (internal-expand-syntax def-or-exp)
  (bind-exit (k)
     (set! m-quit k)
     (set! renaming-counter 0)
     (desugar-definitions def-or-exp global-syntactic-environment)))

(define (desugar-definitions exp env)
  (letrec 
    ((define-loop 
       (lambda (exp rest first)
         (cond ((and (pair? exp)
                     (eq? (syntactic-lookup env (car exp))
                          denotation-of-begin)
                     (pair? (cdr exp)))
                (define-loop (cadr exp) (append (cddr exp) rest) first))
               ((and (pair? exp)
                     (eq? (syntactic-lookup env (car exp))
                          denotation-of-define))
                (let ((exp (desugar-define exp env)))
                  (cond ((and (null? first) (null? rest))
                         exp)
                        ((null? rest)
                         (cons begin1 (reverse (cons exp first))))
                        (else (define-loop (car rest)
                                           (cdr rest)
                                           (cons exp first))))))
               ((and (pair? exp)
                     (eq? (syntactic-lookup env (car exp))
                          denotation-of-define-syntax)
                     (null? first))
                (define-syntax-loop exp rest))
               ((and (null? first) (null? rest))
                (m-expand exp env))
               ((null? rest)
                (cons begin1 (reverse (cons (m-expand exp env) first))))
               (else (cons begin1
                           (append (reverse first)
                                   (map (lambda (exp) (m-expand exp env))
                                        (cons exp rest))))))))
     
     (desugar-define
      (lambda (exp env)
        (cond 
         ((null? (cdr exp)) (m-error "Malformed definition" exp))
         ; (define foo) syntax is transformed into (define foo (undefined)).
         ((null? (cddr exp))
          (let ((id (cadr exp)))
            (redefinition id)
            (syntactic-bind-globally! id (make-identifier-denotation id))
            (list define1 id undefined1)))
         ((pair? (cadr exp))
          ; lambda0 is an unforgeable lambda, needed here because the
          ; lambda expression will undergo further expansion.
          (desugar-define `(,define1 ,(car (cadr exp))
                                     (,lambda0 ,(cdr (cadr exp))
                                               ,@(cddr exp)))
                          env))
         ((> (length exp) 3) (m-error "Malformed definition" exp))
         (else (let ((id (cadr exp)))
                 (redefinition id)
                 (syntactic-bind-globally! id (make-identifier-denotation id))
                 `(,define1 ,id ,(m-expand (caddr exp) env)))))))
     
     (define-syntax-loop 
       (lambda (exp rest)
         (cond ((and (pair? exp)
                     (eq? (syntactic-lookup env (car exp))
                          denotation-of-begin)
                     (pair? (cdr exp)))
                (define-syntax-loop (cadr exp) (append (cddr exp) rest)))
               ((and (pair? exp)
                     (eq? (syntactic-lookup env (car exp))
                          denotation-of-define-syntax))
                (if (pair? (cdr exp))
                    (redefinition (cadr exp)))
                (if (null? rest)
                    (m-define-syntax exp env)
                    (begin (m-define-syntax exp env)
                           (define-syntax-loop (car rest) (cdr rest)))))
               ((null? rest)
                (m-expand exp env))
               (else (cons begin1
                           (map (lambda (exp) (m-expand exp env))
                                        (cons exp rest)))))))
     
     (redefinition
      (lambda (id)
        (if (symbol? id)
            (if (not (ident?
                      (syntactic-lookup global-syntactic-environment id)))
                (m-warn "Redefining keyword" id))
            (m-error "Malformed variable or keyword" id)))))
    
    ; body of letrec
    
    (define-loop exp '() '())))

; Given an expression and a syntactic environment,
; returns an expression in core Scheme.

(define (m-expand exp env)
  (if (not (pair? exp))
      (m-atom exp env)
      (let ((keyword (syntactic-lookup env (car exp))))
        (case (denotation-class keyword)
          ((special)
           (cond
            ((eq? keyword denotation-of-quote)         (m-quote exp))
            ((eq? keyword denotation-of-lambda)        (m-lambda exp env))
            ((eq? keyword denotation-of-if)            (m-if exp env))
            ((eq? keyword denotation-of-set!)          (m-set exp env))
            ((eq? keyword denotation-of-begin)         (m-begin exp env))
            ((eq? keyword denotation-of-let-syntax)    (m-let-syntax exp env))
            ((eq? keyword denotation-of-letrec-syntax) (m-letrec-syntax exp env))
            ((or (eq? keyword denotation-of-define)
                 (eq? keyword denotation-of-define-syntax))
             (m-error "Definition out of context" exp))
            (else (m-bug "Bug detected in m-expand" exp env))))
          ((macro) (m-macro exp env))
          ((identifier) (m-application exp env))
          (else (m-bug "Bug detected in m-expand" exp env))))))

(define (m-atom exp env)
  (cond ((not (symbol? exp))
         ; Here exp ought to be a boolean, number, character, or string,
         ; but I'll allow for non-standard extensions by passing exp
         ; to the underlying Scheme system without further checking.
         exp)
        (else (let ((denotation (syntactic-lookup env exp)))
                (case (denotation-class denotation)
                  ((special macro)
                   (m-error "Syntactic keyword used as a variable" exp env))
                  ((identifier) (identifier-name denotation))
                  (else (m-bug "Bug detected by m-atom" exp env)))))))

(define (m-quote exp)
  (if (= (safe-length exp) 2)
      (list quote1 (m-strip (cadr exp)))
      (m-error "Malformed quoted constant" exp)))

(define (m-lambda exp env)
  (if (> (safe-length exp) 2)
      (let* ((formals (cadr exp))
             (alist (rename-vars (make-null-terminated formals)))
             (env (syntactic-rename env alist))
             (body (cddr exp)))
        (list lambda1
              (rename-formals formals alist)
              (m-body body env)))
      (m-error "Malformed lambda expression" exp)))

(define (m-body body env)
  (define (loop body env defs)
    (if (null? body)
        (m-error "Empty body"))
    (let ((exp (car body)))
      (if (and (pair? exp)
               (symbol? (car exp)))
          (let ((denotation (syntactic-lookup env (car exp))))
            (case (denotation-class denotation)
              ((special)
               (cond ((eq? denotation denotation-of-begin)
                      (loop (append (cdr exp) (cdr body)) env defs))
                     ((eq? denotation denotation-of-define)
                      (loop (cdr body) env (cons exp defs)))
                     (else (finalize-body body env defs))))
              ((macro)
               (m-transcribe exp
                             env
                             (lambda (exp env)
                               (loop (cons exp (cdr body))
                                     env
                                     defs))))
              ((identifier)
               (finalize-body body env defs))
              (else (m-bug "Bug detected in m-body" body env))))
          (finalize-body body env defs))))
  (loop body env '()))

(define (finalize-body body env defs)
  (if (null? defs)
      (let ((body (map (lambda (exp) (m-expand exp env))
                       body)))
        (if (null? (cdr body))
            (car body)
            (cons begin1 body)))
      (let* ((alist (rename-vars '(quote lambda set!)))
             (env (syntactic-alias env alist standard-syntactic-environment))
             (new-quote  (cdr (assq 'quote alist)))
             (new-lambda (cdr (assq 'lambda alist)))
             (new-set!   (cdr (assq 'set!   alist))))
        (define (desugar-definition def)
          (if (> (safe-length def) 2)
              (cond ((pair? (cadr def))
                     (desugar-definition
                      `(,(car def)
                        ,(car (cadr def))
                        (,new-lambda
                          ,(cdr (cadr def))
                          ,@(cddr def)))))
                    ((= (length def) 3)
                     (cdr def))
                    (else (m-error "Malformed definition" def env)))
              (m-error "Malformed definition" def env)))
        (define (expand-letrec bindings body)
          `((,new-lambda ,(map car bindings)
                         ,@(map (lambda (binding)
                                  `(,new-set! ,(car binding)
                                              ,(cadr binding)))
                                bindings)
                           ,@body)
            ,@(map (lambda (binding) `(,new-quote unspecified)) bindings)))
        (m-expand (expand-letrec (map desugar-definition (reverse defs))
                                 body)
                  env))))

(define (m-if exp env)
  (let ((n (safe-length exp)))
    (if (or (= n 3) (= n 4))
        (cons if1 (map (lambda (exp) (m-expand exp env)) (cdr exp)))
        (m-error "Malformed if expression" exp env))))

(define (m-set exp env)
  (if (= (safe-length exp) 3)
      `(,set!1 ,(m-expand (cadr exp) env) ,(m-expand (caddr exp) env))
      (m-error "Malformed assignment" exp env)))

(define (m-begin exp env)
  (if (positive? (safe-length exp))
      `(,begin1 ,@(map (lambda (exp) (m-expand exp env)) (cdr exp)))
      (m-error "Malformed begin expression" exp env)))

(define (m-application exp env)
  (if (> (safe-length exp) 0)
      (map (lambda (exp) (m-expand exp env))
           exp)
      (m-error "Malformed application")))

; I think the environment argument should always be global here.

(define (m-define-syntax exp env)
  (cond ((and (= (safe-length exp) 3)
              (symbol? (cadr exp)))
         (m-define-syntax1 (cadr exp)
                           (caddr exp)
                           env
                           (define-syntax-scope)))
        ((and (= (safe-length exp) 4)
              (symbol? (cadr exp))
              (memq (caddr exp) '(letrec letrec* let*)))
         (m-define-syntax1 (cadr exp)
                           (cadddr exp)
                           env
                           (caddr exp)))
        (else (m-error "Malformed define-syntax" exp env))))

(define (m-define-syntax1 keyword spec env scope)
  (case scope
    ((letrec)  (m-define-syntax-letrec keyword spec env))
    ((letrec*) (m-define-syntax-letrec* keyword spec env))
    ((let*)    (m-define-syntax-let* keyword spec env))
    (else      (m-bug "Weird scope" scope)))
  (list quote1 keyword))

(define (m-define-syntax-letrec keyword spec env)
  (syntactic-bind-globally!
   keyword
   (m-compile-transformer-spec spec env)))

(define (m-define-syntax-letrec* keyword spec env)
  (let* ((env (syntactic-extend (syntactic-copy env)
                                (list keyword)
                                '((fake denotation))))
         (transformer (m-compile-transformer-spec spec env)))
    (syntactic-assign! env keyword transformer)
    (syntactic-bind-globally! keyword transformer)))

(define (m-define-syntax-let* keyword spec env)
  (syntactic-bind-globally!
   keyword
   (m-compile-transformer-spec spec (syntactic-copy env))))

(define (m-let-syntax exp env)
  (if (and (> (safe-length exp) 2)
           (every1? (lambda (binding)
                      (and (pair? binding)
                           (symbol? (car binding))
                           (pair? (cdr binding))
                           (null? (cddr binding))))
                    (cadr exp)))
      (m-body (cddr exp)
              (syntactic-extend env
                                (map car (cadr exp))
                                (map (lambda (spec)
                                       (m-compile-transformer-spec
                                        spec
                                        env))
                                     (map cadr (cadr exp)))))
      (m-error "Malformed let-syntax" exp env)))

(define (m-letrec-syntax exp env)
  (if (and (> (safe-length exp) 2)
           (every1? (lambda (binding)
                      (and (pair? binding)
                           (symbol? (car binding))
                           (pair? (cdr binding))
                           (null? (cddr binding))))
                    (cadr exp)))
      (let ((env (syntactic-extend env
                                   (map car (cadr exp))
                                   (map (lambda (id)
                                          '(fake denotation))
                                        (cadr exp)))))
        (for-each (lambda (id spec)
                    (syntactic-assign!
                     env
                     id
                     (m-compile-transformer-spec spec env)))
                  (map car (cadr exp))
                  (map cadr (cadr exp)))
        (m-body (cddr exp) env))
      (m-error "Malformed let-syntax" exp env)))

(define (m-macro exp env)
  (m-transcribe exp
                env
                (lambda (exp env)
                  (m-expand exp env))))

; To do:
; Clean up alist hacking et cetera.
