package biss.calendar;

import biss.VectorLib;
import biss.XorSet;
import biss.awt.BarMenu;
import biss.awt.Border;
import biss.awt.Button;
import biss.awt.Checkbox;
import biss.awt.Choice;
import biss.awt.ClockView;
import biss.awt.DatePane;
import biss.awt.DecoBox;
import biss.awt.DecoGroup;
import biss.awt.DecoText;
import biss.awt.Label;
import biss.awt.Layouter;
import biss.awt.List;
import biss.awt.Menu;
import biss.awt.TextField;
import biss.awt.TopWindow;
import java.awt.Font;

public class DateViewer
  extends TopWindow
{
	BarMenu BMenu = new BarMenu();
	Checkbox DayBtn = new Checkbox("bsacalday.gif", StringDict.at("day"));
	Checkbox WeekBtn = new Checkbox("bsacalweek.gif", StringDict.at("week"));
	Checkbox MonthBtn = new Checkbox("bsacalmonth.gif", StringDict.at("month"));
	Button PrevBtn = new Button("bsacalprevday.gif");
	Button NextBtn = new Button("bsacalnextday.gif");
	Button MNextBtn = new Button("bsacalnextmon.gif", StringDict.at("month"));
	Button MPrevBtn = new Button("bsacalprevmon.gif", StringDict.at( "month"));
	Button TodayBtn = new Button(StringDict.at( "tToday"));
	List TimePane = new List();
	Label ModeInfo = new Label();
	ClockView TimeInfo = new ClockView(StringDict.at( "timeDim"));
	DecoBox DateInfo = new DecoBox();
	DecoText DText = new DecoText("1");
	DecoText WText = new DecoText("Montag");
	DecoText MText = new DecoText("Januar, 1996");
	List DatePane = new List();
	DatePane MonthView = new DatePane();
	TextField DStart = new TextField();
	TextField DEnd = new TextField();
	Checkbox DAlarm = new Checkbox("Alarm:");
	DecoText TStart = new DecoText(StringDict.at( "from"));
	DecoText TEnd = new DecoText(StringDict.at( "to"));
	DecoText TDate = new DecoText(StringDict.at( "date"));
	DecoText TTime = new DecoText(StringDict.at( "time"));
	DecoText TDet = new DecoText("Details:");
	DecoText TCat = new DecoText(StringDict.at( "category"));
	Choice DCat = new Choice(Choice.READ_ONLY, VectorLib.vectorFromArray( Calendar.Categories));
	TextField DDet = new TextField();
	DecoText TIText = new DecoText("Text:");
	TextField EIText = new TextField();
	Button BEDet = new Button("~File");
	TextField DADate = new TextField();
	TextField DATime = new TextField();
	DecoGroup CDBox = new DecoGroup(StringDict.at( "selAptm"));
	Button ModifyBtn = new Button(StringDict.at( "tModEntry"));
	Button InsertBtn = new Button(StringDict.at( "tInsEntry"));
	TextField DDate = new TextField();
	Button RemoveBtn = new Button(StringDict.at( "tRemEntry"));
	Button SaveBtn = new Button(StringDict.at("tStore"));
	Button ExitBtn = new Button(StringDict.at( "tExit"));
	Layouter Lo = new Layouter( this);

static {
	TextField.setDefaultBorderStyle( Border.BS_STEP);
	Label.setDefaultCarved( false);
	//	DecoGroup.setDefaultCarved( false);
	DecoText.setDefaultCarved( false);
}

public DateViewer(){
	super( "DateViewer");
	open();
}

public void init () {

	XorSet radioBtns = new XorSet();
	DayBtn.setExclusive( radioBtns);
	WeekBtn.setExclusive( radioBtns);
	MonthBtn.setExclusive( radioBtns);

	DText.setAlign( DecoText.DTA_CENTER);
	DText.setFont( new Font( "Dialog", Font.BOLD, 19));

	setBarMenu();
}

public static void main( String[] args ) {
	new DateViewer();
}

public void open() {
	Lo.add( BMenu, 0, 0, 1000, 0, true, 0, 0, 0, 150, 0);
	Lo.add( DayBtn, 0, 0, 0, 0, true, 50, 150, 350, 450, 0);
	Lo.add( WeekBtn, 0, 0, 0, 0, true, 350, 150, 650, 450, 0);
	Lo.add( MonthBtn, 0, 0, 0, 0, true, 650, 150, 950, 450, 0);
	Lo.add( PrevBtn, 0, 0, 0, 0, true, 50, 450, 350, 750, 0);
	Lo.add( DateInfo, 0, 0, 1000, 0, true, 350, 450, -1340, 740, 0);
	Lo.add( DText, 0, 0, 0, 0, true, 380, 480, 680, 720, 0);
	Lo.add( WText, 0, 0, 1000, 0, true, 700, 480, -1353, 600, 0);
	Lo.add( MText, 0, 0, 1000, 0, true, 700, 600, -1353, 720, 0);
	Lo.add( NextBtn, 1000, 0, 1000, 0, true, -1340, 450, -1040, 740, 0);
	Lo.add( MPrevBtn, 1000, 0, 1000, 0, true, -970, 160, -690, 440, 0);
	Lo.add( TodayBtn, 989, 0, 1000, 0, true, -660, 160, -330, 440, 0);
	Lo.add( MNextBtn, 1000, 0, 1000, 0, true, -330, 160, -40, 440, 0);
	Lo.add( MonthView, 1000, 0, 1000, 0, true, -980, 450, -50, 1500, 0);
	Lo.add( TimePane, 0, 0, 1000, 1000, true, 50, 750, -1040, -1380, 0);
	Lo.add( DatePane, 1000, 0, 1000, 1000, true, -980, 1520, -50, -1390, 0);
	Lo.add( CDBox, 0, 1000, 1000, 1000, true, 50, -1330, -1040, -180, 0);
	Lo.add( DDate, 0, 1000, 256, 1000, true, 120, -1200, 0, -1040, 0);
	Lo.add( TStart, 263, 1000, 263, 1000, true, 0, -1200, 160, -1040, 0);
	Lo.add( DStart, 269, 993, 468, 1000, true, 150, -1180, -30, -1040, 0);
	Lo.add( TEnd, 468, 1000, 468, 1000, true, -10, -1200, 140, -1040, 0);
	Lo.add( DEnd, 468, 995, 1000, 1000, true, 160, -1186, -1086, -1040, 0);
	Lo.add( TIText, 0, 1000, 0, 1000, true, 120, -970, 580, -810, 0);
	Lo.add( EIText, 0, 1000, 1000, 1000, true, 620, -970, -1090, -810, 0);
	Lo.add( TCat, 0, 1000, 0, 1000, true, 120, -770, 580, -610, 0);
	Lo.add( DCat, 0, 993, 1000, 1000, true, 620, -740, -1090, -610, 0);
	Lo.add( TDet, 0, 1000, 0, 1000, true, 120, -570, 580, -410, 0);
	Lo.add( DDet, 0, 1000, 1000, 1000, true, 620, -570, -1390, -410, 0);
	Lo.add( BEDet, 1000, 1000, 1000, 1000, true, -1370, -570, -1080, -410, 0);
	Lo.add( DAlarm, 0, 1000, 0, 1000, true, 120, -370, 570, -220, 0);
	Lo.add( TDate, 0, 1000, 0, 1000, true, 620, -370, 840, -220, 0);
	Lo.add( DADate, 0, 1000, 468, 1000, true, 860, -370, -50, -220, 0);
	Lo.add( TTime, 468, 1000, 468, 1000, true, -40, -370, 140, -220, 0);
	Lo.add( DATime, 468, 1000, 1000, 1000, true, 150, -370, -1080, -220, 0);
	Lo.add( ModifyBtn, 1000, 1000, 1000, 1000, true, -810, -1330, -210, -1140, 0);
	Lo.add( InsertBtn, 1000, 1000, 1000, 1000, true, -810, -1100, -210, -920, 0);
	Lo.add( RemoveBtn, 1000, 1000, 1000, 1000, true, -810, -870, -210, -680, 0);
	Lo.add( SaveBtn, 1000, 1000, 1000, 1000, true, -810, -590, -210, -400, 0);
	Lo.add( ExitBtn, 1000, 1000, 1000, 1000, true, -810, -360, -210, -180, 0);
	Lo.add( ModeInfo, 0, 1000, 1000, 1000, true, 40, -140, -810, 0, 0);
	Lo.add( TimeInfo, 1000, 1000, 1000, 1000, true, -790, -140, -20, 0, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openInDlgUnits( 440, 366, 3000, 3400);
}

void setBarMenu () {
	BMenu.addItem( StringDict.at( "view"), new Menu( StringDict.at( "day") + "," +
	                                            StringDict.at( "week") + "," +
	                                            StringDict.at( "month" ) ));
	BMenu.addItem( StringDict.at( "appointment"), new Menu( StringDict.at( "tModEntry") + "," +
	                                            StringDict.at( "tInsEntry") + "," +
	                                            StringDict.at( "tRemEntry" ) ));
	BMenu.addItem( StringDict.at( "print") );
	BMenu.addItem( StringDict.at( "store") );
	BMenu.addItem( StringDict.at( "options"), new Menu( StringDict.at( "gotoDate") + "," +
	                                            StringDict.at( "clone") + "," +
	                                            StringDict.at( "cleanUp" ) ));
	BMenu.addItem( StringDict.at( "tHelp"));
}
}
