package biss.awt;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/**
 * generic dialog to display messages
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class MessageBox
  extends DialogWindow
{
	Vector Btns = new Vector(5);
	Button CancelBtn = null;
	public static String NO = "~No";
	Button Selection = null;
	Label TP = new Label();
	public static String YES = "~Yes";
	int BtnPCW;

public MessageBox( String title, String text, TopWindow owner){
	super( title, owner);

	Lo.add( TP, 0, 0, 1000, 1000, true, 20, 20, -20, -300, 0);

	TP.setContents( text);
	TP.wrapContents();
	TP.setCarved( false);
	TP.setBorder( Border.BS_NONE);
	TP.setAlignment( Label.HA_CENTER, Label.VA_CENTER);
}

public Button addButton( String label ) {

	Button btn = new Button( label );
	Btns.addElement( btn);
	btn.OsAction.addObserver( this);

	return btn;
}

public Button addCancelButton( ) {
	return addCancelButton( "~Cancel");
}

public Button addCancelButton( String label ) {
	return (CancelBtn = addButton( label ));
}

int computeWidth(){

	int  mw = 20*Awt.DlgXUnit;
	int  bw = maxBtnWidth();
	int  s  = Btns.size();
	int gtw = s*bw + (s+1)*Awt.DlgXUnit;

	BtnPCW = (1000 - (s+1)*100) / s;

	return (int)Math.max( gtw, mw);
}

public static MessageBox confirm( String text, Observer target, TopWindow owner){
	MessageBox mb = new MessageBox( "Please Confirm", text, owner);
	mb.addButton( YES);
	mb.addButton( NO);
	if ( target != null)
		mb.OsClose.addObserver( target);
	mb.openCentered();
	return mb;
}

public Button getSelection(){
	return Selection;
}

public int getSelectionIdx(){
	return Btns.indexOf( Selection);
}

public String getSelectionLabel(){
	return Selection.getContents();
}

public static void main( String args[]){

	String s = "This is a quite\nlong text\n" +
	"this line might even be too long to fit in one\n" +
	"another break. Ok?";

	MessageBox mb = new MessageBox( "MessageBox", s, null);
	mb.addButton( "~Yes");
	mb.addButton( "~Maybe");
	mb.addCancelButton( "~Never");
	mb.openCentered();

}

int maxBtnWidth(){
	int  w = 0;
	int  s = Btns.size();

	for ( int i=0; i<s; i++)
		w = Math.max( w, ((Button)Btns.elementAt(i)).minWidth());

	return w + 2*Awt.SysFontWidth;
}

public static MessageBox notify( String text, Observer target, TopWindow owner){
	MessageBox mb = new MessageBox( "Please Notify", text, owner);
	mb.addButton( "~Ok");
	if ( target != null)
		mb.OsClose.addObserver( target);
	mb.openCentered();
	return mb;
}

public void openCentered(){
	int tw = computeWidth(); 
	int mh = TP.minHeight( tw );

	packClient( tw, mh + 5*Awt.DlgYUnit);
	packButtons();
	super.openCentered();
}

void packButtons(){
	int bs = Btns.size();

	for ( int i=0; i<bs; i++) {
		Button btn = (Button)Btns.elementAt( i);
		int ip = (i+1)*100 + i*BtnPCW;
		Lo.add( btn, ip, 1000, ip+BtnPCW, 1000, true, 0, -250, 0, -50, 0);
	}

}

public void update ( Observable o, Object arg ) {
	if ( arg instanceof Button){
		Selection = (Button)arg;
		if ( Selection == CancelBtn)
			dispose();
		else 
			process();
	}

	super.update( o, arg);  
}

public boolean wasConfirmed () {
	return !WasCanceled && Selection.getContents().equals( "Yes");
}
}
