package biss.jde;

import biss.CLPrintStream;
import biss.VectorSorter;
import biss.awt.List;
import biss.awt.SelfDrawingObject;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Vector;

/**
 * model class describing a java class field (instance or class variable)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class Data
  extends FieldDecl
  implements SelfDrawingObject
{
	static DataSorter Sorter = new DataSorter();
	public static BitSet PossibleMods;
	String InitExpr;
	String ArrayDim;

static {
	PossibleMods = new BitSet( NMods);
	PossibleMods.set( PUBLIC);
	PossibleMods.set( PROTECTED);
	PossibleMods.set( PRIVATE);
	PossibleMods.set( STATIC);
	PossibleMods.set( FINAL);
	PossibleMods.set( TRANSIENT);
	PossibleMods.set( VOLATILE);
}

public Data ( BitSet mods, String type, String name ) {
	Mods = mods;
	Type = type;
	Id = name;
}

public static String allDefinitions ( Vector list, boolean withCmt, boolean withMods ) {
	int n, i, len;

	if ( list == null || (n = list.size()) == 0 ) return null;
	len = n * 60;
	ByteArrayOutputStream o = new ByteArrayOutputStream( len);
	PrintStream s = new PrintStream( o);

	for ( i=0;; ) {
		((Data) list.elementAt(i++)).printOn( s, withCmt, withMods);
		if ( i == n ) break;
		// s.println();
	}

	return o.toString();
}

public String definition () {
	String answer = Type + ' ' + Id;
	if ( ArrayDim != null )
		answer += ArrayDim;
	if ( InitExpr != null )
		answer += " = " + InitExpr;

	return answer;
}

public void 	drawSelfIn ( Object pane ){
	DrawSupport.drawData( (List) pane, Type, Id, ArrayDim, InitExpr, Mods);
}

public boolean equals ( Object other ) {
	Data data = (Data) other;
	return (data != null) && (Id.equals( data.Id));
}

public static String getTemplate () {
	return "<type> <name> = <init>";
}

public int  	maxDrawWidth(){
	return DrawSupport.Cx * 60;
}

boolean mergeWith ( Data other ) {
	if ( !Id.equals( other.Id ) )
		return false;

	Type = other.Type;
	if ( other.hasMods() )
		Mods = other.Mods;

	if ( Comment == null || other.Comment != null )
		Comment = other.Comment;
	InitExpr = other.InitExpr;
	ArrayDim = other.ArrayDim;

	return true;
}

public void printOn ( PrintStream s, boolean withCmt, boolean withMods ) {
	if ( s instanceof CLPrintStream )
		Line = ((CLPrintStream)s).Line;

	if ( withCmt) {
		printCommentOn( s);
		s.print( '\t');
	}

	if ( withMods) printModsOn( s);

	s.print( Type);
	s.print( ' ');
	s.print( Id);

	if ( ArrayDim != null )
		s.print( ArrayDim);

	if ( InitExpr != null ){
		s.print( " = ");
		s.print( InitExpr);
	}

	s.println( ';');
}

public void setArrayDim ( String arrayDim ) {
	ArrayDim = arrayDim;
}

public void setInitExpr ( String initExpr ) {
	InitExpr = initExpr;
}
}

class DataSorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	return ((Data)a).Id.compareTo( ((Data)b).Id);
}
}
