/*
 * defs.h for kdrill
 *   Okay, I lied.. this file has struct definitions, as
 *   well as the #defines
 */

#ifdef BSD
#define srand(a) srandom(a)
#define lrand48() random()
/* yes, memcpy is okay.. no overlapping stuff */
#define memcpy(dest,src,sz) bcopy((src),(dest),(sz))
#define strchr(a,b) index((a),(b)) 
#define HAS_BZERO

#else
#define HAS_MEMSET
#endif /* BSD */

/* for reading in kanjidic lines */
#define MAXLINELEN 1024


/* when in random mode, if you have incorrect kanji guessed,
 * will specifically pick an incorrectly-guessed kanji
 * probability of (1/REPEACTFRACTION)
 */
#define REPEATFRACTION 4
/* number of times a missed kanji will be repeated on purpose */
#define REPEATTIMES 2

/* how many possible answers are there? */
/* maximum of 9, since you can only have accelerator keys 1-9 */
#define NUMBEROFCHOICES 5

/* enum for "changemode()" */
enum { GUESSMEANING, GUESSKANJI,TOGGLEKANA};

#define STATUSDISTANCE	10
#define BUTTONSWIDTH	120	/* for options buttons */
#define INPUTWIDTH	50
#define GRADEDISTANCE	14

#define ALLGRADES 0xfe
#define ABOVESIXGRADE 0x80
/* FULLWIDTH is startup size of an english translation button */
#define FULLWIDTH 370
#define KANJIWIDTH 50

#define MINKANJIALLOWED 0x2000
#define MAXKANJIALLOWED 0x8000
#define HAVE_AT_LEAST 9

struct translationstruct {

	char *english;	/* english translation string.
			 * null-terminated.
			 * Can theoretically be any length, but
			 * since it will all be on a single-line
			 * text widget, that would be silly
			 */

	int Uindex;		/* because it seems to be the future */
				/* "Unicode" index */

	int Nindex;		/* for annoying "See Nxxxx" references */
				/* Nelson dictionary */
	int Hindex;		/* Halpern dictionary */

	int frequency;		/* frequency that kanji is used */
	int grade_level;	/* akin to  school class level */
	int incorrect;
	XChar2b *pronunciation;
	XChar2b *ON_extra;

};

/********************************************************************

SO here's the format for the translation/dictionary file I have decided
on so far:

I changed specs. it will have to be in "kanjidic" format...

Two char high-bit-set identifier, followed by JIS number in hex.
Followed by stroke information? [HAS TO BE TERMINATED BY 'Gx', where
				  'x' is any number]
Followed by pronunciation guide, in kana.
Followed by various english translations, enclosed in {}

"kanjidic" often has multiple {} phrases. which leads to another nasty
hack  in readstructs()

*/
