/* frequency.c
 * This file deals with frequency restrictions.
 * It unfortunately also contains some convenience routines like
 *	GetWidgetNumberval  ; read numeric value from input widget
 *	SetWidgetNumberval  ; SET display value of input widget
 *	SetWidgetHexval     ; SET display value of input widget hex.
 *	FindIndex	    ; Given special ascii code, find
 *			    ;	kanji index we need
 */

#include <stdio.h>
#include <stdlib.h>

#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/AsciiText.h>

#include "defs.h"
#include "externs.h"
#include "game.h"
#include "options.h"

Widget frequencyForm,frequencyHigh,frequencyLow;



/*
 *	set the text field of a textwigdet to the passed integer value.
 */
void SetWidgetNumberval(Widget w,int val){
	char tempstr[100];
	if(val == 0)
		tempstr[0] = '\0';
	else
		sprintf(tempstr,"%d",val);
	XtVaSetValues(w,XtNstring,tempstr,NULL);
	return;
}
/*
 *	set the text field of a textwigdet to the passed HEX integer value.
 */
void SetWidgetHexval(Widget w,int val){
	char tempstr[100];
	if(val == 0)
		tempstr[0] = '\0';
	else
		sprintf(tempstr,"%x",val);
	XtVaSetValues(w,XtNstring,tempstr,NULL);
	return;
}

/*
 * FindIndex:
 *
 *  Given ascii string represending index, find actual JIS index.
 *
 *	Has to handle special prefixes:
 *
 *	0x == hex index
 *	U  == Unicode index		(in HEX )
 *	N  == Nelson dictionary index	(in DEC )
 *	H  == Halpern dictionary index    (in DEC )
 *
 *	Should set user status message on faliure
 */

int FindIndex(char *str){
	char statusmsg[100];  /* This gets seeded with potential
				* error messages, even if error does not
				* happen
				*/
				
	int retval=0;
	int tempval,findit;


	sprintf(statusmsg,"Could not find index");


	switch (str[0]){
		case '0':
			if(strncmp(str,"0x",2) == 0){
				sprintf(statusmsg,"Could not find hexadecimal index");
				retval = xtoi(&str[2]);
			}
			else
				retval = atoi(str);
 			break;
		case 'H':
			sprintf(statusmsg,"Could not find H index");
			tempval = atoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Hindex == tempval){
					retval = findit;
					break;
				}
			}
			break;
		case 'N':
			sprintf(statusmsg,"Could not find N index");
			tempval = atoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Nindex == tempval){
					retval = findit;
					break;
				}
			}
			break;
		case 'U':
			sprintf(statusmsg,"Could not find U index");
			tempval = xtoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Uindex == tempval){
					retval = findit;
					break;
				}
			}
			break;

		default:
			retval = atoi(str);
			break;
	}
	if(retval == 0){
		setstatus(statusmsg);
		Beep(0);
	}

	return retval;
}

/* GetWidgetNumberval
 *	Get the asciiText from an input widget.
 *	Attempt to look up kanji index
 *	Set asciiText label to null if not found, or
 *	a clean decimal print of index otherwise.
 *
 *	Calls FindIndex, which accepts special prefixes.
 */
int GetWidgetNumberval(Widget w){
	String str;

	int retval=0;


	XtVaGetValues(w,XtNstring,&str,NULL);

	retval = FindIndex(str);

	SetWidgetNumberval(w,retval);
	  

	return (retval);
}
/* UpdateFrequency()
 *	Change frequency restrictions on range of kanji used
 */
void 
UpdateFrequency(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	int *setthisvalue,oldvalue;

	if(w == frequencyHigh){
		setthisvalue = &highfrequency;
	} else if( w == frequencyLow){
		setthisvalue = &lowfrequency;
	} else {
		puts("??? HUh??? got update callback from imaginary widget??");
		exit(0);
	}

	oldvalue = *setthisvalue;
	*setthisvalue = GetWidgetNumberval(w);

	CountKanji();
	if(numberofkanji <HAVE_AT_LEAST){
		setstatus("Too few kanji available!!");
		Beep();
		*setthisvalue = oldvalue;
		SetWidgetNumberval(w,oldvalue);
		/* and just reset numberofkanji value!! */
		CountKanji();
	} else {
		char numbuff[100];
		sprintf(numbuff,"%d characters active",numberofkanji);
		setstatus(numbuff);
	}
	
}


static char * freqAccel = 
 " <Key>Return:  update-frequency()";


/* MakeFrequency:
 *  make specialised "dialog box" that takes
 *  two input values, with labels next to each input area, and
 *  one make dialog label
 */
void MakeFrequency(){
	Widget mainlabel,highlabel,lowlabel;
	XtAccelerators Accel;
	char highvalue[10] = "";
	char lowvalue[10] = "";

	
	
	if(lowfrequency !=0)
		sprintf(lowvalue,"%d",lowfrequency);
	if(highfrequency !=0)
		sprintf(highvalue,"%d",highfrequency);

	frequencyForm = XtVaCreateManagedWidget(
			"freqForm",formWidgetClass,optionsform,
			XtNhorizDistance,GRADEDISTANCE,
			XtNvertDistance,10,
			XtNfromHoriz,usefilebutton,
			XtNfromHoriz,togglekana,
			XtNfromHoriz,englishmode,
			XtNfromVert,gradelevelForm,
			NULL);

	mainlabel = XtVaCreateManagedWidget("freqLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"        Frequency Range",
			XtNborderWidth,0,
			NULL);

	highlabel = XtVaCreateManagedWidget(
			"freqhighLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"High:",
			XtNfromVert,mainlabel,
			XtNborderWidth,0,
			NULL);
	frequencyHigh = XtVaCreateManagedWidget(
			"freqHigh",asciiTextWidgetClass,frequencyForm,
			XtNfromVert,mainlabel,
			XtNfromHoriz,highlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,45,
			XtNstring,highvalue,
			NULL);
	lowlabel = XtVaCreateManagedWidget(
			"freqlowLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"Low:",
			XtNfromVert,mainlabel,
			XtNfromHoriz,frequencyHigh,
			XtNborderWidth,0,
			NULL);
	frequencyLow = XtVaCreateManagedWidget(
			"freqLow",asciiTextWidgetClass,frequencyForm,
			XtNfromVert,mainlabel,
			XtNfromHoriz,lowlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,50,
			XtNstring,lowvalue,
			NULL);

	Accel = XtParseAcceleratorTable(freqAccel);
	XtOverrideTranslations(frequencyHigh,Accel);
	XtOverrideTranslations(frequencyLow,Accel);
}



