/* game.c:
 *	This file should contail all the internal game mechanisms;
 *	things that deal with the way things play, not how the
 *	windows look.
 */
 

#include <stdio.h>
#include <stdlib.h>	/* This SHOULD define lrand48..
			 *	but doesn't for solaris. go figure
			 */
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>

#include "defs.h"
#include "externs.h"
#include "widgets.h"
#include "grades.h"
#include "init.h"

int lastpicked=0;/* we can't "really" auto-initialize this...
		  * set to zero so we can set it
		  * properly later
		  */
int values[NUMBEROFCHOICES];
int truevalue=0;
int numberincorrect=0;

int Kanji2English=GUESSKANJI;

Boolean doBell,showinorder,showEnglish;
Boolean useUsefile;
Boolean switchKanaEnglish;


int englishwidth=7;	/* unused? */
int englishheight=11;	/* unused? */

void SetupGuess();

/*
*UseThisKanji()
*	Returns Boolean value on whether this is a "valid" kanji for us,
*	based on usefile markings,
*	current grade set,
*	and whether it has english/kana translation
*/
Boolean UseThisKanji(int kanjinum)
{
	struct translationstruct *kanji;

	/*usefile cancels it? */
	if(useUsefile && (useKanji[kanjinum] == 0)) return False;
	
	kanji = translations[kanjinum];
	/* nonexistant kanji? */
	if(kanji == NULL) return False;


	/* check against frequency limits */
	if(kanji->frequency==0) {
		/* No frequency means REALLY LOW frequency,
		 * therefore if there's ANY limit, dont use
		 */
		if(lowfrequency != 0)
			return False;
	} else {
		/* "1" is highest frequency!! */
		if(kanji->frequency < highfrequency) return False;
	}

	if(lowfrequency != 0){
		if(kanji->frequency >lowfrequency)
			return False;
	}

	/* does the appropriate form to display exist? */
	if( switchKanaEnglish || showEnglish){
		if(kanji->english == NULL)
			return False;
		if(kanji->english[0] == '\0')
			return False;
	}
	if( switchKanaEnglish || (!showEnglish)) {
		/* we're supposed to be showing kana.. are there any? */
		if(kanji->pronunciation == NULL)
			return False;
	}

	/* only thing left is to check grade level */
	switch(kanji->grade_level){
		case 1: case 2:
		case 3: case 4:
		case 5: case 6:
			if(gradelevelflags & (1 <<kanji->grade_level) ){
				return True;
			} else {
				return False;				
			}
		default:
			if(gradelevelflags & (1 <<7) ){
				return True;
			} else {
				return False;
			}
	}
}


/* CountKanji
 *This routine gets called a hell of a lot:
 *	When we change grade level, and
 *	when we change kana/english display.
 *	 (the secnd being because kanjidic does not always have
 *	 english and/or kana listings
 *
 *   This counts the number of usable kanji.
 *   It ALSO has to update the "numberincorrect" counter;
 */
void CountKanji(){
	int counter;
	numberofkanji=0;
	numberincorrect=0;
	for(counter=lowestkanji;counter <=highestkanji;counter++){
		if(UseThisKanji(counter)){
			numberofkanji++;
			if(translations[counter]->incorrect >0)
				numberincorrect++;
		}
	}
}

/* pickkanji:
 *   picks an acceptably random kanji index.
 *	NOTE THAT THIS DEPENDS ON "numberofkanji" being correct!
 */

int pickkanji(){
	int rand_kanji,count;
	

	rand_kanji = lrand48()%numberofkanji;

	for(count=lowestkanji;count<=highestkanji;count++) {
		if(UseThisKanji(count)) {
		      rand_kanji--;
		      if(rand_kanji <0)
			  return count;
		}
	}
	
	fprintf(stderr,"Internal error: picked kanji out of range\n");
	fprintf(stderr,"random pick: %d\n",rand_kanji);
	fprintf(stderr,"number of kanji: %d\n",numberofkanji);
	exit(0);

}

/* pickincorrect:
 *	pick a kanji we have missed previously.
 *	start at first incorect kanji after the last one picked.
 *	This hopefully ensures that we don't replay the same incorrect
 *	one too often.
 */
int pickincorrect()
{
	int currentpick=lastpicked;
	if(numberincorrect==0){
		puts("Internal Error.. pickincorrect called when no incorrect stored");
		return pickkanji();
	}
	do {
		do {
			currentpick++;
			if(currentpick >highestkanji)
				currentpick=lowestkanji;
		} while(!UseThisKanji(currentpick));
	} while (translations[currentpick]->incorrect==0);
	setstatus("You missed this one before");
	return currentpick;
}

/*picktruevalue()
 *	Similar to pickkanji().
 *	This calls pickkanji() to generate random kanji when
 *	desired. 
 *	Also tries to go back to missed kanji, ONLY when
 *	"random" order is in effect.
 *
 *	Tries to make sure same kanji isn't called in a row.
 *
 *	Sets "lastpicked" global, AFTER we have picked a new value.
 *	As soon as we have picked a value, it becomes the "lastpicked".
 *
 *	"lastpicked" is used by the "Back" command, outside this file.
 */
int picktruevalue(){
	int currentpick;


	if(!showinorder){
		if(numberincorrect>0){
			if(lrand48()%REPEATFRACTION == 0){
				currentpick = pickincorrect();
			}
			else do {
				currentpick = pickkanji();
			} while (currentpick == lastpicked);
			
		} else 
		do {
			currentpick = pickkanji();
		} while (currentpick == lastpicked);

	} else {
		/* ASSUME this loop will terminate. If there is
		 * something wrong with program setup, it will
		 * not. This is why there are checks for a minimum
		 * number of kanji here and there.
		 */
		currentpick = lastpicked;
		currentpick++;
		while(!UseThisKanji(currentpick)){
			currentpick++;

			if(currentpick >highestkanji)
				currentpick = lowestkanji;
		}
	}

	return currentpick;
} 


/*guessvalue(int)
 *	passed number by EITHER kanji button or english button,
 *	we don't care.
 *	Set status bar to correct/incorrect. Beeps if incorrect
 *	Also sets "incorrect" counter in the translations[].
 *	
*/
/* note that "-1" on guess means "you lose: ran out of time" */

void guessvalue(int guess){
	struct translationstruct *kanjiP;

	kanjiP = translations[values[guess]];
	if(guess == truevalue){
		setstatus("Correct! Now try THIS one...");
		switch(kanjiP->incorrect){
			case 0:
				break;
			case 1:
				kanjiP->incorrect -= 1;
				numberincorrect -= 1;
				break;
			default:
				kanjiP->incorrect -= 1;
		}
		SetupGuess();
		return;
	} 

	/* YOU GOT IT **WWRRROONNGGG!!!!** */
	/* we count off TWICE;
	 *  once for quiz meaning you missed,
	 *  and once for the incorrect kanji you thought it was
	 */
	Beep();
	setstatus("Incorrect.");
#ifdef OLDLOG
	if(logfile != NULL){
		fprintf(logfile,"%x -> %x\n",values[truevalue],values[guess]);
	}
#endif
	if(guess != -1) {
		kanjiP->incorrect += REPEATTIMES;
		if(kanjiP->incorrect ==REPEATTIMES)
			numberincorrect+=1;
	}

	kanjiP = translations[values[truevalue]];
	kanjiP->incorrect += REPEATTIMES;
	if(kanjiP->incorrect ==REPEATTIMES)
		numberincorrect+=1;
	
}



void printkanji(Widget w,unsigned knum){
	XChar2b onecharstring[2];
	onecharstring[1].byte1 = onecharstring[1].byte2 = 0;

	onecharstring[0].byte1 = (knum & 0xff00)>>8;
	onecharstring[0].byte2 = (knum & 0x00ff);

	XtVaSetValues(w,XtNlabel,onecharstring,NULL);

}

/* printallkanji:
 *	updates all the kanji buttons.
 */

void printallkanji(){
	int i;
	unsigned knum;

	for(i=0;i<NUMBEROFCHOICES;i++){
		UnreverseButton(kanjiWidget[i]);
	}

	if(Kanji2English == GUESSKANJI){
		knum = values[truevalue];
		printkanji(kanjiWidget[0],knum);

		for(i=1;i<NUMBEROFCHOICES;i++){
			printkanji(kanjiWidget[i],(unsigned) 0);
			/*XtVaSetValues(kanjiWidget[i],
			      XtNsensitive,False,
			      NULL);
			  */

		}

		/* never more than 4 ON, I hope.. */
		if(translations[knum]->ON_extra != 0){
			int onloop=0;
			XChar2b *on = translations[knum]->ON_extra;

#ifdef SINGLE_WINDOWS
			while(on[onloop].byte1 !=0){
				if(onloop==NUMBEROFCHOICES -1) break;
				
				printkanji(kanjiWidget[onloop+1],
					   ((on[onloop].byte1 <<8) +
					    on[onloop].byte2) );
				onloop++;
			}
#endif /* SINGLE_WINDOWS */
#ifdef USE_OKU
 			XtVaSetValues(ONWidget,XtNlabel,on,NULL);
#endif
		}
#ifdef USE_OKU
		else {
			printkanji(ONWidget,(unsigned) 0 );
		}
#endif
		
		return;
	}
	/* else */
	for(i=0;i<NUMBEROFCHOICES;i++) {
		printkanji(kanjiWidget[i],values[i]);
		XtSetSensitive(kanjiWidget[i],True);
	}
}


/* printenglish
 *	Convenience function to
 *	set label of  of english/kana.
 *	Will change fonts, dependant on "showEnglish"
 */
void printenglish(Widget widget,unsigned Tnum)
{

	if(showEnglish == True){
		XtVaSetValues(widget,
			     XtNencoding,XawTextEncoding8bit,
			     XtNfont,englishfont,
			     XtNlabel,translations[Tnum]->english,
			     NULL);
	} else {
		XtVaSetValues(widget,
			     XtNencoding,XawTextEncodingChar2b,
			     XtNfont,smallkfont,
			     NULL);
		XtVaSetValues(widget,
			      XtNlabel,translations[Tnum]->pronunciation,
			      NULL);
	}
}



/* printallenglish()
 *  similar to printallkanji()
 *  updates all "english" labels...
 *  EXCEPT: sometimes we want then to print kana! :-) so we use
 *  printenglish() to do the correct type
 */
void printallenglish(){
	int i;

	for(i=0;i<NUMBEROFCHOICES;i++){
		UnreverseButton(englishWidget[i]);
	}
	/* we must be guessing which character for one meaning */
	if(Kanji2English == GUESSMEANING){
		printenglish(englishWidget[0],values[truevalue]);
		for(i=1;i<NUMBEROFCHOICES;i++){
			XtVaSetValues(englishWidget[i],
			  XtNlabel,"  ",
			  /*XtNsensitive,False,*/
			  NULL);
		}
		return;
	}
	/* ELSE */
	/* we have all FOUR  active for picking*/
	for(i=0;i<NUMBEROFCHOICES;i++){
		XtSetSensitive(englishWidget[i],True);
		printenglish(englishWidget[i],values[i]);
	}
}




/* SetupGuess
 *		"MAIN LOOP" OF PROGRAM
 ******************************************************
 *
 *	sets up question...
 *	{ "what does this symbol? choose one of the four choices"}
 *	
 *	then returns, presumably falling back to XtAppMainLoop()
 *
 *	Kanji2English == GUESSKANJI : give kanji, and user guesses the meaning
 *					int English
 *	Kanji2English == GUESSENGLISH : give english, and user guesses which
 *					kanji fits best. 
 */
void SetupGuess()
{
	Boolean doloop;
	int valuecount;

	lastpicked = values[truevalue];

	truevalue = lrand48() %NUMBEROFCHOICES;
	for(valuecount=0;valuecount<NUMBEROFCHOICES;valuecount++){
		if(valuecount == truevalue){
			values[valuecount] = picktruevalue();
		} else {
			values[valuecount] = pickkanji();
		}
	}

	/* now weed out duplicates..
	 * This is messy.
	 *  We compare everything to everything else, and change
	 *   the "current" value if there is a conflict...
	 *    UNLESS current value is the "truevalue".
	 *  We then do a full compare again if there was a conflict
	 */
	do{
		int startcount=0;
		doloop = False;
		do {
			if(startcount == truevalue)
				continue;
			for(valuecount=0;valuecount<NUMBEROFCHOICES;valuecount++){
				if(valuecount == startcount)
					continue;
				if(values[startcount]== values[valuecount] ){
					doloop = True;
					values[startcount] = pickkanji();
				}
			}
		} while(++startcount<NUMBEROFCHOICES);

	} while(doloop== True);

	DescribeCurrent(values[truevalue]);

	printallkanji();	/* update labels */
	printallenglish(); /* likewise      */
	printgrades();	/* stupid buttons needs updating manually,
			 * EVERY durn time. arrg */

}


