
/* options.c
 *   Handles the options window popup
 *   This handles the meat of the optiosn popup stuff
 */

#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>

#include "defs.h"
#include "externs.h"
#include "game.h"
#include "grades.h"

Widget orderbutton,usefilebutton;
Widget kanjimode,englishmode,togglekana;

Widget options_popup;

/* Assume "True" == 1 !! */
char * orderlabel[2] = {
	"Showing randomly",
	"Showing in order",
};
char * usefilelabel[2] = {
	"No    Usefile",
	"Using Usefile",
};

void ordercallback(Widget w,XtPointer data,XtPointer calldata){
		   showinorder = !showinorder;
		   XtVaSetValues(w,XtNlabel,orderlabel[(int) showinorder],NULL);
		   switch(showinorder){
			case 0:
				setstatus("Will now select kanji randomly");
				break;
			case 1:
				setstatus("Will now go through kanji in order of #");
				break;


		   }
		   return;
}
		   
void usefilecallback(Widget w,XtPointer data,XtPointer calldata){
	char statbuff[300];
		   switch(useUsefile){
			case 1:
				useUsefile = 0;
				if(usefile != NULL)
					setstatus("Will now ignore usefile");
				break;
			case 0:
				if(usefile == NULL){
					setstatus("No usefile to use");
					break;
				}
				useUsefile = 1;
				sprintf(statbuff,"now using usefile %s",
					usefile);
				setstatus(statbuff);
				break;
		   }
		XtVaSetValues(w,XtNlabel,usefilelabel[(int) useUsefile],NULL);
		CountKanji();
		return;
}
		   
/* This gets called after clicking on the "options" button,
 * or with the "o" keyboard accelerator (but not directly, with
 * the keyboard accelerator)
 */
void OptionsCallback(Widget w,XtPointer client_data, XtPointer call_data)
{
	static up = -1;
	static Position rel_x,rel_y;
	Position x,y;

	if(up == -1){
		/* first time init.. */
		rel_x = GetXtNumber("options_popupx","Options_popupx");
		rel_y = GetXtNumber("options_popupy","Options_popupy");
		up = 0;
	}

	if(up == 0)
	{
		XtTranslateCoords(toplevel,rel_x,rel_y,&x,&y);
		XtVaSetValues(options_popup,
		      XtNx,x,
		      XtNy,y,
		      NULL);
		XtPopup(options_popup,XtGrabNone);
		setstatus("Bringing up options window...");
		up = 1;
	} else
	{
		XtPopdown(options_popup);
		up = 0;
	}
}

Widget optionsform;

void MakeOptionsPopup()
{
	extern XtAccelerators AllAccel;

	options_popup = XtVaCreatePopupShell("kdrill_options",
		transientShellWidgetClass,
		toplevel,
		NULL);

	optionsform = XtVaCreateManagedWidget("optionsform",
					      formWidgetClass,
					      options_popup,
					      NULL);

	kanjimode = XtVaCreateManagedWidget(
			"kanjimode",commandWidgetClass, optionsform,
			XtNlabel,"Guess kanji",
			/*XtNfromVert,statusline,*/
			XtNvertDistance,8,
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	englishmode = XtVaCreateManagedWidget(
			"englishmode",commandWidgetClass, optionsform,
			XtNlabel,"Guess Meaning",
			XtNfromVert,kanjimode,
			XtNshapeStyle,XawShapeOval,
			XtNwidth,BUTTONSWIDTH,
			NULL);

	togglekana = XtVaCreateManagedWidget(
			"togglekana",commandWidgetClass,optionsform,
			XtNlabel,"English/Kana",
			XtNshapeStyle,XawShapeOval,
			XtNfromVert,englishmode,
			XtNwidth,BUTTONSWIDTH,
			NULL);



	orderbutton = XtVaCreateManagedWidget("order",commandWidgetClass,optionsform,
			XtNlabel,orderlabel[(int) showinorder],
			XtNvertDistance,8,
			XtNfromVert,togglekana,
			XtNwidth,BUTTONSWIDTH,
			NULL);
	usefilebutton = XtVaCreateManagedWidget("usefile",commandWidgetClass,optionsform,
			XtNlabel,usefilelabel[(int) useUsefile],
			XtNfromVert,orderbutton,
			XtNwidth,BUTTONSWIDTH,
			NULL);



	switch(Kanji2English){
		case GUESSKANJI:
			XtSetSensitive(kanjimode,False);
			break;
		case GUESSMEANING:
			XtSetSensitive(englishmode,False);
			break;
	}

	MakeGradeSelect();
	MakeFrequency();

	XtAddCallback(kanjimode,XtNcallback,ChangeMode,(XtPointer) GUESSKANJI);
	XtAddCallback(englishmode,XtNcallback,ChangeMode,(XtPointer) GUESSMEANING);
	XtAddCallback(togglekana,XtNcallback,ChangeMode,(XtPointer) TOGGLEKANA);
	XtAddCallback(orderbutton,XtNcallback,ordercallback,NULL);
	XtAddCallback(usefilebutton,XtNcallback,usefilecallback,NULL);

	XtAugmentTranslations(options_popup,AllAccel);
	XtSetKeyboardFocus(options_popup,toplevel);
}
