; Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
;
; Super FX assembler emulator code
; (c) Copyright 1998 zsKnight and _Demo_.
;
; Permission to use, copy, modify and distribute Snes9x in both binary and
; source form, for non-commercial purposes, is hereby granted without fee,
; providing that this license information and copyright notice appear with
; all copies and any derived work.
;
; This software is provided 'as-is', without any express or implied
; warranty. In no event shall the authors be held liable for any damages
; arising from the use of this software.
;
; Snes9x is freeware for PERSONAL USE only. Commercial users should
; seek permission of the copyright holders first. Commercial use includes
; charging money for Snes9x or software derived from Snes9x.
;
; The copyright holders request that bug fixes and improvements to the code
; should be forwarded to them so everyone can benefit from the modifications
; in future versions.
;
; Super NES and Super Nintendo Entertainment System are trademarks of
; Nintendo Co., Limited and its subsidiary companies.
;


%macro FXReturn 0
;   dec dword [NumberOfOpcodes]
;   jz %%endloop
   jmp [FxTabled+ecx*4]
;%%endloop
;   jmp FXEndLoop
   ALIGN32
%endmacro

ALIGN32
FxOpd00:     ; STOP   stop GSU execution (and maybe generate an IRQ)     ; Verified.
   FETCHPIPE
   and dword [SfxSFR],0FFFFh-32     ; Clear Go flag (set to 1 when the GSU is running)
   test dword [SfxCFGR],080h        ; Check if the interrupt generation is on
   jnz .NoIRQ
   or dword [SfxSFR],08000h         ; Set IRQ Flag
.NoIRQ
   CLRFLAGS
   inc ebp
   mov dword [NumberOfOpcodes],1
   jmp FXEndLoop
   FXReturn

FxOpd01:     ; NOP    no operation       ; Verified.
   FETCHPIPE
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn

FxOpd02:     ; CACHE  reintialize GSU cache
   mov eax,ebp
   FETCHPIPE
   sub eax,[SfxCPB]
   and eax,0FFF0h
   cmp dword [SfxCBR],eax
   je .SkipUpdate
   cmp byte [SfxCacheActive],1
   je .SkipUpdate
   mov dword [SfxCBR],eax
   mov dword [SfxCacheActive],1
   call FlushCache
.SkipUpdate
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn

FxOpd03:     ; LSR    logic shift right  ; Verified.
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   mov [SfxCarry],al
   and byte[SfxCarry],1
   shr ax,1                      ; logic shift right
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov dword [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd04:     ; ROL    rotate left (RCL?) ; V
   shr byte[SfxCarry],1
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   rcl ax,1
   rcl byte[SfxCarry],1
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd05:     ; BRA    branch always      ; Verified.
   movsx eax,byte[ebp]
   mov cl,[ebp+1]
   inc ebp
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn

FxOpd06:     ; BGE    branch on greater or equals        ; Verified.
   movsx eax,byte[ebp]
   mov ebx,[SfxSignZero]
   shr ebx,15
   inc ebp
   xor bl,[SfxOverflow]
   mov cl,[ebp]
   test bl,01h
   jnz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd07:     ; BLT    branch on lesss than       ; Verified.
   movsx eax,byte[ebp]
   mov ebx,[SfxSignZero]
   shr ebx,15
   inc ebp
   xor bl,[SfxOverflow]
   mov cl,[ebp]
   test bl,01h
   jz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd08:     ; BNE    branch on not equal        ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test dword[SfxSignZero],0FFFFh
   mov cl,[ebp]
   jz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd09:     ; BEQ    branch on equal (z=1)      ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test dword[SfxSignZero],0FFFFh
   mov cl,[ebp]
   jnz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0A:     ; BPL    branch on plus     ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test dword[SfxSignZero],088000h
   mov cl,[ebp]
   jnz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0B:     ; BMI    branch on minus    ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test dword[SfxSignZero],088000h
   mov cl,[ebp]
   jz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0C:     ; BCC    branch on carry clear      ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test byte[SfxCarry],01h
   mov cl,[ebp]
   jnz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0D:     ; BCS    branch on carry set        ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test byte[SfxCarry],01h
   mov cl,[ebp]
   jz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0E:     ; BVC    branch on overflow clear   ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test byte[SfxOverflow],01h
   mov cl,[ebp]
   jnz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

FxOpd0F:     ; BVS    branch on overflow set     ; Verified.
   movsx eax,byte[ebp]
   inc ebp
   test byte[SfxOverflow],01h
   mov cl,[ebp]
   jz .nojump
   add ebp,eax
   call [FxTable+ecx*4]
   FXReturn
.nojump
   inc ebp
   call [FxTable+ecx*4]
   FXReturn

%macro TORNd 1   ; V
   FETCHPIPE
   mov edi, SfxR0+%1*4
   inc ebp                ; Increase program counter
   call [FxTable+ecx*4]
   mov edi,SfxR0
   FXReturn
%endmacro

FxOpd10:     ; TO RN  set register n as destination register
   TORNd 0
FxOpd11:     ; TO RN  set register n as destination register
   TORNd 1   
FxOpd12:     ; TO RN  set register n as destination register
   TORNd 2   
FxOpd13:     ; TO RN  set register n as destination register
   TORNd 3   
FxOpd14:     ; TO RN  set register n as destination register
   TORNd 4   
FxOpd15:     ; TO RN  set register n as destination register
   TORNd 5   
FxOpd16:     ; TO RN  set register n as destination register
   TORNd 6   
FxOpd17:     ; TO RN  set register n as destination register
   TORNd 7   
FxOpd18:     ; TO RN  set register n as destination register
   TORNd 8   
FxOpd19:     ; TO RN  set register n as destination register
   TORNd 9   
FxOpd1A:     ; TO RN  set register n as destination register
   TORNd 10   
FxOpd1B:     ; TO RN  set register n as destination register
   TORNd 11   
FxOpd1C:     ; TO RN  set register n as destination register
   TORNd 12   
FxOpd1D:     ; TO RN  set register n as destination register
   TORNd 13
FxOpd1E:     ; TO RN  set register n as destination register
   FETCHPIPE
   mov edi,SfxR0+14*4
   inc ebp
   call [FxTable+ecx*4]
   mov edi,SfxR0
   UpdateR14
   FXReturn
FxOpd1F:     ; TO RN  set register n as destination register
   FETCHPIPE
   mov edi,SfxR0+15*4
   inc ebp
   call [FxTable+ecx*4]
   mov ebp,[SfxCPB]
   add ebp,[SfxR15]
   mov edi,SfxR0
   FXReturn

%macro WITHc 1  ; Verified.
   FETCHPIPE
   mov esi,SfxR0+%1*4
   mov edi,SfxR0+%1*4
   mov dword [SfxB],1
   inc ebp                ; Increase program counter
   call [FxTablec+ecx*4]
   mov esi,SfxR0
   mov edi,SfxR0
   mov dword [SfxB],0         ; Clear B Flag
   FXReturn
%endmacro

FxOpd20:     ; WITH  set register n as source and destination register
   WITHc 0
FxOpd21:     ; WITH  set register n as source and destination register
   WITHc 1
FxOpd22:     ; WITH  set register n as source and destination register
   WITHc 2
FxOpd23:     ; WITH  set register n as source and destination register
   WITHc 3
FxOpd24:     ; WITH  set register n as source and destination register
   WITHc 4
FxOpd25:     ; WITH  set register n as source and destination register
   WITHc 5
FxOpd26:     ; WITH  set register n as source and destination register
   WITHc 6
FxOpd27:     ; WITH  set register n as source and destination register
   WITHc 7
FxOpd28:     ; WITH  set register n as source and destination register
   WITHc 8
FxOpd29:     ; WITH  set register n as source and destination register
   WITHc 9
FxOpd2A:     ; WITH  set register n as source and destination register
   WITHc 10
FxOpd2B:     ; WITH  set register n as source and destination register
   WITHc 11
FxOpd2C:     ; WITH  set register n as source and destination register
   WITHc 12
FxOpd2D:     ; WITH  set register n as source and destination register
   WITHc 13
FxOpd2E:     ; WITH  set register n as source and destination register
   FETCHPIPE
   mov esi,SfxR0+14*4
   mov edi,SfxR0+14*4
   mov dword [SfxB],1
   inc ebp
   call [FxTablec+ecx*4]
   mov dword [SfxB],0         ; Clear B Flag
   mov esi,SfxR0
   mov edi,SfxR0
   UpdateR14
   FXReturn
FxOpd2F:     ; WITH  set register n as source and destination register
   FETCHPIPE
   mov esi,SfxR0+15*4
   mov edi,SfxR0+15*4
   mov dword [SfxB],1
   inc ebp
   mov eax,ebp
   sub eax,[SfxCPB]
   mov dword[withr15sk],0
   mov [SfxR15],eax
   call [FxTableb+ecx*4]
   cmp dword[withr15sk],1
   je .skip
   mov ebp,[SfxCPB]
   add ebp,[SfxR15]
.skip
   mov dword [SfxB],0         ; Clear B Flag
   mov esi,SfxR0
   mov edi,SfxR0
   FXReturn

%macro STWRNc 1  ; V
   mov eax,[SfxR0+%1*4]             ; Read register
   mov ebx,[SfxRAMMem]
   mov dword [SfxLastRamAdr],eax    ; Save last ram address
   add dword [SfxLastRamAdr],ebx    ; Save last ram address
   mov edx,[esi]            ; Read Source
   FETCHPIPE
   mov [ebx+eax],dl         ; Store Word
   xor eax,1
   inc ebp                ; Increase program counter
   mov [ebx+eax],dh         ; Store Word
   CLRFLAGS
   FXReturn
%endmacro

FxOpd30:     ; STW RN store word
   STWRNc 0
FxOpd31:     ; STW RN store word
   STWRNc 1
FxOpd32:     ; STW RN store word
   STWRNc 2
FxOpd33:     ; STW RN store word
   STWRNc 3
FxOpd34:     ; STW RN store word
   STWRNc 4
FxOpd35:     ; STW RN store word
   STWRNc 5
FxOpd36:     ; STW RN store word
   STWRNc 6
FxOpd37:     ; STW RN store word
   STWRNc 7
FxOpd38:     ; STW RN store word
   STWRNc 8
FxOpd39:     ; STW RN store word
   STWRNc 9
FxOpd3A:     ; STW RN store word
   STWRNc 10
FxOpd3B:     ; STW RN store word
   STWRNc 11

%macro STBRNc 1  ; V
   mov eax,[SfxR0+%1*4]             ; Read register
   FETCHPIPE
   add eax,[SfxRAMMem]
   mov dword [SfxLastRamAdr],eax    ; Save last ram address
   mov ebx,[esi]            ; Read Source
   mov byte [eax],bl         ; Store Byte
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn
%endmacro

FxOpd30A1:   ; STB RN store byte
   STBRNc 0
FxOpd31A1:   ; STB RN store byte
   STBRNc 1
FxOpd32A1:   ; STB RN store byte
   STBRNc 2
FxOpd33A1:   ; STB RN store byte
   STBRNc 3
FxOpd34A1:   ; STB RN store byte
   STBRNc 4
FxOpd35A1:   ; STB RN store byte
   STBRNc 5
FxOpd36A1:   ; STB RN store byte
   STBRNc 6
FxOpd37A1:   ; STB RN store byte
   STBRNc 7
FxOpd38A1:   ; STB RN store byte
   STBRNc 8
FxOpd39A1:   ; STB RN store byte
   STBRNc 9
FxOpd3AA1:   ; STB RN store byte
   STBRNc 10
FxOpd3BA1:   ; STB RN store byte
   STBRNc 11

FxOpd3C:     ; LOOP   decrement loop counter, and branch on not zero ; V
   dec word [SfxR12]       ; decrement loop counter
   FETCHPIPE
   mov eax,[SfxR12]
   mov [SfxSignZero],eax
   or eax,eax
   jz .NoBranch
   mov eax,dword [SfxR13]
   mov ebp,[SfxCPB]
   add ebp,eax
   CLRFLAGS
   FXReturn
.NoBranch
   inc ebp
   CLRFLAGS
   FXReturn

FxOpd3D:     ; ALT1   set alt1 mode      ; Verified.
   FETCHPIPE
   mov dword [SfxB],0
   or ch,01h
   inc ebp
   call [FxTable+ecx*4]
   xor ch,ch
   FXReturn

FxOpd3E:     ; ALT2   set alt1 mode      ; Verified.
   FETCHPIPE
   mov dword [SfxB],0
   or ch,02h
   inc ebp
   call [FxTable+ecx*4]
   xor ch,ch
   FXReturn

FxOpd3F:     ; ALT3   set alt3 mode      ; Verified.
   FETCHPIPE
   mov dword [SfxB],0
   or ch,03h
   inc ebp
   call [FxTable+ecx*4]
   xor ch,ch
   FXReturn

%macro LDWRNc 1  ; V
   mov eax,[SfxR0+%1*4]             ; Read register
   mov ebx,[SfxRAMMem]
   mov dword [SfxLastRamAdr],eax    ; Save last ram address
   FETCHPIPE
   mov dl,[ebx+eax]         ; Store Word
   add dword [SfxLastRamAdr],ebx    ; Save last ram address
   xor eax,1
   and edx,0FFFFh
   inc ebp                ; Increase program counter
   mov dh,[ebx+eax]         ; Store Word
   mov [edi],edx            ; Read Source
   CLRFLAGS
   FXReturn
%endmacro

FxOpd40:     ; LDW RN load word from RAM
   LDWRNc 0
FxOpd41:     ; LDW RN load word from RAM
   LDWRNc 1
FxOpd42:     ; LDW RN load word from RAM
   LDWRNc 2
FxOpd43:     ; LDW RN load word from RAM
   LDWRNc 3
FxOpd44:     ; LDW RN load word from RAM
   LDWRNc 4
FxOpd45:     ; LDW RN load word from RAM
   LDWRNc 5
FxOpd46:     ; LDW RN load word from RAM
   LDWRNc 6
FxOpd47:     ; LDW RN load word from RAM
   LDWRNc 7
FxOpd48:     ; LDW RN load word from RAM
   LDWRNc 8
FxOpd49:     ; LDW RN load word from RAM
   LDWRNc 9
FxOpd4A:     ; LDW RN load word from RAM
   LDWRNc 10
FxOpd4B:     ; LDW RN load word from RAM
   LDWRNc 11

%macro LDBRNc 1  ; V
   mov eax,[SfxR0+%1*4]             ; Read register
   FETCHPIPE
   add eax,[SfxRAMMem]
   xor ebx,ebx
   mov dword [SfxLastRamAdr],eax    ; Save last ram address
   mov bl,[eax]                     ; Read Byte
   inc ebp                ; Increase program counter
   mov [edi],ebx            ; Store Result
   CLRFLAGS
   FXReturn
%endmacro

FxOpd40A1:   ; LDB RN load byte from RAM
   LDBRNc 0   
FxOpd41A1:   ; LDB RN load byte from RAM
   LDBRNc 1 
FxOpd42A1:   ; LDB RN load byte from RAM
   LDBRNc 2   
FxOpd43A1:   ; LDB RN load byte from RAM
   LDBRNc 3   
FxOpd44A1:   ; LDB RN load byte from RAM
   LDBRNc 4   
FxOpd45A1:   ; LDB RN load byte from RAM
   LDBRNc 5
FxOpd46A1:   ; LDB RN load byte from RAM
   LDBRNc 6   
FxOpd47A1:   ; LDB RN load byte from RAM
   LDBRNc 7   
FxOpd48A1:   ; LDB RN load byte from RAM
   LDBRNc 8
FxOpd49A1:   ; LDB RN load byte from RAM
   LDBRNc 9
FxOpd4AA1:   ; LDB RN load byte from RAM
   LDBRNc 10
FxOpd4BA1:   ; LDB RN load byte from RAM
   LDBRNc 11

FxOpd4C:     ; PLOT   plot pixel with R1,R2 as x,y and the color register as the color
   FETCHPIPE
   inc ebp
   CLRFLAGS
   mov ebx,[SfxR2]
   mov bh,[SfxR1]
   test byte[SfxPOR],10h
   jnz .objmode
   mov al,[SfxSCMR]
   and al,00100100b     ; 4 + 32
   cmp al,4
   je .lines160
   cmp al,32
   je .lines192
   cmp al,36
   je .objmode
   mov eax,[sfx128lineloc]
   jmp .donelines
.lines160
   mov eax,[sfx160lineloc]
   jmp .donelines
.lines192
   mov eax,[sfx192lineloc]
   jmp .donelines
.objmode
   mov eax,[sfxobjlineloc]
.donelines
   mov ebx,[eax+ebx*4]
   cmp ebx,0FFFFFFFFh
   je near .nodraw
   xor eax,eax
   ; bits 5/2 : 00 = 128 pixels, 01 = 160 pixels, 10 = 192 pixels, 11 = obj
   ; bits 1/0 : 00 = 4 color, 01 = 16-color, 10 = not used, 11 = 256 color
   ; 192 pixels = 24 tiles, 160 pixels = 20 tiles, 128 pixels = 16 tiles
   ;              16+8(4/3)              16+4(4/2)              16(4/0)
   push ecx
   mov al,[SfxSCMR]
   and al,00000011b     ; 4 + 32
   cmp al,0
   je near .colors4
   cmp al,3
   je near .colors256

   shl ebx,5    ; x32 (16 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   mov bh,bl
   xor bh,0FFh
   pop ecx
   test byte[SfxPOR],01h
   jnz .nozerocheck_16
   test byte[SfxCOLR],0Fh
   jz .nodraw
.nozerocheck_16
   mov dl,[SfxCOLR]
   test byte[SfxPOR],02h
   jz .nodither4b
   mov dh,[SfxR1]
   xor dh,[SfxR2]
   test dh,01h
   jz .nodither4b
   shr dh,4
.nodither4b
   and byte[eax],bh
   and byte[eax+1],bh
   and byte[eax+16],bh
   and byte[eax+17],bh
   test dl,01h
   jz .nodraw_16
   or byte[eax],   bl
.nodraw_16
   test dl,02h
   jz .nodraw2_16
   or byte[eax+1], bl
.nodraw2_16
   test dl,04h
   jz .nodraw3_16
   or byte[eax+16],bl
.nodraw3_16
   test dl,08h
   jz .nodraw4_16
   or byte[eax+17],bl
.nodraw4_16
.nodraw
   inc word [SfxR1]
   FXReturn

.colors4
   shl ebx,4    ; x16 (4 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   mov bh,bl
   xor bh,0FFh
   pop ecx
   test byte[SfxPOR],01h
   jnz .nozerocheck_4
   test byte[SfxCOLR],03h
   jz .noplot_4
.nozerocheck_4
   mov dl,[SfxCOLR]
   test byte[SfxPOR],02h
   jz .nodither2b
   mov dh,[SfxR1]
   xor dh,[SfxR2]
   test dh,01h
   jz .nodither2b
   shr dh,4
.nodither2b
   and byte[eax],bh
   and byte[eax+1],bh
   test dl,01h
   jz .nodraw_4
   or byte[eax],   bl
.nodraw_4
   test dl,02h
   jz .nodraw2_4
   or byte[eax+1], bl
.nodraw2_4
.noplot_4
   inc word [SfxR1]
   FXReturn

.colors256
   shl ebx,6    ; x64 (256 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   mov bh,bl
   xor bh,0FFh
   pop ecx
   test byte[SfxPOR],01h
   jnz .nozerocheck_256
   mov dl,0FFh
   test byte[SfxPOR],08h
   jz .nozerocheckb_256
   mov dl,0Fh
.nozerocheckb_256
   test byte[SfxCOLR],dl
   jz .noplot_256
.nozerocheck_256
   mov dl,[SfxCOLR]
   and byte[eax],bh
   and byte[eax+1],bh
   and byte[eax+16],bh
   and byte[eax+17],bh
   and byte[eax+32],bh
   and byte[eax+33],bh
   and byte[eax+48],bh
   and byte[eax+49],bh
   test dl,01h
   jz .nodraw_256
   or byte[eax],   bl
.nodraw_256
   test dl,02h
   jz .nodraw2_256
   or byte[eax+1], bl
.nodraw2_256
   test dl,04h
   jz .nodraw3_256
   or byte[eax+16],bl
.nodraw3_256
   test dl,08h
   jz .nodraw4_256
   or byte[eax+17],bl
.nodraw4_256
   test dl,10h
   jz .nodraw5_256
   or byte[eax+32],   bl
.nodraw5_256
   test dl,20h
   jz .nodraw6_256
   or byte[eax+33], bl
.nodraw6_256
   test dl,40h
   jz .nodraw7_256
   or byte[eax+48],bl
.nodraw7_256
   test dl,80h
   jz .nodraw8_256
   or byte[eax+49],bl
.nodraw8_256
.noplot_256
   inc word [SfxR1]
   FXReturn

SECTION .data
.prevx dw 0
.prevy dw 0
SECTION .text

FxOpd4CA1:   ; RPIX   read color of the pixel with R1,R2 as x,y
   FETCHPIPE
   mov ebx,[SfxR2]
   mov bh,[SfxR1]
   test byte[SfxPOR],10h
   jnz .objmode
   mov al,[SfxSCMR]
   and al,00100100b     ; 4 + 32
   cmp al,4
   je .lines160
   cmp al,32
   je .lines192
   cmp al,36
   je .objmode
   mov eax,[sfx128lineloc]
   jmp .donelines
.lines160
   mov eax,[sfx160lineloc]
   jmp .donelines
.lines192
   mov eax,[sfx192lineloc]
   jmp .donelines
.objmode
   mov eax,[sfxobjlineloc]
.donelines
   mov ebx,[eax+ebx*4]
   cmp ebx,0FFFFFFFFh
   je near .nodraw
   xor eax,eax
   ; bits 5/2 : 00 = 128 pixels, 01 = 160 pixels, 10 = 192 pixels, 11 = obj
   ; bits 1/0 : 00 = 4 color, 01 = 16-color, 10 = not used, 11 = 256 color
   ; 192 pixels = 24 tiles, 160 pixels = 20 tiles, 128 pixels = 16 tiles
   ;              16+8(4/3)              16+4(4/2)              16(4/0)
   push ecx
   mov al,[SfxSCMR]
   and al,00000011b     ; 4 + 32

   cmp al,0
   je near .colors4
   cmp al,3
   je near .colors256

   shl ebx,5    ; x32 (16 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   pop ecx
   xor bh,bh
   test byte[eax],bl
   jz .nodraw_16
   or bh,01h
.nodraw_16
   test byte[eax+1],bl
   jz .nodraw2_16
   or bh,02h
.nodraw2_16
   test byte[eax+16],bl
   jz .nodraw3_16
   or bh,04h
.nodraw3_16
   test byte[eax+17],bl
   jz .nodraw4_16
   or bh,08h
.nodraw4_16
.nodraw
   mov bl,bh
   and ebx,0FFh
   inc ebp
;   UpdateR14
   CLRFLAGS
   mov [edi],ebx            ; Write Destination
   mov [flagnz],ebx
   FXReturn

.colors4
   shl ebx,4    ; x16 (4 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   mov bh,bl
   xor bh,0FFh
   pop ecx
   xor bh,bh
   test byte[eax],bl
   jz .nodraw_4
   or bh,01h
.nodraw_4
   test byte[eax+1],bl
   jz .nodraw2_4
   or bh,02h
.nodraw2_4
   mov bl,bh
   and ebx,0FFh
   inc ebp
;   UpdateR14
   CLRFLAGS
   mov [edi],ebx            ; Write Destination
   mov [flagnz],ebx
   FXReturn

.colors256
   shl ebx,6    ; x64 (256 colors)
   mov al,[SfxSCBR]
   shl eax,10   ; Get SFX address
   add eax,ebx
   add eax,[sfxramdata]
   mov ebx,[SfxR2]
   and ebx,07h
   shl ebx,1
   add eax,ebx
   mov cl,[SfxR1]
   and cl,07h
   xor cl,07h
   mov bl,1
   shl bl,cl
   mov bh,bl
   xor bh,0FFh
   pop ecx
   xor bh,bh
   test byte[eax],bl
   jz .nodraw_256
   or bh,01h
.nodraw_256
   test byte[eax+1],bl
   jz .nodraw2_256
   or bh,02h
.nodraw2_256
   test byte[eax+16],bl
   jz .nodraw3_256
   or bh,04h
.nodraw3_256
   test byte[eax+17],bl
   jz .nodraw4_256
   or bh,08h
.nodraw4_256
   test byte[eax+32],bl
   jz .nodraw5_256
   or bh,10h
.nodraw5_256
   test byte[eax+33],bl
   jz .nodraw6_256
   or bh,20h
.nodraw6_256
   test byte[eax+48],bl
   jz .nodraw7_256
   or bh,40h
.nodraw7_256
   test byte[eax+49],bl
   jz .nodraw8_256
   or bh,80h
.nodraw8_256
   mov bl,bh
   and ebx,0FFh
   inc ebp
;   UpdateR14
   CLRFLAGS
   mov [edi],ebx            ; Write Destination
   mov [flagnz],ebx
   FXReturn

FxOpd4D:     ; SWAP   swap upper and lower byte of a register    ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   ror ax,8   
   inc ebp                ; Increase program counter
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

FxOpd4E:     ; COLOR  copy source register to color register     ; V
   FETCHPIPE
   mov eax,[esi]            ; Read Source
   ; if bit 3 of SfxPOR is set, then don't modify the upper 4 bits
   test byte[SfxPOR],04h
   jz .nohighnibble
   mov bl,al
   shr bl,4
   and al,0F0h
   or al,bl
.nohighnibble
   test byte[SfxPOR],08h
   jnz .preserveupper
   mov [SfxCOLR],al
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn
.preserveupper
   mov bl,[SfxCOLR]
   and al,0Fh
   and bl,0F0h
   or al,bl
   mov [SfxCOLR],al
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn

FxOpd4EA1:   ; CMODE  set plot option register ; V
   FETCHPIPE
   mov eax,[esi]            ; Read Source
   inc ebp                ; Increase program counter
   mov dword [SfxPOR],eax
   CLRFLAGS
   FXReturn

FxOpd4F:     ; NOT    perform exclusive exor with 1 on all bits  ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   xor eax,0FFFFh
   inc ebp                ; Increase program counter
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

%macro ADDRNc 1  ; V
   mov eax, [esi]    ; Read Source
   mov ebx, [SfxR0+%1*4]
   FETCHPIPE
   add ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd50:     ; ADD RN add, register + register
   ADDRNc 0
FxOpd51:     ; ADD RN add, register + register
   ADDRNc 1
FxOpd52:     ; ADD RN add, register + register
   ADDRNc 2
FxOpd53:     ; ADD RN add, register + register
   ADDRNc 3
FxOpd54:     ; ADD RN add, register + register
   ADDRNc 4
FxOpd55:     ; ADD RN add, register + register
   ADDRNc 5
FxOpd56:     ; ADD RN add, register + register
   ADDRNc 6
FxOpd57:     ; ADD RN add, register + register
   ADDRNc 7
FxOpd58:     ; ADD RN add, register + register
   ADDRNc 8
FxOpd59:     ; ADD RN add, register + register
   ADDRNc 9
FxOpd5A:     ; ADD RN add, register + register
   ADDRNc 10
FxOpd5B:     ; ADD RN add, register + register
   ADDRNc 11
FxOpd5C:     ; ADD RN add, register + register
   ADDRNc 12
FxOpd5D:     ; ADD RN add, register + register
   ADDRNc 13
FxOpd5E:     ; ADD RN add, register + register
   ADDRNc 14
FxOpd5F:     ; ADD RN add, register + register
   FETCHPIPE
   mov eax, [esi]    ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   add ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn

%macro ADCRNc 1  ; V
   FETCHPIPE
   mov eax, [esi]    ; Read Source
   mov ebx, [SfxR0+%1*4]
   shr byte[SfxCarry],1
   adc ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd50A1:   ; ADC RN add with carry, register + register
   ADCRNc 0
FxOpd51A1:   ; ADC RN add with carry, register + register
   ADCRNc 1
FxOpd52A1:   ; ADC RN add with carry, register + register
   ADCRNc 2
FxOpd53A1:   ; ADC RN add with carry, register + register
   ADCRNc 3
FxOpd54A1:   ; ADC RN add with carry, register + register
   ADCRNc 4
FxOpd55A1:   ; ADC RN add with carry, register + register
   ADCRNc 5
FxOpd56A1:   ; ADC RN add with carry, register + register
   ADCRNc 6
FxOpd57A1:   ; ADC RN add with carry, register + register
   ADCRNc 7
FxOpd58A1:   ; ADC RN add with carry, register + register
   ADCRNc 8
FxOpd59A1:   ; ADC RN add with carry, register + register
   ADCRNc 9
FxOpd5AA1:   ; ADC RN add with carry, register + register
   ADCRNc 10
FxOpd5BA1:   ; ADC RN add with carry, register + register
   ADCRNc 11
FxOpd5CA1:   ; ADC RN add with carry, register + register
   ADCRNc 12
FxOpd5DA1:   ; ADC RN add with carry, register + register
   ADCRNc 13
FxOpd5EA1:   ; ADC RN add with carry, register + register
   ADCRNc 14
FxOpd5FA1:   ; ADC RN add with carry, register + register
   FETCHPIPE
   mov eax, [esi]    ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   shr byte[SfxCarry],1
   adc ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn

%macro ADIRNc 1  ; V
   mov eax, [esi]    ; Read Source
   FETCHPIPE
   add ax,%1
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

; Weird Opdode (FxOpd50A2, add 0, wow!)
FxOpd50A2:   ; ADI RN add, register + immediate
   ADIRNc 0
FxOpd51A2:   ; ADI RN add, register + immediate
   ADIRNc 1
FxOpd52A2:   ; ADI RN add, register + immediate
   ADIRNc 2
FxOpd53A2:   ; ADI RN add, register + immediate
   ADIRNc 3
FxOpd54A2:   ; ADI RN add, register + immediate
   ADIRNc 4
FxOpd55A2:   ; ADI RN add, register + immediate
   ADIRNc 5
FxOpd56A2:   ; ADI RN add, register + immediate
   ADIRNc 6
FxOpd57A2:   ; ADI RN add, register + immediate
   ADIRNc 7
FxOpd58A2:   ; ADI RN add, register + immediate
   ADIRNc 8
FxOpd59A2:   ; ADI RN add, register + immediate
   ADIRNc 9
FxOpd5AA2:   ; ADI RN add, register + immediate
   ADIRNc 10
FxOpd5BA2:   ; ADI RN add, register + immediate
   ADIRNc 11
FxOpd5CA2:   ; ADI RN add, register + immediate
   ADIRNc 12
FxOpd5DA2:   ; ADI RN add, register + immediate
   ADIRNc 13
FxOpd5EA2:   ; ADI RN add, register + immediate
   ADIRNc 14
FxOpd5FA2:   ; ADI RN add, register + immediate
   ADIRNc 15

%macro ADCIRNc 1 ; V
   FETCHPIPE
   mov eax, [esi]    ; Read Source
   shr byte[SfxCarry],1
   adc ax,%1
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   mov [SfxSignZero],eax
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

; Another very useful Opdode
FxOpd50A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 0
FxOpd51A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 1
FxOpd52A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 2
FxOpd53A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 3
FxOpd54A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 4
FxOpd55A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 5
FxOpd56A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 6
FxOpd57A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 7
FxOpd58A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 8
FxOpd59A3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 9
FxOpd5AA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 10
FxOpd5BA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 11
FxOpd5CA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 12
FxOpd5DA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 13
FxOpd5EA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 14
FxOpd5FA3:   ; ADCIRN add with carry, register + immediate
   ADCIRNc 15

%macro SUBRNc 1  ; V
   mov eax,[esi]    ; Read Source
   mov ebx,[SfxR0+%1*4]
   FETCHPIPE
   sub ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   inc ebp                   ; Increase program counter
   mov [edi],eax                        ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpd60:     ; SUBRN  subtract, register - register
   SUBRNc 0
FxOpd61:     ; SUBRN  subtract, register - register
   SUBRNc 1
FxOpd62:     ; SUBRN  subtract, register - register
   SUBRNc 2
FxOpd63:     ; SUBRN  subtract, register - register
   SUBRNc 3
FxOpd64:     ; SUBRN  subtract, register - register
   SUBRNc 4
FxOpd65:     ; SUBRN  subtract, register - register
   SUBRNc 5
FxOpd66:     ; SUBRN  subtract, register - register
   SUBRNc 6
FxOpd67:     ; SUBRN  subtract, register - register
   SUBRNc 7
FxOpd68:     ; SUBRN  subtract, register - register
   SUBRNc 8
FxOpd69:     ; SUBRN  subtract, register - register
   SUBRNc 9
FxOpd6A:     ; SUBRN  subtract, register - register
   SUBRNc 10
FxOpd6B:     ; SUBRN  subtract, register - register
   SUBRNc 11
FxOpd6C:     ; SUBRN  subtract, register - register
   SUBRNc 12
FxOpd6D:     ; SUBRN  subtract, register - register
   SUBRNc 13
FxOpd6E:     ; SUBRN  subtract, register - register
   SUBRNc 14
FxOpd6F:     ; SUBRN  subtract, register - register
   FETCHPIPE
   mov eax,[esi]    ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   sub ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   inc ebp                   ; Increase program counter
   mov [edi],eax                        ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

%macro SBCRNc 1  ; V
   FETCHPIPE
   mov eax,[esi]    ; Read Source
   mov ebx,[SfxR0+%1*4]
   cmp byte[SfxCarry],1
   sbb ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpd60A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 0
FxOpd61A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 1
FxOpd62A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 2
FxOpd63A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 3
FxOpd64A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 4
FxOpd65A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 5
FxOpd66A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 6
FxOpd67A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 7
FxOpd68A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 8
FxOpd69A1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 9
FxOpd6AA1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 10
FxOpd6BA1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 11
FxOpd6CA1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 12
FxOpd6DA1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 13
FxOpd6EA1:   ; SBCRN  subtract with carry, register - register
   SBCRNc 14
FxOpd6FA1:   ; SBCRN  subtract with carry, register - register
   mov eax,[esi]    ; Read Source
   mov ebx,ebp
   FETCHPIPE
   sub ebx,[SfxCPB]
   cmp byte[SfxCarry],1
   sbb ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

%macro SUBIRNc 1 ; V
   mov eax,[esi]    ; Read Source
   FETCHPIPE
   sub ax,%1
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   inc ebp                ; Increase program counter
   mov [edi],eax      ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpd60A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 0
FxOpd61A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 1
FxOpd62A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 2
FxOpd63A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 3
FxOpd64A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 4
FxOpd65A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 5
FxOpd66A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 6
FxOpd67A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 7
FxOpd68A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 8
FxOpd69A2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 9
FxOpd6AA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 10
FxOpd6BA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 11
FxOpd6CA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 12
FxOpd6DA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 13
FxOpd6EA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 14
FxOpd6FA2:   ; SUBIRN subtract, register - immediate
   SUBIRNc 15

%macro CMPRNc 1  ; V
   mov eax,[esi]    ; Read Source
   mov ebx,[SfxR0+%1*4]
   FETCHPIPE
   sub ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   mov [SfxSignZero],eax
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn
%endmacro

FxOpd60A3:   ; CMPRN  compare, register, register
   CMPRNc 0
FxOpd61A3:   ; CMPRN  compare, register, register
   CMPRNc 1
FxOpd62A3:   ; CMPRN  compare, register, register
   CMPRNc 2
FxOpd63A3:   ; CMPRN  compare, register, register
   CMPRNc 3
FxOpd64A3:   ; CMPRN  compare, register, register
   CMPRNc 4
FxOpd65A3:   ; CMPRN  compare, register, register
   CMPRNc 5
FxOpd66A3:   ; CMPRN  compare, register, register
   CMPRNc 6
FxOpd67A3:   ; CMPRN  compare, register, register
   CMPRNc 7
FxOpd68A3:   ; CMPRN  compare, register, register
   CMPRNc 8
FxOpd69A3:   ; CMPRN  compare, register, register
   CMPRNc 9
FxOpd6AA3:   ; CMPRN  compare, register, register
   CMPRNc 10
FxOpd6BA3:   ; CMPRN  compare, register, register
   CMPRNc 11
FxOpd6CA3:   ; CMPRN  compare, register, register
   CMPRNc 12
FxOpd6DA3:   ; CMPRN  compare, register, register
   CMPRNc 13
FxOpd6EA3:   ; CMPRN  compare, register, register
   CMPRNc 14
FxOpd6FA3:   ; CMPRN  compare, register, register
   FETCHPIPE
   mov eax,[esi]    ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   sub ax,bx
   seto byte[SfxOverflow]
   setc byte[SfxCarry]
   xor byte[SfxCarry],1
   mov [SfxSignZero],eax
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn

FxOpd70:     ; MERGE  R7 as upper byte, R8 as lower byte (used for texture-mapping) */
            ; V
   xor eax,eax
   FETCHPIPE
   mov ah,byte [SfxR7+1]
   mov al,byte [SfxR8+1]
   inc ebp
   mov [edi],eax            ; Write Destination
   mov dword[SfxSignZero],0001h
   test eax,0F0F0h
   jz .nozero
   mov dword[SfxSignZero],0000h
.nozero
   test eax,08080h
   jz .nosign
   or dword [SfxSignZero],80000h
.nosign
   mov dword [SfxOverflow],1
   test ax,0c0c0h
   jnz .Overflow
   mov dword [SfxOverflow],0
.Overflow
   mov dword [SfxCarry],1
   test ax,0e0e0h
   jnz .Carry
   mov dword [SfxCarry],0
.Carry
   CLRFLAGS
   FXReturn

%macro ANDRNc 1  ; V
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxR0+%1*4]             ; Read RN
   FETCHPIPE
   and eax,ebx
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd71:     ; AND RN register & register
   ANDRNc 1
FxOpd72:     ; AND RN register & register
   ANDRNc 2
FxOpd73:     ; AND RN register & register
   ANDRNc 3
FxOpd74:     ; AND RN register & register
   ANDRNc 4
FxOpd75:     ; AND RN register & register
   ANDRNc 5
FxOpd76:     ; AND RN register & register
   ANDRNc 6
FxOpd77:     ; AND RN register & register
   ANDRNc 7
FxOpd78:     ; AND RN register & register
   ANDRNc 8
FxOpd79:     ; AND RN register & register
   ANDRNc 9
FxOpd7A:     ; AND RN register & register
   ANDRNc 10
FxOpd7B:     ; AND RN register & register
   ANDRNc 11
FxOpd7C:     ; AND RN register & register
   ANDRNc 12
FxOpd7D:     ; AND RN register & register
   ANDRNc 13
FxOpd7E:     ; AND RN register & register
   ANDRNc 14
FxOpd7F:     ; AND RN register & register
   FETCHPIPE
   mov eax,[esi]            ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   and eax,ebx
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

%macro BICRNc 1  ; V
   mov ebx,[SfxR0+%1*4]             ; Read RN
   mov eax,[esi]            ; Read Source
   xor ebx,0FFFFh
   FETCHPIPE
   and eax,ebx
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd71A1:   ; BIC RN register & ~register
   BICRNc 1
FxOpd72A1:   ; BIC RN register & ~register
   BICRNc 2
FxOpd73A1:   ; BIC RN register & ~register
   BICRNc 3
FxOpd74A1:   ; BIC RN register & ~register
   BICRNc 4
FxOpd75A1:   ; BIC RN register & ~register
   BICRNc 5
FxOpd76A1:   ; BIC RN register & ~register
   BICRNc 6
FxOpd77A1:   ; BIC RN register & ~register
   BICRNc 7
FxOpd78A1:   ; BIC RN register & ~register
   BICRNc 8
FxOpd79A1:   ; BIC RN register & ~register
   BICRNc 9
FxOpd7AA1:   ; BIC RN register & ~register
   BICRNc 10
FxOpd7BA1:   ; BIC RN register & ~register
   BICRNc 11
FxOpd7CA1:   ; BIC RN register & ~register
   BICRNc 12
FxOpd7DA1:   ; BIC RN register & ~register
   BICRNc 13
FxOpd7EA1:   ; BIC RN register & ~register
   BICRNc 14
FxOpd7FA1:   ; BIC RN register & ~register
   FETCHPIPE
   mov ebx,ebp
   sub ebx,[SfxCPB]
   mov eax,[esi]            ; Read Source
   xor ebx,0FFFFh
   and eax,ebx
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

%macro ANDIRNc 1 ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   and eax,%1
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd71A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 1
FxOpd72A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 2
FxOpd73A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 3
FxOpd74A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 4
FxOpd75A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 5
FxOpd76A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 6
FxOpd77A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 7
FxOpd78A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 8
FxOpd79A2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 9
FxOpd7AA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 10
FxOpd7BA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 11
FxOpd7CA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 12
FxOpd7DA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 13
FxOpd7EA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 14
FxOpd7FA2:   ; ANDIRNc and #n - register & immediate
   ANDIRNc 15

%macro BICIRNc 1 ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   and eax,%1
   inc ebp
   mov dword [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd71A3:   ; BICIRNc register & ~immediate
   BICIRNc 1 ^ 0FFFFh
FxOpd72A3:   ; BICIRNc register & ~immediate
   BICIRNc 2 ^ 0FFFFh
FxOpd73A3:   ; BICIRNc register & ~immediate
   BICIRNc 3 ^ 0FFFFh
FxOpd74A3:   ; BICIRNc register & ~immediate
   BICIRNc 4 ^ 0FFFFh
FxOpd75A3:   ; BICIRNc register & ~immediate
   BICIRNc 5 ^ 0FFFFh
FxOpd76A3:   ; BICIRNc register & ~immediate
   BICIRNc 6 ^ 0FFFFh
FxOpd77A3:   ; BICIRNc register & ~immediate
   BICIRNc 7 ^ 0FFFFh
FxOpd78A3:   ; BICIRNc register & ~immediate
   BICIRNc 8 ^ 0FFFFh
FxOpd79A3:   ; BICIRNc register & ~immediate
   BICIRNc 9 ^ 0FFFFh
FxOpd7AA3:   ; BICIRNc register & ~immediate
   BICIRNc 10 ^ 0FFFFh
FxOpd7BA3:   ; BICIRNc register & ~immediate
   BICIRNc 11 ^ 0FFFFh
FxOpd7CA3:   ; BICIRNc register & ~immediate
   BICIRNc 12 ^ 0FFFFh
FxOpd7DA3:   ; BICIRNc register & ~immediate
   BICIRNc 13 ^ 0FFFFh
FxOpd7EA3:   ; BICIRNc register & ~immediate
   BICIRNc 14 ^ 0FFFFh
FxOpd7FA3:   ; BICIRNc register & ~immediate
   BICIRNc 15 ^ 0FFFFh

%macro MULTRNc 1 ; V
   mov al,byte [esi]     ; Read Source
   mov bl,byte [SfxR0+%1*4]      ; Read RN
   FETCHPIPE
   imul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd80:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 0 
FxOpd81:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 1 
FxOpd82:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 2 
FxOpd83:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 3 
FxOpd84:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 4 
FxOpd85:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 5 
FxOpd86:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 6 
FxOpd87:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 7 
FxOpd88:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 8 
FxOpd89:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 9 
FxOpd8A:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 10 
FxOpd8B:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 11 
FxOpd8C:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 12 
FxOpd8D:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 13 
FxOpd8E:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   MULTRNc 14 
FxOpd8F:     ; MULTRNc 8 bit to 16 bit signed multiply, register * register
   FETCHPIPE
   mov ebx,ebp
   mov al,byte [esi]     ; Read Source
   sub ebx,[SfxCPB]
   imul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

%macro UMULTRNc 1        ; V
   mov al,byte [esi]     ; Read Source
   mov bl,byte [SfxR0+%1*4]      ; Read RN
   FETCHPIPE
   mul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd80A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 0
FxOpd81A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 1
FxOpd82A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 2
FxOpd83A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 3
FxOpd84A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 4
FxOpd85A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 5
FxOpd86A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 6
FxOpd87A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 7
FxOpd88A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 8
FxOpd89A1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 9
FxOpd8AA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 10
FxOpd8BA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 11
FxOpd8CA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 12
FxOpd8DA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 13
FxOpd8EA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   UMULTRNc 14
FxOpd8FA1:   ; UMULRN 8 bit to 16 bit unsigned multiply, register * register
   FETCHPIPE
   mov ebx,ebp
   mov al,byte [esi]     ; Read Source
   sub ebx,[SfxCPB]
   mul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn

%macro MULTIRNc 1        ; V
   mov al,byte [esi]     ; Read Source
   mov bl,%1                  ; Read RN
   FETCHPIPE
   imul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd80A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 0
FxOpd81A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 1
FxOpd82A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 2
FxOpd83A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 3
FxOpd84A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 4
FxOpd85A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 5
FxOpd86A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 6
FxOpd87A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 7
FxOpd88A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 8
FxOpd89A2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 9
FxOpd8AA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 10
FxOpd8BA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 11
FxOpd8CA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 12
FxOpd8DA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 13
FxOpd8EA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 14
FxOpd8FA2:   ; MULIRN 8 bit to 16 bit signed multiply, register * immediate
   MULTIRNc 15

%macro UMULTIRNc 1       ; V
   mov al,byte [esi]     ; Read Source
   mov bl,%1                  ; Read RN
   FETCHPIPE
   mul bl
   inc ebp
   and eax,0FFFFh
   mov [SfxSignZero],eax
   mov [edi],eax            ; Write Destination
   CLRFLAGS
   FXReturn
%endmacro

FxOpd80A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 0
FxOpd81A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 1
FxOpd82A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 2
FxOpd83A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 3
FxOpd84A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 4
FxOpd85A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 5
FxOpd86A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 6
FxOpd87A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 7
FxOpd88A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 8
FxOpd89A3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 9
FxOpd8AA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 10
FxOpd8BA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 11
FxOpd8CA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 12
FxOpd8DA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 13
FxOpd8EA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 14
FxOpd8FA3:   ;UMULIRN 8 bit to 16 bit unsigned multiply, register * immediate
   UMULTIRNc 15

FxOpd90:     ; SBK    store word to last accessed RAM address    ; V
   mov ebx,[SfxLastRamAdr]   ; Load last ram address
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   mov [ebx],al         ; Store Word
   sub ebx,[SfxRAMMem]
   xor ebx,1
   add ebx,[SfxRAMMem]
   inc ebp                ; Increase program counter
   mov [ebx],ah         ; Store Word
   CLRFLAGS
   FXReturn

%macro LINKc 1   ; Verified.
   mov eax,ebp
   sub eax,[SfxCPB]
   add eax,%1
   FETCHPIPE
   mov word [SfxR11],ax
   CLRFLAGS
   inc ebp
   FXReturn
%endmacro

FxOpd91:     ; LINKc#n R11 = R15 + immediate
   LINKc 1
FxOpd92:     ; LINKc#n R11 = R15 + immediate
   LINKc 2
FxOpd93:     ; LINKc#n R11 = R15 + immediate
   LINKc 3
FxOpd94:     ; LINKc#n R11 = R15 + immediate
   LINKc 4

FxOpd95:     ; SEX    sign extend 8 bit to 16 bit        ; V
   movsx eax, byte [esi]     ; Read Source
   FETCHPIPE
   and eax,0FFFFh
   inc ebp
   mov [edi],eax            ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd96:     ; ASR    aritmethic shift right by one      ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   mov [SfxCarry],al
   and byte[SfxCarry],1
   sar ax,1                      ; logic shift right
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov dword [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd96A1:   ; DIV2   aritmethic shift right by one      ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   cmp ax,-1
   je .minusone
   mov [SfxCarry],al
   and byte[SfxCarry],1
   sar ax,1                      ; logic shift right
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov dword [SfxSignZero],eax
   CLRFLAGS
   FXReturn
.minusone
   mov byte[SfxCarry],1
   xor eax,eax
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov dword [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd97:     ; ROR    rotate right by one        ; V
   FETCHPIPE
   mov eax,[esi]            ; Read Source
   shr byte[SfxCarry],1
   rcr ax,1
   setc byte[SfxCarry]
   inc ebp                ; Increase program counter
   mov [edi],eax            ; Write Destination
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

%macro JMPRNc 1  ; V
   FETCHPIPE
   mov eax,[SfxR0+%1*4]             ; Read RN
   mov ebp,[SfxCPB]
   add ebp,eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpd98:     ; JMPRNc  jump to address of register
   JMPRNc 8
FxOpd99:     ; JMPRNc  jump to address of register
   JMPRNc 9
FxOpd9A:     ; JMPRNc  jump to address of register
   JMPRNc 10
FxOpd9B:     ; JMPRNc  jump to address of register
   JMPRNc 11
FxOpd9C:     ; JMPRNc  jump to address of register
   JMPRNc 12
FxOpd9D:     ; JMPRNc  jump to address of register
   JMPRNc 13

%macro LJMPRNc 1 ; V
   FETCHPIPE
   mov eax,[SfxR0+%1*4]
   and eax,07Fh
   mov byte[SfxPBR],al
;   mov byte[fxtrace+eax],1
   mov eax,[SfxMemTable+eax*4]
   mov [SfxCPB],eax
   mov ebp,eax
   add ebp,[esi]             ; Read RN
   mov dword [SfxCacheActive],0
   push ecx
   call FxOp02
   pop ecx
   dec ebp
   FXReturn
%endmacro

FxOpd98A1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 8
FxOpd99A1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 9
FxOpd9AA1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 10
FxOpd9BA1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 11
FxOpd9CA1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 12
FxOpd9DA1:   ; LJMPRNc set program bank to source register and jump to address of register
   LJMPRNc 13

FxOpd9E:     ; LOB    set upper byte to zero (keep low byte) ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   and eax,0FFh
   inc ebp
   mov [edi],eax            ; Write Destination
   shl eax,8
   mov dword [SfxSignZero],eax
   CLRFLAGS
   FXReturn

FxOpd9F:     ; FMULT  16 bit to 32 bit signed multiplication, upper 16 bits only
            ; V
   mov eax,[esi]             ; Read Source
   mov ebx,[SfxR6]
   FETCHPIPE
   imul bx
   inc ebp
   and edx,0FFFFh
   mov [SfxSignZero],edx
   mov [edi],edx        ; Write Destination
   shr ax,15
   mov [SfxCarry],al
   CLRFLAGS
   FXReturn

FxOpd9FA1:   ; LMULT  16 bit to 32 bit signed multiplication     ; V
   mov eax,[esi]             ; Read Source
   mov ebx,[SfxR6]
   FETCHPIPE
   imul bx
   and edx,0FFFFh
   inc ebp
   mov [edi],edx        ; Write Destination
   mov [SfxR4],ax
   mov [SfxSignZero],edx
   shr ax,15
   mov [SfxCarry],al
   CLRFLAGS
   FXReturn

%macro IBTRNc 1  ; V
   movsx eax,byte[ebp]
   mov cl,[ebp+1]
   add ebp,2
   mov [SfxR0+%1*4],ax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdA0:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 0
FxOpdA1:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 1
FxOpdA2:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 2
FxOpdA3:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 3
FxOpdA4:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 4
FxOpdA5:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 5
FxOpdA6:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 6
FxOpdA7:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 7
FxOpdA8:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 8
FxOpdA9:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 9
FxOpdAA:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 10
FxOpdAB:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 11
FxOpdAC:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 12
FxOpdAD:     ; IBTRNc,#PP immediate byte transfer
   IBTRNc 13
FxOpdAE:     ; IBTRNc,#PP immediate byte transfer
   movsx eax,byte[ebp]
   mov cl,[ebp+1]
   add ebp,2
   mov [SfxR0+14*4],ax
   UpdateR14
   CLRFLAGS
   FXReturn
FxOpdAF:     ; IBTRNc,#PP immediate byte transfer
   movsx eax,byte[ebp]
   mov cl,[ebp+1]
   and eax,0FFFFh
   mov ebp,[SfxCPB]
   add ebp,eax
   CLRFLAGS
   FXReturn

%macro LMSRNc 1  ; Verified.
   xor eax,eax
   mov al,[ebp]
   add eax,eax
   inc ebp
   add eax,[SfxRAMMem]
   mov cl,[ebp]
   mov dword [SfxLastRamAdr],eax
   mov ebx,[eax]              ; Read word from ram
   inc ebp
   mov [SfxR0+%1*4],bx              ; Write data
   CLRFLAGS
   FXReturn
%endmacro

FxOpdA0A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 0
FxOpdA1A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 1
FxOpdA2A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 2
FxOpdA3A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 3
FxOpdA4A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 4
FxOpdA5A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 5
FxOpdA6A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 6
FxOpdA7A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 7
FxOpdA8A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 8
FxOpdA9A1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 9
FxOpdAAA1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 10
FxOpdABA1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 11
FxOpdACA1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 12
FxOpdADA1:   ; LMS rn,(yy)  load word from RAM (short address)
   LMSRNc 13
FxOpdAEA1:   ; LMS rn,(yy)  load word from RAM (short address)
   xor eax,eax
   mov al,[ebp]
   add eax,eax
   inc ebp
   add eax,[SfxRAMMem]
   mov cl,[ebp]
   mov dword [SfxLastRamAdr],eax
   mov ebx,[eax]              ; Read word from ram
   inc ebp
   mov [SfxR0+14*4],bx              ; Write data
   UpdateR14
   CLRFLAGS
   FXReturn
FxOpdAFA1:   ; LMS rn,(yy)  load word from RAM (short address)
   xor eax,eax
   mov al,[ebp]
   add eax,eax
   inc ebp
   add eax,[SfxRAMMem]
   mov cl,[ebp]
   mov dword [SfxLastRamAdr],eax
   mov ebx,[eax]              ; Read word from ram
   and ebx,0FFFFh
   mov ebp,[SfxCPB]
   add ebp,ebx
   CLRFLAGS
   FXReturn

%macro SMSRNc 1  ; Verified.
   xor eax,eax
   mov al,[ebp]
   inc ebp
   add eax,eax
   mov cl,[ebp]
   add eax,[SfxRAMMem]
   mov ebx,[SfxR0+%1*4]              ; Read data
   mov dword [SfxLastRamAdr],eax
   inc ebp
   mov [eax],bx              ; Write word to ram
   CLRFLAGS
   FXReturn
%endmacro

FxOpdA0A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 0
FxOpdA1A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 1
FxOpdA2A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 2
FxOpdA3A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 3
FxOpdA4A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 4
FxOpdA5A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 5
FxOpdA6A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 6
FxOpdA7A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 7
FxOpdA8A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 8
FxOpdA9A2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 9
FxOpdAAA2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 10
FxOpdABA2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 11
FxOpdACA2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 12
FxOpdADA2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 13
FxOpdAEA2:   ; SMS (yy),rn  store word in RAM (short address)
   SMSRNc 14
FxOpdAFA2:   ; SMS (yy),rn  store word in RAM (short address)
   xor eax,eax
   mov ebx,ebp
   sub ebx,[SfxCPB]
   mov al,[ebp]
   inc ebp
   add eax,eax
   FETCHPIPE
   add eax,[SfxRAMMem]
   mov dword [SfxLastRamAdr],eax
   inc ebp
   mov [eax],bx              ; Write word to ram
   CLRFLAGS
   FXReturn

%macro FROMRNd 1 ; V
   FETCHPIPE
   mov esi,SfxR0+%1*4
   inc ebp                ; Increase program counter
   call [FxTable+ecx*4]
   mov esi,SfxR0
   FXReturn
%endmacro

FxOpdB0:     ; FROM rn   set source register
   FROMRNd 0
FxOpdB1:     ; FROM rn   set source register
   FROMRNd 1
FxOpdB2:     ; FROM rn   set source register
   FROMRNd 2
FxOpdB3:     ; FROM rn   set source register
   FROMRNd 3
FxOpdB4:     ; FROM rn   set source register
   FROMRNd 4
FxOpdB5:     ; FROM rn   set source register
   FROMRNd 5
FxOpdB6:     ; FROM rn   set source register
   FROMRNd 6
FxOpdB7:     ; FROM rn   set source register
   FROMRNd 7
FxOpdB8:     ; FROM rn   set source register
   FROMRNd 8
FxOpdB9:     ; FROM rn   set source register
   FROMRNd 9
FxOpdBA:     ; FROM rn   set source register
   FROMRNd 10
FxOpdBB:     ; FROM rn   set source register
   FROMRNd 11
FxOpdBC:     ; FROM rn   set source register
   FROMRNd 12
FxOpdBD:     ; FROM rn   set source register
   FROMRNd 13
FxOpdBE:     ; FROM rn   set source register
   FROMRNd 14
FxOpdBF:     ; FROM rn   set source register
   FETCHPIPE
   mov esi,SfxR0+15*4
   inc ebp                ; Increase program counter
   mov eax,ebp
   sub eax,[SfxCPB]
   mov [SfxR15],eax
   call [FxTableb+ecx*4]
   mov esi,SfxR0
   FXReturn

FxOpdC0:     ; HIB       move high-byte to low-byte      ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   and eax,0FF00h
   mov dword [SfxSignZero],eax
   shr eax,8
   inc ebp
   mov [edi],eax
   CLRFLAGS
   FXReturn

%macro ORRNc 1   ; V
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxR0+%1*4]             ; Read
   FETCHPIPE
   or eax,ebx
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdC1:     ; OR rn     or rn
   ORRNc 1
FxOpdC2:     ; OR rn     or rn
   ORRNc 2
FxOpdC3:     ; OR rn     or rn
   ORRNc 3
FxOpdC4:     ; OR rn     or rn
   ORRNc 4
FxOpdC5:     ; OR rn     or rn
   ORRNc 5
FxOpdC6:     ; OR rn     or rn
   ORRNc 6
FxOpdC7:     ; OR rn     or rn
   ORRNc 7
FxOpdC8:     ; OR rn     or rn
   ORRNc 8
FxOpdC9:     ; OR rn     or rn
   ORRNc 9
FxOpdCA:     ; OR rn     or rn
   ORRNc 10
FxOpdCB:     ; OR rn     or rn
   ORRNc 11
FxOpdCC:     ; OR rn     or rn
   ORRNc 12
FxOpdCD:     ; OR rn     or rn
   ORRNc 13
FxOpdCE:     ; OR rn     or rn
   ORRNc 14
FxOpdCF:     ; OR rn     or rn
   mov eax,[esi]            ; Read Source
   mov ebx,ebp
   FETCHPIPE
   sub ebx,[SfxCPB]
   or eax,ebx
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

%macro XORRNc 1  ; V
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxR0+%1*4]             ; Read
   FETCHPIPE
   xor eax,ebx
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdC1A1:   ; XOR rn    xor rn
   XORRNc 1
FxOpdC2A1:   ; XOR rn    xor rn
   XORRNc 2
FxOpdC3A1:   ; XOR rn    xor rn
   XORRNc 3
FxOpdC4A1:   ; XOR rn    xor rn
   XORRNc 4
FxOpdC5A1:   ; XOR rn    xor rn
   XORRNc 5
FxOpdC6A1:   ; XOR rn    xor rn
   XORRNc 6
FxOpdC7A1:   ; XOR rn    xor rn
   XORRNc 7
FxOpdC8A1:   ; XOR rn    xor rn
   XORRNc 8
FxOpdC9A1:   ; XOR rn    xor rn
   XORRNc 9
FxOpdCAA1:   ; XOR rn    xor rn
   XORRNc 10
FxOpdCBA1:   ; XOR rn    xor rn
   XORRNc 11
FxOpdCCA1:   ; XOR rn    xor rn
   XORRNc 12
FxOpdCDA1:   ; XOR rn    xor rn
   XORRNc 13
FxOpdCEA1:   ; XOR rn    xor rn
   XORRNc 14
FxOpdCFA1:   ; XOR rn    xor rn
   FETCHPIPE
   mov eax,[esi]            ; Read Source
   mov ebx,ebp
   sub ebx,[SfxCPB]
   xor eax,ebx
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn

%macro ORIc 1    ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   or eax,%1
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdC1A2:   ; OR #n     OR #n
   ORIc 1
FxOpdC2A2:   ; OR #n     OR #n
   ORIc 2
FxOpdC3A2:   ; OR #n     OR #n
   ORIc 3
FxOpdC4A2:   ; OR #n     OR #n
   ORIc 4
FxOpdC5A2:   ; OR #n     OR #n
   ORIc 5
FxOpdC6A2:   ; OR #n     OR #n
   ORIc 6
FxOpdC7A2:   ; OR #n     OR #n
   ORIc 7
FxOpdC8A2:   ; OR #n     OR #n
   ORIc 8
FxOpdC9A2:   ; OR #n     OR #n
   ORIc 9
FxOpdCAA2:   ; OR #n     OR #n
   ORIc 10
FxOpdCBA2:   ; OR #n     OR #n
   ORIc 11
FxOpdCCA2:   ; OR #n     OR #n
   ORIc 12
FxOpdCDA2:   ; OR #n     OR #n
   ORIc 13
FxOpdCEA2:   ; OR #n     OR #n
   ORIc 14
FxOpdCFA2:   ; OR #n     OR #n
   ORIc 15

%macro XORIc 1   ; V
   mov eax,[esi]            ; Read Source
   FETCHPIPE
   xor eax,%1
   inc ebp
   mov [edi],eax            ; Write DREG
   mov [SfxSignZero],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdC1A3:   ; XOR #n    xor #n
   XORIc 1
FxOpdC2A3:   ; XOR #n    xor #n
   XORIc 2
FxOpdC3A3:   ; XOR #n    xor #n
   XORIc 3
FxOpdC4A3:   ; XOR #n    xor #n
   XORIc 4
FxOpdC5A3:   ; XOR #n    xor #n
   XORIc 5
FxOpdC6A3:   ; XOR #n    xor #n
   XORIc 6
FxOpdC7A3:   ; XOR #n    xor #n
   XORIc 7
FxOpdC8A3:   ; XOR #n    xor #n
   XORIc 8
FxOpdC9A3:   ; XOR #n    xor #n
   XORIc 9
FxOpdCAA3:   ; XOR #n    xor #n
   XORIc 10
FxOpdCBA3:   ; XOR #n    xor #n
   XORIc 11
FxOpdCCA3:   ; XOR #n    xor #n
   XORIc 12
FxOpdCDA3:   ; XOR #n    xor #n
   XORIc 13
FxOpdCEA3:   ; XOR #n    xor #n
   XORIc 14
FxOpdCFA3:   ; XOR #n    xor #n
   XORIc 15

%macro INCRNc 1  ; Verified
   inc word[SfxR0+%1*4]
   FETCHPIPE
   mov eax,[SfxR0+%1*4]            ; Read Source
   mov [SfxSignZero],eax
   CLRFLAGS
   inc ebp
   FXReturn
%endmacro

FxOpdD0:     ; INC rn    increase by one
   INCRNc 0
FxOpdD1:     ; INC rn    increase by one
   INCRNc 1
FxOpdD2:     ; INC rn    increase by one
   INCRNc 2
FxOpdD3:     ; INC rn    increase by one
   INCRNc 3
FxOpdD4:     ; INC rn    increase by one
   INCRNc 4
FxOpdD5:     ; INC rn    increase by one
   INCRNc 5
FxOpdD6:     ; INC rn    increase by one
   INCRNc 6
FxOpdD7:     ; INC rn    increase by one
   INCRNc 7
FxOpdD8:     ; INC rn    increase by one
   INCRNc 8
FxOpdD9:     ; INC rn    increase by one
   INCRNc 9
FxOpdDA:     ; INC rn    increase by one
   INCRNc 10
FxOpdDB:     ; INC rn    increase by one
   INCRNc 11
FxOpdDC:     ; INC rn    increase by one
   INCRNc 12
FxOpdDD:     ; INC rn    increase by one
   INCRNc 13
FxOpdDE:     ; INC rn    increase by one
   FETCHPIPE
   mov eax,[SfxR0+14*4]            ; Read Source
   inc ax
   mov [SfxR0+14*4],eax
   mov [SfxSignZero],eax
   CLRFLAGS
   inc ebp
   UpdateR14
   FXReturn

FxOpdDF:     ; GETC      transfer ROM buffer to color register
   mov eax,[SfxRomBuffer]
   FETCHPIPE
   mov eax,[eax]
   test byte[SfxPOR],04h
   jz .nohighnibble
   mov bl,al
   shr bl,4
   and al,0F0h
   or al,bl
.nohighnibble
   test byte[SfxPOR],08h
   jnz .preserveupper
   mov [SfxCOLR],al
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn
.preserveupper
   mov bl,[SfxCOLR]
   and al,0Fh
   and bl,0F0h
   or al,bl
   mov [SfxCOLR],al
   CLRFLAGS
   inc ebp                ; Increase program counter
   FXReturn

FxOpdDFA2    ; RAMB      set current RAM bank    ; Verified
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxnRamBanks]
   FETCHPIPE
   dec ebx
   and eax,ebx
   mov dword [SfxRAMBR],eax
   shl eax,16
   add eax,[sfxramdata]
   mov dword [SfxRAMMem],eax
   CLRFLAGS
   inc ebp
   FXReturn

FxOpdDFA3    ; ROMB      set current ROM bank    ; Verified
   mov eax,[esi]            ; Read Source
   and eax,07Fh
   FETCHPIPE
   mov dword [SfxROMBR],eax
   mov eax,[SfxMemTable+eax*4]
   mov [SfxCROM],eax
   CLRFLAGS
   inc ebp
   FXReturn

%macro DECRNc 1  ; Verified
   dec word[SfxR0+%1*4]
   FETCHPIPE
   mov eax,[SfxR0+%1*4]            ; Read Source
   mov [SfxR0+%1*4],eax
   mov [SfxSignZero],eax
   CLRFLAGS
   inc ebp
   FXReturn
%endmacro

FxOpdE0:     ; DEC rn    decrement by one
   DECRNc 0
FxOpdE1:     ; DEC rn    decrement by one
   DECRNc 1
FxOpdE2:     ; DEC rn    decrement by one
   DECRNc 2
FxOpdE3:     ; DEC rn    decrement by one
   DECRNc 3
FxOpdE4:     ; DEC rn    decrement by one
   DECRNc 4
FxOpdE5:     ; DEC rn    decrement by one
   DECRNc 5
FxOpdE6:     ; DEC rn    decrement by one
   DECRNc 6
FxOpdE7:     ; DEC rn    decrement by one
   DECRNc 7
FxOpdE8:     ; DEC rn    decrement by one
   DECRNc 8
FxOpdE9:     ; DEC rn    decrement by one
   DECRNc 9
FxOpdEA:     ; DEC rn    decrement by one
   DECRNc 10
FxOpdEB:     ; DEC rn    decrement by one
   DECRNc 11
FxOpdEC:     ; DEC rn    decrement by one
   DECRNc 12
FxOpdED:     ; DEC rn    decrement by one
   DECRNc 13
FxOpdEE:     ; DEC rn    decrement by one
   dec word[SfxR0+14*4]
   FETCHPIPE
   mov eax,[SfxR0+14*4]            ; Read Source
   mov [SfxSignZero],eax
   UpdateR14
   CLRFLAGS
   inc ebp
   FXReturn

FxOpdEF:     ; getb      get byte from ROM at address R14        ; V
   FETCHPIPE
   mov eax,[SfxRomBuffer]
   inc ebp
   mov eax,[eax]
   and eax,0FFh
   cmp edi,SfxR15
   je .nor15
   mov [edi],eax            ; Write DREG
   CLRFLAGS
   FXReturn
.nor15
   mov eax,ebp
   sub eax,[SfxCPB]
   mov [SfxR15],eax
   CLRFLAGS
   FXReturn

FxOpdEFA1:   ; getbh     get high-byte from ROM at address R14   ; V
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxRomBuffer]
   and eax,0FFh
   FETCHPIPE
   mov ah,[ebx]
   inc ebp
   mov [edi],eax            ; Write DREG
   CLRFLAGS
   FXReturn

FxOpdEFA2:   ; getbl     get low-byte from ROM at address R14    ; V
   mov eax,[esi]            ; Read Source
   mov ebx,[SfxRomBuffer]
   and eax,0FF00h
   FETCHPIPE
   mov al,[ebx]
   inc ebp
   mov [edi],eax            ; Write DREG
   CLRFLAGS
   FXReturn

FxOpdEFA3:   ; getbs     get sign extended byte from ROM at address R14  ; V
   mov ebx,[SfxRomBuffer]
   FETCHPIPE
   movsx eax,byte[ebx]
   inc ebp
   mov [edi],ax            ; Write DREG
   CLRFLAGS
   FXReturn

%macro IWTRNc 1  ; aka LEA       ; Verified.
   mov eax,[ebp]
   mov cl,[ebp+2]
   and eax,0FFFFh
   add ebp,3
   mov [SfxR0+%1*4],eax
   CLRFLAGS
   FXReturn
%endmacro

FxOpdF0:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 0
FxOpdF1:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 1
FxOpdF2:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 2
FxOpdF3:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 3
FxOpdF4:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 4
FxOpdF5:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 5
FxOpdF6:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 6
FxOpdF7:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 7
FxOpdF8:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 8
FxOpdF9:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 9
FxOpdFA:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 10
FxOpdFB:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 11
FxOpdFC:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 12
FxOpdFD:     ; IWT RN,#xx   immediate word transfer to register
   IWTRNc 13
FxOpdFE:     ; IWT RN,#xx   immediate word transfer to register
   mov eax,[ebp]
   mov cl,[ebp+2]
   and eax,0FFFFh
   add ebp,3
   mov [SfxR0+14*4],eax
   UpdateR14
   CLRFLAGS
   FXReturn
FxOpdFF:     ; IWT RN,#xx   immediate word transfer to register
   mov eax,[ebp]
   mov cl,[ebp+2]
   and eax,0FFFFh
   mov ebp,[SfxCPB]
   add ebp,eax
   CLRFLAGS
   FXReturn

%macro LMRNc 1   ; Verified!
   xor eax,eax
   mov cl,[ebp+2]
   mov ax,[ebp]
   mov ebx,[SfxRAMMem]
   mov [SfxLastRamAdr],eax
   add [SfxLastRamAdr],ebx
   mov dl,[eax+ebx]
   xor eax,1
   add ebp,3
   mov dh,[eax+ebx]
   mov word [SfxR0+%1*4],dx         ; Store Word
   CLRFLAGS
   FXReturn
%endmacro

FxOpdF0A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 0
FxOpdF1A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 1
FxOpdF2A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 2
FxOpdF3A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 3
FxOpdF4A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 4
FxOpdF5A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 5
FxOpdF6A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 6
FxOpdF7A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 7
FxOpdF8A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 8
FxOpdF9A1:   ; LM RN,(XX)   load word from RAM
   LMRNc 9
FxOpdFAA1:   ; LM RN,(XX)   load word from RAM
   LMRNc 10
FxOpdFBA1:   ; LM RN,(XX)   load word from RAM
   LMRNc 11
FxOpdFCA1:   ; LM RN,(XX)   load word from RAM
   LMRNc 12
FxOpdFDA1:   ; LM RN,(XX)   load word from RAM
   LMRNc 13
FxOpdFEA1:   ; LM RN,(XX)   load word from RAM
   xor eax,eax
   mov cl,[ebp+2]
   mov ax,[ebp]
   mov ebx,[SfxRAMMem]
   mov [SfxLastRamAdr],eax
   add [SfxLastRamAdr],ebx
   mov dl,[eax+ebx]
   xor eax,1
   add ebp,3
   mov dh,[eax+ebx]
   mov word [SfxR0+14*4],dx         ; Store Word
   UpdateR14
   CLRFLAGS
   FXReturn
FxOpdFFA1:   ; LM RN,(XX)   load word from RAM
   FETCHPIPE
   mov eax,ecx
   inc ebp
   FETCHPIPE
   inc ebp
   mov ah,cl
   FETCHPIPE
   mov ebx,[SfxRAMMem]
   mov [SfxLastRamAdr],eax
   add [SfxLastRamAdr],ebx
   mov dl,[eax+ebx]
   xor eax,1
   mov dh,[eax+ebx]
   and edx,0FFFFh
   mov ebp,[SfxCPB]
   add ebp,edx
   CLRFLAGS
   FXReturn

%macro SMRNc 1   ; Verified
   mov ebx,[SfxR0+%1*4]
   mov eax,[ebp]
   mov cl,[ebp+2]
   and eax,0FFFFh
   mov dx,bx
   mov ebx,[SfxRAMMem]
   mov [SfxLastRamAdr],eax
   add [SfxLastRamAdr],ebx
   mov [eax+ebx],dl
   xor eax,1
   add ebp,3
   mov [eax+ebx],dh
   CLRFLAGS
   FXReturn
%endmacro

FxOpdF0A2:   ; SM (XX),RN   store word in RAM
   SMRNc 0
FxOpdF1A2:   ; SM (XX),RN   store word in RAM
   SMRNc 1
FxOpdF2A2:   ; SM (XX),RN   store word in RAM
   SMRNc 2
FxOpdF3A2:   ; SM (XX),RN   store word in RAM
   SMRNc 3
FxOpdF4A2:   ; SM (XX),RN   store word in RAM
   SMRNc 4
FxOpdF5A2:   ; SM (XX),RN   store word in RAM
   SMRNc 5
FxOpdF6A2:   ; SM (XX),RN   store word in RAM
   SMRNc 6
FxOpdF7A2:   ; SM (XX),RN   store word in RAM
   SMRNc 7
FxOpdF8A2:   ; SM (XX),RN   store word in RAM
   SMRNc 8
FxOpdF9A2:   ; SM (XX),RN   store word in RAM
   SMRNc 9
FxOpdFAA2:   ; SM (XX),RN   store word in RAM
   SMRNc 10
FxOpdFBA2:   ; SM (XX),RN   store word in RAM
   SMRNc 11
FxOpdFCA2:   ; SM (XX),RN   store word in RAM
   SMRNc 12
FxOpdFDA2:   ; SM (XX),RN   store word in RAM
   SMRNc 13
FxOpdFEA2:   ; SM (XX),RN   store word in RAM
   SMRNc 14
FxOpdFFA2:   ; SM (XX),RN   store word in RAM
   FETCHPIPE
   mov ebx,ebp
   sub ebx,[SfxCPB]
   mov eax,ecx
   inc ebp
   FETCHPIPE
   inc ebp
   mov ah,cl
   FETCHPIPE
   mov dx,bx
   mov ebx,[SfxRAMMem]
   mov [SfxLastRamAdr],eax
   add [SfxLastRamAdr],ebx
   mov [eax+ebx],dl
   xor eax,1
   inc ebp
   mov [eax+ebx],dh
   CLRFLAGS
   FXReturn
