/*
 ******************* X-Mame header file *********************
 * file "xmame.h"
 *
 * by jantonio@dit.upm.es
 *
 ************************************************************
*/

#ifndef __XMAME_H_
#define __XMAME_H_

#ifdef __MAIN_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/*
 * Include files.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <ctype.h>
#include <pwd.h>
#include "driver.h"

#ifdef linux
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined FREEBSD && ( ! defined BSDi )
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#include <sys/ioctl.h>
#include <errno.h>
#endif


/* Network */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef svgalib
#include <vga.h>
#endif

#ifndef svgalib 
#ifndef ggi
/* the svgalib and ggi versions don't need these X-includes */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef X11_JOYSTICK
#include <X11/extensions/XI.h>
#include <X11/extensions/XInput.h>
/* event types returned by XSelecExtensionEvent() */
int num_x_buttons;
int devicebuttonpress;
int devicebuttonrelease;
int devicemotionnotify;
int devicebuttonmotion;
/* ifdef X11_JOYSTICK */
#endif
#endif

#ifdef USE_MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#ifdef HAS_XPM
#include <X11/xpm.h>
#endif

/* notdef svgalib */
#endif

#include "osdepend.h"

/*
 * Definitions.
 */

#ifndef TRUE
#define	TRUE			(1)
#endif

#ifndef FALSE
#define FALSE			(0)
#endif

#define OSD_OK			(0)
#define OSD_NOT_OK		(1)

#define DEBUG(x)


/*
 * Global variables.
 */

#ifndef svgalib 
#ifndef ggi
/* some more X-stuff we don't need for svgalib or ggi */
/* dirty_line struct */

struct dirty_line {
	int x;
	char *start;
	char *end;
};

#ifdef USE_MITSHM
EXTERN XShmSegmentInfo 	shm_info;
#endif
EXTERN Display 		*display;
EXTERN Window		window;
EXTERN Screen 		*screen;
EXTERN Colormap		colormap;
EXTERN XImage		*image;
EXTERN GC		gc;
EXTERN int		eval_update_display_func(void);
EXTERN char  		*scaled_buffer_ptr ;
EXTERN unsigned long 	xpixel[256];           /* Pixel index values */
EXTERN char		xpixel_allocated[256];
EXTERN unsigned long	black_xpixel;
EXTERN struct dirty_line *dirty_lines;
EXTERN struct dirty_line *old_dirty_lines;
EXTERN void		(*update_display_func)(void);
EXTERN void		(*dirty_update_display_func)(void);
EXTERN char		*copybuffer;

/* Network Variables */
EXTERN int socks[4];
EXTERN struct sockaddr_in names[4];
EXTERN int syncsocks[4];
EXTERN struct sockaddr_in syncnames[4];
EXTERN int netstate;
EXTERN int netkeymap;
EXTERN int players;
EXTERN char *mastername;
EXTERN int slaves;

/*
 * Workaround: in DO$, the Allegro library maintains this array.
 * In X, we'll have to do it ourselves. Bummer.
 */
EXTERN char	 	xkey[OSD_MAX_KEY+1];
EXTERN char             netkey[OSD_MAX_KEY+1];
/* ndef svgalib */
#endif
#endif

/* global variables and miscellaneous flags */

EXTERN int              root_window_id; /* root window id (for swallowing the mame window) */
EXTERN unsigned int 	widthscale;     /* X scale */
EXTERN unsigned int 	heightscale;    /* Y SCALE */
EXTERN int 		mit_shm_avail;  /* use mitshm if available */
EXTERN char 		*displayname;   /* default is use local */
#ifndef MESS
EXTERN char		*mamedir;       /* home directory of mame tree */
#endif
EXTERN char		*spooldir;      /* directory to store high scores */
EXTERN char		*towns_pad_dev; /* name of FM-TOWNS device */
EXTERN char 		*x11joyname;
EXTERN char             *audiodevice;   /* /dev/dsp or /dev/audio */
EXTERN char		*key;
EXTERN char		No_FM;
EXTERN int		swapjoyaxis;
EXTERN int		analogstick;
EXTERN int		use_joystick;
EXTERN int		use_mouse;
EXTERN int		use_dirty;
EXTERN int		use_layer;
EXTERN int		play_sound;
EXTERN int		fake_sound;
EXTERN int		use_private_cmap;
EXTERN int		use_xsync;
EXTERN int		video_mode;
EXTERN int		force_truecolor;
EXTERN int		throttle;
EXTERN int 		snapshot_no;
EXTERN int		game_index;
EXTERN struct osd_bitmap *bitmap;
EXTERN int		palette_dirty;
EXTERN int		black_pen_valid;
EXTERN int		black_pen;

/* visual is the visual part of the bitmap */
EXTERN int 		visual_width;
EXTERN int		visual_height;
EXTERN struct rectangle	visual;
EXTERN unsigned char	current_palette[256*3];

/* platform independent options go here */
EXTERN struct GameOptions options;

/* system dependent functions */
int sysdep_init(void);
void sysdep_exit(void);
int sysdep_create_display(void);
void sysdep_init_palette(int totalcolors,const unsigned char *palette, unsigned short *pens);
void sysdep_update_display(void);
void sysdep_clear_screen(void);

/* audio related */
int start_timer();
int sysdep_audio_initvars(void);
long sysdep_get_audio_freespace(void);
int sysdep_play_audio(byte *buf, int size);
void sysdep_fill_audio_buffer(long *in,char *out,int start,int end);

/* keyboard related */
int sysdep_keyboard_init(void);
void sysdep_keyboard_close(void);
void sysdep_update_keyboard (void);
int sysdep_mapkey(int from, int to);

/* mouse related */
int sysdep_mouse_init(void);
void sysdep_mouse_close(void);

/* joystick related */
int sysdep_joy_initvars(void);
int x11_joystick_init(void);
void sysdep_joy_close(void);

/* miscelaneous */
int get_config (void);
int parse_command_line (int argc, char *argv[]);
int frontend_help (int argc, char *argv[]);
#ifndef svgalib
#ifndef ggi
void process_mouse_event(XEvent *event);
void process_x11_joy_event(XEvent *event);
int osd_snapshot(void);
#endif
#endif

/* dirty functions */
void osd_mark_dirty(int sx,int sy, int ex, int ey, int ui);
void merge_dirty(void);
void copy_dirty_layer_to_dirty(void);

#ifndef svgalib 
#ifndef ggi
/* the svgalib and ggi versions don't need these X-prototypes */
/* X-update functions, for all the special cases */
void osd_refresh_screen(void);
void osd_refresh_dirty_screen(void);

/* 8bpp pseudocolor functions */
void do_update_pseudo_generic(void);
void do_update_pseudo_scale1(void);
void do_update_pseudo_scale2(void);
void do_update_pseudo_scale3(void);
void do_update_pseudo_dirty_generic(void);
void do_update_pseudo_dirty_scale1(void);
void do_update_pseudo_dirty_scale2(void);
void do_update_pseudo_dirty_scale3(void);

/* truecolor functions */
void do_update_truec_generic(void);
void do_update_truec_scale1(void);
void do_update_truec_scale2(void);
void do_update_truec_scale3(void);
void do_update_truec_dirty_generic(void);
void do_update_truec_dirty_scale1(void);
void do_update_truec_dirty_scale2(void);
void do_update_truec_dirty_scale3(void);

#endif /* if not defined svgalib */
#endif /* if not defined ggi */

#undef EXTERN
#endif
