/*
 * X-mame main-routine
 */

#define __MAIN_C_
#include "xmame.h"
#include "sound.h"
#include "driver.h"

/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int osd_init(void)
{
	/* now invoice system-dependent initialization */
	if (sysdep_keyboard_init() ==OSD_NOT_OK) return OSD_NOT_OK;
	if (sysdep_mouse_init()    ==OSD_NOT_OK) return OSD_NOT_OK;
	if (sysdep_joy_initvars()  ==OSD_NOT_OK) return OSD_NOT_OK;
	if (sysdep_audio_initvars()==OSD_NOT_OK) return OSD_NOT_OK;
	
	return OSD_OK;
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */
void osd_exit (void)
{
	sysdep_keyboard_close();
	sysdep_mouse_close();
	sysdep_joy_close();
	sysdep_audio_close();
	sysdep_exit();
}


int main (int argc, char **argv)
{
	int res;

#ifdef svgalib
        /* first let's try to init svgalib */
        /* and give up those evil root rights, */
        /* esp since the rest of the code is full of bufferoveruns ;( */
	vga_init();
#endif
#ifdef ggi
	/* ggi needs to be initialized too */
     	ggiInit();
#endif
#ifdef xf86_dga
	if(xf86_init() == OSD_NOT_OK) return OSD_NOT_OK;
#endif

        /* Set the title, now auto build from defines from the makefile */
        sprintf(title,"%s (%s) version %s", NAME, DISPLAY_METHOD, VERSION);

	/* parse configuration file and environment */
	if ((res = get_config(argc, argv)) != 1234) return res;
	
#ifdef MAME_NET
	/* Network Init */
        if (netstate) osd_net_init();
#endif /* MAME_NET */

	/* this could change the samplerate so has to be done here and not
	   in osd_init ! */
	sysdep_init();

	/* Set the samplerate to 0 if sound is disabled,
	   this should notify mame not to "render" it (speed improvement) */
	if (play_sound==0) 
	{
	   if (fake_sound)
	      options.samplerate=8000;
	   else
	   {
	      options.samplerate=0;
	      No_FM=0;
	   }
	}
	
	/* go for it */
	res = run_game (game_index , &options);

	/* close open files */
	if (options.errorlog) fclose (options.errorlog);
	if (options.playback) osd_fclose (options.playback);
	if (options.record)   osd_fclose (options.record);

	return res;
}
