#ifndef MESS /* not yet in mess */
#include "xmame.h"

static struct
{
	clock_t start;
	clock_t count[OSD_TOTAL_PROFILES];
} profile;

/* Writes messages on the screen. */
static void my_textout(char *buf,int x,int y)
{
	int trueorientation,l,i;

	/* hack: force the display into standard orientation to avoid */
	/* rotating the text */
	trueorientation = Machine->orientation;
	Machine->orientation = ORIENTATION_DEFAULT;

	l = strlen(buf);
	for (i = 0;i < l;i++)
		drawgfx(Machine->scrbitmap,Machine->uifont,buf[i],DT_COLOR_WHITE,0,0,
				x + i*Machine->uifont->width, y, 0, TRANSPARENCY_NONE,0);

	Machine->orientation = trueorientation;
	osd_mark_dirty(x, y, x + l*Machine->uifont->width, 
		y + Machine->uifont->height, 0);
}

void osd_profiler_init(void)
{
	int i;

	profile.start = uclock();
	for (i = 0;i < OSD_TOTAL_PROFILES;i++)
		profile.count[i] = 0;
}

void osd_profiler(int type)
{
	static int FILO_type[10];
	static clock_t FILO_start[10];
	static int FILO_length;


	if (!use_profiler) return;

	if (type != OSD_PROFILE_END)
	{
		if (FILO_length >= 10)
		{
			if (options.errorlog)
				fprintf(options.errorlog,"Profiler error: FILO buffer overflow\n");
			return;
		}

		if (FILO_length > 0)
		{
			/* handle nested calls */
			profile.count[FILO_type[FILO_length-1]] += uclock() - FILO_start[FILO_length-1];
		}
		FILO_type[FILO_length] = type;
		FILO_start[FILO_length] = uclock();
		FILO_length++;
	}
	else
	{
		if (FILO_length <= 0)
		{
			if (options.errorlog)
				fprintf(options.errorlog,"Profiler error: FILO buffer underflow\n");
			return;
		}

		profile.count[FILO_type[FILO_length-1]] += uclock() - FILO_start[FILO_length-1];
		FILO_length--;
		if (FILO_length > 0)
		{
			/* handle nested calls */
			FILO_start[FILO_length-1] = uclock();
		}
	}
}

void osd_profiler_display(void)
{
	int i;
	int total;
	int val;
	char buf[30];
	static char *names[OSD_TOTAL_PROFILES] =
	{
		"CPU 1",
		"CPU 2",
		"CPU 3",
		"CPU 4",
		"Video",
		"Blit ",
		"Sound",
		"Cllbk",
		"Extra",
		"User1",
		"User2",
		"User3",
		"User4",
		"Prflr",
		"Idle ",
	};


	if (!use_profiler) return;

	osd_profiler(OSD_PROFILE_PROFILER);
	
	total = (uclock() - profile.start) / (UCLOCKS_PER_SEC / 1000);

	if (total == 0) return;	/* we have been just reset */

	for (i = 0;i < OSD_TOTAL_PROFILES;i++)
	{
		val = profile.count[i] / (UCLOCKS_PER_SEC / 1000);
		sprintf(buf,"%s %3d%%",names[i],val * 100 / total);
		my_textout(buf, visual.min_x, i*Machine->uifont->height);
	}
	
	osd_profiler(OSD_PROFILE_END);
}
#endif
