/*
* Solaris dependent code
*
* Preliminary audio support by jantonio@dit.upm.es
* no control on mono/stereo output channel and so  (yet)
*
*Major rewrite by Keith Hargrove condor@sun.com
*       This is my first pass at this
*       I use the EOF counter to keep track of how
*       data has been played
*
*       The whole sound system needs to be rewiten as a thread
*       This would give better performace and perfect sound
*       This code is more of a band-aid
*       I did not add support for the old ss1 and ss2 audio
*       I don't think that a ss1 or ss2 can run MAME
*       unless somone is using an ss2 with the turbo chip??
*       if there is a need it can be added
*
*/

#ifdef solaris

#define __SOLARIS_C
#define CODEC_BUFFER_SIZE 5000
#include "xmame.h"
#include "sound.h"
#include "lin2ulaw.h"

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stropts.h>
#include <sys/audioio.h>

int audioctl_fd;                /* audio control device for solaris     */
int audio_fd;                   /* audio device for solaris             */
int written = 0;                /* number of bytes written              */
int eof_written = 0;            /* number of bytes written              */
int eof_counter = 0;            /* Keep count of sound data written     */
short tmp_buf[512];

audio_info_t            a_info; /* info about audio settings            */
audio_device_t          a_dev;  /* info about audio hardware            */
struct      audio_info      info;

int sysdep_init(void) {

        int     i;
        if (play_sound) {
                int supported=FALSE;
                fprintf(stderr_file, "Solaris sound device initialization...\n");
                /* try to open audio device */
                if ( (audio_fd=open("/dev/audio",O_WRONLY | O_NDELAY)) < 0)
                {
                        fprintf(stderr_file, "couldn't open audio device\n");
                        exit(1);
                }
                /* try to open audioctl device */
                if ( (audioctl_fd=open("/dev/audioctl",O_RDWR )) < 0)
                {
                        fprintf(stderr_file, "couldn't open audioctl device\n");
                        close(audio_fd);
                        exit(1);
                }
                                sleep(2);

                /* empty buffers before change config */
                ioctl(audio_fd, AUDIO_DRAIN, 0);    /* drain everything out */
                ioctl(audio_fd, I_FLUSH, FLUSHRW);  /* flush everything     */
                ioctl(audioctl_fd, I_FLUSH, FLUSHRW);   /* flush everything */

                /* identify audio device. if AMD chipset, bad, luck :-( */
                if(ioctl(audio_fd,AUDIO_GETDEV,&a_dev)<0) {
                        fprintf(stderr_file, "Cannot get sound device type\n");
                        close(audio_fd);
                        close(audioctl_fd);
                        exit(1);
                }
                fprintf(stderr_file, "Sound device is a %s %s version %s\n",a_dev.config,a_dev.name,a_dev.version);

                /* get audio parameters. */
                if (ioctl(audioctl_fd,AUDIO_GETINFO,&a_info)<0){
                fprintf(stderr_file, "AUDIO_GETINFO failed!\n");
                        close(audio_fd);
                        close(audioctl_fd);
                        exit(1); }
                AUDIO_INITINFO(&a_info);
                        supported=TRUE;
                        options.samplerate=AUDIO_SAMPLE_FREQ;
                        /* Sun Dbri doesn't support 8bits linear         */
                        /* I dont muck with the gain or the port setting */
                        /* I hate when a program does that               */
                        /* There is nothing more frustrating then having */
                        /* a program change you volume and change from   */
                        /* external speakers to the tiny one             */
                        a_info.play.sample_rate   = options.samplerate;
                        a_info.play.encoding      = AUDIO_ENCODING_LINEAR;
                        a_info.play.precision     = 16;
                        a_info.play.channels      = 1;  /* mono */
#if 0
fprintf(stderr_file, "a_info.play.buffer_size = %d \n",a_info.play.buffer_size);

                /* patches by djr@dit.upm.es */
                a_info.record.buffer_size = 2536;
#endif
                a_info.play.buffer_size = CODEC_BUFFER_SIZE;

                i=0;
                if ( ioctl(audio_fd,AUDIO_SETINFO,&a_info) < 0 )        i+=2;
                if (i) {
                        fprintf(stderr_file, "Error %d: cannot set audio device parameters\n",i);
                        sleep(2);
                        close(audio_fd);
                        close(audioctl_fd);
                        exit(1);
                }
        }
        return (TRUE);
}

void sysdep_exit(void) {
        if (play_sound) {
                close(audio_fd);
                close(audioctl_fd);
        }
}

int sysdep_play_audio(byte *buf, int bufsize) {
    int i;
    char c;
    /*
        mixer code works with unsigned samples ( like SoundBlaster ), but all non SB
       soundcards speak signed .... ( so change 8th bit )
     */
        /* 8 bits signed linear 22050hz */
        /* we will set it to 16 bits and just shift it by 8 */
        i=0;
        while(i < (bufsize)){tmp_buf[eof_counter] = (short)((buf[i]-127)<<8);
                                        eof_counter++;
                                        i=i++;
                                        if(eof_counter >= 512 ){
                                                                write(audio_fd,tmp_buf,(eof_counter)*2);
                                                                written += (eof_counter);
                                                                write(audio_fd, &c, 0);
                                                                eof_counter=0;
                                                                eof_written++;
                                                                }
                                }
return;

}

long sysdep_get_audio_freespace() {
       ioctl(audioctl_fd,AUDIO_GETINFO,&a_info);
        return(CODEC_BUFFER_SIZE -(written-(a_info.play.eof*512)));

}

#endif
