/*
 * X-Mame video specifics code
 *
 */
#ifdef x11
#define __XWINDOWS_C_

/*
 * Include files.
 */

#include "xmame.h"
#include "sound.h" /* for rearming the timer */
#include <X11/cursorfont.h>

static Cursor        cursor;
static XVisualInfo   myvisual;
static unsigned long black_xpixel;

/* hmm we need these to do the clean up correctly, or we could just 
   trust unix & X to clean up after us but lett's keep things clean */
#ifdef USE_MITSHM   
static int mit_shm_attached       = 0;
#endif
static int private_cmap_allocated = 0;
static int use_rw_palette         = 0;
static int warn_low_on_colors     = 1;

/*
 * makes a snapshot of screen when F12 is pressed.
 *
 * store it in xpm pixmap format
 * save in users'home dir as gamename-XXX.xpm ( XXX equals to #snapshot )
 * 
 */
void osd_save_snapshot(void)
{
#ifdef HAS_XPM
	char name[1024];
	FILE *f;
	int res;
	XpmAttributes *xpmattr;
	do
	{
		sprintf(name,"%s/%s-snap%03d.xpm",home_dir,Machine->gamedrv->name,snapshot_no);
		/* avoid overwriting of existing files */
		if ((f = fopen(name,"rb")) != 0)
		{
			fclose(f);
			snapshot_no++;
		}
	} while (f != 0);
	/* set propper colormap */
	xpmattr=calloc(1,sizeof(XpmAttributes));
	if ( ! xpmattr ) { 
		fprintf(stderr_file,"calloc() Failed in osd_snapshot\n");
		return;
	}
	xpmattr->valuemask	= XpmColormap;
	xpmattr->colormap	= colormap;	/* set my own colormap */
	res = XpmWriteFileFromImage(display,name,image,0,xpmattr);
	free(xpmattr);				/* cleanup task */
	if ( res != XpmSuccess ) {
		fprintf(stderr_file,"Failed to save snapshot %s\n",name);
		return;
	} else {
		fprintf(stderr_file,"Saved snapshot as %s\n",name);
		/* wait until key released */
		while( osd_key_pressed(OSD_KEY_F12) );
		return;
	}
#else
	fprintf(stderr_file,"Sorry: XPM library not included. Cannot make snapshot\n");
#endif
}

/*
 * Create a display screen, or window, large enough to accomodate a bitmap
 * of the given dimensions. 
 *
 * Added: let osd_create_display allocate the actual display buffer. This
 * seems a bit dirty, but is more or less essential for X implementations
 * to avoid a lengthy memcpy().
 */

#ifdef USE_MITSHM   
/* following routine traps missused MIT-SHM if not available */
int test_mit_shm(Display *display, XErrorEvent *error) {
	char msg[256];
	unsigned char ret=error->error_code;
	XGetErrorText(display,ret,msg,256);
	/* if MIT-SHM request failed, note and continue */
	if (ret == BadAccess ) { mit_shm_avail=0; return 0; }
	/* else unspected error code: notify and exit */
	fprintf(stderr_file,"Unspected X Error %d: %s\n",ret,msg );
	exit(1);
}
#endif

/* Create display */
int sysdep_create_display(void)
{
	XSetWindowAttributes winattr;
	XGCValues	 xgcv;
	int 		 myscreen;
	XEvent		 event;
  	XSizeHints 	 hints;
  	XWMHints 	 wm_hints;
	Status		 result;
	int		 xsize,ysize;
	int              i,j,k;
	
	window		= 0;
	display		= NULL;
	image		= NULL;
	dirty_lines	= NULL;
	old_dirty_lines	= NULL;
	copybuffer	= NULL;
	x_palette_dirty	= FALSE;
	memset(xpixel_allocated, FALSE , sizeof(char) * 256);
	
	if (!use_dirty)
	{
	   /* round to long, otherwise non-aligned access may happen,
	   since the nodirty code uses long compare. */
	   visual.min_x &= ~(sizeof(long)-1);
	   visual.max_x  = ( (visual.max_x + 1) & ~(sizeof(long)-1) ) - 1;
	   /* now we need to recalculate the width */
	   visual_width  = visual.max_x - visual.min_x + 1;
	}

	xsize = widthscale  * visual_width;
	ysize = heightscale * visual_height;
	
	/* Open the display. */

	display = XOpenDisplay (displayname);
	if(!display) {
		fprintf (stderr_file,"OSD ERROR: failed to open the display.\n");
		osd_close_display(); /* this will clean up for us */
		return OSD_NOT_OK; 
	}

	screen 	 = DefaultScreenOfDisplay (display);
	myscreen = DefaultScreen(display);
	cursor   = XCreateFontCursor(display,XC_trek);

	/* test for available 8bit bitmaps resources */
	/* if not 8bit pseudocolor found, try to get any supported True color */
	/* set update display func properly */
	result 	 = XMatchVisualInfo(display,myscreen,8,PseudoColor,&myvisual);
	if ( ! result || force_truecolor ) {
	    force_truecolor=1;
	    fprintf(stderr_file,"8bit depth PseudoColor X-Visual not available :-( \n");
	    /* test for a 8bpp environment */
	    if      (XMatchVisualInfo(display,myscreen,8,TrueColor,&myvisual))
	       fprintf(stderr_file,"Using 8bpp TrueColor X-Visual Resource\n");
	    /* test for a 15bpp environment */
	    else if (XMatchVisualInfo(display,myscreen,15,TrueColor,&myvisual))
	       fprintf(stderr_file,"Using 15bpp TrueColor X-Visual Resource\n");
	    /* test for a 16bpp environment */
	    else if (XMatchVisualInfo(display,myscreen,16,TrueColor,&myvisual))
	       fprintf(stderr_file,"Using 16bpp TrueColor X-Visual Resource\n");
	    /* test for a 24bpp environment */
	    else if (XMatchVisualInfo(display,myscreen,24,TrueColor,&myvisual))
	       fprintf(stderr_file,"Using 24bpp TrueColor X-Visual Resource\n");
	    /* test for a 32bpp environment */
	    else if (XMatchVisualInfo(display,myscreen,32,TrueColor,&myvisual))
	       fprintf(stderr_file,"Using 32bpp TrueColor X-Visual Resource\n");
	    /* if arrives here means an error :-( */
	    else
	    {
	       fprintf(stderr_file,"Cannot find any supported X-Visual resource\n");
	       osd_close_display(); /* this will clean up for us */
	       return OSD_NOT_OK; 
	    }
	} else fprintf(stderr_file,"Using 8bpp PseudoColor Visual. Good!\n");

#ifdef USE_MITSHM   
	if (mit_shm_avail) /* look for available Mitshm extensions */
	{
	   mit_shm_avail = 0;
	   /* get XExtensions to be if mit shared memory is available */
	   result 	= XQueryExtension(display,"MIT-SHM",&i,&j,&k);
	   if ( ! result)
	      fprintf(stderr_file,"X-Server Doesn't support MIT-SHM extension\n");
	    else
	      mit_shm_avail = 1;
	}
#endif

	/* now get a color map structure */
	if(force_truecolor && use_private_cmap)
	{
	  fprintf(stderr_file,"Private ColorMap use disabled in TrueColor mode\n");
	  use_private_cmap=0;
	}
	
	if(!use_private_cmap)
	{
	  colormap = DefaultColormapOfScreen(screen);
          black_xpixel = BlackPixelOfScreen(screen);
	}
	else
	{
	  colormap = XCreateColormap(display,RootWindowOfScreen(screen),myvisual.visual,AllocNone);
	  private_cmap_allocated = 1;
	  black_xpixel = 0; /* no way to tell which xpixel will be black,
	   but we won't need it anyway since color allocation shouldn't
	   fail on a privatecmap */
	  fprintf(stderr_file,"Using private color map\n");
	}
	
	/* set xpixel to black */
	for(i=0;i<256;i++) xpixel[i] = black_xpixel;
	
	/* Create the window. No buttons, no fancy stuff. */
	winattr.background_pixel      = black_xpixel;
	winattr.border_pixel          = WhitePixelOfScreen(screen);
	winattr.bit_gravity           = ForgetGravity;
	winattr.win_gravity           = NorthWestGravity;
	winattr.backing_store         = NotUseful;
	winattr.override_redirect     = False;
	winattr.save_under            = False;
	winattr.event_mask            = 0;
	winattr.do_not_propagate_mask = 0;
	winattr.colormap              = colormap;
	winattr.cursor                = None;
	if (root_window_id == 0) {
		root_window_id = RootWindowOfScreen(screen);
	}
	window = XCreateWindow(display,root_window_id,0,0,xsize,ysize,0,myvisual.depth,
                           InputOutput,myvisual.visual,CWBorderPixel | CWBackPixel | CWBitGravity | \
                           CWWinGravity | CWBackingStore | CWOverrideRedirect | \
                           CWSaveUnder | CWEventMask | CWDontPropagate | \
                           CWColormap | CWCursor,&winattr);
  	if (!window) {
  		fprintf(stderr_file,"OSD ERROR: failed in XCreateWindow().\n");
		osd_close_display(); /* this will clean up for us */
		return OSD_NOT_OK; 
	}
	
	gc = XCreateGC(display,window,0,&xgcv);

	/*  Placement hints etc. */

	hints.flags	= PSize | PMinSize | PMaxSize;
 	hints.min_width	= hints.max_width = hints.base_width = xsize;
 	hints.min_height= hints.max_height = hints.base_height = ysize;

	wm_hints.input	= TRUE;
	wm_hints.flags	= InputHint;

	XSetWMHints 		(display, window, &wm_hints);
	XSetWMNormalHints 	(display, window, &hints);
	XStoreName 		(display, window, title);

	XDefineCursor(display,window,cursor);

#ifdef X11_JOYSTICK
	if(use_joystick) x11_joystick_init(); /* in devices.c */
#endif
	/* Map and expose the window. */
	if (use_mouse)
	{
	    /* grabb the pointer and query MotionNotify events */
	    XSelectInput(display, 
			 window, 
			 FocusChangeMask   | ExposureMask | 
			 KeyPressMask      | KeyReleaseMask | 
			 EnterWindowMask   | LeaveWindowMask |
			 ButtonPressMask   | ButtonReleaseMask
			);
	} else {
	    XSelectInput(display, 
			 window, 
			 FocusChangeMask | ExposureMask | 
			 KeyPressMask | KeyReleaseMask
			 );
	}
	XMapRaised     (display, window);
	XClearWindow   (display, window);
	XWindowEvent   (display, window, ExposureMask, &event);

#ifdef USE_MITSHM
	if ( mit_shm_avail ) {
	    /* Create a MITSHM image. */

	    XSetErrorHandler( test_mit_shm );

	    image = XShmCreateImage (display,
				myvisual.visual,
				myvisual.depth,
       			    	ZPixmap, 
				NULL, 
				&shm_info, 
				xsize, 
				ysize);
  	    if (!image) {
  		fprintf (stderr_file,"OSD ERROR: failed in XShmCreateImage().\n");
		mit_shm_avail = 0;
		goto mit_shm_failed;
	    }
	    shm_info.shmid = shmget ( IPC_PRIVATE,
				      image->bytes_per_line * image->height, 
				      (IPC_CREAT | 0777) );
	    if ( shm_info.shmid < 0) {
		    fprintf (stderr_file,"OSD ERROR: failed to create MITSHM block.\n");
		    osd_close_display(); /* this will clean up for us */
		    return OSD_NOT_OK;
	    }

	    /* And allocate the bitmap buffer. */
            /* new pen color code force double buffering in every cases */
  	    scaled_buffer_ptr = image->data = shm_info.shmaddr = 
			(char *) shmat ( shm_info.shmid,0 ,0);
  	    if (!scaled_buffer_ptr) {
    	    	    fprintf (stderr_file,"OSD ERROR: failed to allocate MITSHM bitmap buffer.\n");
		    osd_close_display(); /* this will clean up for us */
		    return OSD_NOT_OK; 
  	    }

	    shm_info.readOnly = FALSE;

	    /* Attach the MITSHM block. this will cause an exception if */
	    /* MIT-SHM is not available. so trap it and process         */

	    fprintf(stderr_file,"MIT-SHM Extension Available. trying to use...");

	    if(!XShmAttach (display, &shm_info)) {
  		    fprintf (stderr_file,"OSD ERROR: failed to attach MITSHM block.\n");
		    osd_close_display(); /* this will clean up for us */
		    return OSD_NOT_OK; 
	    }
	    XSync(display,False); /* be sure to get request processed */
	    sleep(2); /* enought time to notify error if any */
#ifdef USE_TIMER
	    /* agh!! sleep() disables timer alarm. have to re-arm */
	    if (play_sound) start_timer();
#endif
	    XSetErrorHandler( None ); /* Restore error handler to default */
	    if ( ! mit_shm_avail )
	    {
	      fprintf (stderr_file," failed.\nReverting to normal XPutImage() mode\n");
	      shmdt ((char *)scaled_buffer_ptr); scaled_buffer_ptr = NULL;
	      shmctl(shm_info.shmid, IPC_RMID, 0);
	      XDestroyImage(image); image = NULL;
	      goto mit_shm_failed;
	    } 
	    fprintf(stderr_file,"Success.\nUsing Shared Memory Features to speed up\n");
	    mit_shm_attached = 1;
	} else { /* Not MITSHM Allocate a bitmap buffer. */
mit_shm_failed:
#endif
  	    scaled_buffer_ptr = (char *) malloc ( 4 * xsize * ysize );
  	    if (!scaled_buffer_ptr) {
    		fprintf (stderr_file,"OSD ERROR: failed to allocate bitmap buffer.\n");
		osd_close_display(); /* this will clean up for us */
		return OSD_NOT_OK; 
	    }
  	    image = XCreateImage ( display,
			myvisual.visual , 
			myvisual.depth, 
			ZPixmap, 
			0, 
			scaled_buffer_ptr,
			xsize, ysize,
			(myvisual.depth==8)?8:32, 
			0);
  	    if (!image) {
    		fprintf (stderr_file,"OSD ERROR: could not create image.\n");
		osd_close_display(); /* this will clean up for us */
		return OSD_NOT_OK; 
  	    }
#ifdef USE_MITSHM
	}/* end of not MITSHM */
#endif
	/* call to routine to set update_display_func properly */
	if ( eval_update_display_func() == OSD_NOT_OK )
	{
		osd_close_display(); /* this will clean up for us */
		return OSD_NOT_OK;
	}
	
	if (use_layer) fprintf(stderr_file,"Using layer system\n");
	if (use_dirty) fprintf(stderr_file,"Using dirty_buffer strategy\n");

	/* 
	   and now clear screen to black. ( should be done by default, but
	   some stupid servers has BlackWindowOfScreen set to White 
	*/
	XClearWindow(display,window);
	return OSD_OK;
}

/*
 * Shut down the display, also used to clean up if any error happens
 * when creating the display
 */
void osd_close_display (void)
{
	int		i;
	
	/* first lett's free the non-X stuff */
	if (dirty_lines)     { free (dirty_lines);      dirty_lines     = NULL; }
	if (old_dirty_lines) { free (old_dirty_lines);  old_dirty_lines = NULL; }
	if (copybuffer)      { free (copybuffer);       copybuffer      = NULL; }
	if (bitmap)          { osd_free_bitmap(bitmap); bitmap          = NULL; }

	/* we can only talk to X if we have a display, thus
	   we only have to clean up all this if we have display */
	if (display)
	{
	   /* better free any allocated colors before freeing the colormap */
	   if (use_rw_palette)
	   {
	      XFreeColors (display, colormap, xpixel, totalcolors, 0);
	   }
	   else
	   {
	      for (i = 0; i < 256; i++)
	      {
	         if (xpixel_allocated[i])
	            XFreeColors (display, colormap, &xpixel[i], 1, 0);
	      }
	   }
	   
	   if (private_cmap_allocated)
	      XFreeColormap(display, colormap);

	   /* This is only allocated/done if we succeeded to get a window */
	   if (window)
	   {
#ifdef USE_MITSHM
	      if (mit_shm_avail)
	      {
	         if (mit_shm_attached)    XShmDetach (display, &shm_info);
	         if (scaled_buffer_ptr)   shmdt  (scaled_buffer_ptr);
	         if (shm_info.shmid >= 0) shmctl (shm_info.shmid, IPC_RMID, 0);
	         scaled_buffer_ptr = NULL;
	      }
#endif
	      if (image) { XDestroyImage (image); scaled_buffer_ptr = NULL; }
	      if (scaled_buffer_ptr) free (scaled_buffer_ptr);
	   }
	   XSync         (display, False); /* send all events to sync; */
	   XCloseDisplay (display);
	}
}

/*
 * Set the screen colors using the given palette.
 *
 */
void sysdep_alloc_palette(void)
{
       /* allocate color cells */ 
       if(XAllocColorCells(display, colormap, 0, 0, 0, xpixel, totalcolors))
       {
          use_rw_palette = 1;
          fprintf(stderr_file, "Using r/w palette entries to speed up, good\n");
       }
}

/* not needed under X */
void sysdep_clear_screen(void)
{
}

void sysdep_modify_pen(int pen, unsigned char red,unsigned char green,unsigned char blue)
{
	XColor		color;
	
	/* Translate VGA 0-63 values of new color to X 0-65536 values. */
	color.flags	= (DoRed | DoGreen | DoBlue);
	color.red	= (int) red << 8;
	color.green	= (int) green << 8;
	color.blue	= (int) blue << 8;
	color.pixel	= xpixel[pen];
	
	if (use_rw_palette)
	{
	   XStoreColor(display, colormap, &color);
	}
	else
	{
	   /* free previously allocated color */
	   if (xpixel_allocated[pen])
	   {
	      XFreeColors (display, colormap, &xpixel[pen], 1, 0);
	      xpixel_allocated[pen] = FALSE;
	   }
	   
	   /* allocate new color and assign it to pen index */
	   if (XAllocColor (display,colormap,&color)) 
	   {
		if (xpixel[pen] != color.pixel)
		   x_palette_dirty   = TRUE;
  		xpixel[pen]               = color.pixel;
		xpixel_allocated[pen]     = TRUE ;
	   } else {
	        if (warn_low_on_colors)
	        {
	           warn_low_on_colors = 0;
	           fprintf(stderr_file,
	              "Couldn't allocate all colors, some parts of the emulation may be black\n"  
	              "Try running xmame with the -privatecmap option\n");
	        }
		/* If color allocation failed, use black to ensure the
		   pen is not left set to an invalid color */
		xpixel[pen] = black_xpixel;
	   }
	}
}

#endif /* ifdef x11 */
