#include "cthugha.h"
#include "interface.h"
#include "keys.h"
#include "information.h"
#include "display.h"
#include "action.h"
#include "sound.h"
#include "cd_player.h"
#include "options.h"
#include "action.h"
#include "translate.h"
#include "waves.h"
#include "disp-sys.h"

#include <unistd.h>

int help_pre_key() {
    main_text = display_reprint(main_text, (char*)help_text, 0, 'l', 0, TEXT_COLOR_NORMAL);

    return 0;
}

void main_do_key() {
    char str[256];

    switch( int_var.key ) {
    case CK_NONE:
	return;
    case 'f':			change(f_flame, CHANGE_NEXT, 1);		return;
    case 'F':			change(f_flame, CHANGE_PREV, 1);		return;
    case 'g': case 'G':		change(f_flame_general, CHANGE_RANDOM, 1);	return;
    case 'w':			change(f_wave, CHANGE_NEXT, 1);			return;
/*    case 'W':			change(f_wave, CHANGE_PREV, 1);			return; */
    case 'd':			change(f_screen, CHANGE_NEXT, 1);		return;
    case 'D':			change(f_screen, CHANGE_PREV, 1);		return;
    case 't':			change(f_translation, CHANGE_NEXT, 1);		return;
    case 'T':			change(f_translation, CHANGE_PREV, 1);		return;
    case 'm':			change(f_massage, CHANGE_NEXT, 1);		return;
    case 'M':			change(f_massage, CHANGE_PREV, 1);		return;

    case 'h': case 'H':		change(f_mirror_horiz, CHANGE_NEXT, 1);		return;
    case 'v': case 'V':		change(f_mirror_vert, CHANGE_NEXT, 1);		return;

    case 's': case 'S':		change(f_flashlight, CHANGE_NEXT, 1);		return;
    case 'e': case 'E':		change(f_fft, CHANGE_NEXT, 1);			return;

    case 'p':			change(f_palette, CHANGE_NEXT, 1);		return;
    case 'P':			change(f_palette, CHANGE_NEXT, 1);		return;
    case 'b':			change(f_table, CHANGE_NEXT, 1);		return;
    case 'B':			change(f_table, CHANGE_PREV, 1);		return;
    case '3':			change(f_object, CHANGE_NEXT, 1);		return;

    case 'r': case 'R':		change(f_rgb, CHANGE_NEXT, 1);			return;

    case 'W':			wave_scale = (wave_scale+1) % 3;		return;

    case 'l': case 'L':				/* lock */
	change_lock(CHANGE_NEXT);
	return;

#if USE_DSP == 1
    case '-':					/* Sample-Rate-1000 */
	if ( (sound_options->speed -= 1000) <= 0)
	    sound_options->speed = 0;
	sound_dsp_update();

	sprintf(str, "rate: %d %s", sound_options->speed, 
		(sound_options->channels-1) ? "STEREO" : "MONO");

	msg_text = display_add_text(msg_text, str, -2, 'r', 1, TEXT_COLOR_NORMAL);
	display_scroll_text(msg_text, 8);
	return;
    case '+':					/* Sample Rate+1000 */
	sound_options->speed += 1000;
	sound_dsp_update();

	sprintf(str, "rate: %d %s", sound_options->speed, 
		(sound_options->channels-1) ? "STEREO" : "MONO");

	msg_text = display_add_text(msg_text, str, -2, 'r', 1, TEXT_COLOR_NORMAL);
	display_scroll_text(msg_text, 8);
	return;
    case '*':					/* toggle channels */
	sound_options->channels = (sound_options->channels == 1) ? 2 : 1;
	sound_dsp_update();

	sprintf(str, "rate: %d %s", sound_options->speed, 
		(sound_options->channels-1) ? "STEREO" : "MONO");

	msg_text = display_add_text(msg_text, str, -2, 'r', 1, TEXT_COLOR_NORMAL);
	display_scroll_text(msg_text, 8);
	return;
#endif

    case '<':
	sound_minnoise += 2;
    case '>':
	sound_minnoise --;
	if ( sound_minnoise < 0)	sound_minnoise = 0;
	if ( sound_minnoise > 256)	sound_minnoise = 256;
	sprintf(str, "Minnoise: %d", sound_minnoise);
	msg_text = display_add_text(msg_text, str, -2, 'r', 1, TEXT_COLOR_NORMAL);
	display_scroll_text(msg_text, 8);
	return;

    case 'x': case 'X':				/* show pcx-picture */
	new_state();
	if ( display_use_pcx) { 
	    int tmp = display_text_on_screen;
	    display_text_on_screen = 0;
	    show_pcx( 1 /*upper-left*/, 1 /*correct-colors*/);	
	    
	    change(f_pcx, (int_var.key == 'x') ? CHANGE_NEXT : CHANGE_PREV, 1);
	    
	    display();
	    display_sync_sys();
	    sleep(1);
	    display_text_on_screen = tmp;
	    update_palette();
	} else {
	    msg_text = display_add_text(msg_text, "PCX is disabled", -2, 'r', 1, TEXT_COLOR_ERROR);
	    display_scroll_text(msg_text, 8);
	}
	return;
	
    case 'a': case 'A':
	write_ini();
	return;
	
    case 'n': case 'N':			/* send request to server */
	net_request(0);
	return;

    case CK_PRINT: case '#':		/* real print screen */
	save_display();
	return;

    case CK_BACK:			/* change back */
	back_state();
	return;

    default:				/* change everything */
	general_change();
	return;
    }
    return;
}
