/*
 * CTHUGHA-X11
 *
 * X11-Version of Cthugha
 */

#include "../cthugha.h"
#include "../cthugha-X11.h"
#include "../information.h"
#include "../sound.h"
#include "../action.h"
#include "../translate.h"
#include "../options.h"
#include "../keys.h"
#include "../cd_player.h"
#include "../display.h"
#include "../disp-sys.h"
#include "../interface.h"
#include "../waves.h"
#include "dga.h"

#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xatom.h> 
#include <signal.h>

#if USE_SAVER == 1
   #include <X11/extensions/scrnsaver.h>
#endif


int xcth_saver = 0;			/* run as screen saver or not */
int xcth_panel = 1;			/* use control panel */
int xcth_dga = 0;			/* use DGA */

Display * xcth_display;
Visual * xcth_visual;
Window xcth_root;			/* root window */
Window xcth_window;			/* window to draw into */
int xcth_screen;
int xcth_planes;
GC xcth_gc;
Colormap xcth_cmap;

int rev_byte_order;


static Widget xcth_toplevel;
static XtAppContext xcth_app_con;

char * cthugha_mode_text() {
    return xcth_saver ? "xsav" : "xwin";
}

int init_ncurses() { return 0; } 
int exit_ncurses() { return 0; }

static void CreateWindow(int full, char * name);


static int ignoreError(Display * d, XErrorEvent * e) {
    return 0;
}


static void resize(int new_width, int new_height) {
    if ( ! display_on_root ) {
	if( (window_size.x != new_width) || (window_size.y != new_height) ) {
	    window_size.x = new_width;
	    window_size.y = new_height;

	    XClearWindow(xcth_display, xcth_window);

	    resize_display(window_size.x, window_size.y); 
	}
    }
}

/*
 * Handlers for Buttons
 */
static void quit() {
    cthugha_close = 1;
    exit(0);
}
static void key_button(Widget w, XtPointer data, XtPointer data2) {
    if(data)
	keys_x11((char*)data);
}

/*
 * create the menu buttons
 * handler for activated menu-items
 */
typedef struct {
    int nr;
    int pos;
} menu_data_t;

static void menuCB(Widget item, XtPointer data, XtPointer data2) {
    menu_data_t * d = data;

    if(d->nr >= 0)
	change(d->nr, d->pos, 0);
}

static Widget add_menu(char * name, feature * what, Widget parent,
		       Widget under, Widget right) {
    Arg wargs[3]; int n;
    Widget button, menu, item;
    int i;

    if(parent == NULL)
	return NULL;

    /* create menu button */
    n = 0;
    XtSetArg(wargs[n], XtNlabel, name); n++;
    if(under) {
	XtSetArg(wargs[n], XtNfromVert, under); n++;
    }
    if(right) {
	XtSetArg(wargs[n], XtNfromHoriz, right); n++;
    }
    button = XtCreateManagedWidget(name, menuButtonWidgetClass, parent, wargs, n);
    if(button == NULL)
	return NULL;

    /* create the menu popup */
    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
			      button, NULL, 0);
    if(menu == NULL) {
	XtDestroyWidget(button);
	return NULL;
    }

    if (what->nr_entries <= 0) {
	XtSetArg(wargs[0], XtNlabel, "none");
	XtCreateManagedWidget("none", smeBSBObjectClass, menu, wargs, 1);
    }
    
    /* create menu items */
    for(i=0; i < what->nr_entries; i++) {
	menu_data_t * md = cth_memory(NULL, sizeof(md), NULL);

	md->nr = what->f_nr;
	md->pos = i;

	XtSetArg(wargs[0], XtNlabel, what->entries[i].name);
	item = XtCreateManagedWidget(what->entries[i].name, smeBSBObjectClass, menu, wargs, 1);
	XtAddCallback(item, XtNcallback, menuCB, md );
    }
    return button;
}


/*
 * Create the panel with buttons and menus 
 */
static int xcth_create_panel() {
    Widget panel;
    Widget quit_button, change_button;
    Widget menu[7];
    Arg wargs[3];

    /* create the panel formWidget */
    panel = XtCreateManagedWidget("panel", formWidgetClass,
				 xcth_toplevel, NULL, 0);

    /* create the quit button */
    XtSetArg(wargs[0], XtNlabel, "Quit!");
    quit_button = XtCreateManagedWidget("quit", commandWidgetClass, panel, wargs, 1);
    XtAddCallback(quit_button, XtNcallback, (XtCallbackProc)quit, NULL);

    /* create the change button */
    XtSetArg(wargs[0], XtNlabel, "Change!");
    XtSetArg(wargs[1], XtNfromHoriz, quit_button);
    change_button = XtCreateManagedWidget("change", commandWidgetClass, panel, wargs, 2);
    XtAddCallback(change_button, XtNcallback, key_button, " ");
    
    /* create the menus */
    menu[0] = add_menu("Display", &screens, panel, quit_button, NULL); 
    menu[1] = add_menu("Wave", &waves,	    panel, quit_button, menu[0]);
    menu[2] = add_menu("Flame", &flames,    panel, quit_button, menu[1]);
    menu[3] = add_menu("Translation", &translations, panel, quit_button, menu[2]);
    menu[4] = add_menu("Palette", &palettes,panel, quit_button, menu[3]);
    menu[5] = add_menu("PCX", &pcxs,        panel, quit_button, menu[4]);
    menu[6] = add_menu("Objects", &objects, panel, quit_button, menu[5]);

    /* realize window */
    XtRealizeWidget(xcth_toplevel);

    return 0;
}

/*
 * create an empty cursor
 */
static Cursor xcth_cursor() {
    Pixmap blank_pix;
    XColor dummyColor;
    GC   bit_1_gc, bit_0_gc;

    blank_pix = XCreatePixmap(xcth_display, xcth_root, 1, 1, 1);
    bit_0_gc = XCreateGC(xcth_display, blank_pix, 0, 0);
    XSetForeground(xcth_display, bit_0_gc, 0);
    
    bit_1_gc = XCreateGC(xcth_display, blank_pix, 0, 0);
    XSetForeground(xcth_display, bit_1_gc, ~0);
    
    XFillRectangle(xcth_display, blank_pix, bit_0_gc, 0, 0, 1, 1);
    
    return XCreatePixmapCursor(xcth_display, blank_pix, blank_pix, 
			       &dummyColor, &dummyColor, 0, 0);
}


/*
 * initialization for xcthugha
 */
int cth_init(int * argc, char *argv[]) {
    unsigned int byte_order_test = 0x04030201;

    seteuid(getuid());			/* give up root privileges */

    /* intialize application */
    xcth_toplevel = XtAppInitialize(&xcth_app_con, 
				    xcth_saver ? "Cthugha-saver" : "Cthugha", 
				    NULL, 0,
				    argc, argv, NULL, NULL, 0);
    
    xcth_display = XtDisplay(xcth_toplevel);
    xcth_screen	 = DefaultScreen(xcth_display);
    xcth_visual	 = DefaultVisual(xcth_display, xcth_screen);
    xcth_planes	 = DefaultDepth(xcth_display, xcth_screen );
    bypp         = (xcth_planes+7) / 8;
    xcth_root    = DefaultRootWindow(xcth_display);

    rev_byte_order = (ImageByteOrder(xcth_display) == MSBFirst) ? 1 : 0;
    if( *(char*)&byte_order_test == 4)
	rev_byte_order = !rev_byte_order;

    return 0;
}


#if USE_SAVER == 1

/*
 * Screen saver:
 *
 * Because of problems with XInstallColormap (only WMs should use it)
 * I use the following method to get the correct colors:
 *  - Install the screen saver, completely normal
 *  - On activation: turn off the screen saver, create a window filling the whole
 *                   screen and use that for drawing. For that window I can
 *                   specify a private colormap, so everything works find.
 */
static int  ss_event = 0;
static int  screen_saved = False;

static void StartSaver();
static void StopSaver();

/*
 * Initialize the screen saver
 */
static int init_saver() {
    XSetWindowAttributes attr;
    int			ss_error = 0;
    XID			kill_id;
    Atom		kill_type;
    XScreenSaverInfo    *info;
    unsigned long	mask;
    Pixmap		blank_pix;
    GC			black_gc;
    unsigned long	black_pixel = 0;

    free_sound();		/* release sound again, get only when needed */
	
    window_size.x = DisplayWidth(xcth_display, xcth_screen);
    window_size.y = DisplayHeight(xcth_display, xcth_screen);

    /* check, if screen saver is possible */
    if (!XScreenSaverQueryExtension (xcth_display, &ss_event, &ss_error))
	return 1;

    XScreenSaverUnregister(xcth_display, xcth_screen);
    if(XScreenSaverGetRegistered(xcth_display,xcth_screen,&kill_id,&kill_type))
	XKillClient(xcth_display, kill_id);
    
    /* make sure, we get screen saver events */
    XScreenSaverSelectInput(xcth_display, xcth_root, ScreenSaverNotifyMask);

    blank_pix = XCreatePixmap (xcth_display, xcth_root, 1, 1, 1);
    XScreenSaverRegister(xcth_display, xcth_screen, (XID) blank_pix, XA_PIXMAP); 
    
    info = XScreenSaverAllocInfo();
    XScreenSaverQueryInfo(xcth_display, xcth_root, info);

    mask = 0;
    XScreenSaverSetAttributes(xcth_display, xcth_root, 0, 0,
			      window_size.x, window_size.y, 0,
			      CopyFromParent, CopyFromParent, 
			      CopyFromParent, mask, &attr);
			     
    XSync (xcth_display, False);

    XSetErrorHandler (ignoreError);

    xcth_gc = XCreateGC (xcth_display, xcth_root, 0, 0);
    black_gc = XCreateGC (xcth_display, xcth_root, 0, 0);
    XSetForeground (xcth_display, black_gc, black_pixel);

    signal(SIGINT, quit);    signal(SIGQUIT, quit);
    signal(SIGHUP, quit);    signal(SIGKILL, quit);
    signal(SIGTERM, quit);
	
    printfv(1, "Ready.\n");

    if (info->state == ScreenSaverOn) {
	if (info->kind != ScreenSaverExternal) {
	    XResetScreenSaver (xcth_display);
	    XActivateScreenSaver (xcth_display);
	}
	StartSaver();
    }

    return 0;
}


int ss_timeout, ss_interval, ss_prefer_blanking, ss_allow_exposures;
static void StartSaver() {
    Pixmap		blank_pix;

    if (screen_saved)			/* check if running */
	return;

    screen_saved = 2;			/* currently starting */

    /* deactivate screen saver, but remember all values */
    XGetScreenSaver(xcth_display, &ss_timeout, &ss_interval,
		    &ss_prefer_blanking, &ss_allow_exposures);
    XResetScreenSaver (xcth_display);
    XSetScreenSaver(xcth_display, 0, ss_interval,
		    ss_prefer_blanking, ss_allow_exposures);

    blank_pix = XCreatePixmap (xcth_display, xcth_root, 1, 1, 1);
    XScreenSaverRegister(xcth_display, xcth_screen, (XID) blank_pix, XA_PIXMAP); 

    XSync(xcth_display, True);

    CreateWindow(1, "xcthugha-saver");
    
    XRaiseWindow(xcth_display,xcth_window);    

    init_graph_mode();			/* some extra initialization stuff */
    alloc_sound();			/* get sound only when needd */

    screen_saved = 1;
}

static void StopSaver() {
    if( screen_saved == 2)		/* currently starting */
	return;

    if (!screen_saved)			/* not saving */
	return;

    /* OK. Saver is running, not stop it */
    exit_graph_mode();
    free_sound();

    XDestroyWindow(xcth_display, xcth_window);

    /* reactivate saver */
    XSetScreenSaver(xcth_display, ss_timeout, ss_interval,
		    ss_prefer_blanking, ss_allow_exposures);
    screen_saved = 0;			/* no longer saving now */
}

#endif	/* USE_SAVER */


/*
 * create a window
 */
static void CreateWindow(int full, char * name) {
    XSetWindowAttributes attr;
    unsigned long mask;
    XSizeHints  * sh;
    unsigned long	black_pixel = 0;
    
    attr.background_pixel = black_pixel;
    attr.event_mask = ButtonPressMask | PointerMotionMask | KeyReleaseMask;
    attr.cursor = xcth_cursor();
    mask = CWEventMask | CWCursor | CWBackPixel;
    
    /* Create the window */
    xcth_window = XCreateWindow(xcth_display, 
				DefaultRootWindow(xcth_display), 0, 0,
				window_size.x, window_size.y, 
				0, CopyFromParent, InputOutput,
				CopyFromParent, mask, &attr);
    
    XStoreName(xcth_display, xcth_window, name);

    /* allocate the colormap */
    init_palettes();
    
    if(full) {
	/* make sure our window get's placed automatically, and filles the whole screen */
	sh = XAllocSizeHints();
	sh->flags = USPosition | PPosition | PBaseSize | PWinGravity;
	sh->x = sh->y = 0;
	sh->base_width = window_size.x;
	sh->base_height = window_size.y;
	sh->win_gravity = 0;
	XSetWMNormalHints(xcth_display, xcth_window, sh);
    }

    XMapWindow(xcth_display,xcth_window);
}

/*
 *  main for xcthugha
 */
int cth_main() {
    printfv(0, "Setting X11...\n");

    /* run as screen saver */
    if( xcth_saver ) {
#if USE_SAVER == 1
	init_saver();
#else
	printfe("Screensaver was disabled at compile.\n");
	return 1;
#endif
    }

    /* with DGA support */
    if(xcth_dga) {
#if USE_DGA == 1
	if(InitDGAEnvironment()) {
	    printfe("Unable to init DGA environment!\n");
	    return 1;
	}

	if(!xcth_saver) {
	    CreateWindow(1, "xcthugha-dga");
	    XRaiseWindow(xcth_display,xcth_window);
	    
	    if( init_graph_mode() ) 
		return 1;

	    xcth_gc = XCreateGC(xcth_display, xcth_window, 0, 0);
	}
#else
	printfe("DGA was disabled at compile.\n");
	return 1;
#endif
    } 

    /* nothing special */
    if(!xcth_dga && !xcth_saver) {
	if(xcth_panel) {			/* create the control panel */
	    xcth_create_panel(); 
	    XSelectInput(xcth_display, XtWindow(xcth_toplevel), 
			 KeyReleaseMask | StructureNotifyMask); 
	}
		     
	if(display_on_root) {			/* display on root window */
	    xcth_window = xcth_root;
	    
	    /* get size of screen */
	    window_size.x = DisplayWidth(xcth_display, xcth_screen);
	    window_size.y = DisplayHeight(xcth_display, xcth_screen);
	    
	    init_palettes();
	    if( init_graph_mode() ) 
		return 1;

	} else {				/* display in a window */
	    window_size = disp_size;
	    CreateWindow(0, "Cthugha");

	    if( init_graph_mode() )
		return 1;
	}

	xcth_gc = XCreateGC(xcth_display, xcth_window, 0, 0);
    }

    while(cthugha_close == 0) {
	XEvent event;
	XWindowAttributes wa;
	
	while( XtAppPending(xcth_app_con) 
#if USE_SAVER == 1
	       || (xcth_saver && !screen_saved)
#endif
	    ) {

	    XtAppNextEvent(xcth_app_con, &event);

	    if( event.type == KeyRelease) { 		/* handle keyboard input */
		char key_buff[256];
		int count;
		KeySym ks;

		count = XLookupString( (XKeyEvent*)&event,
				      key_buff, 256, &ks, NULL);
		key_buff[count] = '\0';
		if( count == 0) {
		    char * tmp = XKeysymToString(ks);
		    strncpy(key_buff, tmp ? tmp : "", 256);
		}
		keys_x11(key_buff);

		/* Stop the screen saver only on 'q' */
		if( ((key_buff[0] == 'q') || (key_buff[1] == 'Q')) &&
		    (key_buff[1] == '\0') )
		    StopSaver();
		
#if USE_SAVER == 1
	    } else if (event.type == ss_event) {	/* handle screen saver events */

		XScreenSaverNotifyEvent * sevent;
		sevent = (XScreenSaverNotifyEvent *) &event;

		/* turn on screen saver */
		if (sevent->state == ScreenSaverOn) {
		    if (sevent->kind != ScreenSaverExternal) {
			XResetScreenSaver (xcth_display);
			XActivateScreenSaver (xcth_display);
		    } else {
			StartSaver ();
		    }
		    /* turn off screen saver */
		} else if (sevent->state == ScreenSaverOff) {
		    StopSaver ();
		}
#endif
	    } else if( (event.type == MotionNotify) && (xcth_saver) ){
		StopSaver();
		
	    } else {
		XtDispatchEvent(&event);
	    }

	    interface();
	}
    	XGetWindowAttributes(xcth_display, xcth_window, &wa);
	resize(wa.width, wa.height); 
	    
	display_sound(); 
	interface();
    }

    return 0;
}
    












