/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgDeriv.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:35 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Deriv"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char**argv)
{
  it_image *in1,*in2,*out1;
  int width,height,x,y,load_file,v_x,v_y,y_end,v_width;
  it_float *in_ptr1,*in_ptr2,*out_ptr,*ang_ptr;
  double val,min,max,angle,aa,cc,cos_const,sin_const;
  char *ptr;
  double strtod();

  IFHELP
    {
      fprintf(stderr,"img%s - Compute 1D directional derivative\n",
	      PRGNAME);
      fprintf(stderr,"img%s [angle]\n",
	      PRGNAME);
      fprintf(stderr,"img%s [filename]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  file: Float\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc!=1 && argc!=2)
    ERROR("invalid parameters");
  angle=0.0;
  load_file=0;
  if(argc==2)
    {
      angle=strtod(argv[1],&ptr);
      angle=angle*M_PI/180.0;
      if(ptr==argv[1])
	load_file=1;
    }

  /* Loop for all images */
  do {
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    
    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    in2=NULL;
    if(argc==1)
      {
	in2=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
	if(in2==NULL)
	  ERROR("can't import angle file");
      }
    if(load_file)
      {
	in2=i_load_image(argv[1],-1,IT_FLOAT,IM_FRAGMENT);
	if(in2==NULL)
	  ERROR("can't load angle file");
      }

    v_x=in1->valid_x;
    v_y=in1->valid_y;
    v_width=in1->valid_width-1;
    y_end=v_y+in1->valid_height-1;
    imgInitMinMax(min,max);

    if(in2==NULL)
      {
	/* Derivative at a constant angle */
	angle+=M_PI_4;
	cos_const=M_SQRT1_2*cos(angle);
	sin_const=M_SQRT1_2*sin(angle);
	for(y=v_y;y<y_end;y++)
	  {
	    in_ptr1=im_float_row(in1,y)+v_x;
	    in_ptr2=im_float_row(in1,y+1)+v_x;
	    out_ptr=im_float_row(out1,y)+v_x;
	    for(x=0;x<v_width;x++)
	      {
		aa= *in_ptr1++;
		cc= *in_ptr2++;
		val=(*in_ptr2-aa)*cos_const+(*in_ptr1-cc)*sin_const;
		*out_ptr++ =val;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
      }
    else
      {
	/* Derivative at an angle from in2 */
	if(in2->width!=width || in2->height!=height)
	  ERROR("images are of different sizes");
	for(y=v_y;y<y_end;y++)
	  {
	    in_ptr1=im_float_row(in1,y)+v_x;
	    in_ptr2=im_float_row(in1,y+1)+v_x;
	    ang_ptr=im_float_row(in2,y)+v_x;
	    out_ptr=im_float_row(out1,y)+v_x;
	    for(x=0;x<v_width;x++)
	      {
		aa= *in_ptr1++;
		cc= *in_ptr2++;
		angle=M_PI_4+ *ang_ptr++;
		cos_const=M_SQRT1_2*cos(angle);
		sin_const=M_SQRT1_2*sin(angle);
		val=(*in_ptr2-aa)*cos_const+(*in_ptr1-cc)*sin_const;
		*out_ptr++ =val;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
	i_destroy_image(in2);
      }

    out1->valid_x=v_x;
    out1->valid_y=v_y;
    out1->valid_width=v_width;
    out1->valid_height=in1->valid_height-1;
    out1->min_value=min;
    out1->max_value=max;

    i_destroy_image(in1);

    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
