/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgPpmToFlt3.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:53 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "PpmToFlt3"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y;
  it_rgb *rgb_ptr;
  it_float *flt_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert each PPM colour image to 3 x Float images\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: ppm\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  do {
    in1=i_read_image_file(stdin,IT_RGB,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;

    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");
    out1->min_value=0.0;
    out1->max_value=255.0;

    /* Copy Red Component */
    for(y=0;y<height;y++)
      {
	rgb_ptr=im_rgb_row(in1,y);
	flt_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++)
	  *flt_ptr++=(it_float) (rgb_ptr++)->r;
      }
    i_write_image_file(stdout,out1,IF_BINARY);

    /* Copy Green Component */
    for(y=0;y<height;y++)
      {
	rgb_ptr=im_rgb_row(in1,y);
	flt_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++)
	  *flt_ptr++=(it_float) (rgb_ptr++)->g;
      }
    i_write_image_file(stdout,out1,IF_BINARY);

    /* Copy Blue Component */
    for(y=0;y<height;y++)
      {
	rgb_ptr=im_rgb_row(in1,y);
	flt_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++)
	  *flt_ptr++=(it_float) (rgb_ptr++)->b;
      }
    i_destroy_image(in1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
