module Seafigs(
	sky, blue_sky, clouds, clouds2, gull, man, sun, vm, windmill, palm
	) where

import Prelude
import Movie(Movie, rBESIDE, rOVERLAY, overlay, mkMovie, picsOf)
import qualified Movie as M
import Color(Color(..))
import Polygon(Poly)
import qualified Polygon as Poly
import Picture(Pic)
import qualified Picture as Pic
{-
	(
	wid, 
	overlay, twist, beside, above, over,
	flipx
	)
-}
import Utility(osc)
import Shapes(box, tri)
import qualified Behaviour as B
	{-
	(
	scale_rel, apply, bPar, mov, movto, rot, flip
	)
	-}
import Inbetween(inbetween)
import Defaults(right, smaller, punit, cw)

-- This entire module used to leak a lot of space because everything was
-- a CAF so I added dummy arguments

blue_sky :: () -> Movie
blue_sky _ = M.repeat (box LightBlue 1000 1000)

sky:: Color -> Movie
sky c = M.repeat (box c 1000 1000)

clouds2:: Movie
clouds2 = B.apply (B.mov (repeat (cld_wid,0))) (rBESIDE[cld,cld])
 where 
  cld_wid = -(Pic.wid (head (M.picsOf cld)))
  cld     = B.apply (B.bPar [right, B.mov (repeat (250,-50))]) cldm1
  cldm1   = M.repeat cloud1
 
clouds:: () -> Movie
clouds _
  = rOVERLAY
      [B.bPar [right, B.mov (repeat (250,-50))] `B.apply` cloudm1,
       B.bPar [right, B.mov (repeat (0,  -50))] `B.apply` cloudm2,
       B.bPar [right, B.mov (repeat (250,-75))] `B.apply` cloudm2,
       B.bPar [right, B.flip, smaller,B.mov (repeat (200,-100))] `B.apply` cloudm2,
       B.bPar [right, B.flip, smaller,B.mov (repeat (300,-125))] `B.apply` cloudm1,
       B.bPar [right, right, B.mov (repeat (-50,50))] `B.apply` cloudm1]
       where cloudm1 = M.repeat cloud1
             cloudm2 = M.repeat cloud2

cloud1, cloud2 :: Pic
cloud1 = Pic.poly White ply
         where ply = [(142,301),(169,309),(180,315),(192,312),
                      (196,308),(202,302),(216,300),(224,308),
                      (238,312),(258,311),(274,301),(278,283),
                      (265,279),(246,279),(230,281),(197,286),
                      (185,288),(167,287),(148,287),(136,292),
                      (136,292),(142,301)]


cloud2 = Pic.poly White ply
         where ply = [(51,262), (56,266),
                      (66,265), (90,264), (92,266), (98,270),
                      (111,268),(137,268),(155,266),(174,266),
                      (183,262),(183,253),(162,251),(136,254),
                      (132,250),(126,248),(115,252),(109,253),
                      (98,252), (90,253), (88,254), (67,254),
                      (56,252), (49,254), (47,259), (51,262)]

gull :: () -> Movie
gull _ = mkMovie $ osc [gull1,gull2]

gull1, gull2 :: Pic
gull1 = Pic.poly Black [(2,4),(6,4),(9,2),(10,0),(11,2),(16,4),(20,4)]

gull2 = Pic.poly Black [(0,0),(2,2),(6,3),(9,2),(12,3),(16,2),(18,0)]

man :: () -> Movie
man _ = mkMovie $ osc [man1,man2,man3]

man1, man2, man3 :: Pic
man1 = Pic.polys [
   Poly.vecs Black [(0,0),(10,0),(20,40),(30,60),(40,20),(60,0),(50,0)],
   Poly.vecs Black [(0,40),(20,60),(30,80),(50,70),(60,60)],
   Poly.vecs Black [(30,60),(30,100)],
   Poly.vecs Black [(30,100),(25,100),(20,105),(23,112),(20,115),
	            (30,120),(35,120),(40,115),(40,110),(35,105)]
   ]

man2 = Pic.polys [
   Poly.vecs Black [(20,0),(30,0),(20,40),(30,60),(45,30),(60,20),(50,0)],
   Poly.vecs Black [(0,60),(20,60),(20,80),(40,80),(50,60)],
   Poly.vecs Black [(30,60),(20,100)],
   Poly.vecs Black [(20,100),(15,100),(10,105),(13,112),(10,115),
	            (20,120),(30,120),(30,115),(30,110),(25,105)]
   ]

man3 = Pic.polys [
   Poly.vecs Black [(0,15),(5,10),(15,45),(30,60),(35,25),(44,10),(35,0)],
   Poly.vecs Black [(10,40),(22,60),(20,80),(40,75),(45,44)],
   Poly.vecs Black [(30,60),(20,100)],
   Poly.vecs Black [(20,100),(19,100),(14,105),(17,112),(14,115),
        	   (24,120),(34,120),(34,115),(34,110),(29,105)]
   ]

sun :: () -> Movie
sun _ = M.repeat sun'
      where
      sun' = foldr1 Pic.overlay [sun1,
                                 Pic.twist (pi/24.0) sun1,
                                 Pic.twist (pi/12.0) sun1]

sun1 :: Pic
sun1 = Pic.poly Yellow [(43,16),(18,27),(9,51),(20,71),(42,81),
                        (66,73),(76,47),(69,25),(43,15),(43,16)]

vm :: () -> Movie
vm _ =  M.mkMovie $ cycle [vm1,vm2]

vm1, vm2 :: Pic
vm1 = Pic.beside (box Brown 10 15)
                 (Pic.above light1 (box Brown 40 80))
      where light1 = box Yellow 10 10

vm2 = Pic.beside (box Brown 10 15)
                 (foldr1 Pic.above [light,light2,box Brown 40 80])
      where light2 = Pic.over (box Red 10 10) (box White 5 5)
            light  = Pic.polys [ 
                       Poly.vecs Red [(5,5), (10,2), (0,30),(5,5)],
                       Poly.vecs Red [(20,2),(25,5),(30,30),(20,2)],
                       Poly.vecs Red [(15,15),(20,15),(15,50),(10,25)]
                       ]

windmill :: () -> Movie
windmill _
   = B.apply
       (B.bpar (B.mov (repeat (punit*3,0))) (B.scale_rel (0,0) (repeat 3)))
       (overlay (body ()) (B.apply (B.movto (repeat (100,400))) prop))

blade = M.repeat (tri Red (0,0) (100,0) (50,300))
prop  = B.apply cw fan

fan  = rOVERLAY [fan1,fan2,fan3,fan4]
fan1 = blade
fan2 = B.rot (repeat (50,300)) (repeat (pi/2.0)) `B.apply` fan1
fan3 = B.rot (repeat (50,300)) (repeat (pi/2.0)) `B.apply` fan2
fan4 = B.rot (repeat (50,300)) (repeat (pi/2.0)) `B.apply` fan3

body :: () -> Movie
body _ = M.repeat (Pic.poly Brown [(0,0),(200,0),(170,300),(100,400),(30,300),(0,0)])


palm :: () -> Movie
palm _ = mkMovie (osc (picsOf palms))
 where 
  palms = inbetween 3 palm1 (Pic.flipx 100 palm1)
  palm1 = foldr1 Pic.overlay [trunk,frond1,frond2,frond3,frond4]

  frond1 = Pic.polys [
	     Poly.vecs Green [(50,60),(60,70),(80,60)],
	     Poly.vecs Green [(50,70),(60,80),(80,70)],
	     Poly.vecs Green [(50,80),(55,90),(70,80)],
	     Poly.vecs Green [(60,70),(55,90),(50,100)]
	     ]

  frond2 = Pic.flipx 50 frond1

  frond3 = Pic.polys [ 
	     Poly.vecs Green [(10,70),(5,80)],
	     Poly.vecs Green [(10,80),(10,90)],
	     Poly.vecs Green [(20,90),(20,100)],
	     Poly.vecs Green [(30,95),(40,104)],
	     Poly.vecs Green [(5,80),(20,100),(40,104),(50,100)]
	     ]

  frond4 = Pic.polys [
	    Poly.vecs Green [(0,100),(5,110)],
	    Poly.vecs Green [(15,105),(15,115)],
	    Poly.vecs Green [(25,105),(30,115)],
	    Poly.vecs Green [(35,105),(40,115)],
	    Poly.vecs Green [(5,110),(30,115),(50,110),(50,100)]
	    ]

  trunk  = Pic.poly Brown [(100,0),(95,40),(80,80),(70,90),(60,97),(50,100)]


