module GraphicsUtils
	( clearWindow, draw
	, getKey,      getKeyEx
	, getButton,   getLBP, getRBP
	, windowSize
	) where

import GraphicsPicture
import GraphicsWindows
import GraphicsEvent( Event(..) )

----------------------------------------------------------------
-- The interface
----------------------------------------------------------------

clearWindow  :: Window -> IO ()
draw         :: Window -> Picture -> IO ()

windowSize   :: Window -> IO Point

-- wait for left/right mouse button up
getLBP       :: Window -> IO Point
getRBP       :: Window -> IO Point

-- wait for left/right mouse button to go down/up
getButton    :: Window -> Bool -> Bool -> IO Point

-- wait for a key to go down then a (possibly different) key to go up
getKey       :: Window -> IO Char

-- wait for key to go down/up
getKeyEx     :: Window -> Bool -> IO Char

----------------------------------------------------------------
-- The window buffer
----------------------------------------------------------------

clearWindow w = setPicture w empty

draw w p = do
	oldPicture <- getPicture w
	setPicture w (p `over` oldPicture)

----------------------------------------------------------------
-- Simple input operations
----------------------------------------------------------------

getLBP w = getButton w True  True
getRBP w = getButton w False True
getKey w = do { getKeyEx w True; getKeyEx w False }

----------------------------------------------------------------
-- Slightly more complicated input operations
----------------------------------------------------------------

getKeyEx w down = loop
 where
  loop = do
	e <- getEvent w
	case e of 
	Key { char = c, isDown } 
          |  isDown == down 
          -> return c
	_ -> loop

getButton w left down = loop
 where
  loop = do
	e <- getEvent w
	case e of 
	Button {pt,isLeft,isDown} 
          | isLeft == left && isDown == down
          -> return pt
	_ -> loop

----------------------------------------------------------------

windowSize w = do
 	((l,t),(r,b)) <- windowRect w
        return (r-l, b-t)

----------------------------------------------------------------
-- The end
----------------------------------------------------------------
