.TH RICC G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
ricc - Riccati equation 
.SH CALLING SEQUENCE
.nf
[X]=ricc(A,B,C,"cont")
[X]=ricc(F,G,H,"disc")
.fi
.SH PARAMETERS
.TP 10
A,B,C 
: real matrices of appropriate dimensions
.TP 
F,G,H 
: real matrices of appropriate dimensions
.TP
X
: real matrix
.TP 15
"cont","disc"'
: imposed string (flag for continuous or discrete)
.SH DESCRIPTION
Riccati solver.
.LP
Continuous time:
.nf
  X=ricc(A,B,C,'cont')
.fi
gives a solution to the continuous time ARE
.nf
  A'*X+X*A-X*B*X+C=0 .
.fi 
\fVB\fR and \fVC\fR are assumed to be nonnegative definite.
\fV(A,G)\fR is assumed to be stabilizable with \fVG*G'\fR a full rank
factorization of \fVB\fR.
.LP
\fV(A,H)\fR is assumed to be detectable with \fVH*H'\fR a full rank
factorization of \fVC\fR.

.LP
Discrete time:
.nf
  X=ricc(F,G,H,'disc')
.fi
gives a solution  to the discrete time ARE 
.nf
  X=F'*X*F-F'*X*G1*((G2+G1'*X*G1)^-1)*G1'*X*F+H
.fi
\fVF\fR is assumed invertible and   \fVG = G1*inv(G2)*G1'\fR.
.LP
One  assumes  \fV(F,G1)\fR stabilizable and \fV(C,F)\fR detectable
with \fVC'*C\fR full rank factorization of \fVH\fR. Use preferably
\fVric_desc\fR.
.SH EXAMPLE
.nf
//Standard formulas to compute Riccati solutions
A=rand(3,3);B=rand(3,2);C=rand(3,3);C=C*C';R=rand(2,2);R=R*R'+eye;B=B*inv(R)*B';
X=ricc(A,B,C,'cont');
norm(A'*X+X*A-X*B*X+C,1)
H=[A -B;-C -A'];
[T,d]=gschur(eye(H),H,'cont');T=T(:,1:d);
X1=T(4:6,:)/T(1:3,:);
norm(X1-X,1)
[T,d]=schur(H,'cont');T=T(:,1:d);
X2=T(4:6,:)/T(1:3,:);
norm(X2-X,1)
//       Discrete time case
F=A;B=rand(3,2);G1=B;G2=R;G=G1/G2*G1';H=C;
X=ricc(F,G,H,'disc');
norm(F'*X*F-(F'*X*G1/(G2+G1'*X*G1))*(G1'*X*F)+H-X)
H1=[eye(3,3) G;zeros(3,3) F'];
H2=[F zeros(3,3);-H eye(3,3)];
[T,d]=gschur(H2,H1,'disc');T=T(:,1:d);X1=T(4:6,:)/T(1:3,:);
norm(X1-X,1)
Fi=inv(F);
Hami=[Fi Fi*G;H*Fi F'+H*Fi*G];
[T,d]=schur(Hami,'d');T=T(:,1:d);
Fit=inv(F');
Ham=[F+G*Fit*H -G*Fit;-Fit*H Fit];
[T,d]=schur(Ham,'d');T=T(:,1:d);X2=T(4:6,:)/T(1:3,:);
norm(X2-X,1)
.fi
.SH SEE ALSO
riccati, ric_desc, schur, gschur


