/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/kr_ui_rpc_main.c,v $
  SHORTNAME      : kr_ui_rpc_main
  SNNS VERSION   : 4.1

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.8 $
  LAST CHANGE    : $Date: 1995/11/16 07:26:20 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#ifdef sgi
#include <sym.h>
#include <exception.h>
#endif
#include <sys/types.h> /* open */
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h> /* for pmap_unset */
#include <rpc/pmap_prot.h> /* for pmap_unset */
#include <string.h> /* strcmp */ 
#include <string.h> /* strcmp */ 
#include <signal.h>
#include <sys/signal.h>
#include <sys/ioctl.h> /* ioctl, TIOCNOTTY */
#include <sys/stat.h> /* open */
#include <fcntl.h> /* open */
#include <unistd.h> /* getdtablesize */
#include <memory.h>
#include <syslog.h>
#include <sys/param.h> /* MAXHOSTNAMELEN */
#include <sys/time.h>
#include <sys/errno.h>
#include <sys/resource.h>



#include "ui_rpcsnns.h"
#include "ui.h"
#include "kr_ui_rpc.h"
#include "kr_ui_rpc_main.ph"

extern void snnskernelprog_40(struct svc_req *rqstp, register SVCXPRT *transp);

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
char *getDomainName(void)
{
    static char domain[MAXDOMAINDLEN+1];
    char *hp;
    if ( (hp = getenv("DOMAINNAME"))!= NULL){
	strncpy(&domain[0],hp,MAXDOMAINDLEN);
	return(&domain[0]);
    }
    if( getdomainname(domain,MAXDOMAINDLEN)==0){/* is used for Yellowpage */
	return(&domain[0]);
    }
    domain[0] = '.';
    domain[1] = '\0';
    return(&domain[0]);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
void QuitKernel(int Mode)
{
    char buf[128];
    char hostname[MAXHOSTDLEN];
    int  hostlen=16;
    (void) pmap_unset(SNNSKERNELPROG, rpcversion);
    
    switch(Mode){
      case SAVENET:
	gethostname(hostname,hostlen);
	sprintf(buf,"%s.%ld.%d.net",hostname,rpcversion,getpid());
	/* Netzwerk sichern */
	krui_saveNet(buf,NULL);
	break;
    }
    exit(0);
} 

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void _msgout(char* msg)
{
	syslog(LOG_ERR, msg);
}


/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

void
checkForRPCCalls(void)
{
    struct timeval timeout;

#ifdef FD_SETSIZE
    fd_set readfds;
#else
    int readfds;
#endif /* def FD_SETSIZE */
    extern int errno;

#ifdef FD_SETSIZE
    readfds = svc_fdset;
#else
    readfds = svc_fds;
#endif /* def FD_SETSIZE */
    /*
     * get requests without waiting
     */
    timeout.tv_sec=0L;
    timeout.tv_usec=0L;
    switch (select(_rpc_dtablesize(), &readfds, (int *)0, (int *)0,
		   (struct timeval *)&timeout)) {
      case -1:
	if (errno == EINTR) {
	    return;
	}
	return;
      case 0:
	return;
      default:
	svc_getreqset(&readfds);
    }
    return;
}


/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

#ifdef __linux__
static int
sigalarmcallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigalarmcallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    signal(SIGALRM, sigalarmcallback);
    /* Decrease timeout */
    acttimervalue--;

    /* Timeout reached => Quit */
    if (acttimervalue < 0){
	QuitKernel(SAVENET);
    }
#ifdef __linux__
    return 0;
#endif
}


/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

#ifdef __linux__
static int
sigtermcallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigtermcallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    fprintf(stderr,"Caught Signal %d, terminating ... \n",sig);
    if(sig == 15)
	QuitKernel(NOSAVE);
    else
	QuitKernel(SAVENET);
#ifdef __linux__
    return 0;
#endif
	
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

#ifdef __linux__
static int
sigrpccallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigrpccallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    checkForRPCCalls();    
#ifdef __linux__
    return 0;
#endif
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

#ifdef __linux__
static int
sigpipecallback(int sig, int code,const struct sigaction * scp, struct sigaction *addr)
#else
static void
sigpipecallback(int sig, int code, struct sigcontext * scp, char *addr)
#endif
{
    fprintf(stderr,"Caught Signal Broken Pipe, ignoring ... \n");
#ifdef __linux__
    return 0;
#endif
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void checkall(struct svc_req *rqstp, register SVCXPRT *transp)
{
    struct authunix_parms *unix_cred;
    static long counter=0;

    /* Save transp for reply in user functions */
    global_transp = transp;
    acttimervalue=timervalue;
    if (! rqstp->rq_proc == NULLPROC){
	switch(rqstp->rq_cred.oa_flavor){
	  case AUTH_UNIX:
	    unix_cred = (struct authunix_parms *)rqstp->rq_clntcred;
	    if(anzClients >0){
		switch(kernel_config.kernelMode){
		  case NORMALKERNEL:
		  case COOP_M_KERNEL:
		    if( uid == unix_cred->aup_uid){
			/* Is xgui the same */
			rpc_CheckXgui(&xguiclient);
			break;
		    }
		    svcerr_weakauth(transp);
		    return;
		}
	    }
	    break;
	  default:
	    svcerr_weakauth(transp);
	    return;
	}	
    }

#ifdef DEBUG
/*printf("Execute command Number : %ld command : %d \n",counter++,rqstp->rq_proc);
*/
#endif

#ifndef KERNELSLAVE
    snnskernelprog_40(rqstp, transp);
#else
    snnskernelslaveprog_40(rqstp, transp);
#endif
}

/*****************************************************************************
  FUNCTION : make_version

  PURPOSE  : 
  RETURNS  : The version number for the portmapper
  NOTES    : 987654321
             ||||\\\\\
             |||| ------> User Id
             || \--> Kernelnumber
              \--> Kernel Version 
  UPDATE   :
*****************************************************************************/
static long make_version(int uid)
{
    long vers = SNNSKERNELVERS*10000000; /* The 2 most recent Digits */
    int kernelno;
    bool_t found = TRUE;
    struct pmaplist *list,*list_hp;
    struct sockaddr_in addr,*addr_hp;

    vers += (long) uid; /* The last 5 Digits */
    /* Look if Server allready running */
    addr_hp = &addr;
    IN_SET_LOOPBACK_ADDR(addr_hp);
    list = pmap_getmaps(&addr);

    vers -=100000;

    for (kernelno = 0; found == TRUE && kernelno <= MAXKERNELS ; kernelno++ ){
        vers +=100000;
        found = FALSE;
	for (list_hp = list; list_hp != NULL ;list_hp = list_hp->pml_next){
	    if(list_hp->pml_map.pm_prog ==  SNNSKERNELPROG && list_hp->pml_map.pm_vers == vers){
		found = TRUE;
	    }
	}
    } 
    if (kernelno <= MAXKERNELS){
	return (vers);
    }else{
	return(0L);
    }


}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/
static char *make_inetaddr(char *addr)
{
    static char inetaddr[16];
    sprintf(inetaddr,"%d.%d.%d.%d",(u_char)addr[0],
	                           (u_char)addr[1],
	                           (u_char)addr[2],
	                           (u_char)addr[3]);
#ifdef DEBUG
    printf("->%s<-\n",inetaddr);
#endif
    return((char *)&inetaddr[0]);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :xguiid or error
  NOTES    :

  UPDATE   :
*****************************************************************************/

int rpc_CheckXgui(struct client *Client)
{
    if (anzClients ==-1 ){
	memcpy(&xguiclient,Client,sizeof(struct client));
	/* xguihost points to a static String */
	xguiclient.xguihost = strdup(Client->xguihost);
	anzClients = 1;
	return(0);
    }else{
	switch(kernel_config.kernelMode){
	  case NORMALKERNEL:
	  case COOP_M_KERNEL:
	    /* Broadcast from known xgui ? */
	    if ( (strcmp(xguiclient.xguihost,Client->xguihost) ==0) &&
		(xguiclient.pid == Client->pid)){
		return(0);
	    }
#ifdef DEBUG
	    printf("New Xgui asking for connection => replacing old Xgui");
#endif
	    memcpy(&xguiclient,Client,sizeof(struct client));
	    /* xguihost points to a static String */
	    xguiclient.xguihost = strdup(Client->xguihost);
	    anzClients = 1;
	    return(0);
	    break;
	}
    }
    return(0);
}
/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  : -1 => error , 0 =>OK
  NOTES    :

  UPDATE   :
*****************************************************************************/

int make_xgui_callback(struct client *Client,int error)
{
    static register_info reg;
    static xgui_info *xgui_info;
    struct sockaddr_in addr;
    char *ipadr;
    char hostname[MAXHOSTDLEN];
    char hostaddr[16];
    int  hostlen=16;
    struct hostent *ent;

    reg.error =error;
    reg.vers = rpcversion;
    reg.programm = SNNSKERNELPROG;
    reg.pid = (u_int) getpid();

    
    /* Ceck Xgui */
    rpc_CheckXgui(Client);

    /*
     * Create client "handle" used for calling register_new_server on the
     * server. We tell the rpc package
     * to use the "udp" protocol when contacting the server.
     */
    xguiclient.cl = clnt_create(xguiclient.xguihost,
				xguiclient.xguiprogramm,
				xguiclient.xguiversion, "udp");

    if (xguiclient.cl == NULL) {
	/*
	 * Couldn't establish connection with server.
	 * Print error message and wait for timeout .
	 */
	clnt_pcreateerror(xguiclient.xguihost);
	anzClients=-1;
	return (-1);
    }

    /*
     * Call the remote procedure "getservers" on the server
     * and use Unix authentication and set uid of xgui
     */
    gethostname(hostname,hostlen);
    reg.host = (char *)&hostname[0];
    reg.domain = getDomainName();
	
/* Only for SUNOS    get_myaddress(&addr);
    ipadr = make_inetaddr(addr.sin_addr.s_addr);
*/
    ent = gethostbyname(hostname);
    ipadr = make_inetaddr(ent->h_addr_list[0]);
    strncpy (hostaddr,ipadr, 15); 
    reg.hostaddr = (char *)&hostaddr[0];
    reg.xguiid = globalxguiid++;
    xguiclient.cl->cl_auth = 
	authunix_create(hostname,xguiclient.uid,0,0,NULL);
/*    ((struct authunix_parms *)cl->cl_auth->ah_cred.oa_base)->aup_uid = uid;*/
    memcpy(&reg.kernel_config,&kernel_config,sizeof(par_config2));
    xgui_info = register_new_kernel_40(&reg,xguiclient.cl);
    if (xgui_info == NULL) {
	/*
	 * An error occurred while calling the server. 
	 * Print error message and die.
	 */
	clnt_perror(xguiclient.cl, xguiclient.xguihost);
	auth_destroy(xguiclient.cl->cl_auth);
	clnt_destroy(xguiclient.cl);
	anzClients=-1;
	return (-1);
    }
    if (xgui_info->error != 0){
	auth_destroy(xguiclient.cl->cl_auth);
	clnt_destroy(xguiclient.cl);
	anzClients=-1;
	return (-1);
    }
    xguiclient.xguiid = reg.xguiid;
    xguiclient.kernelid = xgui_info->kernelid;
    return(0);
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

int rpc_callXgui(callback_info *c_info)
{
    struct timeval oldtimeout,timeout;
    c_info->kernelid = xguiclient.kernelid;
    switch(kernel_config.kernelMode){
      case COOP_M_KERNEL:
      case NORMALKERNEL:
	memcpy(&c_info->kernel_config, &kernel_config , sizeof(kernel_config));
	/* No wait => asynchronos Call */
	timeout.tv_sec = 0;
	timeout.tv_usec = 0;
	clnt_control(xguiclient.cl,CLGET_TIMEOUT,&oldtimeout);
	clnt_control(xguiclient.cl,CLSET_TIMEOUT,&timeout);
	kernel_callback_40(c_info,xguiclient.cl);
	clnt_control(xguiclient.cl,CLSET_TIMEOUT,&oldtimeout);
	break;
    }
}

/*****************************************************************************
  FUNCTION :

  PURPOSE  :
  RETURNS  :
  NOTES    :

  UPDATE   :
*****************************************************************************/

int main(int argc, char **argv)
{
    register SVCXPRT *transp;
    int sock;
    int proto;
    int i;
    int opt=0;
    struct itimerval alarmt;
    char *netname,*hp;
    int setno;
    bool hasnet=FALSE;


    /* Init uid */
    uid = getuid();
#ifdef KERNELSLAVE
    kernel_config.kernelMode  = COOP_S_KERNEL; 
    kernelMode = COOP_S_KERNEL;
#endif

    hp = &kernel_config.PATTERN_SET_FILE[0];
    /* Parse parameters */
    for( i = 1 ; i < argc ; i++){
	OPT("-uid",i){
	    if(++i < argc){
		xguiclient.uid = atol(argv[i]);
		uid = xguiclient.uid;
	    }else
		goto wrong_par;
	    opt=opt|1;
	    continue;
	}
	OPT("-host",i){
	    if(++i < argc)
		xguiclient.xguihost  = argv[i];
	    else
		goto wrong_par;
	    opt=opt|2;
	    continue;
	}
	OPT("-program",i){
	    if(++i < argc)
		xguiclient.xguiprogramm  = atol(argv[i]);
	    else
		goto wrong_par;
	    opt=opt|4;
	    continue;
	}
	OPT("-version",i){
	    if(++i < argc)
		xguiclient.xguiversion  = atol(argv[i]); 
	    else
		goto wrong_par;
	    opt=opt|8;
	    continue;
	}
#ifndef KERNELSLAVE
	OPT("-type",i){
	    if(++i < argc){
		OPT("normal",i){
		    kernel_config.kernelMode  = NORMALKERNEL; 
		    kernelMode = NORMALKERNEL;
		    continue;
		}		
		OPT("master",i){
		    kernel_config.kernelMode  = COOP_M_KERNEL; 
		    kernelMode  = COOP_M_KERNEL; 
		    continue;
		}		
		goto wrong_par;
	    }else
	    continue;
	}
#endif
	OPT("-net",i){
	    if(++i < argc){
		if(krui_loadNet(argv[i],&netname)==0){
		    strncpy(kernel_config.ui_filenameNET,
			    netname,MAX_NAME_LENGTH);
		    hasnet = TRUE;
		}
	    }else
		goto wrong_par;
	    continue;
	}
    	OPT("-pat",i){
	    if(++i < argc){
		if(krui_loadNewPatterns(argv[i],&setno)==0){
		    patternloaded = TRUE;
		    kernel_config.NO_OF_PATTERN_SETS++;
		    kernel_config.CURR_PATTERN_SET = 0;
		    strncpy(hp,argv[i],( (strlen(argv[i])-4) >19) ? 19 : (strlen(argv[i])-4));
		    hp[((strlen(hp)+1)>20) ? 20 : (strlen(hp))]='\0';
		    hp+=(strlen(hp)+1);
		    strncpy(kernel_config.ui_filenamePAT ,
			    argv[i],MAX_NAME_LENGTH);
		}
	    }else
		goto wrong_par;
	    continue;
	}
	/* No option found */
	goto wrong_par;
    }


    /* Are there enough parameter for a new client*/
    if (opt == 15){
	anzClients = 1;
    } 
  
    if (anzClients <1){
	if( (rpcversion = make_version(uid))== 0) {
	    fprintf(stderr,"To many kernels running\n");
	    exit(TOMANYKERNELS);
	}
    }else{
	if( (rpcversion = make_version(xguiclient.uid))== 0){
	    fprintf(stderr,"To many kernels running\n");
	    make_xgui_callback(&xguiclient,TOMANYKERNELS);
	    exit(TOMANYKERNELS);
	}
    }

    /* Net loaded ?? */
    if(hasnet){
#ifndef KERNELSLAVE
	if(kernel_config.kernelMode == COOP_M_KERNEL) {
#endif
#ifdef 0
	    krui_setSpecialNetworkType(KERNEL_MODE_VECTOR);
	    printf("Network vectorized.\n" );
#endif
#ifndef KERNELSLAVE
	}
#endif
    }

#ifndef RPC_SVC_FG

    pid = fork();
    if (pid < 0) {
	perror("cannot fork");
	exit(1);
    }
    if (pid)
	exit(0);
    size = getdtablesize();
    for (i = 0; i < size; i++)
	(void) close(i);
    i = open("/dev/console", 2);
    (void) dup2(i, 1);
    (void) dup2(i, 2);
    i = open("/dev/tty", 2);
    if (i >= 0) {
	(void) ioctl(i, TIOCNOTTY, (char *)NULL);
	(void) close(i);
    }
    openlog("kr_ui_rpc", LOG_PID, LOG_DAEMON);
#endif
    sock = RPC_ANYSOCK;

    transp = svcudp_create(sock);
    if (transp == NULL) {
	_msgout("cannot create udp service.");
	exit(1);
    }
    proto = IPPROTO_UDP;
    if (!svc_register(transp, SNNSKERNELPROG, rpcversion, checkall , proto)) {
	_msgout("unable to register (SNNSKERNELPROG, rpcversion, udp).");
	exit(1);
    }
    transp = svctcp_create(sock, 0, 0);
    if (transp == NULL) {
	_msgout("cannot create tcp service.");
	exit(1);
    }
    proto = IPPROTO_TCP;
    if (!svc_register(transp, SNNSKERNELPROG, rpcversion , checkall, proto)) {
	_msgout("unable to register (SNNSKERNELPROG, rpcversion , tcp).");
	exit(1);
    }

    if (transp == (SVCXPRT *)NULL) {
	_msgout("could not create a handle");
	exit(1);
    }

    /* SIGNALS caught for clean exit */
    signal(SIGHUP, (void *)sigtermcallback);
    signal(SIGINT, (void *)sigtermcallback);
    signal(SIGQUIT,(void *)sigtermcallback);
    signal(SIGILL, (void *)sigtermcallback);
    signal(SIGURG, (void *)sigtermcallback);
    signal(SIGBUS, (void *)sigtermcallback);
    signal(SIGSEGV,(void *)sigtermcallback);
    signal(SIGTERM,(void *)sigtermcallback);

    signal(SIGPIPE, (void *)sigpipecallback);

    /* Signal for RPC-CALLS send bei XGUI */
    signal(SIGUSR1, (void *)sigrpccallback);

    /* Watch timeout of the Kernel */
    signal(SIGALRM, (void *)sigalarmcallback);
    alarmt.it_interval.tv_sec=60;
    alarmt.it_interval.tv_usec=0;
    alarmt.it_value.tv_sec=60;
    alarmt.it_value.tv_usec=0;

    setitimer(ITIMER_REAL,&alarmt,NULL);
    if(anzClients >0){
	make_xgui_callback(&xguiclient,NOERROR);
    }
    /* init the coopstructure */
    for (i = 0 ;i < MAXPARAKERNELS ; i++){
	m_coopKernels[i].status = S_IDLE;
	m_coopKernelsCl[i] = NULL;
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
	m_coopKernelsLastT[i].tv_sec = 0L;
	m_coopKernelsLastT[i].tv_usec = 0L;
    }

    svc_run();

    _msgout("svc_run returned");
    exit(1);
    /* NOTREACHED */

/* Print Usage */
wrong_par:
#ifndef KERNELSLAVE
    printf("Usage : kernelrpc [-uid uid] [-host hostname] [-program nr] [-version nr] [-type normal|master] [-net file] {-pat file}\n");
#else
    printf("Usage : kernelslave [-uid uid] [-host hostname] [-program nr] [-version nr] [-net file] {-pat file}\n");
#endif
    exit(-1);


}
