/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *  dfs@research.att.com        dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

#define NAMESIZE 15
#define NAMESV(j) (namesv + j*NAMESIZE)

/* Set in br_save_to_group_var; used by imputation routines */
int nclust;

typedef struct {
  int glyphtype, glyphsize;
  unsigned long color;
} colorv;

void
copy_brushinfo_to_senddata(xgobidata *xg)
{
/*
 * Fill the vector that is used in linked brushing.  This
 * routine is called when brushing is turned on and will
 * need to be called whenever there is a change in
 * xg->rows_in_plot[].  This same vector is used to transfer
 * all the brushing data or just the rows_in_plot[] vector.
*/
  int i, j, k, nr = xg->nrows_in_plot;
  static int nrows = 0;

  /*
   * Only reallocate senddata when nrows_in_plot has changed.
  */
  if (nrows != nr) {
    xg->senddata = (unsigned long *) XtRealloc((XtPointer) xg->senddata,
      (Cardinal) (9 + 2*nr) * sizeof(unsigned long) );
    nrows = nr;
  }

  xg->senddata[0] = (unsigned long) xg->nlinkable;
  xg->senddata[1] = (unsigned long) xg->nrows_in_plot;
  xg->senddata[2] = (unsigned long) xg->link_points_to_points;
  xg->senddata[3] = (unsigned long) xg->link_lines_to_lines; /* not used */
  xg->senddata[4] = (unsigned long) xg->link_points_to_lines;
  xg->senddata[5] = (unsigned long) xg->link_color_brushing;
  xg->senddata[6] = (unsigned long) xg->link_glyph_brushing;
  xg->senddata[7] = (unsigned long) xg->link_erase_brushing;
  if (xg->brush_mode == transient)
    xg->senddata[8] = (unsigned long) True;
  else
    xg->senddata[8] = (unsigned long) False;

  for (i=0, j=9; i<nr; i++, j++) {
    /*
     * Only bundle up the linkable rows
    */
    if ( (k = xg->rows_in_plot[i]) < xg->nlinkable ) {
      xg->senddata[j] = (unsigned long) k;
      xg->senddata[j + nr] = (unsigned long) glyph_color_pointtype(xg, k);
    }
  }
}

/* ARGSUSED */
XtCallbackProc
brush_points_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  xg->is_point_painting = !xg->is_point_painting;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
brush_active_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  xg->brush_on = !xg->brush_on ;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
brush_lines_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  xg->is_line_painting = !xg->is_line_painting;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_perst_cback(w, xg, callback_data)
/*
 * Turn persistent brushing on or off.
*/
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  if (xg->brush_mode != persistent)
  { 
    int j, k;

    xg->brush_mode = persistent;
    if (xg->is_erase) turn_off_erase(xg);
    for (j=0; j<xg->nrows_in_plot; j++)
    {
      k = xg->rows_in_plot[j];
      xg->color_ids[k] =      xg->color_now[k] ;
      xg->glyph_ids[k].type = xg->glyph_now[k].type;
      xg->glyph_ids[k].size = xg->glyph_now[k].size;
    }
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_trans_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  /*
   * If transient brushing is being turned off, also
   * restore colors and glyphs to persistent identities.
  */
/* No, don't */
  if (xg->brush_mode == transient)
  {
/*
    int j;
    for (j=0; j<xg->nrows_in_plot; j++)
    {
      xg->glyph_now[j].type = xg->glyph_ids[j].type;
      xg->glyph_now[j].size = xg->glyph_ids[j].size;
      xg->color_now[j] = xg->color_ids[j];
    }
*/
  }
  else {
    xg->brush_mode = transient;
    if (xg->is_erase) turn_off_erase(xg);
  }

  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_erase_cback(w, xg, callback_data)
/*
 * Erase brushing:  for now, just disable the choices of brushing
 * type during erase brushing.  At this point, erase is only implemented
 * as a persistent operation.
*/
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  if (!xg->is_erase) {
    /*
     * If we've been using transient brushing, restore
     * all points colors and glyphs to their persistent state.
    */
    if (xg->brush_mode == transient) {
      int j;
      for (j=0; j<xg->nrows_in_plot; j++) {
        xg->glyph_now[j].type = xg->glyph_ids[j].type;
        xg->glyph_now[j].size = xg->glyph_ids[j].size;
        xg->color_now[j] = xg->color_ids[j];
      }
    }
    xg->is_erase = True;
  }
  else
    xg->is_erase = False;

/*  Andreas suggests ...
  reset_br_types(xg);
*/
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_complement_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int j, m;

  for (j=0; j<xg->nrows_in_plot; j++)
  {
    m = xg->rows_in_plot[j];
    xg->erased[m] = !xg->erased[m];
  }

  copy_brushinfo_to_senddata(xg);
  if (xg->link_erase_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
  
#ifdef RPC_USED
  xfer_brushinfo(xg);
#endif

  /* Update case profile? */
  if (xg->is_cprof_plotting && xg->link_cprof_plotting)
    cprof_plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_undo_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  if (xg->brush_mode != undo) {
    xg->brush_mode = undo;
    if (xg->is_erase) turn_off_erase(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_update_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  if (xg->plot_the_points) {
    if (xg->link_glyph_brushing ||
        xg->link_color_brushing ||
        xg->link_erase_brushing)
    {
      /*
       * if an nlinkable file is used, then do not pass
       * any of the rows_in_plot data.
      */
      if (xg->nlinkable == xg->nrows)
      {
        XtOwnSelection( (Widget) xg->workspace,
          (Atom) XG_ROWSINPLOT,
          (Time) CurrentTime,
          (XtConvertSelectionProc) pack_rowsinplot_data,
          (XtLoseSelectionProc) pack_brush_lose ,
          (XtSelectionDoneProc) pack_brush_done );
        announce_rows_in_plot(xg);
      }

      XtOwnSelection( (Widget) xg->workspace,
        (Atom) XG_NEWPAINT,
        (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
        /*(Time) XtLastTimestampProcessed(display),*/
        (XtConvertSelectionProc) pack_brush_data,
        (XtLoseSelectionProc) pack_brush_lose ,
        (XtSelectionDoneProc) pack_brush_done );
      announce_brush_data(xg);
    }
  }

  if ((xg->link_points_to_points || xg->link_points_to_lines) &&
    xg->connect_the_points)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWLINEPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_line_brush_data,
      (XtLoseSelectionProc) pack_line_brush_lose ,
      (XtSelectionDoneProc) pack_line_brush_done );
    announce_line_brush_data(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
reset_brush_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  init_brush_size(xg);
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_point_colors_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int j;

  if (!mono)
  {
    for (j=0; j<xg->nrows; j++)
      xg->color_ids[j] = xg->color_now[j] = plotcolors.fg;
  }

  copy_brushinfo_to_senddata(xg);
  if (xg->link_color_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_line_colors_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  if (!mono)
    init_line_colors(xg);
  if (xg->link_points_to_points || xg->link_points_to_lines)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWLINEPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      (XtConvertSelectionProc) pack_line_brush_data,
      (XtLoseSelectionProc) pack_line_brush_lose ,
      (XtSelectionDoneProc) pack_line_brush_done );
    announce_line_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_glyphs_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  init_glyph_ids(xg);

  copy_brushinfo_to_senddata(xg);
  if (xg->link_glyph_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_erase_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  init_erase(xg);
  if (xg->link_erase_brushing)
  {
    copy_brushinfo_to_senddata(xg);
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);

#ifdef RPC_USED
  xfer_brushinfo(xg);
#endif

  /* Update case profile? */ 
  if (xg->is_cprof_plotting && xg->link_cprof_plotting)
    cprof_plot_once(xg);
}

int
find_gid(glyph)
  glyphv *glyph;
{
  int gid = 0;

  gid = NGLYPHSIZES*(glyph->type-1) + glyph->size ;
  return(gid);
}

/* ARGSUSED */
XtCallbackProc
br_save_to_group_var(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int i, k, n, j, groupno;
  int new_color, new_glyph;
  colorv *clusv;
  glyphv glyphs_used[NGLYPHS];
  unsigned long colors_used[NCOLORS+1];
  int nglyphs_used, ncolors_used;
  int *cols, ncols;
  int ncols_used_prev = xg->ncols_used;

/*
 * Find all glyphs and colors used.
*/
  colors_used[0] = xg->color_ids[0];
  ncolors_used = 1;
  if (!mono)
  {
    for (i=0; i<xg->nrows; i++)
    {
      new_color = 1;
      for (k=0; k<ncolors_used; k++)
      {
        if (colors_used[k] == xg->color_ids[i])
        {
          new_color = 0;
          break;
        }
      }
      if (new_color)
      {
        colors_used[ncolors_used] = xg->color_ids[i];
        ncolors_used++;
      }
    }
  }

  glyphs_used[0].type = xg->glyph_ids[0].type;
  glyphs_used[0].size = xg->glyph_ids[0].size;
  nglyphs_used = 1;
  for (i=0; i<xg->nrows; i++)
  {
    new_glyph = 1;
    for (k=0; k<nglyphs_used; k++)
    {
      if (glyphs_used[k].type == xg->glyph_ids[i].type &&
        glyphs_used[k].size == xg->glyph_ids[i].size)
      {
        new_glyph = 0;
        break;
      }
    }
    if (new_glyph)
    {
      glyphs_used[nglyphs_used].type = xg->glyph_ids[i].type;
      glyphs_used[nglyphs_used].size = xg->glyph_ids[i].size;
      nglyphs_used++;
    }
  }

  if (ncolors_used * nglyphs_used == 1)  /* no brushing groups */
  {
    /*
     * If there are no brushing groups, set each value = 1.
     * Forget about unmapping the variable, though; it's
     * too excruciating.
    */
    for (i=0; i<xg->nrows; i++)
    {
      xg->tform_data[i][xg->ncols-1] =
        xg->raw_data[i][xg->ncols-1] = 1.0 ;
    }
  }
  else
  {
    xg->ncols_used = xg->ncols;

    clusv = (colorv *)
      XtMalloc((Cardinal) (ncolors_used * nglyphs_used) * sizeof(colorv));
    /*
     * Loop over glyphs and colors to find out how many
     * clusters there are.
    */
    nclust = 0;
    for (k=0; k<nglyphs_used; k++)
    {
      clusv[nclust].glyphtype = glyphs_used[k].type;
      clusv[nclust].glyphsize = glyphs_used[k].size;

      for (n=0; n<ncolors_used; n++)
      {
        new_color = 0;
        /*
         * Loop over all points, looking at glyph and color ids.
         * new clusv group.
        */
        for (i=0; i<xg->nrows; i++)
        {
          /*
           * If we find a pair ...
          */
          if (xg->glyph_ids[i].type == glyphs_used[k].type &&
            xg->glyph_ids[i].size == glyphs_used[k].size &&
            xg->color_ids[i] == colors_used[n])
          {
            new_color = 1;
            /*
             * make sure it's not already a member of clusv[]
            */
            for (j=0; j<nclust; j++)
            {
              if (clusv[j].glyphtype == glyphs_used[k].type &&
                clusv[j].glyphsize == glyphs_used[k].size &&
                clusv[j].color == colors_used[n])
                  new_color = 0;
            }
            break;
          }
        }

        if (new_color)
        {
          clusv[nclust].glyphtype = glyphs_used[k].type;
          clusv[nclust].glyphsize = glyphs_used[k].size;
          clusv[nclust].color = colors_used[n];
          nclust++;
        }
      }
    }

/* 
 * If there are missing values, be sure to initialize
 * the added column of the missing values matrix.
*/
    if (xg->missing_values_present)
      init_missing_groupvar(xg);

    map_group_var(xg);

    /*
     * If there are clusters, this sets the data to reflect that.
    */
    for (n=0; n<nclust; n++)
    {
      for (i=0; i<xg->nrows; i++)
      {
        if (xg->glyph_ids[i].type == clusv[n].glyphtype &&
          xg->glyph_ids[i].size == clusv[n].glyphsize &&
          xg->color_ids[i] == clusv[n].color)
        {
          xg->tform_data[i][xg->ncols-1] =
            xg->raw_data[i][xg->ncols-1] = (float) n;
        }
      }
    }
    XtFree((XtPointer) clusv);
  }

  reset_3d_cmds(xg);
  if (xg->ncols_used == 3)
  {
    alloc_tour(xg);
    init_tour(xg, 1);
  }
  if (xg->ncols_used == 3)
  {
    alloc_corr(xg);
    init_corr(xg);
  }
  /* tour_alloc() should have been executed in any case */

/*
 * Run the data through the pipeline.
*/
  /*
   * Figure out which group the group variable belongs to.
   * This isn't meaningful yet, but it will be if we implement
   * an interactive way to reset groups.
  */
  ncols = 0;
  groupno = xg->vgroup_ids[xg->ncols-1];
  cols = (int *) XtMalloc((unsigned) xg->ncols_used * sizeof(int));
  for (j=0; j<xg->ncols_used; j++)
  {
    if (xg->vgroup_ids[j] == groupno)
      cols[ncols++] = j;
  }

  if (xg->ncols_used > 2)
    update_sphered(xg, cols, ncols);
  update_lims(xg);
  xg->v0[0][xg->ncols-1] = 0.0;
  xg->v0[1][xg->ncols-1] = 0.0;
  xg->uold[0][xg->ncols-1] = 0.0;
  xg->uold[1][xg->ncols-1] = 0.0;
  update_world(xg);

  init_tickdelta(xg);
  if (xg->is_xyplotting)
    init_ticks(&xg->xy_vars, xg);
  else if (xg->is_dotplotting)
    init_ticks(&xg->dotplot_vars, xg);

  /*
   * This will add the extra variable to the case profile plot
   * if xgobi is case profile plotting.
  */
  reset_nvars_cprof_plot(xg);

  if (ncols_used_prev != xg->ncols_used)
    varlist_add_group_var(xg);

  /*
   * This part is only necessary if the group column is plotted,
  */
  if (xg->varchosen[xg->ncols-1] == True)
  {
    if (xg->is_dotplotting)
      dotplot_texture_var(xg);
    world_to_plane(xg);
    plane_to_screen(xg);
    assign_points_to_bins(xg);
    plot_once(xg);
  }

  XtFree((XtPointer) cols);
}

void
reset_rows_in_plot(xgobidata *xg, Boolean reset_lims)
{
  int j;

  if (xg->is_dotplotting)
    dotplot_texture_var(xg);

  if (xg->ncols_used > 2)
    update_sphered(xg, (int *) NULL, xg->ncols_used);
  if (reset_lims)
    update_lims(xg);
  update_world(xg);
  world_to_plane(xg);
  plane_to_screen(xg);

  if (reset_lims)
  {
    if (xg->is_xyplotting)
    {
      for (j=0; j<xg->ncols_used; j++)
      {
        xg->nicelim[j].min = xg->lim0[j].min;
        xg->nicelim[j].max = xg->lim0[j].max;
        SetNiceRange(j, xg);
        xg->deci[j] = set_deci(xg->tickdelta[j]);
      }
      init_ticks(&xg->xy_vars, xg);
    }
    else if (xg->is_dotplotting)
      init_ticks(&xg->dotplot_vars, xg);
  }

  if (xg->is_pp)
  {
    xg->recalc_max_min = True;
    reset_pp_plot();
    pp_index(xg,0,1);
  }
}

/* ARGSUSED */
XtCallbackProc
delete_erased_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int i;
  Boolean nerased = False;

  /*
   * First make sure that some points are erased.
  */
  for (i=0; i<xg->nrows; i++)
    if (!xg->erased[i])
    {
      nerased = True;
      break;
    }

  if (nerased)
  {
    xg->nrows_in_plot = 0;
    for (i=0; i<xg->nrows; i++)
      if (!xg->erased[i])
        xg->rows_in_plot[(xg->nrows_in_plot)++] = i;

    xg->delete_erased_pts = True;

    reset_rows_in_plot(xg, True);
    if (xg->link_erase_brushing)
    {
      copy_brushinfo_to_senddata(xg);
      XtOwnSelection( (Widget) xg->workspace,
        (Atom) XG_ROWSINPLOT,
        (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
        /*(Time) XtLastTimestampProcessed(display),*/
        (XtConvertSelectionProc) pack_rowsinplot_data,
        (XtLoseSelectionProc) pack_brush_lose ,
        (XtSelectionDoneProc) pack_brush_done );
      announce_rows_in_plot(xg);
    }

    assign_points_to_bins(xg);
    plot_once(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
undelete_erased_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int i;

  for (i=0; i<xg->nrows; i++)
    xg->rows_in_plot[i] = i;
  xg->nrows_in_plot = xg->nrows;
  xg->delete_erased_pts = False;

  reset_rows_in_plot(xg, True);
  if (xg->link_erase_brushing)
  {
    copy_brushinfo_to_senddata(xg);
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
  }

  assign_points_to_bins(xg);
  plot_once(xg);
}


void
brush_on(xg)
  xgobidata *xg;
{
/*
 *  If this mode is currently selected, turn it off.
*/
  if (xg->prev_plot_mode == BRUSH_MODE && xg->plot_mode != BRUSH_MODE)
  {
    XtDisownSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) XtLastTimestampProcessed(display));
      /*(XtConvertSelectionProc) pack_brush_data );*/

    xg->is_brushing = False;
    /* Remove event handler for the workspace widget. */
    XtRemoveEventHandler(xg->workspace, XtAllEvents,
      TRUE, (XtEventHandler) brush_button, (XtPointer) xg);
    XtRemoveEventHandler(xg->workspace, XtAllEvents,
      TRUE, (XtEventHandler) brush_motion, (XtPointer) xg);

    /*
     * If we've been using transient brushing, restore
     * all points colors and glyphs to their persistent state.
    if (xg->brush_mode == transient) {
      int j;
      for (j=0; j<xg->nrows_in_plot; j++) {
        xg->glyph_now[j].type = xg->glyph_ids[j].type;
        xg->glyph_now[j].size = xg->glyph_ids[j].size;
        xg->color_now[j] = xg->color_ids[j];
      }
    }
    */  /* No, don't. */

    map_brush(xg, False);
    plot_once(xg);
  }
  else if (xg->prev_plot_mode != BRUSH_MODE &&
           xg->plot_mode == BRUSH_MODE)
  {
    /* Add event handlers for the workspace widget.  */
    XtAddEventHandler(xg->workspace,
      ButtonPressMask | ButtonReleaseMask,
      FALSE, (XtEventHandler) brush_button, (XtPointer) xg);
    XtAddEventHandler(xg->workspace,
      Button1MotionMask | Button2MotionMask ,
      FALSE, (XtEventHandler) brush_motion, (XtPointer) xg);

    xg->is_brushing = True;
    map_brush(xg, True);

    if (xg->reshape_brush)
      init_brush_size(xg);
    draw_brush(xg);

    assign_points_to_bins(xg);

    /*
     * The current transient brushing behavior is as follows:
     * the selected points remain selected when leaving brushing.
     * When re-entering brushing (or when selecting a new
     * variable; see varselect() for very similar code), the
     * brushing operations are performed so that the initial
     * state matches what's under the brush.  This is necessary
     * here to cover two cases:  a change of projection outside
     * of brushing (either through change of mode or variable,
     * or a transformation), and if reshape_brush is true.
    */ 
    if (xg->brush_mode == transient) {
      int j, k;
      for (j=0; j<xg->nrows_in_plot; j++) {
        k = xg->rows_in_plot[j];
        xg->color_now[k] = xg->color_ids[k] ;
        xg->glyph_now[k].type = xg->glyph_ids[k].type;
        xg->glyph_now[k].size = xg->glyph_ids[k].size;
      }
      brush_once(xg, False);
      plot_once(xg);
    }
  /* */

    copy_brushinfo_to_senddata(xg);

    if (xg->is_tour_section)
      turn_off_section_tour(xg);
  }
}

#undef NAMESIZE
#undef NAMESV
#undef SMALL
#undef MEDIUM
#undef LARGE
