/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include "xdir.h"

static int operation_in_progress = False;
static int controls_are_grey;

extern int search_complete;
extern struct dirwin_st *dirwin_head;

/*
 * start_op - This function must be called at the start of each
 *            operation to prevent the possibility of the user
 *            invoking a new operation while one is still in
 *            progress.  If "grey" is "True", grey out directory
 *            window controls.  If an operation is already in
 *            progress, this function beeps and returns False,
 *            otherwise True is returned.  At the end of an
 *            operation, end_op() must be called.
 */
start_op(grey)
int grey;
{
	/* Is there an operation already in progress */
	if (operation_in_progress) {
		beep();
		return False;
	}

	/* If requested, grey out directory window controls */
	if (grey)
		enable_controls(False);

	/* The operation is in progress */
	operation_in_progress = True;
	controls_are_grey = grey;

	return True;
}


/*
 * end_op - This function must be called at the end of each operation
 *          to prevent the possibility of the user invoking a new
 *          operation while one is still in progress.  start_op()
 *          must be called at the start of each operation.
 */
end_op()
{
	/* Sanity check */
	if (!operation_in_progress)
		fatal_error("Bug in end_op()");

	/* If directory window controls are greyed out, reenable them */
	if (controls_are_grey)
		enable_controls(True);

	/* The operation is complete */
	operation_in_progress = False;
}


/*
 * update_dir_controls - Set the sensitivity of directory controls.
 */
update_dir_controls()
{
    struct dirwin_st *dirwin = dirwin_head;
	int i;
	int viewable = False;

	/* Set sensitivity of controls that operate on selected entries */
	while (dirwin) {
	    if (dirwin->has_selection && has_selected_entries(dirwin)) {
	        XtSetSensitive(dirwin->w_deleteItem, True);
			XtSetSensitive(dirwin->w_renameItem, True);
	        XtSetSensitive(dirwin->w_deleteButton, True);
			for (i=0; i<dirwin->nentries; i++) {
				if (dirwin->entries[i].state == SELECTED) {
					switch (dirwin->entries[i].type) {
					case UNKNOWN_TYPE:
					case FILE_TYPE:
					case LINK_TYPE:
					case EXECUTABLE_TYPE:
						viewable = True;
					}
				}
			}
			XtSetSensitive(dirwin->w_viewItem, viewable);
	    } else {
	        XtSetSensitive(dirwin->w_deleteItem, False);
			XtSetSensitive(dirwin->w_renameItem, False);
	        XtSetSensitive(dirwin->w_deleteButton, False);
			XtSetSensitive(dirwin->w_viewItem, False);
	    }
		if (search_complete)
			XtSetSensitive(dirwin->w_searchAgainItem, False);
		else
			XtSetSensitive(dirwin->w_searchAgainItem, True);
		dirwin = dirwin->next;
	}
}


/*
 * enable_controls - If "enable" is FALSE, certain controls that should
 *                   not be used during deletions are turned off. If
 *                   "enable" is TRUE, these controls are turned back on.
 */
enable_controls(enable)
int enable;
{
	struct dirwin_st *dirwin = dirwin_head;

	while (dirwin) {
		XtSetSensitive(dirwin->w_dirMenuBar, enable);
		XtSetSensitive(dirwin->w_urButton, enable);
		XtSetSensitive(dirwin->w_toolbarForm, enable);
		update_layout_mode_buttons(dirwin);
		XtSetSensitive(dirwin->w_scrolledWindow, enable);
		dirwin = dirwin->next;
	}
}


/*
 * op_in_progress - Returns True if an operation is in progress, else False.
 */
op_in_progress()
{
	return operation_in_progress;
}

