
/*
 * LIB/FATAL.C
 */

#include "defs.h"

Prototype void fatal(const char *ctl, ...);

void
fatal(const char *ctl, ...)
{
    va_list va;
    char buf[1024];

    va_start(va, ctl);
    vsnprintf(buf, sizeof(buf), ctl, va);
    va_end(va);
    fprintf(stderr, "%s\n", buf);

    va_start(va, ctl);
    vsyslog(LOG_CRIT, ctl, va);
    va_end(va);

    exit(1);
}

