//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGE4K_HXX
#define CARTRIDGE4K_HXX

class Cartridge4K;

#include "machine.hxx"
#include "Cart.hxx"

/**
  Object of this class are used to represent 4K cartridges.

  @author  Bradford W. Mott
  @version $Id: Cart4K.hxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/
class Cartridge4K : public Cartridge
{
  public:
    /// Constructor
    Cartridge4K(System& system, uByte* image);
 
    /// Destructor
    virtual ~Cartridge4K();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Reset to power on state
    virtual void reset();
 
  private:
    // Addressing offset in ROM image (always zero)
    uWord myImageOffset;

    // 4k ROM Image of the cartridge
    uByte myImage[4096];
};
#endif

