//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Base class for 2600 controllers.

  @author  Bradford W. Mott
  @version $Id: Control.cxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/

#include "Control.hxx"

//============================================================================
// Constructor
//============================================================================
Controller::Controller(const System& system)
    : mySystem(system)
{
  // Upon construction all four bits of the PIA are set high
  myPIA = 0x0f;

  // Upon construction all 3 bits of the TIA are set high
  myTIA = 0x03;
}
 
//============================================================================
// Destructor
//============================================================================
Controller::~Controller()
{
}

//============================================================================
// Called before each frame is generated
//============================================================================
void Controller::update()
{
  // In general this will poll the terminal to see if the contoller
  // needs to change state.  However, we don't do anything here.
}

//============================================================================
// Read the PIA information from the controller
//============================================================================
uByte Controller::readPIA() const
{
  return myPIA;
}

//============================================================================
// Read the TIA information from the controller
//============================================================================
uByte Controller::readTIA() const
{
  return myTIA;
}

//============================================================================
// Configure the TIA portion of the controller
//============================================================================
void Controller::configureTIA(Controller::TIACommand)
{
  // In general we'll need to look at the command and modify the
  // state of the contoller.  However, we don't do anything here.
}

