//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef M6532_HXX
#define M6532_HXX

class System;

#include "machine.hxx"
#include "Device.hxx"

/**
  RIOT

  @author  Bradford W. Mott
  @version $Id: M6532.hxx,v 1.2 1997/05/17 19:00:06 bwmott Exp $
*/
class M6532 : public Device
{
  public:
    /// Constructor
    M6532(System& system);
 
    /// Destructor
    virtual ~M6532();
 
    /// Answer the byte at the given address
    uByte peek(uWord addr);

    /// Write value at the given address.
    void poke(uWord addr, uByte value);

    /// Reset to my power on state
    void reset();

  private:
    // Offset used for RAM addressing (always zero)
    uWord myRAMOffset;

    // I contain an amazing 128 bytes of RAM
    uByte myRAM[128];

    // Indicates the adjustment value for the timer from the properties
    Long myTimerAdjustment;

    // Current value of my Timer
    uLong myTimer;

    // Log base 2 of the number of cycles in a timer interval
    uLong myIntervalShift;

    // Indicates the number of CPU cycles when the timer was last set
    uLong myCyclesWhenTimerSet;

    // Indicates if a read from timer has taken place after interrupt occured
    bool myTimerReadAfterInterrupt;

    // Data Direction Register for Port A
    uByte myDDRA;

    // Data Direction Register for Port B
    uByte myDDRB;
};
#endif

