/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU, DNH
 *******************************************************************************/
#ifndef lint
static char pcspkr_c[] = "$Id: pcspkr.c,v 4.3 1998/01/28 19:55:55 erik Rel $";
#endif

#include <sys/io.h>
#include <unistd.h>
#include "config.h"
#include "io.h"
#include "util.h"
#include "pcspkr.h"



int SpActive = 0;
int SpOn = 0;


int
SpeakerInit(int audioOn)
{

	if (ioperm(0x61, 1, 1))
	{
		Msg(M_PERR, "couldn't get permission for the speaker port");
		return -1;
	}
	(void)setgid(getgid());
	(void)setuid(getuid());
	SpActive = 1;
	SpOn = 1;
	if (!audioOn)
	{
		SpeakerOnOff();
	}
	return 0;
}

void
SpeakerOnOff(void)
{
	if (SpActive)
	{
		SpOn = !SpOn;
	}
}

void
SpeakerOutByte(uns8 newval)
{
	static uns8 oldval = 0;
	if (SpActive && SpOn && ((newval ^ oldval) & B_SPEAKER))
	{
		if (newval & B_SPEAKER)
		{
			outb(inb(0x61) | 0x02, 0x61);
		}
		else
		{
			outb(inb(0x61) & 0xfc, 0x61);
		}
		oldval = newval;
	}
}

