/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: main.c,v 4.4 1998/01/31 18:54:33 erik Rel $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include "config.h"
#include "z80.h"
#include "mem.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#include "emul.h"
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef JOY
#include "joystick.h"
#endif
#ifdef REGISTERED
#include "monitor.h"
#endif
#ifdef PRINTER
#include "printer.h"
#endif
#include "screen.h"
#include "snapshot.h"
#include "version.h"
#ifdef REGISTERED
#include "vtp.h"
#endif
#include "main.h"

#ifndef EXPIRATION
#define EXPIRATION		0
#endif

static int initEmulator(int, char **);
static void quitEmulator(int);

char *ProgName, *Version;
time_t StartupTime;
int StdinFileType, StdoutFileType;


int
main(int argc, char **argv)
{
	char *s;
	int *t;
	if ((s = strrchr(argv[0], '/')) != NULL)
	{
		ProgName = ++s;
	}
	else
	{
		ProgName = argv[0];
	}
	Version = (char *)Malloc(sizeof("XZX X.XX.XXR") + 1, "main");
#ifdef REGISTERED
	(void)sprintf(Version, "XZX %d.%d.%dR", ZX_Major, ZX_Minor, ZX_Patch);
#else
	(void)sprintf(Version, "XZX %d.%d.%d", ZX_Major, ZX_Minor, ZX_Patch);
#endif

	t = (int *)"\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
#ifdef LITTLE_ENDIAN
	if (*t != 1)
	{
		(void)fprintf(stderr,
					  "********* This machine is high-endian. **********\n"
					  "Take #define LSB_FIRST out and compile XZX again.\n");
		return 1;
 	}
#else
	if (*t == 1)
	{
		(void)fprintf(stderr,
					  "********* This machine is low-endian. *********\n"
					  "Insert #define LSB_FIRST and compile XZX again.\n");
		return 1;
	}
#endif

	StartupTime = time(NULL);
	if (EXPIRATION && ((time_t)EXPIRATION < StartupTime))
	{
		(void)fprintf(stderr,
					  "Sorry, your version has expired! Get a new one.\n");
		return 1;
	}
	if (!initEmulator(argc, argv))
	{
		Emulate();
	}
	Quit(1);

	return 0;
}

static int
initEmulator(int ac, char **av)
{
	struct sigaction sigact;
	int i;


	sigact.sa_handler = SIG_IGN;
	(void)sigemptyset(&sigact.sa_mask);
#ifdef SA_RESTART
	sigact.sa_flags = SA_RESTART;
#else
	sigact.sa_flags = 0;
#endif
	(void)sigaction(SIGINT,   &sigact, NULL);
	(void)sigaction(SIGHUP,   &sigact, NULL);
	(void)sigaction(SIGTERM,  &sigact, NULL);
	(void)sigaction(SIGQUIT,  &sigact, NULL);
#ifdef SIG_XCPU
	(void)sigaction(SIG_XCPU, &sigact, NULL);
#endif
	(void)sigaction(SIGSEGV,  &sigact, NULL);

	InitX(&ac, av);
	SetBlocking(STDIN_FILENO, 1);
	StdinFileType = ClassifyDescriptor(STDIN_FILENO);
	SetBlocking(STDOUT_FILENO, 1);
	StdoutFileType = ClassifyDescriptor(STDOUT_FILENO);
#ifdef AUDIO
	AudioInit();
#endif
#ifdef JOY
	JoyInit();
#endif
	MemoryInit();
	Z80_Init();
#ifdef XZX_PLUS3
	FdcInit();
#endif
#ifdef XZX_IF1
	If1Init();
#endif
#ifdef PRINTER
	PrinterInit();
#endif
	DialogInit(!av[1]);
#ifdef REGISTERED
	VtpInit();
	DebuggerInit();
#endif

	if (!av[1] || ReadSnapshot(av[1]) == -1)
	{

		srand((unsigned int)getpid());
		for (i = DFILE; i < (DFILE + PIXEL_LENGTH + ATTR_LENGTH); i++)
		{
			WR_BYTE((uns16)i, (uns8)rand());
		}
	}
	ScreenRefresh();
	sigact.sa_handler = quitEmulator;
	(void)sigaction(SIGINT,  &sigact, NULL);
	(void)sigaction(SIGHUP,  &sigact, NULL);
	(void)sigaction(SIGTERM, &sigact, NULL);
	(void)sigaction(SIGQUIT, &sigact, NULL);
	(void)sigaction(SIGSEGV, &sigact, NULL);
	return 0;
}

static void
quitEmulator(int signo)
{
	SetBlocking(STDIN_FILENO, 0);
	SetBlocking(STDOUT_FILENO, 0);

	Quit(2);

}

