/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_MEM_H
#define _XZX_MEM_H
/* $Id: mem.h,v 4.5 1998/02/07 17:26:16 erik Rel $ */
#include "config.h"
#include "z80.h"
#include "io.h"
#ifdef EMULATE_ULA_DELAY
#include "emul.h"
#endif
#include "screen.h"

#if !defined(__GNUC__)
#define inline
#endif

#define XZX_PAGESIZE 16384
enum {
	SP48ROM,
	SP128ROM0, SP128ROM1,
#ifdef XZX_PLUS3
	SP3ROM0, SP3ROM1, SP3ROM2, SP3ROM3,
#endif
#ifdef XZX_IF1
	IF1ROM,
#endif
#ifdef XZX_MF128
	MF128ROM,
#endif
	RAM0, RAM1, RAM2, RAM3, RAM4, RAM5, RAM6, RAM7,
#ifdef XZX_MF128
	MF128RAM,
#endif
	NPAGES
};

#define VPAGE(addr)		((addr) >> 13)
#define RPAGE(addr)		(RealPageNumbers[VPAGE(addr)])
#define MEM(addr)		(TheMemory[VPAGE(addr)][(addr) & 0x1fff])
#define READ_ONLY(addr)	(RPAGE(addr) < RAM0)
#define CONTENDED(addr)	(ContendedMemory[VPAGE(addr)])
typedef struct _machineSettings {
	int basicRom;
	int romType;
	int tvLines;
	int tstatesPerLine;
	int tstatesPerFrame;
	uns8 ula;
} MachineSettings;
enum { SP_48_2, SP_48_3, SP_128, SP_3, NMACHINES };
enum {
	ROM_UNKNOWN,
	ROM_STANDARD, ROM_TK95, ROM_GROOT, ROM_IMC,
	ROM_128,
	ROM_PLUS2,
#ifdef XZX_PLUS3
	ROM_PLUS3,
#endif
	NUMROMS
};

extern void MemoryInit(void);
extern void InitPages(void);
extern void PageIn(int, int);
extern int GetRomChecksum(int , int);
extern void SelectModel(int, int);
extern uns8 *TheMemory[8];
extern int RealPageNumbers[8];
extern uns8 *RealMemory[NPAGES];
extern int ContendedMemory[8];
extern MachineSettings Machines[NMACHINES], *Machine;

static inline uns8
RD_BYTE(uns16 addr)
{
	return MEM(addr);
}

static inline uns16
RD_WORD(uns16 addr)
{
	return ((uns16)MEM(addr) + (uns16)(MEM(addr + (uns16)1) << 8));
}

static inline void
WR_BYTE(uns16 addr, uns8 val)
{
	register int page = VPAGE(addr);
	if (RealPageNumbers[page] >= RAM0)
	{
		TheMemory[page][addr &= 0x1fff] = val;
		if (RealPageNumbers[page] == ScreenSelect)
		{
			if (addr < (uns16)PIXEL_LENGTH)
			{
				ScreenWrite(addr, val);
			}
			else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
			{
				AttrWrite(addr, val);
			}
		}
#ifdef EMULATE_ULA_DELAY
		if (ContendedMemory[page] && ULA_DRAWS_SCREEN)
		{
			Tstates += 4;
		}
#endif
	}
}

static inline void
WR_WORD(uns16 addr, uns16 val)
{
	WR_BYTE(addr, (uns8)LOWBYTE(val));
	WR_BYTE(addr + (uns16)1, (uns8)HIGHBYTE(val));
}
#endif

