/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_UTIL_H
#define _XZX_UTIL_H
/* $Id: util.h,v 4.2 1998/01/06 21:15:59 erik Rel $ */
#include <sys/types.h>
#include <stdio.h>
#include "config.h"


enum { M_INFO, M_WARN, M_PWARN, M_ERR, M_PERR, M_FATAL, M_DEBUG };

enum { FD_UNKNOWN, FD_TTY, FD_FILE, FD_PIPE };

enum { FT_UNKNOWN,
	   FT_SNA, FT_Z80, FT_SLT,
	   FT_TAP, FT_VOC, FT_TZX,
	   FT_DSK, FT_MDR };
typedef struct _llist {
	struct _llist *next;
	void *item;
} llist;

extern FILE *Fopen(char *, char *);
extern void *Malloc(size_t, char *);
extern char *Strdup(char *, char *);
extern void *Mmap(char *, int, int *, size_t *);
extern void Munmap(void *, size_t);
extern void OnQuit(void (*)(void));
extern void Quit(int );
#ifdef nec_ews
extern void Msg();
#else
extern void Msg(int, ...);
#endif
extern void IntFrequency(int);
extern int ClassifyDescriptor(int);
extern void SetBlocking(int, int);
extern char *GetBaseName(char *);
extern int GetFileType(char *);
#ifdef NEED_STRCASECMP
extern int strcasecmp(char *, char *);
extern int strncasecmp(char *, char *, int);
#endif

extern void DestroyList(llist *, void (*)(void *));
extern llist *AppendElemList(llist *, void *);
extern llist *PrependElemList(llist *, void *);
extern llist *RemoveElemList(void *, int (*)(void *, void *), llist *,
							 void (*)(void *));
extern llist *SortedInsertList(void *, int (*)(void *, void *), llist *);
extern void *RetrieveElemList(llist *, int);
#endif

