/*  major kludge to implement AIFC 32 Floating point "compression" type */
/*  someday I'll rewrite AAAAAALLLLLL this stuff */
/*  Dave Madole 1/97 */

#include	"cs.h"                            /*                AIFF.C    */
#include	"soundio.h"
#include	"aiff.h"
#include	"sfheader.h"
#include	<math.h>
#include	"ieee80.h"

#ifndef __MWERKS__	/* -EAD */
#define TRUE    1
#define FALSE   0
#endif
#define DEBUG	0

struct FP32Chunk {
	CkHdr	ckHdr;
	unsigned long	applicationSignature;
	float	maxamps[AIFF_MAXCHAN+1];
} FP32Chunk;

struct FP32Chunk FP32Chunk;

static char     FORM_ID[4] = {'F','O','R','M'};
static char     COMM_ID[4] = {'C','O','M','M'};
static char     MARK_ID[4] = {'M','A','R','K'};
static char     INST_ID[4] = {'I','N','S','T'};
static char     SSND_ID[4] = {'S','S','N','D'};
static char	APPL_ID[4] = {'A','P','P','L'};
static char	APPL_SIG[4] = {'p','E','r','F'};
static char     FORM_TYPE[4] = {'A','I','F','C'};
static char	FL32_TYPE[4] = {'F','L','3','2'};

static char	FL32_NAME[12] =  Float32Name;

static FormHdr	    form;
static CommChunk1   comm1;   /* CommonChunk split    */
static CommChunk2   comm2;   /*  to avoid xtra space */
static CommChunk3	comm3;
static ApplicationSpecificChunk	*appCkPtr;
static SoundDataHdr ssnd;

void GetMaxAmps(float *a);
static int sizFormHdr = sizeof(FormHdr);
static int sizCommChunk1 = sizeof(CkHdr) + sizeof(short); /* to avoid long roundup */
static int sizCommChunk2 = sizeof(CommChunk2);
static int sizCommChunk3 = 0;
static int sizAppChunk = 0;
static int sizSoundDataHdr = sizeof(SoundDataHdr);
static int sframe_size = 0;
static int aifchdrsize = 0;

extern double  onept; 			/* A440 tuning factor */
extern double  log10d20;		/* for db to ampfac   */

extern int  bytrevhost(void);
extern short benshort(short sval);
extern long benlong(long lval);
extern short natshort(short sval);
extern long benlong(long lval);

void aifcWriteHdr(		/* Write AIFF header at start of file.   */
    int fd,			/* Called after open, before data writes */
    int sampsize,		/* sample size in bytes */
    int nchls,
    double sr)			/* sampling rate */
{
#if DEBUG
	printf("aifcWriteHdr: fd %d sampsize %d nchls %d sr %lf\n",
		fd,sampsize,nchls,sr);
#endif
	sframe_size = sampsize * nchnls;
	form.ckHdr.ckID = *(long *) FORM_ID;
	form.ckHdr.ckSize = 0;  		/* leave for aiffReWriteHdr */
	form.formType = *(long *) FORM_TYPE;
	
	comm1.ckHdr.ckID = *(long *) COMM_ID;
	comm1.ckHdr.ckSize = benlong((long)sizeof(short) +
				     sizCommChunk2 + sizeof(ID) + 
				     (short)FL32_NAME[0]);
	comm1.numChannels = benshort((short)nchls);
    
	comm2.numSampleFrames = 0;	        /* leave for aiffReWriteHdr */
	comm2.sampleSize = benshort((short)(sampsize * 8));
	double_to_ieee_80(sr,(unsigned char*)comm2.sampleRate);  /* insert 80-bit srate */
	
	comm3.compressionType = *(long *)FL32_TYPE;;	
	memcpy(comm3.compressionName,FL32_NAME,FL32_NAME[0]);/* Pascal string */
	sizCommChunk3 = sizeof(comm3.compressionType)+(short)FL32_NAME[0];
	if (sizCommChunk3 & 0x01) sizCommChunk3 += 1;
	
	sizAppChunk = sizeof(CkHdr)+sizeof(ID)+(sizeof(float)*(nchnls+1));
	FP32Chunk.ckHdr.ckID = *(long *) APPL_ID;
	FP32Chunk.ckHdr.ckSize = sizeof(ID)+(sizeof(float)*(nchnls+1));
	FP32Chunk.applicationSignature = *(long *) APPL_SIG;
	ssnd.ckHdr.ckID = *(long *) SSND_ID;
	ssnd.ckHdr.ckSize = 0;  		/* leave for aifcReWriteHdr */
	ssnd.offset = 0;
	ssnd.blockSize = 0;

	if ( write(fd, (char *)&form, sizFormHdr) != sizFormHdr
	  || write(fd, (char *)&comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, (char *)&comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, (char *)&comm3,sizCommChunk3) != sizCommChunk3
	  || write(fd, (char *)&FP32Chunk,sizAppChunk) != sizAppChunk
	  || write(fd, (char *)&ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	   die("error writing AIFC header");
	   aifchdrsize = sizFormHdr + sizCommChunk1 +
	                 sizCommChunk2 + sizCommChunk3 + 
	   sizAppChunk + sizSoundDataHdr;
	  mfree((char *)appCkPtr);
}
             
void aifcReWriteHdr(		/* Write proper sizes into AIFF header */
    int   fd,			/*         called before closing file  */
    long  datasize)		/*         & optionally under -R       */
{
        long endpos = tell(fd);
	long num_sframes, ssnd_size, form_size;

	if (datasize != endpos - aifchdrsize)
	    die("inconsistent AIFC sizes");
	num_sframes = datasize / sframe_size;
	ssnd_size = datasize + 2 * sizeof(long);
	form_size = endpos - sizeof(CkHdr);
#if DEBUG
	printf("aifcReWriteHdr: fd %d\n", fd);
	printf("endpos %lx num_sframes %lx ssnd_size %lx form_size %lx\n",
		endpos, num_sframes, ssnd_size, form_size);
#endif
	form.ckHdr.ckSize = benlong(form_size);
	comm2.numSampleFrames = benlong(num_sframes);
	GetMaxAmps(&(FP32Chunk.maxamps[0]));
	ssnd.ckHdr.ckSize = benlong(ssnd_size);
	if (lseek(fd, 0L, 0))
	    die("seek error while updating AIFC header");
	if ( write(fd, (char *)&form, sizFormHdr) != sizFormHdr
	  || write(fd, (char *)&comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, (char *)&comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, (char *)&comm3,sizCommChunk3) != sizCommChunk3
	  || write(fd, (char *)&FP32Chunk,sizAppChunk) != sizAppChunk
	  || write(fd, (char *)&ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	    die("error while rewriting AIFC header");
	lseek(fd, endpos, 0);
}

void aifcfResetFrameSize(int sampsize, int nchnls) {
	sframe_size = sampsize * nchnls;
	comm2.sampleSize = 32;
}

extern int is_aiff_form(long);
int is_aifc_form(long firstlong) /* test a long for aiff form ID               */
			/* called by readheader prior to aiffReadHeader */
{
        return (firstlong == *(long *)FORM_ID);
}

int is_aifc_formtype(fd) /* test a long for aiff form ID                 */
			/* called by readheader prior to aiffReadHeader */
{
    FormHdr form;
    long saveloc = tell(fd);	
    read(fd,(char *)&form + sizeof(long),sizeof(FormHdr) - sizeof(long));
    lseek(fd,saveloc,SEEK_SET);	
    return (form.formType == *(long *)FORM_TYPE);
}

typedef struct {
  short markerID;
  long  position;
} MARKER;

extern long natlong(long);

void aifcReadHeader(		/* Read AIFF header, fill hdr, &  */
  int fd,			/* postn rd ptr to start of samps */
  char *fname,
  HEADATA *hdr,			/* datablock for passing data back */
  long firstlong,
  SOUNDIN *p)
{
    CkHdr        ckHdr;
    FormHdr      form;
    CommChunk1   comm1;
    CommChunk2   comm2;
    InstrChunk   instr;
    SoundDataHdr ssnd;
    int mark_read = 0, inst_read = 0, loops_read = 0, peak_read = 0;
    int comm_read = 0, ssnd_read = 0;
    long ssnd_offset, ssnd_pos, pos, ckSize;
    long Appl_ID = 0;
    short sampsize, nmarkers = 0, nn;
    MARKER  *markersp = NULL, *mp = NULL;
    Loop    *ilp = NULL;
    AIFFDAT *adp = NULL;
    char    *err;
    double  sr, oct;

    p->filetyp = 0;             /* ensure no bytrevs in sreadin for now */
    if (!is_aiff_form(firstlong))   /* double check it's a form header  */
      die("bad form for aifcReadHeader");         /* & read remainder */
    sreadin(fd,(char *)&form + sizeof(long),sizeof(FormHdr) - sizeof(long),p);
    if (form.formType != *(long *) FORM_TYPE)
      die("form header not type aifc");
    hdr->readlong = FALSE;
    while (1) {				     /* read in the next header */
      if (sreadin(fd,(char *)&ckHdr,sizeof(CkHdr),p) < sizeof(CkHdr))
	break;
      pos = tell(fd);
      if (ckHdr.ckID == *(long *) COMM_ID) {    /* CommChunk hdr: rd rem 1 */
	sreadin(fd,(char *)&comm1 + sizeof(CkHdr), sizeof(short), p);
	sreadin(fd,(char *)&comm2, sizCommChunk2, p); /* + all of part 2 */
	sreadin(fd,(char *)&comm3, sizeof(ID)+1, p);
	sreadin(fd,(char *)&comm3+sizeof(ID)+1,(short)comm3.compressionName[0], p);
	sampsize = natshort(comm2.sampleSize);
	if (sampsize != 32) {
	  printf("Sample size %2d reset to 32 for AIFC\n", sampsize);
	}
	if (sampsize <= 8) {    	/* parse CommChunk to hdr format */
	  hdr->format = AE_CHAR;
	  hdr->sampsize = sizeof(char);
	}
	else if (sampsize <= 16) {
	  hdr->format = AE_SHORT;
	  hdr->sampsize = sizeof(short);
	}
	else if (sampsize <= 24)
	  die("AIFC 3-byte samples not supported");
	else {
	  hdr->format = AE_FLOAT;
	  hdr->sampsize = sizeof(float);
	}
	hdr->nchnls = natshort(comm1.numChannels);
	/* decode 80-bit srate */
	sr = ieee_80_to_double((unsigned char*)comm2.sampleRate);
	hdr->sr = (long) sr;
	if (comm3.compressionType != *(long *) FL32_TYPE) {
	  die("Compression Type is not FL32");
	} 
	comm_read = TRUE;
      }
      else if (ckHdr.ckID == *(long *) MARK_ID) { 	/* MarkersChunk: */
	sreadin(fd,(char *)&nmarkers, sizeof(short), p);
	nmarkers = natshort(nmarkers);
	printf("nmarkers = %d\n",nmarkers);
	if (nmarkers != 0) {
	  markersp = (MARKER *) mcalloc((long)sizeof(MARKER) * nmarkers);
	  for (nn = nmarkers, mp = markersp; nn--; mp++) {  /* for nmarkrs */
	    u_char psiz, pstring[256];             /* read ID/postn pair */
	    sreadin(fd,(char *)&mp->markerID, sizeof(short), p);
	    sreadin(fd,(char *)&mp->position, sizeof(long), p);
	    printf("markerID = %d position = %ld\n", mp->markerID, mp->position);
	    sreadin(fd,(char *)&psiz, 1, p);       /* leave unnatural,   */
	    psiz |= 01;                            /*     & skip pstring */
	    sreadin(fd, (char *)pstring, (int)psiz, p);
	  }
	}
	mark_read = TRUE;
      }
      else if (ckHdr.ckID == *(long *) APPL_ID) { 	/* Instr Chunk:  */
	int i = 0;
	int subhdrsiz = ckHdr.ckSize;
	sreadin(fd,(char *)&Appl_ID, sizeof(Appl_ID), p);
	if (Appl_ID != *(long *) APPL_SIG)
	  warning("Application Signature not pErF");
	subhdrsiz -= sizeof(Appl_ID);
	if (hdr->aiffdata == NULL)
	  hdr->aiffdata = adp = (AIFFDAT *)mcalloc((long)sizeof(AIFFDAT));
	sreadin(fd,(char *)&(adp->maxamps), subhdrsiz, p);
	peak_read = TRUE;
      }
      else if (ckHdr.ckID == *(long *) INST_ID) { /* Instr chunk */
	int subhdrsiz = sizeof(InstrChunk) - sizeof(CkHdr);
	if (hdr->aiffdata == NULL)
	  hdr->aiffdata = adp = (AIFFDAT *)mcalloc((long)sizeof(AIFFDAT));
	sreadin(fd,(char *)&instr + sizeof(CkHdr), subhdrsiz, p);
	oct = (instr.baseNote + instr.detune/100.) / 12. + 3.;
	adp->natcps = (float)(pow(2., oct) * onept);
	adp->gainfac = (float)exp((double)(natshort(instr.gain)) * log10d20);
	inst_read = TRUE;
      }
      else if (ckHdr.ckID == *(long *) SSND_ID) { /* SoundDataHdr: */
	int subhdrsiz = sizeof(SoundDataHdr) - sizeof(CkHdr);
	sreadin(fd,(char *)&ssnd + sizeof(CkHdr), subhdrsiz, p);
	ssnd_offset = natlong(ssnd.offset);
	ssnd_pos = pos + subhdrsiz + ssnd_offset;
	hdr->hdrsize = ssnd_pos;
	hdr->audsize = natlong(ckHdr.ckSize) - subhdrsiz - ssnd_offset;
	hdr->filetyp = TYP_AIFC;
	ssnd_read = TRUE;
      }
      if (mark_read && inst_read && !loops_read) {
	ilp = &instr.sustainLoop;
	adp->loopmode1 = natshort(ilp->playMode);
	if (adp->loopmode1 && nmarkers > 0) {
	  for (nn = nmarkers, mp = markersp; nn--; mp++) {
	    if (mp->markerID == ilp->beginLoop)
	      adp->begin1 = natlong(mp->position);
	    if (mp->markerID == ilp->endLoop)
	      adp->end1 = natlong(mp->position);
	  }
	}
	ilp = &instr.releaseLoop;
	adp->loopmode2 = natshort(ilp->playMode);
	if (adp->loopmode2 && nmarkers > 0) {
	  for (nn = nmarkers, mp = markersp; nn--; mp++) {
	    if (mp->markerID == ilp->beginLoop)
	      adp->begin2 = natlong(mp->position);
	    if (mp->markerID == ilp->endLoop)
	      adp->end2 = natlong(mp->position);
	  }
	}
	err = NULL;
	if (adp->natcps <= 0.0)
	  err = "baseNote";
	if (adp->loopmode1 < 0 || adp->loopmode1 > 3)
	  err = "sustain loop playMode";
	else if (adp->loopmode1
		 && (adp->begin1 < 0 || adp->begin1 >= adp->end1))
	  err = "sustain loop";
	else if (adp->loopmode2 < 0 || adp->loopmode2 > 3)
	  err = "release loop playMode";
	else if (adp->loopmode2
		 && (adp->begin2 < 0 || adp->begin2 >= adp->end2))
	  err = "release loop";
	if (err != NULL) {
	  printf("INFILE ERROR: illegal %s info in aifc file %s\n",
		 err,fname);
	  hdr->aiffdata = NULL;
	  mfree((char *)adp);
	}
	if (markersp != NULL) mfree(markersp);
	loops_read = TRUE;
      }    
      /* if read CommonChunk,SoundDataHdr,Loops, */
      if (comm_read && ssnd_read && loops_read)		/*   we're done */
	break;
      ckSize = natlong(ckHdr.ckSize); /* else seek past this chunk to nxt */
      if (ckSize & 1)  ckSize++;      /*      rnded up to even byte bndry */
      if (lseek(fd, pos + ckSize, 0) != pos + ckSize)
	die("error while seeking past AIFC chunk");
    }
    
    /*	if ((adp = hdr->aiffdata) == NULL)
	return; */
    printf("%s: AIFC, %ld%s samples", fname,
	   hdr->audsize/hdr->sampsize/hdr->nchnls, hdr->nchnls==1 ?"":" stereo");
    
    if (inst_read) {
      if (instr.detune == 0)
	printf(", baseFrq %4.1f (midi %d), gain %d db",
	       adp->natcps, instr.baseNote, natshort(instr.gain));
      else
	printf(", baseFrq %4.1f (midi %d, detune %d), gain %d db",
	       adp->natcps, instr.baseNote, instr.detune, natshort(instr.gain));
    }
    if (loops_read) {
      printf(", sustnLp: mode %d", adp->loopmode1);
      if (adp->loopmode1)
	printf(", %ld to %ld", adp->begin1,adp->end1);
      printf(", relesLp: mode %d", adp->loopmode2);
      if (adp->loopmode2)
	printf(", %ld to %ld", adp->begin2,adp->end2);
      printf("\n");
    }
    else printf(", no looping\n");
    if (peak_read) {
      int i = 0;
      printf("overall peak: %f\n",adp->maxamps[0]);
      printf("channel peaks:\n");
      for(i=0; i<hdr->nchnls; i++) 
	printf("%1d: %f%s",i,adp->maxamps[i+1], i+1 % 4 == 0 ? "\n" : " ");
      if (i+1%4) printf("\n");
    }
    if (lseek(fd,ssnd_pos,0) != ssnd_pos)
      die("error seeking to start of sound data");
  }

extern OPARMS O;
extern float maxamp[4];
extern float smaxamp[4];
extern float omaxamp[4];

void GetMaxAmps(float *a) 
{
    int i,j;
    float lmaxamp = 0.0f;
    float absmax = (float)fabs(*a);
    for (i=0; i<nchnls; i++) {
      j = i+1;
      a[j] = maxamp[i];
      if (absmax < lmaxamp) {
	*a = lmaxamp;
	absmax = (float)fabs(*a);
      }
      lmaxamp = (float)fabs(smaxamp[i]);
      if (absmax < lmaxamp) {
	*a = lmaxamp;
	absmax = (float)fabs(*a);
      }
      if ((fabs(a[j]) < lmaxamp)) 
	a[j] = smaxamp[i];
      lmaxamp = (float)fabs(omaxamp[i]);
      if (absmax < lmaxamp) {
	*a = lmaxamp;
	absmax = (float)fabs(*a);
      }
      if ((fabs(a[j]) < lmaxamp)) 
	a[j] = omaxamp[i];
    }
}
