 ########################################################-*-mode:Makefile-*-
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Various People                                ##
 ##                       : Reorganised (and probably broken)             ##
 ##                       : by Richard Caley (rjc@cstr.ed.ac.uk)          ##
 ##                   Date: June 1997                                     ##
 ## --------------------------------------------------------------------- ##
 ## Default Makefile rules includede everywhere.                          ##
 ##                                                                       ##
 ###########################################################################

# This is the default rule
all:	 $(ALL) .sub_directories
	@ : Do nothing but shut up make

# Include generated system description

include $(TOP)/config/system.mak

ifeq ($(SYSTEM_LOADED),)
	MACHINETYPE=unknown
	OSTYPE=unknown
	OSREV=
endif

#  Include project specific rules
-include $(TOP)/config/project.mak

#  Include installation specific information
-include $(TOP)/config/config

# Map selected modules to how to include them.
include $(TOP)/config/rules/modules.mak

ifdef REQUIRED_MAKE_INCLUDE
-include $(REQUIRED_MAKE_INCLUDE)
endif

-include $(TOP)/config/project_config_check.mak

# Places to find templates, needed by Sun CC
# export TEMPLATE_DIRS
export CI_ARGS

ifdef JAVA_CLASSES
	NEED_JAVA=1
endif

# Various subsets of directories

ifndef ALL_DIRS
ifdef BUILD_DIRS
    ALL_DIRS = $(BUILD_DIRS)
endif
endif

ifdef JUST_LIB
    SUBDIRECTORIES = ${LIB_BUILD_DIRS} ${EXTRA_LIB_BUILD_DIRS}
else
    SUBDIRECTORIES =  ${EXTRA_LIB_BUILD_DIRS} ${BUILD_DIRS} ${EXTRA_BUILD_DIRS}
endif

# now include various rule-sets

include $(TOP)/config/rules/defaults.mak

include $(TOP)/config/rules/compile_options.mak

include $(TOP)/config/rules/make_depend.mak

include $(TOP)/config/rules/library.mak

include $(TOP)/config/rules/targets.mak

include $(TOP)/config/rules/visual_c.mak

include $(TOP)/config/rules/rcs.mak

include $(TOP)/config/rules/c.mak

ifdef NEED_JAVA
include $(TOP)/config/rules/java.mak
endif

include $(TOP)/config/rules/config_errors.mak

# keep track of the places we put templates. Used for compiling things
# which depend on this

ifndef MADE_FROM_ABOVE
all: $(MAKE_INCLUDE)
$(MAKE_INCLUDE) : FORCE
	@echo "LIBRARY_TEMPLATE_DIRS=$(TEMPLATE_DIRS)" > $(MAKE_INCLUDE)
endif

# Finally, here are the automatically updated dependencies
ifdef SRCS
-include $(DEPEND)
endif
