 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/

#include "UnitCatalogue.h"

#ifndef __RAWUNITCATALOGUE_H__
#define __RAWUNITCATALOGUE_H__

/** Catalogue suitable for use with RawUnitDatabase.
  * 
  * This abstract class describes catalogues which are suitable for use
  * with RawUnitDatabase format databases.
  * 
  * @see RawUnitDatabase
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: RawUnitCatalogue.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */
class RawUnitCatalogue : public UnitCatalogue {

public:
    /// Maximum unit name length 
#   define RUC_NAME_LENGTH (10)
    /// Length of a file basename
#   define RUC_FILENAME_LENGTH (10)
    /// Maximum number of segments per unit.
#   define RUC_MAX_SEGMENTS_PER_UNIT (10)
  
    /// Record to keep information about a unit.
    struct Entry {
	/// The unit name.
	char name[RUC_NAME_LENGTH +1];
	/// The file basename.
	char filename[RUC_FILENAME_LENGTH +1];
	/// How many segmenst does this unit cover.
	int n_segments;
	/// Segment end times.
	float segments[RUC_MAX_SEGMENTS_PER_UNIT];
    };
    typedef struct Entry Entry;

protected:
    /// Default constructor.
    RawUnitCatalogue(void);
public:
    /// Destructor
    virtual ~RawUnitCatalogue(void) = 0;

    /**@name Properties */
    //@{
    /// Names of all available properties.
    virtual void property_names(EST_TList<EST_String> &list) const;
    /// Get the value for a property.
    virtual ValueType property(EST_String property) const;
    //@}

  /**@name Subtyping */
  //@{
  /// Recognise it in a file
  static bool recognise(FILE *stream) { (void)stream; return FALSE;}
  /// Create a FramesUnit
  static UnitCatalogue *create(void) {return NULL;}
  /// Name of this type of unit
  virtual EST_String subtype_name(void) const {return "Raw";}
  //@}

    /// Get entry for name.
    virtual struct Entry *lookup(UnitName name) = 0; 

    /// Count entries in catalogue
    virtual int num_entries (void) = 0;
    /// Is this a valid entry?
    virtual int has_entry(UnitName name) =0;

    friend class RawUnitDatabase;
};

#endif
