/*
 * Functions for modifying the mp3 files.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mp3info.h"

bool Mpfile::open(char *fname, bool write) {
   struct stat fi;
   if (write) {
      file=fopen(fname,"r+") ;
   } else {
      file=fopen(fname,"r") ;
   }
   if (file != NULL) {
      fstat(fileno(file), &fi);
      filelen=fi.st_size;
   } else {
      return(false);
   }
   strncpy(filename,fname,FILENAME_LEN);
   return (true);
}

bool Mpfile::frename(char *format) {
  char newname[STD_BUF_LEN];
  mpformat(newname,format,STD_BUF_LEN);
  if (newname[0]) {
    if (rename(filename,newname)==0) return(true) ;
    else return(false);
  }
  return(true);
}

Mpfile::Mpfile() {
  filelen=0;
  filename[0]=0;
  length=0;  
  tag=new Tag;
  layer=new Layer;
  hastag=false;
  haslayer=false;
}

Mpfile::~Mpfile() {
  delete(layer);
  delete(tag);
}

bool Mpfile::initfile(bool gettag) {
  if (!(layer->get(file))) {
    haslayer=false;
    return(false);
  }
  haslayer=true;
  if (gettag) hastag=tag->get(file);

  length=filelen /
     (layer->bitrate() * 125);

  return(true);
}


bool Mpfile::writetag() {
  return(tag->set(file));
}

bool Mpfile::wipetag() {
  return(tag->wipe(file,filelen));
}
