/*
 Parse and print std header.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mp3info.h"

bool Mpfile::parseif(char what) {
   switch (what) {
    case 'T' :
      return (hastag) ;
      break ;
    case 'H' :
      return (haslayer) ;
      break ;
    case 'a' :
      return (tag->artist[0]) ;
      break;
    case 'n' :
      fprintf(stderr,"Warning: Using old %%In for Tag Title, use %%It.");
      return (tag->title[0]) ;
      break;
    case 't' :
      return (tag->title[0]) ;
      break;
    case 'l' :
      return (tag->album[0]) ;
      break;
    case 'y' :
      return (tag->year[0]) ;
      break;
    case 'c' :
      return (tag->comment[0]) ;
      break;
    case 'C' :
      return (layer->error_protection) ;
      break;
    case 'O' :
      return (layer->copyright) ;
      break;
    case 'o' :
      return (layer->original) ;
      break;
    case 'S' :
      return (layer->stereo) ;
      break;
    default :
      fprintf(stderr,"Warning: If-Format unknown.");
      return (0);
   }
}

bool Mpfile::mpformat(char *out, char *format, size_t maxlen) {
   char *from=format;
   int ifnest=0;
   int ifinc=0;
   size_t to=0;
   while ((from[0]!=0) && (to<maxlen)) {
      if (from[0]=='%') {
	 from++;
	 switch (from[0]) {
	  case 'I' :
	    from++;
	    if (from[0]=='E') {
	       if (ifnest==ifinc) ifinc--;
	       ifnest--;
	    } else {
	       if ((ifinc==ifnest) && parseif(from[0])) ifinc++;
	       ifnest++;
	    }
	    break;
	  case '!' :
	    from++;
	    if (from[0]=='E') {
	       if (ifnest==(ifinc+1)) ifinc++;
	         else if (ifnest==ifinc) ifinc--;
	    } else {
	       if ((ifinc==ifnest) && !parseif(from[0])) ifinc++;
	       ifnest++;
	    }
	    break;
	  default :
	    if (ifnest==ifinc) {
	       switch(from[0]) {
		case 'a' :
		  to+=strlen(strncpy(&out[to],tag->artist,maxlen-to));
                  break;
                case 't' :
		  to+=strlen(strncpy(&out[to],tag->title,maxlen-to));
		  break;
                case 'n' :
                  fprintf(stderr,"Warning: Using old binding %%n for TAG TITLE. Use %%t.");
		  to+=strlen(strncpy(&out[to],tag->title,maxlen-to)); 
		  break;
		case 'l' :
		  to+=strlen(strncpy(&out[to],tag->album,maxlen-to));
		  break;
		case 'y' :
		  to+=strlen(strncpy(&out[to],tag->year,maxlen-to));
		  break;
		case 'c' :
		  to+=strlen(strncpy(&out[to],tag->comment,maxlen-to));
		  break;
		case 'g' :
		  to+=strlen(strncpy(&out[to],tag->genre,maxlen-to));
		  break;
		case '#' :
		  to+=sprintf(&out[to],"%i",tag->gennum);
		  break;
		case 'v' :
		  to+=strlen(strncpy(&out[to],layer->version_num(),maxlen-to));
		  break;
		case 'V' :
		  to+=strlen(strncpy(&out[to],layer->version_name(),maxlen-to));
		  break;
                case 'L' :
		  to+=strlen(strncpy(&out[to],layer->layer_name(),maxlen-to));
		  break;
                case 'A' :
		  to+=sprintf(&out[to],"%i",layer->lay);
		  break;
		case 'C' :
		  to+=sprintf(&out[to],"%i",layer->error_protection);
		  break;
		case 'b' :
		  to+=sprintf(&out[to],"%i",layer->bitrate());
		  break;
		case 'F' :
		  to+=sprintf(&out[to],"%u",layer->sfreq());
		  break;
		case 'M' :
		  to+=strlen(strncpy(&out[to],layer->mode_name(),maxlen-to));
		  break;
		case 'O' :
		  to+=sprintf(&out[to],"%i",layer->copyright);
		  break;
		case 'o' :
		  to+=sprintf(&out[to],"%i",layer->original);
		  break;  
		case 'm' :
		  to+=sprintf(&out[to],"%lu",length/60);
		  break;
		case 's' :
		  to+=sprintf(&out[to],"%lu",length%60);
		  break;
		case 'S' :
		  to+=sprintf(&out[to],"%lu",length);
		  break;
		case 'N' :
		  to+=sprintf(&out[to],"\n");
		  break;
		case 'f' :
		  to+=strlen(strncpy(&out[to],filename,maxlen-to));
		  break;
		case 'i' :
		  to+=sprintf(&out[to],"%u",filelen);
		  break;
		default :
		  out[to]=from[0];
		  to++;
	       }
	    }
	 }
      } else {
	 if (ifnest==ifinc) {
	    out[to]=from[0];
	    to++;
	 }
      }
      from++;
   }
   if (to>maxlen) to=maxlen;
   out[to]=0;
   if (to>=maxlen) fprintf(stderr,"Warning: Output too large, cut.");
   return(to!=0);
}  
